	i8080

nk.sys	equ	62		;system size in  kBytes
td	equ	nk.sys/10	;decimal tens digit
od	equ	nk.sys%10	;decimal ones digit
td.asc	equ	td+&h30		;ascci tens digit
od.asc	equ	od+&h30		;ascii ones digit
k.byte	equ	1024		;bytes in a kilobyte
cpm.sz	equ	nk.sys*k.byte	;top system addres
v.20k	equ	20*k.byte	;twenty kByte 
cpm.bs	equ	cpm.sz-v.20k	;cpm bias value
ccp	equ	cpm.bs+&H3400	;addres of ccp
bdos	equ	cpm.bs+&H3c00	;addres of bdos
bios	equ	cpm.bs+&H4a00	;addres of bios
;bios.r	equ	&H1000-bios	;DDT offset load?
tpa	equ	&H100		;addres of TPA
iobyte	equ	&Hff		;initial iobyte value

io.byte	equ	3		;address of iobyte
c.disk	equ	4		;address of current logged disk

dsk.cmd equ &HD0 
dsk.sts equ &HD0 
dsk.drv		equ	&HD1 	;drv
dsk.trkL	equ	&HD2 	;trkLow
dsk.trkH	equ	&HD3 	;trkHigh
dsk.secL	equ	&HD4 	;secLow
dsk.secH	equ	&HD5 	;secHigh
dsk.dmaL	equ	&HD6 	;dmaLow
dsk.dmaH	equ	&HD7 	;dmaHigh
dsk.sptL	equ	&HD8 	;sptLow
dsk.sptH	equ	&HD9 	;sptHigh

cmd.read	equ	1
cmd.write	equ	2
cmd.log		equ	4
cmd.fmt		equ	8

sec.sz	equ	128

	org	0100h
	
diskrd
	lxi	h,bios		;init dma
	shld	bt.dma
	mvi	a,0		;sel drive
	out	dsk.drv
	mvi	a,0		;sel Track
	out	dsk.trkL
	mvi	a,17		;sel Sector
	out	dsk.secL
w.read
	lda	bt.dma		;setdma
	out	dsk.dmaL
	lda	bt.dma+1	
	out	dsk.dmaH
	mvi	a,cmd.read	;read
	out	dsk.cmd
	in	dsk.sts
	ana	a		;set flags(ccr)
	jrnz	w.eror		;exit if error
	in	dsk.secL	;get sector number
	cmpi	28
	jz	bios		;exit to BIOS
	inr	a		;next sector
	out	dsk.secL	;store next sector
	lxi	d,sec.sz	;sector size
	lhld	bt.dma		;inc buffer pointer to next sec
	dad	d		;new buffer address 
	shld	bt.dma		;store new buffer address
	jmpr	w.read		;again 

w.eror	 sta	bt.sts		;store error 
	 hlt			;halt

bt.dma	dw	0100h
bt.sts	db	0
bt.sec	db	0