	title	'Boot loader module for CP/M 3.0'

true equ -1
false equ not true

;banked	equ true

	public	?init,?ldccp,?rlccp,?time
	extrn	?pmsg,?conin
	extrn	@civec,@covec,@aivec,@aovec,@lovec
	extrn 	@cbnk,?bnksl,?xmove,?move
	extrn 	@date,@hour,@min,@sec

	maclib ports
	maclib z80
	maclib bank

bdos	equ 5

	if banked
tpa$bank	equ 1
	else
tpa$bank	equ 0
	endif

Extra$B	equ	0fh	;use bank 15 for extra

	dseg	; init done from banked memory

?init:
	lxi h,08000h ! shld @civec ! shld @covec	; assign console to TTY:
	lxi h,00800h ! shld @lovec 			; assign printer to LPT:
	lxi h,02000h ! shld @aivec ! shld @aovec	; assign AUX to SERA:
	mvi a,0 ! out p$bank$select			; select bank 0
	lxi h,signon$msg ! call ?pmsg		; print signon message
	ret	

	cseg	; boot loading most be done from resident memory
	
    ;	This version of the boot loader loads the CCP from a file
    ;	called CCP.COM on the system drive (A:).


?ldccp:
	; First time, load the A:CCP.COM file into TPA
	xra a ! sta ccp$fcb+15		; zero extent
	lxi h,0 ! shld fcb$nr		; start at beginning of file
	lxi d,ccp$fcb ! call open	; open file containing CCP
	inr a ! jz no$CCP		; error if no file...
	lxi d,0100h ! call setdma	; start of TPA
	lxi d,128 ! call setmulti	; allow up to 16k bytes
	lxi d,ccp$fcb ! call read	; load the thing
					; now,
	;   copy CCP to Extra bank for reloading

	mvi	b,Extra$b
	mvi	c,tpa$bank
	call	?xmove		
	lxi	d,0100h		;
	lxi	h,0100h		;
	lxi	b,1000h		;4k
	call	?move
	ret

no$CCP:			; here if we couldn't find the file
	lxi h,ccp$msg ! call ?pmsg	; report this...
	call ?conin			; get a response
	jmp ?ldccp			; and try again


?rlccp:
	mvi	c,Extra$b
	mvi	b,tpa$bank
	call	?xmove		
	lxi	d,0100h		;
	lxi	h,0100h		;
	lxi	b,1000h		;4k
	call	?move
	ret


    ; Emulators system clock.
?time:
	mov	a,c
	ana	a		;set flags
	rnz			;exit if SET time
	in 	0b0H		;force time update
	in 	0b2H		;get high byte
	sta	@DATE+1		;
	in	0b3H		;get low byte
	sta	@DATE		;
	in	0b4H
	sta	@HOUR
	in	0b5H
	sta	@MIN
	in	0b6H
	sta	@SEC
	ret

	; CP/M BDOS Function Interfaces

open:
	mvi c,15 ! jmp bdos		; open file control block

setdma:
	mvi c,26 ! jmp bdos		; set data transfer address

setmulti:
	mvi c,44 ! jmp bdos		; set record count

read:
	mvi c,20 ! jmp bdos		; read records

signon$msg	db	13,10,13,10,'CP/M Ver3.0 BIOSihv3.31, Z80 Emulator',13,10,0

ccp$msg		db	13,10,'BIOS Err on A: No CCP.COM file',0


ccp$fcb		db	1,'CCP     ','COM',0,0,0,0
		ds	16
fcb$nr		db	0,0,0


	end
