true	equ	-1
false	equ	not true

AS8080 	equ	true
	if	AS8080
	z80
	else
	maclib	z80
	endif

nk$sys	equ	62		;system size in  kBytes
td	equ	nk$sys/10	;decimal tens digit
od	equ	nk$sys mod 10	;decimal ones digit
td$asc	equ	td+030h		;ascci tens digit
od$asc	equ	od+030h		;ascii ones digit
k$byte	equ	1024		;bytes in a kilobyte
cpm$sz	equ	nk$sys*k$byte	;top system addres
v$20k	equ	20*k$byte	;twenty kByte 
cpm$bs	equ	cpm$sz-v$20k	;cpm bias value

ccp	equ	cpm$bs+03400h	;addres of ccp
bdos	equ	cpm$bs+03c00h	;addres of bdos
bios	equ	cpm$bs+04a00h	;addres of bios
tpa	equ	0100h		;addres of TPA

c$disk	equ	4		;address of current logged disk
err$sts	equ	8

dsk$cmd equ 0D0h 
dsk$sts equ 0D0h 
dsk$drv		equ	0D1h ;drv
dsk$trkL	equ	0D2h ;trkLow
dsk$trkH	equ	0D3h ;trkHigh
dsk$secL	equ	0D4h ;secLow
dsk$secH	equ	0D5h ;secHigh
dsk$dmaL	equ	0D6h ;dmaLow
dsk$dmaH	equ	0D7h ;dmaHigh
dsk$sptL	equ	0D8h ;sptLow
dsk$sptH	equ	0D9h ;sptHigh

cmd$read	equ	1
cmd$write	equ	2
cmd$log		equ	4
cmd$fmt		equ	8

sec$sz	equ	128

	org	tpa
	
diskrd:
	mvi	a,018h		;select Drive
	out	0cah		;disk reg select

	mvi	a,0
	out	0c8h		;dsk$drv

	mvi	a,022h		;select track
	out	0cah		;disk reg select

	mvi	a,0
	out	0c8h		;dsk$trkL

	mvi	a,024h		;select sector
	out	0cah		;disk reg select

	mvi	a,17
	out	0c8h		;dsk$secL

	mvi	a,010h		;select DMA
	out	0cah		;disk reg select

	mvi	a,low bios
	out	0c8h		;dsk$dmaL
	mvi	a,high bios
	out	0c9h		;dsk$dmaH


read$sec:

	mvi	a,000h		;select Command
	out	0cah		;disk reg select

	mvi	a,cmd$read
	out	0c8h		;dsk$cmd

	mvi	a,08h		;select status
	out	0cah		;disk reg select

	in	0c8h		;dsk$sts

	ana	a		;set flags(ccr)
	jrnz	r$eror		;exit if error

;read sector, inc and write back

	mvi	a,024h		;select sector
	out	0cah		;disk reg select

	in	0c8h		;get sector number
	cpi	28
	jz	bios		;exit to BIOS
	inr	a		;next sector
	out	0c8h		;store next sector


;read DMA , inc and write back

	lxi	d,sec$sz	;sector size

	mvi	a,010h		;select DMA
	out	0cah		;disk reg select

	in	0c8h
	mov	l,a
	in	0c9h
	mov	h,a
	dad	d		;new buffer address 
	mov	a,l
	out	0c8h
	mov	a,h
	out	0c9h

	jr	read$sec	;again 

r$eror:	 sta	err$sts		;store error 
	 hlt			;halt

