	title	'MP/M II V2.0  DSC-2 Basic & Extended I/O Systems'
	cseg

false	equ	0
true	equ	not false

	maclib	z80

Banked	equ	false
;Banked	equ	true

debug	equ	true
;debug	equ	false

;ldcmd	equ	true
ldcmd	equ	false
;
; disk io is in separate module

	extrn	home,seldsk,settrk,setsec,setdma,read,write,sectran

	public	swtuser,swtsys,pdisp,xdos,sysdat

;bios jump vector table

	jmp	commonbase
wboot:
	jmp	warmstart	;warm start
	jmp	const		;console status
	jmp	conin		;console character in
outCH:	jmp	conout		;console character out
	jmp	list		;list character out
	jmp	rtnempty	;punch not implemented
	jmp	rtnempty	;reader not implemented
	jmp	home		;move head to home
	jmp	seldsk		;select disk
	jmp	settrk		;set track number
	jmp	setsec		;set sector number
	jmp	setdma		;set dma address
	jmp	read		;read disk
	jmp	write		;write disk
	jmp	listst		;list status
	jmp	sectran		;sector translate

	jmp	selmemory	; select memory
	jmp	polldevice	; poll device
	jmp	startclock	; start clock
	jmp	stopclock	; stop clock
	jmp	exitregion	; exit region
	jmp	maxconsole	; maximum console number
	jmp	systeminit	; system initialization
	db	0,0,0		; force use of internal dispatch @ idle
;	jmp	idle		; idle procedure
;

	public	d0$all,d1$all,d2$all,d3$all
	public	d4$all,d5$all
	public	d8$all,d9$all
	public	df$all
	public	d0$chk,d1$chk,d2$chk,d3$chk
	public	d4$chk,d5$chk
	public	d8$chk,d9$chk
	public	df$chk

;Un-initialized data area must be below common base 

cseg

; drive allocation area

all$sz set	91

d0$all	ds	all$sz
d1$all	ds	all$sz
d2$all	ds	all$sz
d3$all	ds	all$sz

all$sz set	31

d4$all	ds	all$sz
d5$all	ds	all$sz

all$sz set	255

d8$all	ds	all$sz
d9$all	ds	all$sz

all$sz set	4096

df$all	ds	all$sz

;changed disk area

chk$sz	set	64

d0$chk	ds	chk$sz
d1$chk	ds	chk$sz
d2$chk	ds	chk$sz
d3$chk	ds	chk$sz

chk$sz	set	16

d4$chk	ds	chk$sz
d5$chk	ds	chk$sz

chk$sz	set	0

d8$chk	ds	chk$sz
d9$chk	ds	chk$sz

df$chk	ds	chk$sz

eoui	equ	$

commonbase:
	 jmp	coldstart
swtuser: jmp	$-$
swtsys:  jmp	$-$
pdisp:   jmp	$-$
xdos:	 jmp	$-$
sysdat:  dw	$-$

coldstart:
warmstart:
	mvi	c,0
	jmp	xdos		; system reset, terminate process


;I/O handlers
;
;
;  MP/M II V2.0   Console Bios
;
;
nmbcns	equ	8	; number of consoles

poll	equ	131	; XDOS poll function
makeque	equ	134	; XDOS make queue function
readque	equ	137	; XDOS read queue function
writeque equ	139	; XDOS write queue function
xdelay	equ	141	; XDOS delay function
create	equ	144	; XDOS create process function

plco0	equ	0	; poll console out #0
plco1	equ	1	; poll console out #1
plco2	equ	2	; poll console out #2
plco3	equ	3	; poll console out #3 
plco4	equ	4	; poll console out #4
plco5	equ	5	; poll console out #5
plco6	equ	6	; poll console out #6
plco7	equ	7	; poll console out #7 
plci0	equ	8	; poll console in #0
plci1	equ	9	; poll console in #1
plci2	equ	10	; poll console in #2 
plci3	equ	11	; poll console in #3
plci4	equ	12	; poll console in #4
plci5	equ	13	; poll console in #5
plci6	equ	14	; poll console in #6 
plci7	equ	15	; poll console in #7
pllpt0	equ	16	; poll printer #0
pllpt1	equ	17	; poll printer #1
pllpt2	equ	18	; poll printer #2
pllpt3	equ	19	; poll printer #3
pllpt4	equ	20	; poll printer #4
pllpt5	equ	21	; poll printer #5
pllpt6	equ	22	; poll printer #6
pllpt7	equ	23	; poll printer #7

;
const:			; Console Status
	
	call	ptbljmp	; compute and jump to hndlr
	dw	pt0st	; console #0 status routine
	dw	pt1st	; console #1 status rt
	dw	pt2st	; console #2 status rt
	dw	pt3st	; console #3 status rt
	dw	pt4st	; console #4 status routine
	dw	pt5st	; console #5 status rt
	dw	pt6st	; console #6 status rt
	dw	pt7st	; console #7 status rt

conin:			; Console Input
	call	ptbljmp	; compute and jump to hndlr
	dw	pt0in	; console #0 input
	dw	pt1in	; console #1 input
	dw	pt2in	; console #2 input
	dw	pt3in	; console #3 input
	dw	pt4in	; console #4 input
	dw	pt5in	; console #5 input
	dw	pt6in	; console #6 input
	dw	pt7in	; console #7 input

conout:			; Console Output
	call	ptbljmp	; compute and jump to hndlr
	dw	pt0out	; console #0 output
	dw	pt1out	; console #1 output
	dw	pt2out	; console #2 output
	dw	pt3out	; console #3 output
	dw	pt4out	; console #4 output
	dw	pt5out	; console #5 output
	dw	pt6out	; console #6 output
	dw	pt7out	; console #7 output

;
ptbljmp:		; compute and jump to handler
			; d = console #
			; do not destroy d !
	mov	a,d
	cpi	nmbcns
	jc	tbljmp
	pop	psw	; throw away table address
rtnempty:
	xra	a
	ret
tbljmp:			; compute and jump to handler
			; a = table index
	add	a	; double table index for adr offst
	pop	h	; return adr points to jump tbl
	mov	e,a
	mvi	d,0
	dad	d	; add table index * 2 to tbl base
	mov	e,m	; get handler address
	inx	h
	mov	d,m
	xchg
	pchl		; jump to computed cns handler

;
; ASCII Character Equates
;
uline	equ	5fh
rubout	equ	7fh
space	equ	20h
backsp	equ	8h
altrub	equ	uline
;
; Input / Output Port Address Equates
;
data0	equ	20h	;0
sts0	equ	data0+1
cd0	equ	sts0
data1	equ	24h	;1
sts1	equ	data1+1
cd1	equ	sts1
data2	equ	28h	;2
sts2	equ	data2+1
cd2	equ	sts2
data3	equ	2ch	;3
sts3	equ	data3+1
cd3	equ	sts3
data4	equ	30h	;4
sts4	equ	data4+1
cd4	equ	sts4
data5	equ	34h	;5
sts5	equ	data5+1
cd5	equ	sts5
data6	equ	38h	;6
sts6	equ	data6+1
cd6	equ	sts6
data7	equ	3ch	;7
sts7	equ	data7+1
cd7	equ	sts7

;POLL CONSOLE # 0 INPUT

polci0:
pt0st:			;TEST CONSOLE STATUS
	in	sts0
	ani	02h
	rz
	mvi	a,0ffh
	ret

;console # 0 input

pt0in:			;return char in reg a
	call	polci0	;is it ready now?
	ora	a
	jrnz	pt0in1	;if ready, skip poll
	mvi	c,poll
	mvi	e,plci0	;poll console #0 input
	call	xdos
pt0in1:
	in	data0		;read character
	ani	07fh		;strip parity
	ret

;console # 0 output 

pt0out:			;reg c = char to output
	call	polco0	;is it ready now?
	ora	a
	jrnz	pt0out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,plco0
	call	xdos	;poll console #0 output
	pop	b
pt0out1:
	mov	a,c
	out	data0	;transmit character
	ret

;poll console # 0 output

polco0:			;return offh if ready
	in	sts0
	ani	01h
	rz
	mvi	a,0ffh
	ret

;POLL CONSOLE # 1 INPUT

polci1:
pt1st:			;TEST CONSOLE STATUS
	in	sts1
	ani	02h
	rz
	mvi	a,0ffh
	ret

;console # 1 input

pt1in:			;return char in reg a
	call	polci1	;is it ready now?
	ora	a
	jrnz	pt1in1	;if ready, skip poll
	mvi	c,poll
	mvi	e,plci1	;poll console #1 input
	call	xdos
pt1in1:
	in	data1		;read character
	ani	07fh		;strip parity
	ret

;console # 1 output 

pt1out:			;reg c = char to output
	call	polco1	;is it ready now?
	ora	a
	jrnz	pt1out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,plco1
	call	xdos	;poll console #1 output
	pop	b
pt1out1:
	mov	a,c
	out	data1	;transmit character
	ret

;poll console # 1 output

polco1:			;return offh if ready
	in	sts1
	ani	01h
	rz
	mvi	a,0ffh
	ret

;POLL CONSOLE # 2 INPUT

polci2:
pt2st:			;TEST CONSOLE STATUS
	in	sts2
	ani	02h
	rz
	mvi	a,0ffh
	ret

;console # 2 input

pt2in:			;return char in reg a
	call	polci2	;is it ready now?
	ora	a
	jrnz	pt2in1	;if ready, skip poll
	mvi	c,poll
	mvi	e,plci2	;poll console #2 input
	call	xdos
pt2in1:
	in	data2		;read character
	ani	07fh		;strip parity
	ret

;console # 2 output 

pt2out:			;reg c = char to output
	call	polco2	;is it ready now?
	ora	a
	jrnz	pt2out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,plco2
	call	xdos	;poll console #2 output
	pop	b
pt2out1:
	mov	a,c
	out	data2	;transmit character
	ret

;poll console # 2 output

polco2:			;return offh if ready
	in	sts2
	ani	01h
	rz
	mvi	a,0ffh
	ret

;POLL CONSOLE # 3 INPUT

polci3:
pt3st:			;TEST CONSOLE STATUS
	in	sts3
	ani	02h
	rz
	mvi	a,0ffh
	ret

;console # 3 input

pt3in:			;return char in reg a
	call	polci3	;is it ready now?
	ora	a
	jrnz	pt3in1	;if ready, skip poll
	mvi	c,poll
	mvi	e,plci3	;poll console #3 input
	call	xdos
pt3in1:
	in	data3		;read character
	ani	07fh		;strip parity
	ret

;console # 3 output 

pt3out:			;reg c = char to output
	call	polco3	;is it ready now?
	ora	a
	jrnz	pt3out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,plco3
	call	xdos	;poll console #3 output
	pop	b
pt3out1:
	mov	a,c
	out	data3	;transmit character
	ret

;poll console # 3 output

polco3:			;return offh if ready
	in	sts3
	ani	01h
	rz
	mvi	a,0ffh
	ret

;POLL CONSOLE # 4 INPUT

polci4:
pt4st:			;TEST CONSOLE STATUS
	in	sts4
	ani	02h
	rz
	mvi	a,0ffh
	ret

;console # 4 input

pt4in:			;return char in reg a
	call	polci4	;is it ready now?
	ora	a
	jrnz	pt4in1	;if ready, skip poll
	mvi	c,poll
	mvi	e,plci4	;poll console #4 input
	call	xdos
pt4in1:
	in	data4		;read character
	ani	07fh		;strip parity
	ret

;console # 4 output 

pt4out:			;reg c = char to output
	call	polco4	;is it ready now?
	ora	a
	jrnz	pt4out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,plco4
	call	xdos	;poll console #4 output
	pop	b
pt4out1:
	mov	a,c
	out	data4	;transmit character
	ret

;poll console # 4 output

polco4:			;return offh if ready
	in	sts4
	ani	01h
	rz
	mvi	a,0ffh
	ret

;POLL CONSOLE # 5 INPUT

polci5:
pt5st:			;TEST CONSOLE STATUS
	in	sts5
	ani	02h
	rz
	mvi	a,0ffh
	ret

;console # 5 input

pt5in:			;return char in reg a
	call	polci5	;is it ready now?
	ora	a
	jrnz	pt5in1	;if ready, skip poll
	mvi	c,poll
	mvi	e,plci5	;poll console #5 input
	call	xdos
pt5in1:
	in	data5		;read character
	ani	07fh		;strip parity
	ret

;console # 5 output 

pt5out:			;reg c = char to output
	call	polco5	;is it ready now?
	ora	a
	jrnz	pt5out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,plco5
	call	xdos	;poll console #5 output
	pop	b
pt5out1:
	mov	a,c
	out	data5	;transmit character
	ret

;poll console # 5 output

polco5:			;return offh if ready
	in	sts5
	ani	01h
	rz
	mvi	a,0ffh
	ret

;POLL CONSOLE # 6 INPUT

polci6:
pt6st:			;TEST CONSOLE STATUS
	in	sts6
	ani	02h
	rz
	mvi	a,0ffh
	ret

;console # 6 input

pt6in:			;return char in reg a
	call	polci6	;is it ready now?
	ora	a
	jrnz	pt6in1	;if ready, skip poll
	mvi	c,poll
	mvi	e,plci6	;poll console #6 input
	call	xdos
pt6in1:
	in	data6		;read character
	ani	07fh		;strip parity
	ret

;console # 6 output 

pt6out:			;reg c = char to output
	call	polco6	;is it ready now?
	ora	a
	jrnz	pt6out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,plco6
	call	xdos	;poll console #6 output
	pop	b
pt6out1:
	mov	a,c
	out	data6	;transmit character
	ret

;poll console # 6 output

polco6:			;return offh if ready
	in	sts6
	ani	01h
	rz
	mvi	a,0ffh
	ret

;POLL CONSOLE # 7 INPUT

polci7:
pt7st:			;TEST CONSOLE STATUS
	in	sts7
	ani	02h
	rz
	mvi	a,0ffh
	ret

;console # 7 input

pt7in:			;return char in reg a
	call	polci7	;is it ready now?
	ora	a
	jrnz	pt7in1	;if ready, skip poll
	mvi	c,poll
	mvi	e,plci7	;poll console #7 input
	call	xdos
pt7in1:
	in	data7		;read character
	ani	07fh		;strip parity
	ret

;console # 7 output 

pt7out:			;reg c = char to output
	call	polco7	;is it ready now?
	ora	a
	jrnz	pt7out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,plco7
	call	xdos	;poll console #7 output
	pop	b
pt7out1:
	mov	a,c
	out	data7	;transmit character
	ret

;poll console # 7 output

polco7:			;return offh if ready
	in	sts7
	ani	01h
	rz
	mvi	a,0ffh
	ret

;
;
; Line Printer Driver:  z80 emulator
;
lptprt0	EQU	40H		;PRINTER #0 DATA
lptsts0	EQU	lptprt0+1	;PRINTER #0 STATUS
lptprt1	EQU	44H		;PRINTER #1 DATA
lptsts1	EQU	lptprt1+1	;PRINTER #1 STATUS
lptprt2	EQU	48H		;PRINTER #2 DATA
lptsts2	EQU	lptprt2+1	;PRINTER #2 STATUS
lptprt3	EQU	4cH		;PRINTER #3 DATA
lptsts3	EQU	lptprt3+1	;PRINTER #3 STATUS
lptprt4	EQU	50H		;PRINTER #4 DATA
lptsts4	EQU	lptprt4+1	;PRINTER #4 STATUS
lptprt5	EQU	54H		;PRINTER #5 DATA
lptsts5	EQU	lptprt5+1	;PRINTER #5 STATUS
lptprt6	EQU	58H		;PRINTER #6 DATA
lptsts6	EQU	lptprt6+1	;PRINTER #6 STATUS
lptprt7	EQU	5cH		;PRINTER #7 DATA
lptsts7	EQU	lptprt7+1	;PRINTER #7 STATUS

list:			; List Output

	call	ptbljmp	; compute and jump to hndlr
	dw	lp0out	; console #0 output
	dw	lp1out	; console #1 output
	dw	lp2out	; console #2 output
	dw	lp3out	; console #3 output
	dw	lp4out	; console #4 output
	dw	lp5out	; console #5 output
	dw	lp6out	; console #6 output
	dw	lp7out	; console #7 output

lp0out:			;reg c = char to output
	call	pollpt0	;is it ready now?
	ora	a
	jrnz	lp0out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,pllpt0
	call	xdos	;poll lpt #0 output
	pop	b
lp0out1:
	mov	a,c
	out	lptprt0	;transmit character
	ret
;------------
lp1out:			;reg c = char to output
	call	pollpt1	;is it ready now?
	ora	a
	jrnz	lp1out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,pllpt1
	call	xdos	;poll lpt #1 output
	pop	b
lp1out1:
	mov	a,c
	out	lptprt1	;transmit character
	ret
;------------
lp2out:			;reg c = char to output
	call	pollpt2	;is it ready now?
	ora	a
	jrnz	lp2out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,pllpt2
	call	xdos	;poll lpt #2 output
	pop	b
lp2out1:
	mov	a,c
	out	lptprt2	;transmit character
	ret
lp3out:			;reg c = char to output
	call	pollpt3	;is it ready now?
	ora	a
	jrnz	lp3out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,pllpt3
	call	xdos	;poll lpt #3 output
	pop	b
lp3out1:
	mov	a,c
	out	lptprt3	;transmit character
	ret
lp4out:			;reg c = char to output
	call	pollpt4	;is it ready now?
	ora	a
	jrnz	lp4out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,pllpt4
	call	xdos	;poll lpt #4 output
	pop	b
lp4out1:
	mov	a,c
	out	lptprt4	;transmit character
	ret
lp5out:			;reg c = char to output
	call	pollpt5	;is it ready now?
	ora	a
	jrnz	lp5out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,pllpt5
	call	xdos	;poll lpt #5 output
	pop	b
lp5out1:
	mov	a,c
	out	lptprt5	;transmit character
	ret
lp6out:			;reg c = char to output
	call	pollpt6	;is it ready now?
	ora	a
	jrnz	lp6out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,pllpt6
	call	xdos	;poll lpt #6 output
	pop	b
lp6out1:
	mov	a,c
	out	lptprt6	;transmit character
	ret
lp7out:			;reg c = char to output
	call	pollpt7	;is it ready now?
	ora	a
	jrnz	lp7out1	;if ready, skip poll
	push	b
	mvi	c,poll
	mvi	e,pllpt7
	call	xdos	;poll lpt #7 output
	pop	b
lp7out1:
	mov	a,c
	out	lptprt7	;transmit character
	ret

;poll lpt # 0 output
listst:
	call	ptbljmp	; compute and jump to hndlr
	dw	lp0st	; console #0 status routine
	dw	lp1st	; console #1 status rt
	dw	lp2st	; console #2 status rt
	dw	lp3st	; console #3 status rt
	dw	lp4st	; console #4 status routine
	dw	lp5st	; console #5 status rt
	dw	lp6st	; console #6 status rt
	dw	lp7st	; console #7 status rt

lp0st:
pollpt0:			;return offh if ready
	in	lptsts0
	ani	01h
	rz
	mvi	a,0ffh
	ret
lp1st:
pollpt1:			;return offh if ready
	in	lptsts1
	ani	01h
	rz
	mvi	a,0ffh
	ret
lp2st:
pollpt2:			;return offh if ready
	in	lptsts2
	ani	01h
	rz
	mvi	a,0ffh
	ret
lp3st:
pollpt3:			;return offh if ready
	in	lptsts3
	ani	01h
	rz
	mvi	a,0ffh
	ret
lp4st:
pollpt4:			;return offh if ready
	in	lptsts4
	ani	01h
	rz
	mvi	a,0ffh
	ret
lp5st:
pollpt5:			;return offh if ready
	in	lptsts5
	ani	01h
	rz
	mvi	a,0ffh
	ret
lp6st:
pollpt6:			;return offh if ready
	in	lptsts6
	ani	01h
	rz
	mvi	a,0ffh
	ret
lp7st:
pollpt7:			;return offh if ready
	in	lptsts7
	ani	01h
	rz
	mvi	a,0ffh
	ret
;
;
;
;  MP/M II V2.0   Xios
;
;
polldevice:
			; Reg C = device # to be polled
			; return 0ffh if ready,
			;        000h if not
	mov	a,c
	cpi	nmbdev
	jc	devok
	mvi	a,nmbdev; if dev # >= nmbdev,
			; set to nmbdev
devok:
	call	tbljmp	; jump to dev poll code

devtbl:
	dw	polco0	; poll console #0 output
	dw	polco1	; poll console #1 output
	dw	polco2	; poll console #2 output
	dw	polco3	; poll console #3 output
	dw	polco4	; poll console #4 output
	dw	polco5	; poll console #5 output
	dw	polco6	; poll console #6 output
	dw	polco7	; poll console #7 output
	dw	polci0	; poll console #0 input
	dw	polci1	; poll console #1 input
	dw	polci2	; poll console #2 input
	dw	polci3	; poll console #3 input
	dw	polci4	; poll console #4 input
	dw	polci5	; poll console #5 input
	dw	polci6	; poll console #6 input
	dw	polci7	; poll console #7 input
	dw	pollpt0	; poll printer #0 output
	dw	pollpt1	; poll printer #1 output
	dw	pollpt2	; poll printer #2 output
	dw	pollpt3	; poll printer #3 output
	dw	pollpt4	; poll printer #4 output
	dw	pollpt5	; poll printer #5 output
	dw	pollpt6	; poll printer #6 output
	dw	pollpt7	; poll printer #7 output
nmbdev	equ	($-devtbl)/2	; number of devices to poll
	dw	rtnempty; bad device handler
;


; Select / Protect Memory
;
selmemory:
			; Reg BC = adr of mem descriptor
			; BC ->  base   1 byte,
			;        size   1 byte,
			;        attrib 1 byte,
			;        bank   1 byte.
	cpi	020h
	jz	$
	lxi	h,3
	dad	b
	mov	a,m
	ani	7
	out 	0c0h

	ret
;
; Start Clock
;
startclock:
			; will cause flag #1 to be set
			;  at each system time unit tick
	mvi	a,0ffh
	sta	tickn
	ret
;
; Stop Clock
;
stopclock:
			; will stop flag #1 setting at
			;  system time unit tick
	xra	a
	sta	tickn
	ret
;
; Exit Region
;
exitregion:
			; EI if not preempted or in dispatcher
	lda	preemp
	ora	a
	rnz
	ei
	ret
;
; Maximum Console Number
;
maxconsole:
	mvi	a,nmbcns
	ret
;
; System Initialization
;
systeminit:
;
;  This is the place to insert code to initialize
;  the time of day clock, if it is desired on each
;  booting of the system.
;	C= BREAKPOINT RESTART NUMBER
;	DE= BREAKPOINT RESTART HANDLER ADDRESS
;	HL= DIRECT XIOS INTERCEPT JUMP TABLE ADDRESS

	mvi	a,0c3h
	sta	0038h
	lxi	h,inthnd
	shld	0039h		; JMP INTHND at 0038H

	mvi	a,0h	
	out	0E2h	; source bank 0
	out	0e5h	; source high 0
	out	0e7h	; dest high 0
	out	0e4h	; source low 0
	out	0e6h	; dest low 0
	out	0e9h	; count high 0
	mvi	a,40h	; move 40h bytes
	out	0e8h	; count low 0

	mvi	a,01h	
	out	0E3h	; destination bank
	; cmd=move s to d, but only to/from common, above boundary
	mvi	a,04h	
	out	0e0h	; single thread, no need to wait

	mvi	a,02h	
	out	0E3h	; destination bank
	mvi	a,04h	
	out	0e0h	; single thread, no need to wait

	mvi	a,03h	
	out	0E3h	; destination bank
	mvi	a,04h	
	out	0e0h	; single thread, no need to wait

	mvi	a,04h	
	out	0E3h	; destination bank
	mvi	a,04h	
	out	0e0h	; single thread, no need to wait

	mvi	a,05h	
	out	0E3h	; destination bank
	mvi	a,04h	
	out	0e0h	; single thread, no need to wait

	mvi	a,06h	
	out	0E3h	; destination bank
	mvi	a,04h	
	out	0e0h	; single thread, no need to wait

	mvi	a,07h	
	out	0E3h	; destination bank
	mvi	a,04h	
	out	0e0h	; single thread, no need to wait

	mvi	a,0h
	out	0bbh	;interval high
	mvi	a,50	;50 * 20 =1000
	out	0bah	;interval low
	mvi 	a,081h	; enable int timer 0
	out	0b8h		; init interrupt 

	db	0edh,056h	; Interrupt Mode 1
				; ** Z80 Instruction **
;	ei

	ret			;   & return

;
; Idle procedure
;
;idle:
;	ret

;	-or-

;	ei
;	hlt
;	ret			; for full interrupt system

;
;  MP/M II V2.0   Interrupt Handlers
;

flagwait equ	132
flagset	equ	133
dsptch	equ	142

inthnd:
			; Interrupt handler entry point
			;  All interrupts gen a RST 7
			;  Location 0038H contains a jmp
			;  to INTHND.
	shld	svdhl
	pop	h
	shld	svdret
	push	psw
	lxi	h,0
	dad	sp
	shld	svdsp		; save users stk ptr
	lxi	sp,lstintstk	; lcl stk for intr hndl
	push	d
	push	b

	mvi	a,0ffh
	sta	preemp	; set preempted flag

	in	0b8h		; read timer 0  
	ani	010000000b	; test & jump if clk int
	jnz	clktick
;	.....
	jmp	intdone


clktick:
				; timer tick interrupt
	lda	tickn
	ora	a		; test tickn, indicates
				;  delayed process(es)
	jz	notickn
	mvi	c,flagset
	mvi	e,1
	call	xdos		; set flag #1 each tick
notickn:
	lxi	h,tickcnt
	dcr	m		; dec tick cntr
	jnz	not1sec
	mvi	m,20
	mvi	c,flagset
	mvi	e,2
	call	xdos		; set flag #2 @ 1 sec
not1sec:
;	jmp	intdone
;
;	...
; Other interrupt handlers
;	...
;
intdone:
	xra	a
	sta	preemp	; clear preempted flag
	pop	b
	pop	d
	lhld	svdsp
	sphl			; restore stk ptr
	pop	psw
	lhld	svdret
	push	h
	lhld	svdhl
; The following dispatch call will force round robin
;  scheduling of processes executing at the same priority
;  each 1/50th of a second.
; Note: Interrupts are not enabled until the dispatcher
;  resumes the next process.  This prevents interrupt
;  over-run of the stacks when stuck or high frequency
;  interrupts are encountered.
	jmp	pdisp		; MP/M dispatch
;
;
;
; BIOS Data Segment
;
tickcnt:	db	20	; 20 tick cntr = 1 sec
intstk:			; local intrpt stk
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h,0c7c7h
lstintstk:
svdhl:	dw	0	; saved Regs HL during int hndl
svdsp:	dw	0	; saved SP during int hndl
svdret:	dw	0	; saved return during int hndl
tickn:	db	0	; ticking boolean,true = delayed
	if	debug
intmsk:	db	44h	; intrpt msk, enables clk intrpt, & con2
	else
intmsk:	db	54h	; intrpt msk, enables clk intrpt, & con0/2
	endif
preemp:	db	0	; preempted boolean
;

	db	0	;force out last byte in hex file

	end
