	title	'MP/M II V2.0   Disk I/O System'

;This DiskIO module for MPM bios does not do logins. 

	public	home,seldsk,settrk,setsec
	public	setdma,read,write,sectran

	extrn	swtuser,swtsys,pdisp,xdos,sysdat

	extrn	d0$all,d1$all,d2$all,d3$all
	extrn	d4$all,d5$all
	extrn	d8$all,d9$all
	extrn	df$all
	extrn	d0$chk,d1$chk,d2$chk,d3$chk
	extrn	d4$chk,d5$chk
	extrn	d8$chk,d9$chk
	extrn	df$chk

false	equ	0
true	equ	not false

	maclib	z80

;	maclib 	diskdef

	cseg

;Banked	equ	false
;Banked	equ	true

df$drv	equ	0		;default drive
sec$sz	equ	80h		;sector size

dsk$cmd equ 0D0h 
dsk$sts equ 0D0h 
dsk$drv		equ	0D1h ;drv
dsk$trkL	equ	0D2h ;trkLow
dsk$trkH	equ	0D3h ;trkHigh
dsk$secL	equ	0D4h ;secLow
dsk$secH	equ	0D5h ;secHigh
dsk$dmaL	equ	0D6h ;dmaLow
dsk$dmaH	equ	0D7h ;dmaHigh
dsk$sptL	equ	0D8h ;sptLow
dsk$sptH	equ	0D9h ;sptHigh
dsk$dmaB	equ	0dah ;Disk DMA Bank
dsk$order	equ	0dbh ;track order

cmd$read	equ	1
cmd$write	equ	2
cmd$log	equ	4
cmd$fmt	equ	8

log$dpb	equ	20h		;offset to dpb in buffer

;read sector

read:
	mvi	a,cmd$read
	sta	bt$cmd
	jmp	dsk$ex		;perform operation

;write sector

write:	
	mvi	a,cmd$write
	sta	bt$cmd		;fall through to dsk exec

;disk executive

dsk$ex:
	call	dpb$ad		;de points to dpb
	xchg			;hl ->dpb
	mov	a,m		;sptLow
	out	dsk$sptL
	inx	hl
	mov	a,m		;sptHigh
	out	dsk$sptH
	xra	a
	out	dsk$order	;sides
	lda	bt$dma
	out	dsk$dmaL
	lda	bt$dma+1	
	out	dsk$dmaH
	mvi	a,0ffh
	out	dsk$dmaB	;use default bank
	lda	bt$drv
	out	dsk$drv
	lda	bt$trk
	out	dsk$trkL
	lda	bt$sec
	out	dsk$secL
	lda	bt$sec+1
	out	dsk$secH
	call	swtuser		;switch to user bank
	lda	bt$cmd
	out	dsk$cmd
	call	swtsys		;switch to system bank
	in	dsk$sts
	ana	a		;set ccr
	ret

;disk read write format exits and errors

dsk$ok:	
	xra	a		;clear a to indicate OK
	ret

dsk$er:	
	mvi	a,0FFh		;set a to indicate ERROR
	ret

seldsk:
	mov	a,c		;get drive no from c
	sta	bt$drv	;save drive no in bt$drv

	mov	a,e		;get log on request from e
	sta	log$rq	;save log on req in log$rq

	mov	l,c
	mvi	h,0
	dad	h		;drive no times 2 in HL
	lxi	d,dr$tbl	;base of Drive Table in DE
	dad	d		;pointer to DPH in HL
	mov	a,m		
	inx	hl
	mov 	h,m
	mov	l,a		;hl contains DPH of drive in c
	shld	dt$ptr	;store DPH
	jr	dsk$ok

;get drv par block address

dpb$ad	lhld	dt$ptr		;ptr to dph table
	lxi	d,10		;
	dad	d		;d points to dpb in dph
	mov	e,m		;get dpb from dph at offset 10
	inx	h		;
	mov	d,m		;
	ret


;home drive

home:	mvi	c,0		;set track to 0 fall into settrk

;set track

settrk:	mov	a,c		;track no in a from c
	sta	bt$trk		;store track number
	ret

;set sector

setsec:	mov	a,c		;low sector no in a from c
	sta	bt$sec		;store sector number low
	mov	a,b			;high sector no in a from b
	sta	bt$sec+1		;store sector number high
	ret

;set dma

setdma:	mov	l,c		;just save in bt$dma
	mov	h,b
	shld	bt$dma
	ret

;sector translation

sectran:	mov	a,d		;testing tbl addr
	ora	e		;chk if 0
	jrz	notran		;no xlation
	xchg			;hl=xlat tbl
	dad	b		;hl + sec offset
	mov	l,m		;
	mvi	h,0		;assumed 8 bit sector numbers
	ret	
notran	lxi	h,1		;add one to sector number and ret
	dad	b		
	ret	

;3740 parameters

sdtran:	db	01h,07h,0dh,13h,19h,05h
		db	0bh,11h,17h,03h,09h,0fh
		db	15h,02h,08h,0eh,14h,1ah
		db	06h,0ch,12h,18h,04h,0ah
		db	10h,16h

;default drive parametr block for 3$5" pc1440
;		pc1440
;		IBM PC
pc$dpb:	dw	72		;spt
	db	4		;bsh
	db	15		;blm
	db	0		;exm
	dw	710		;dsm
	dw	255		;drm
	db	0f0h		;al0
	db	0		;al1
	dw	64		;cks
	dw	2		;off

;default drive parametr block for 8" IBM3740

sd$dpb:	dw	26		;spt
	db	3		;bsh
	db	7		;blm
	db	0		;exm
	dw	242		;dsm
	dw	63		;drm
	db	0c0h		;al0
	db	0		;al1
	dw	16		;cks
	dw	2		;off

hd4$dpb:  DW	128		;sectors per track
	DB	4		;block shift factor
	DB	15		;block mask
	DB	0		;extent mask
	DW	2039		;disk size-1
	DW	1023		;directory max
	DB	255		;alloc 0
	DB	255		;alloc 1
	DW	8000H		;check size
	DW	0		;track offset

hd512$dpb:	DW	16384		;sectors per track
	DB	7		;block shift factor
	DB	127		;block mask
	DB	0		;extent mask
	DW	7FFFH		;disk size-1
	DW	8191		;directory max
	DB	255		;alloc 0
	DB	255		;alloc 1
	DW	8000H		;check size
	DW	0		;track offset

;bios variable storage

bt$cmd	db	0	;dcm command
bt$drv	db	0	;drive number
bt$trk	db	0	;track number
bt$sec	dw	0	;sector number - made 16 bits
bt$sp0	db	0	;spare
bt$sp1	db	0	;spare
bt$mod	db	0	;mode controls
bt$sts	db	0	;command status

bt$lad	dw	0	;load address
bt$lng	dw	0	;load length
bt$dma	dw	0	;system tranfer address

dt$ptr	dw	0	;drive table pointer
log$rq	db	0	;log on request

dr$tbl: dw      d0$dph
        dw      d1$dph
        dw      d2$dph
        dw      d3$dph
        dw      d4$dph
        dw      d5$dph
        dw      0
        dw      0
        dw      d8$dph
        dw      d9$dph
        dw      0
        dw      0
        dw      0
        dw      0
        dw      0
        dw      df$dph

;drive parameter area

d0$dph:	dw	0		;xlat table
	dw	0		;scratch area
	dw	0		;scratch area
	dw	0		;scratch area
	dw	dir$bf		;directory buffer
	dw	pc$dpb		;drive parameter block
	dw	d0$chk		;chk for disk change area
	dw	d0$all		;drive allocation table
d1$dph:	dw	0
	dw	0
	dw	0
	dw	0
	dw	dir$bf
	dw	pc$dpb
	dw	d1$chk
	dw	d1$all
d2$dph:	dw	0
	dw	0
	dw	0
	dw	0
	dw	dir$bf
	dw	pc$dpb
	dw	d2$chk
	dw	d2$all
d3$dph:	dw	0
	dw	0
	dw	0
	dw	0
	dw	dir$bf
	dw	pc$dpb
	dw	d3$chk
	dw	d3$all
d4$dph:	dw	sdtran
	dw	0
	dw	0
	dw	0
	dw	dir$bf
	dw	sd$dpb
	dw	d4$chk
	dw	d4$all
d5$dph:	dw	sdtran
	dw	0
	dw	0
	dw	0
	dw	dir$bf
	dw	sd$dpb
	dw	d5$chk
	dw	d5$all
d8$dph:	dw	0
	dw	0
	dw	0
	dw	0
	dw	dir$bf
	dw	hd4$dpb
	dw	d8$chk
	dw	d8$all
d9$dph:	dw	0
	dw	0
	dw	0
	dw	0
	dw	dir$bf
	dw	hd4$dpb
	dw	d9$chk
	dw	d9$all
df$dph:	dw	0
	dw	0
	dw	0
	dw	0
	dw	dir$bf
	dw	hd512$dpb
	dw	df$chk
	dw	df$all

; buffers

dir$bf	ds	128

eob:	equ	$

