; This is Configure Disk (DC)version 2.4.1 for RAW and IMD images (requires Z80 Emulator 1.0.28 and up)
;	
;
; WARNING- BIOS22Dv23 is modified to prevent older versions of this program from working
; The magic has changed.... (location)like-wise this program wont work on old BIOS22D
;
; This program will configure the Z80 Emulator to access Disk Images in the IMD format
; from OTHER emulator Packages... 
; IT DOES NOT CONFIGURE THE EMULATOR TO RUN SOFTWARE ON THOSE DISKS
;   YOU CAN READ/WRITE THE CONTENTS OF THE DISKS, 
;   BUT THE SOFTWARE ON THOSE DISKS WILL NOT RUN ON THE EMULATOR, 
; 	UNLESS THEY ARE FOR A MACHINE SUPPORTED BY THE Z80 EMULATOR
;
; WARNING-IMD disks contain a variable size disk preamble, based on the comment stored there.
;       open IMD file, and then select disk type with DC. 
;       For IMD, DC only sets up bios DPB and XLT, and the order
; Some IMD disk images contain compressed sector data and/or interleaved sectors... 
;	the z80 emulator(1.0.37 and up) can use compressed data, 
;	it can it understand sector interleave 
;
;WARNING- this program works with CPM2.2 only, and requires a Custom BIOS(BIOS22Dv22.asm)  
;   which reserves extra space for the XLTs, DPBs, ALL, CHK vectors
;(it can work with CPM3 and/or MPM if, and only if the bios for them is modified.)
;WARNING-do not define formats that use more than the available space in 
; XLT tables, CHK vectors and allocation Vectors..
;
;	XLT	CHK	ALL
; A:-P:	256	512	512
;   this provides room for up to 8mb and 2048 directory entries.
; XLT is always at 0xFA00 for every drive
;  because, each drives parameters is kept in a differrent bank.
; A: in bank 0, B: in bank 1, etc, etc P: in bank 15
;
; Changing Drive A: or the currently logged drive is possible.... but dangerous, 
;   you can change it if you know enough.
;
;	XLTs can be 1 or zero based, will convert 0 to 1 base during injection
;
;(note-most BIOSes put a pointer to a shared DPB for disks that are Identical)
;
; This program can be modified to work with ANY BIOS that uses separate DPBs
;   for each disk, or if you want to change multiple disks at a time, it can be made to work
;   with ANY BIOS whether or NOT there's individual DPBs. However, it may not work as you think.
; The program simply writes new DPB info into the DPB 
;   pointed to by the DPH (returned after SELDSK)
; It then writes new sector translate data to the an area for the XLT and 
;   then puts that address in the DPH
; It then reprograms the Z80 Emulator's Disk Controller for the type disk
; IT is designed to run with BIOS22Dv23.ASM. BIOS22Ddv23.ASM has areas reserved 
;   specifically for this program
;
; This program sets sector size to 128 and then uses a modified XLT 
;        to access large sectors as 128 bytes, using the z80 emulator's auto-deblock
;
;This program requires AS8080 to assemble (symbols violate ASM/MAC rules)

	org 	100h

true	equ	-1
false	equ	not true

AS8080		equ	true

	if 	AS8080
		z80
	else
		maclib	z80
	endif

bdos	equ	05h
CR	equ	13
LF	equ	10


	jmp	start

;Storage used for testing OS version

bdos$ver 	dw	0
mpm$ver		dw	0
dir$bio		db	0	; direct bios bdos-0=no-1=yes
run$msg		db	'Running under $'
cpm$msg		db	'CP/M $'
mpm$msg		db	'MP/M $'
II$msg		db	'II $'
pri$msg		db	'Prior to 2.0$'
ukn$msg		db	'Unknown System$'
ext$msg		db	'Exiting$'
bds$msg 	db	'BDOS $'
msd$msg		db	'0.'
lsd$msg		db	'0 $'
noDB$msg 	db	'No '
DB$msg 		db	'BDOS Direct BIOS Support$'
bad$msg		db	'Can not run on this configuration$'
msg.die		db	CR,LF,LF
		db	"Requires Z80 Emulator Version 1.0.28 or higher$"
msg.cpu		db	CR,LF,LF
		db	"Requires Z80 CPU$"
NO$MAGIC	db	CR,LF,LF
		db	"NO MAGIC Requires Special BIOS22Dv22/23.ASM to run$"

BS.DSK	EQU	01BH

DSK$REG$SEL	equ	0cah
DSK$REG$LOW	equ	0c8h
DSK$REG$HI	equ	0c9h

crlf		db	CR,LF
		db	'$'

; Storage for Program

Opening	db	cr,lf
		db	"Configure Disk Version 2.4.1 for Z80 Emulator 1.0.28 and up",cr,lf
		db	'$'

Trm$Msg	db	"Finished",cr,lf
		db	'$'

Ask$disk	db	"Select Disk to be reconfigured(letter only)....B through P - "
		db	'$'

Ask$Type	db	"Select Disk type (two hex characters)- "
		db	'$'

Notice
		DB	"This program will temporarily reconfigure a disk drive to access specific",cr,lf
		db	"  types of disks. The NEW configuration will remain in effect until the next",cr,lf
		db	"  COLD BOOT. You can read and write the disks. ",cr,lf
		db	cr,lf
		DB	"To configure HD image files, use command line option HD, ex. A>DC HD<cr>",cr,lf
		DB	"To configure IMD files, use command line option IMD",cr,lf
		db	cr,lf
		db	'$'
NoticeIMD
		db	"  NOTE-Selecting an IMD disk image only sets emulator for auto deblocking,",cr,lf
		db	"       sets ORDER, IDM flag and configures BIOS's DPB and XLT.",cr,lf
		db	"       You MUST open an IMD image, FIRST,",cr,lf
		db	"       so the Emulator can process and set all other info.",cr,lf
		db	'$'

DiskNumber 	db	0
DiskType	db	0
Stack$Save	dw	0
OptDiskTable	db	0	;0=regular, 1=HD, 2=IMD
DiskTablePtr	dw	DiskTable
NumberOfDisksPtr	db	NumberOfDisks

DPB		dw	0
DPH		dw	0
XLT		dw	0
SPT		dw	0

; - - - - - - - - - - - - - - - - - -
start:
	sspd	Stack$Save
	lxi	sp,Stack
	lxi	d,run$msg
	call	print

; - - - - - - - - - - - - - - - - - -
; check for proper CPM/MPM version

; Check for CPM prior to 2, we can not use CPM prior to 2

	mvi	c,0ch		;get CPM/bdos version
	call	bdos
	shld	bdos$ver

chk$old
	xra	a
	cmp	l		;L=0 for cpm prior to 2.0
	jnz	chk$cpm
	lxi	d,cpm$msg	;CPM
	call	print
	lxi	d,pri$msg	;old CPM
	call 	print
badexit
	call 	printNL
	lxi	d,bad$msg	;Can not run on old CPM
	call	print
	call	printNL		;newline
exit:
	lxi	d,ext$msg	;tell them about exit
	call 	print
	call	Exit$PGM
	jmp	0		;warm boot
	
chk$cpm
	xra	a
	cmp	h		;H=0 for CPM
	jnz	chk$mpm
	lxi	d,cpm$msg	;CPM 
	call	print
	lda	bdos$ver	;get saved bdos version
	call	cnv$htd		;convert to ascii
	lxi	d,msd$msg
	call	print
	lda	bdos$ver	;get saved bdos version
	cpi	030h		;>=3.0 has direct bios in bdos
	jnc	no$dbios
	mvi	a,1
	sta	dir$bio		;set direct bios flag
no$dbios:
	jmp	GOT$CPM2or3

; check for MPM, but can not run on MPM

chk$mpm
	mvi	a,01h		;H=1 for MPM
	cmp	h
	jnz	unknown		;something's weird
	lxi	d,mpm$msg	
	call	print
	mvi	c,0a3h		;get MPM version
	call	bdos
	shld	mpm$ver
	xra	a		;H=0 for MPM 1
	cmp	h
	jnz	chk$mII
	jmp	badexit		;MPM
chk$mII
	mvi	a,1		;H=1 for MPM 2
	cmp	h
	jnz	unknown
	lxi	d,II$msg	;MPM II
	call 	print
	lda	mpm$ver
	call	cnv$htd		;convert to ascii
	lxi	d,msd$msg	;print MPM version
	call	print

	lxi	d,bds$msg	;print bdos indicator
	call	print
	lda	bdos$ver	;get saved bdos version
	call	cnv$htd		;convert to ascii
	lxi	d,msd$msg	;print bdos version
	call	print
	jmp	badexit

unknown
	lxi	d,ukn$msg	;unknown OS
	call	print
	jmp	badexit

;Got something we can use CPM 2 or 3 (both require special bios)
; currently won't worrk on CPM 3 no CPM 3 BIOS has the Magic

GOT$CPM2or3:
	call	printNL		;newline
	lda 	dir$bio		;get saved direct bios flag
	ana	a
	jz	noDB
	lxi	d,nodb$msg	;tell no direct bios
	jmp	yesDB
noDB:
	lxi	d,db$msg	;tell direct bios available
yesDB:	call	print

; - - - - - - - - - - - - - - - - - -
; check for proper emulator version

; if major and minor and rev = 0 then bad
; if rev=0xff then bad
; z80 Emulators prior to 1.0.17 return unused port value of 0 or 0xff

	in 	0xc4		;read major number
	cpi 	0		;port c4 not implemented in wrong vers
	jnz	NOT_000
	in 	0xc5		;read minor number
	cpi 	0		;port c5 not implemented in wrong vers
	jnz	NOT_000
	in 	0xc6		;read revision number
	cpi 	0		;port c6 not implemented in wrong vers
	jz	Ver.Bad
NOT_000
	cpi	0xff		;returns either 0 or ff if bad
	jz	Ver.Bad

; Versioning ports available so find out what version
; We can run on Version 1.0.22 or greater using NEW disk interface

	in 	0xc4		;read major number
	cpi	1
	jc	Ver.Bad
	in 	0xc5		;read minor number
	cpi	0
	jc	Ver.Bad
	in 	0xc6		;read minor number
	cpi	28
	jc	Ver.Bad
	jmp	Ver.OK
Ver.Bad
	lxi	de,msg.die	;death message
	call	PrintDE		;out message
	call	Exit$PGM	;exit if bad so disks dont get trashed
	jmp	0			
Ver.OK

; - - - - - - - - - - - - - - - - - -
; check CPU (we need z80)

	in 	0c2h
	cpi	0
	jz	cpu.OK
	lxi	de,msg.cpu	;death message
	call	PrintDE		;out message
	call	Exit$PGM	;exit if bad so disks dont get trashed
	jmp	0			

cpu.Ok

; - - - - - - - - - - - - - - - - - -
; check for correct BIOS
;  Correct Bios contains Magic 763232 at BIOS+036h
;WARNING version 2 moves magic from BIOS+33 to BIOS+36
;V2 BIOS22D has a bios format entry as per Jade Computer products bios. 
; This allows the JadeDD format program for Z80 EMu to initialize JADE disk images
; it also prevents old version of disk configure from working on wrong bios. 

	LDA	BS.PAG
	MOV	H,A
	mvi	L,036h
	mov	a,m
	CPI	076H
	JNZ	GotNoMagic
	inx	hl
	mov	a,m
	CPI	'2'
	JNZ	GotNoMagic
	inx	hl
	mov	a,m
	CPI	'2'
	JNZ	GotNoMagic
	jmp	RunPGM

GotNoMagic
	lxi	de,NO$MAGIC
	call	PrintDE
	call	Exit$PGM
	jmp 	0
; - - - - - - - - - - - - - - - - - -

RunPGM:

; Get command line option "IMD" is only option

	lxi	hl,0x80
	mov	a,m
	cpi	0
	jz	NoOptions
..skip
	inx	hl	;warning - not testing for all blanks, probably OK
	mov	a,m
	cpi	' '
	jz	..skip
	
	cpi	'I'
	jnz	NotIMD
	inx	hl
	mov	a,m
	cpi	'M'
	jnz	NotIMD
	inx	hl
	mov	a,m
	cpi	'D'
	jnz	NotIMD
;  is IMD so change pointers to disk table and length of table
	mvi	a,2
	sta 	OptDiskTable
	lxi	hl,DiskTableIMD
	shld	DiskTablePtr
	mvi	a,NumberOfDisksIMD
	sta	NumberOfDisksPtr
	jmp	NextOption
NotIMD:	; test for HD
	cpi	'H'
	jnz	NotHD
	inx	hl
	mov	a,m
	cpi	'D'
	jnz	NotHD
;  is HD so change pointers to disk table and length of table
	mvi	a,1
	sta 	OptDiskTable
	lxi	hl,DiskTableHD
	shld	DiskTablePtr
	mvi	a,NumberOfDisksHD
	sta	NumberOfDisksPtr
;	jmp	NextOption
NotHD:
NextOption:	;no more options
NoOptions:

	call	NewLine
	lxi	d,Opening
	call 	PrintDE
	call	NewLine
	lxi	d,Notice
	call 	PrintDE

	lda	OptDiskTable
	cpi	2
	jnz	SkipIMDnotice
	lxi	d,NoticeIMD
	call	PrintDE

SkipIMDnotice:

;find out what disk user wants to configure

Get.SelDisk:
	call	NewLine
	LXI 	d,Ask$disk
	CALL	PrintDE
	CALL	ReadOne
	cpi	'a'
	jc 	notLC	;LT a
	cpi	'q'
	jnc	notLC	;GTE q or GT q

	jmp	Got$diskLC
notLC
	cpi	'A'
	jc 	notUC	;LT A
	cpi	'Q'
	jnc	notUC	;GTE Q or GT Q
	
	jmp 	Got$disk
notUC
	call 	NewLine
	jmp 	Get.SelDisk

Got$diskLC
	sui	'a'-'A'
Got$disk
	sui	'A'
	sta	DiskNumber
	

; - - - - - - - - - - - - - - - - - -
;Find out what the user wants to configure disk as
; supports two digit hex value- 0-9 and a-f ..
	call	NewLine
	call 	PrintMenu

Get.Type:
	Call	NewLine
	LXI 	d,Ask$Type
	CALL	PrintDE

	CALL	ReadOne		;read first char
	call	CHK.Valid
	
	cpi	0ffh
	jz	NOT$Type

	rlc
	rlc
	rlc
	rlc
	
	mov b,a

	CALL	ReadOne		;read second char
	call	CHK.Valid
	
	cpi	0ffh
	jz	NOT$Type

	ora	b	
	lxi	hl,NumberOfDisksPtr
	cmp	m
	jc	Got$Type

NOT$Type
	call 	NewLine
	jmp 	Get.Type

Got$Type

	sta	DiskType

; - - - - - - - - - - - - - - - - - -
; Get pointers to internal data in BIOS for disk config

;get DPH
	lda	DiskNumber
	mov	c,a
	call	SelDisk		; bios call returns DPH in HL
	shld	DPH
;get XLT (not needed, we use predefined locations for all, since could be 0000h)
	mov	e,m		;First entry in DPH points to XLT
	inx	hl
	mov	d,m
	sded	XLT
;get DPB
	lhld	DPH		;DPH + 10 points to DPB
	lxi	de,10
	dad	de
	mov	e,m
	inx	hl
	mov	d,m
	sded	DPB

;get SPT for XLT length 

;get SPT
	lhld	DPB		;First entry in DPB is SPT
	mov	e,m
	inx	hl
	mov	d,m
	sded	SPT

; - - - - - - - - - - - - - - - - - -
; load disk config from EDP table
; this routine writes new disk config data from programs data tables
;   to the Z80 Emulator's Disk Controller config registers
	
;select drive
	lda	DiskType	
	call 	GetEDPptr	;get HL=EDPptr

	mvi	a,018h	;select
	out	DSK$REG$SEL
	lda	DiskNumber	
	out	DSK$REG$LOW

; config the disk

;hl should be ED pointer	

another	mov	a,m	;got size 1=low 2=low/high and FF=finished
	cpi	0ffh
	jz	finished
	cpi	2
	jz	do2
do1	inx	hl
	mov	a,m	;got register selector in a
	out	0cah	;out to select port
	inx	hl
	mov	a,m	;got value to out to register
	out 	0c8h	; out to low reg
	inx	hl
	jmp 	another
do2	inx	hl
	mov	a,m	;got register selector in a
	out	0cah	;out to select port
	inx	hl
	mov	a,m	;got value to out to low register
	out 	0c8h	; out to low reg
	inx	hl
	mov	a,m	;got value to out to high register
	out 	0c9h	; out to high reg
	inx	hl
	jmp 	another
finished


;set parameters
	mvi	a,000h	;select command Reg
	out	DSK$REG$SEL
	mvi	a,07fh	;command is NULL but causes parameters to be set
	out	DSK$REG$LOW

; - - - - - - - - - - - - - - - - - -
;inject DPB from internal program area to DPB in BIOS
; assume CPM 2
; NEEDs work to run on CPM 3 (plus special BIOS)

DPBsize	equ	15	;17 for CPM3

	lda	DiskType	
	call	GetDPBptr	;hl=internal DPB
	lded	DPB		;de=DPB in bios
	lxi	b,DPBsize	;size of dpb
	ldir

; get SPT form internal DPB

	lda	DiskType	
	call	GetDPBptr	;hl=internal DPB
	mov	e,m		;SPT is first entry in DPB
	inx	hl
	mov	d,m
	sded	SPT		;SPT = new SPT

;get XLT pointer from internal table

	lda	DiskType	
	call	GetXLTptr
	mov	a,h
	ora	l
	jz	no$XLT		;zero if no XLT used

	lxi	d,0xFA00

Set$XLT
	lhld	DPH		;set DPH's XLT to value in DE
	mov	m,e
	inx	hl
	mov	m,d

;DE=pointer to XLT in Bios
	lda	DiskType
	call	GetXLTptr	;HL=internal XLT, a= 0 or 1 based
	lbcd	SPT		;count of sectors/bytes in XLT
	cpi	0
	jz	ZeroBase
OneBase
	ldir
	jmp	Exit$Here

ZeroBase
	mov	a,m
	inr	a		; for zero based XLTs
	stax	d
	inx	h
	inx	d
	dcx	b
	mov	a,b
	ora	c
	jnz	ZeroBase

	jmp	Exit$Here

no$XLT
	lhld	DPH		;set DPH's XLT to 0
	mvi	m,0
	inx	hl
	mvi	m,0

; - - - - - - - - - - - - - - - - - -
;Must exit here if after SELDISK Call
Exit$here
	mvi	c,13		;reset disk system
	call	bdos

	call	Exit$PGM
	jmp 	0		;should never happen

; - - - - - - - - - - - - - - - - - -
; this get entered by Cntrl-C check in ReadOne
; also by normal Exit$Here
; it does NOT return to PGM
; Can exit here only if before SELDSK call

Exit$PGM:
	call	NewLine
	lxi	de,Trm$Msg
	call	PrintDE
	lspd	Stack$Save
	ret			; this should return to CPM
; - - - - - - - - - - - - - - - - - -
;Entry	
;	C=disk
;Return
;	HL=ptr to DPH

SelDisk
	push	de
	push	bc
	push	a
	mvi	L,bs.dsk
	call	bios
	pop	a
	pop	bc
	pop	de
	ret

; - - - - - - - - - - - - - - - - - -
BS.PAG	EQU	02H

;BIOS TRANSFER ROUTINE (only works with CPM 2)

BIOS	LDA	BS.PAG
	MOV	H,A
	PCHL
; - - - - - - - - - - - - - - - - - -

; CONSOLE LINKAGE - BDOS CALLS

CNS.RD	EQU	1
CNS.WR	EQU	2

CNTL.C	EQU	3
REBOOT	EQU	0

ReadOne:
	push	b
	push	d
	push	h
	MVI	C,CNS.RD
	CALL	BDOS
	pop	h
	pop	d
	pop	b
	ANI	07FH
	CPI	CNTL.C
	CZ	Exit$PGM
	RET
	
WriteOne:
	PUSH	H
	MOV	E,A
	MVI	C,CNS.WR
	CALL	BDOS
	POP	H
	RET
	
; - - - - - - - - - - - - - - - - - -
;entry 
;	A=char
;return 
;	HEX character value or FF if bad

Valid$Chars
	db	'0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f'
	db	'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'
;   YES it checks 0-9 twice, but i dont care
CHK.valid	
	push	b
	push	h
	lxi	h,Valid$Chars+31
	mvi	b,16
..loop	
	cmp	m		;match?
	jz	Char$OK		;OK
	dcx	h		;point to next chars
	dcr	b		;dec count of characters
	jnz	..loop		;again

;	lxi	h,Valid$Chars+15
	mvi	b,16
..loop	
	cmp	m		;match?
	jz	Char$OK		;OK
	dcx	h		;point to next chars
	dcr	b		;dec count of characters
	jnz	..loop		;again
	
Char$OK	
	dcr	b
	mov	a,b
	pop	h
	pop	b
	ret

; - - - - - - - - - - - - - - - - - -
;convert Binary in A to Hex 
HEX2:
HEX2H	db	030h
HEX2L	db	030h
	db	'$'
BIN2HEX:	
	push	a		
	push	a
	ani	0f0h
	rrc
	rrc	
	rrc
	rrc
	cpi	0ah
	jc	notA_FH
	adi	041h-03ah
notA_FH
	adi	030h
	sta	HEX2H
	pop	a
	ani	0fh
	cpi	0ah
	jc	notA_FL
	adi	041h-03ah
notA_FL
	adi	030h
	sta 	HEX2L
	pop	a
	ret

; - - - - - - - - - - - - - - - - - -
PrintHEX2:
	push	de
	call	BIN2HEX
	lxi	de,HEX2
	call	PrintDE
	pop	de
	ret
; - - - - - - - - - - - - - - - - - -

GetDiskEntryPtr:

;Entry
;	A=Disk Number
;Returns 
;	DE=entry size
;	HL=ptr to disk entry
;	A=0

	lhld	DiskTablePtr
	lxi	de,8
..loop
	ora	a
	rz
	dad	d
	dcr	a
	jmp	..loop
; - - - - - - - - - - - - - - - - - -
GetHLDEptr:

;Entry
;	DE= offset
;	HL=PTR
;Returns
;	hl=ptr at HL + DE

	dad	de
	mov	e,m
	inx	hl
	mov	d,m
	mov	h,d
	mov	l,e
	ret
; - - - - - - - - - - - - - - - - - -
GetLABptr:

;Entry
;	A=Disk Number
;Returns
;	hl=ptr to disk LABEL

	push	de
	push	a
	call	GetDiskEntryPtr
	lxi	de,0
	call 	GetHLDEptr	
	pop	a
	pop	de
	ret
; - - - - - - - - - - - - - - - - - -
GetDPBptr:

;Entry
;	A=Disk Number
;Returns
;	hl=ptr to disk DPB

	push	de
	push	a
	call	GetDiskEntryPtr
	lxi	de,4
	call 	GetHLDEptr	
	pop	a
	pop	de
	ret
; - - - - - - - - - - - - - - - - - -
GetEDPptr:

;Entry
;	A=Disk Number
;Returns
;	hl=ptr to disk Emu Disk Configuration

	push	de
	push	a
	call	GetDiskEntryPtr
	lxi	de,2
	call 	GetHLDEptr	
	pop	a
	pop	de
	ret

; - - - - - - - - - - - - - - - - - -
GetXLTptr:

;Entry
;	A=Disk Number
;Returns
;	hl=ptr to disk Emu Disk Configuration
;	a=0 or 1 based

	push	de
	call	GetDiskEntryPtr
	lxi	d,6
	call 	GetHLDEptr
	dcx	h
	mov	a,m
	inx	h
	pop	de
	ret
; - - - - - - - - - - - - - - - - - -
PrintHL:
	push	de
	mov	e,l
	mov	d,h
	call	PrintDE
	pop 	de
	ret
; - - - - - - - - - - - - - - - - - -
PrintDE:
	push	hl
	push	bc
	push	a
	mvi	c,9
	call	bdos
	pop	a
	pop	bc
	pop	hl
	ret
; - - - - - - - - - - - - - - - - - -
NL	db	13,10,'$'
NewLine:
	push	de
	lxi	de,NL
	call	PrintDE
	pop	de
	ret
; - - - - - - - - - - - - - - - - - -
SP	db	' ','$'
PrintSpace:
	push	de
	lxi	de,SP
	call	PrintDE
	pop	de
	ret
; - - - - - - - - - - - - - - - - - -


PrintMenu:
	call	NewLine
	mvi	a,0
..loop
	call	PrintHex2
	call	PrintSpace
	call	GetLABptr
	call	PrintHL
	call	NewLine
	inr	a
	lxi	hl,NumberOfDisksPtr
	cmp	m
	jnz	..loop
;	call	NewLine
	ret
	
; - - - - - - - - - - - - - - - - - -
;Print NewLine and Print

printNL	lxi	d,crlf
print:	
	mvi	c,09h
	jmp	bdos

; - - - - - - - - - - - - - - - - - -
;convert to bcd
cnv$htd:			
	push	psw
	ani	0f0h
	rrc
	rrc	
	rrc
	rrc
	adi	030h
	sta	msd$msg
	pop	psw
	ani	0fh
	adi	030h
	sta	lsd$msg
	ret
; - - - - - - - - - - - - - - - - - -
;DPBs/DISK configuration
; - - - - - - - - - - - - - - - - - -

; Label,EMU Disk Parameters,DPB,XLT

DiskTable	
	dw 	PC1440L,PC1440P,PC1440D,0
	dw 	PC4104L,PC4104P,PC4104D,0
	dw 	PC8190L,PC8190P,PC8190D,0

	dw 	ibm8L,ibm8P,ibm8D,ibm8X

	dw 	F1440L,F1440P,F1440D,0

 	dw	AppleIIL,AppleIIP,AppleIID,AppleIIX

	dw	vme10t48L,vme10t48P,vme10t48D,0
	dw	vme10t96L,vme10t96P,vme10t96D,0

	dw	mits2L,mits2P,mits2D,mitsX	;uses 137 byte sectors
	dw	mitsL,mitsP,mitsD,mitsX		;uses 137 byte sectors

	dw 	eps1L,eps1P,eps1D,0
	dw 	eps2L,eps2P,eps2D,0
	dw 	eps3L,eps3P,eps3D,0

	dw 	ACdsdL,ACdsdP,ACdsdD,B1G20x128k2L128
	dw 	LFT720L,LFT720P,LFT720D,0


NumberOfDisks	equ 	($-DiskTable)/8

DiskTableHD	
	dw 	PC4104L,PC4104P,PC4104D,0
	dw 	PC8190L,PC8190P,PC8190D,0

	dw	vme10HD5L,vme10HD5P,vme10HD5D,0

	dw	mithdL,mithdP,mithdD,0 

	dw	UMHD4L,UMHD4P,UMHD4D,0

	dw	LBLD2N1,EPBD2N,DPBD2N1,0 
	dw	LBLD2N2,EPBD2N,DPBD2N2,0 
	dw	LBLD2N3,EPBD2N,DPBD2N3,0

NumberOfDisksHD	equ 	($-DiskTableHD)/8


DiskTableIMD	
	dw 	PC1440IMDL,PC1440IMDP,PC1440D,0

	dw 	ibm8IMDL,ibm8IMDP,ibm8D,ibm8X

	dw 	F1440IMDL,F1440IMDP,F1440D,0

	dw	AppleIIIMDL,AppleIIIMDP,AppleIID,AppleIIX

	dw	vme10t48IMDL,vme10t48IMDP,vme10t48D,0
	dw	vme10t96IMDL,vme10t96IMDP,vme10t96D,0

	dw 	eps1IMDL,eps1IMDP,eps1D,0
	dw 	eps2IMDL,eps2IMDP,eps2D,0
	dw 	eps3IMDL,eps3IMDP,eps3D,0

	dw 	ACdsdIMDL,ACdsdIMDP,ACdsdD,B1G20x128k2L128
	dw 	LFT720IMDL,LFT720IMDP,LFT720D,0

	dw 	LBLF8S0,EPBF8S0,DPBF8S0,XLT8S0
	dw 	LBLF8S1,EPBF8S1,DPBF8S1,XLT8S0
	dw 	LBLF8D2,EPBF8D2,DPBF8D2,XLT8D1
	dw 	LBLF8D3,EPBF8D3,DPBF8D3,XLT8D1
	dw 	LBLF8D4,EPBF8D4,DPBF8D4,XLT8D2
	dw 	LBLF8D5,EPBF8D5,DPBF8D5,XLT8D2
	dw 	LBLF8D6,EPBF8D6,DPBF8D6,XLT8D3
	dw 	LBLF8D7,EPBF8D7,DPBF8D7,XLT8D3

NumberOfDisksIMD	equ 	($-DiskTableIMD)/8
; - - - - - - - - - - - - - - - - - -
;the parameters used to configure the z80 emulator's disk controller 
;  may not be completly correct, but work with auto deblock to read and write disks...
; we always use a sector size of 128...
; we set XLT 4 at a time (for 512 byte sectors).. 
; we multiply number of real sectors by 4 (for 512 byte sectors)
;  and allow the z80 emulator to do the deblocking
; only disk images that require pre/post 
;	or use auto deblk , such as IMD files with sector size >128
;	have the real sector size set,
;   but then only for deblocking , 
;   CPM still uses 128 byte sector size but emulator knows it is 512
; - - - - - - - - - - - - - - - - - -
; IMD disks have variable preamble sizes, 
;  first open the IMD file allow the emulator to process IMD file and set disk parameters
;  to whatever value is found in the IMD file.
;  then use Disk Configure to set only values needed to auto deblock; and, for IDM flag and ORDER
;   and select DONT use prepost, unless your OS is planning to do deblocking


; NOTE - allowing the emulator to set all values , would set them for some OS to do deblocking
;  the values set here are for CPM 2.x (no deblocking), with the emulator doing the deblocking
; - - - - - - - - - - - - - - - - - -


Set8	macro	?Register,?Value
	db	1,?Register,?Value
	endm
Set16	macro	?Register,?Value
	db	2,?Register
	dw	?Value
	endm
; - - - - - - - - - - - - - - - - - -

;default drive parameters for IBM 3740

ibm8IMDL
	db	"Standard 8 IBM 3740 Single Sided Single Density(IMD)$"

ibm8IMDP:
	set8	080h,0	;order
	set16	09ah,0	;IDM flag	0

	db	0ffh

; - - - - - - - - - - - - - - - - - -

;default drive parameters for IBM 3740

ibm8L
	db	"Standard 8 IBM 3740 Single Sided Single Density$"

ibm8P:
	set8	080h,0	;order
	set8	081h,0	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,77	;Cylinders
	set8	0a1h,1	;Heads

	set8	0a3h,1	;density	(data) 	Single=1
	set16	0a4h,26	;SPT		(data) 
	set8	0a5h,0	;Sector Size	(data) 	128
	set8	0a6h,2	;clock		(data) 	8inch=2

	db	0ffh

ibm8D
	dw	26		;spt
	db	3		;bsh
	db	7		;blm
	db	0		;exm
	dw	242		;dsm
	dw	63		;drm
	db	0c0h		;al0
	db	0		;al1
	dw	16		;cks
	dw	2		;off
	DB	0,0		;physical sector size and shift

; - - - - - - - - - - - - - - - - - -
;default drive parameters for VME10 48 tpi 5.25

vme10t48IMDL
	db	"VME10 5.25 48 tpi Double Density(IMD)$"

vme10t48IMDP:

	set8	080h,1	;order 0,79,1,78,2,77,....

	set16	09ah,0	;IDM flag	0

	set16	0a4h,32	;SPT		(data)  32 (8 512)
	set8	0a5h,0	;Sector Size	(data) 	128

	set16	0b4h,16	;SPT		(T0) 	16 (16 128)
	set8	0b5h,0	;Sector Size	(T0) 	128

	set16	0c4h,32	;SPT		(SYS)   32 (8 512)
	set8	0c5h,0	;Sector Size	(SYS) 	128

	db	0ffh

vme10t48L
	db	"VME10 5.25 48 tpi Double Density$"

vme10t48P:
	set8	080h,1	;order
	set8	081h,1	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,40	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,2	;density	(data) 	Double
	set16	0a4h,32	;SPT		(data)  32 (8 512)
	set8	0a5h,0	;Sector Size	(data) 	128
	set8	0a6h,3	;clock		(data) 	5inch

	set16	0b2h,1	;#t0
	set8	0b3h,1	;density	(T0) 	single
	set16	0b4h,16	;SPT		(T0) 	16 (16 128)
	set8	0b5h,0	;Sector Size	(T0) 	128
	set8	0b6h,3	;clock		(T0)	5inch

	set16	0c2h,1	;#sys
	set8	0c3h,2	;density	(SYS) 	Double
	set16	0c4h,32	;SPT		(SYS)   32 (8 512)
	set8	0c5h,0	;Sector Size	(SYS) 	128
	set8	0c6h,3	;clock		(SYS) 	5inch

	db	0ffh

vme10t48D
	dw	32		;spt
	db	4		;bsh
	db	15		;blm
	db	1		;exm
	dw	153		;dsm	(155 is max, but they used 153)
	dw	127		;drm
	db	0c0h		;al0
	db	0		;al1
	dw	32		;cks
	dw	2		;off
	DB	0,0		;physical sector size and shift

; - - - - - - - - - - - - - - - - - -
;default drive parameters for VME10 96 tpi 5.25

vme10t96IMDL
	db	"VME10 5.25 96 tpi Double Density(IMD)$"

vme10t96IMDP:

	set8	080h,1	;order 

	set16	09ah,0	;IDM flag	0

	set16	0a4h,32	;SPT		(data)  32 (8 512)
	set8	0a5h,0	;Sector Size	(data) 	128

	set16	0b4h,16	;SPT		(T0) 	16 (16 128)
	set8	0b5h,0	;Sector Size	(T0) 	128

	set16	0c4h,32	;SPT		(SYS)   32 (8 512)
	set8	0c5h,0	;Sector Size	(SYS) 	128

	db	0ffh
vme10t96L
	db	"VME10 5.25 96 tpi Double Density$"

vme10t96P:
	set8	080h,1	;order
	set8	081h,1	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,80	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,2	;density	(data) 	Double
	set16	0a4h,32	;SPT		(data)  32 (8 512)
	set8	0a5h,0	;Sector Size	(data) 	128
	set8	0a6h,3	;clock		(data) 	5inch

	set16	0b2h,1	;#t0
	set8	0b3h,1	;density	(T0) 	single
	set16	0b4h,16	;SPT		(T0) 	16 (16 128)
	set8	0b5h,0	;Sector Size	(T0) 	128
	set8	0b6h,3	;clock		(T0)	5inch

	set16	0c2h,1	;#sys
	set8	0c3h,2	;density	(SYS) 	Double
	set16	0c4h,32	;SPT		(SYS)   32 (8 512)
	set8	0c5h,0	;Sector Size	(SYS) 	128
	set8	0c6h,3	;clock		(SYS) 	5inch

	db	0ffh

vme10t96D
	dw	32		;spt
	db	4		;bsh
	db	15		;blm
	db	1		;exm
	dw	313		;dsm	(315 is max, but they used 313)
	dw	127		;drm
	db	0c0h		;al0
	db	0		;al1
	dw	32		;cks
	dw	2		;off
	DB	0,0		;physical sector size and shift

; - - - - - - - - - - - - - - - - - -
vme10HD5L
	db	"VME10 5MB HD$"

vme10HD5P:
	set8	080h,0	;order
	set8	081h,0	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,306	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,2	;density	(data) 	Double
	set16	0a4h,64	;SPT		(data)  64 (32 256)
	set8	0a5h,0	;Sector Size	(data) 	128
	set8	0a6h,1	;clock		(data) 	HD

	db	0ffh

vme10HD5D
	dw	64		;spt
	db	5		;bsh
	db	31		;blm
	db	1		;exm
	dw	1215		;dsm	
	dw	1023		;drm
	db	0ffh		;al0
	db	0		;al1
	dw	256		;cks
	dw	2		;off
	DB	0,0		;physical sector size and shift

; - - - - - - - - - - - - - - - - - -
; NOTE order is 0,159,1,158,2,157 .... 77,82,78,81, 79,80


F1440IMDL
	db	"CPM-86 3.5 F144(IMD)$"

F1440IMDP:

	set8	080h,1	;order = cylinders, not sides
	set16	09ah,0	;IDM flag	0

	set16	0a4h,72	;SPT		(data)  72 (18 512)
	set8	0a5h,0	;Sector Size	(data) 	128

	db	0ffh


F1440L
	db	"CPM-86 3.5 F144$"

F1440P:
	set8	080h,1	;order = cylinders, not sides
	set8	081h,0	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,80	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,2	;density	(data) 	Double=2
	set16	0a4h,72	;SPT		(data) 
	set8	0a5h,0	;Sector Size	(data) 	128=0
	set8	0a6h,4	;clock		(data) 	3inch=4

	db	0ffh

F1440D
	dw	72		;spt
	db	5		;bsh
	db	31		;blm
	db	1		;exm
	dw	354		;dsm
	dw	255		;drm
	db	0c0h		;al0
	db	0		;al1
	dw	64		;cks
	dw	2		;off
	DB	0,0		;phys and m

; - - - - - - - - - - - - - - - - - -
AppleIIL	db	"Apple II$"

; NOTE these parameters work, but do not properly match the real parameters
; Works with IMage file from ALTAIRZ80 
; MAY NOT WORK WITH OTHER IMAGE FILES FOR APPLE II
; The Real disk had 16 256 byte sectors, 
;    but the Z80 Emu will auto deblock if the image file is just-right
; the trick is in the XLT table and setting SPT to 32 128 byte sectors

AppleIIIMDL
	db	"Apple II(IMD)$"

AppleIIIMDP:

	set8	080h,0	;order 

	set16	09ah,0	;IDM flag	0

	set16	0a4h,32	;SPT		(data)  32 (16 256)
	set8	0a5h,0	;Sector Size	(data) 	128

	db	0ffh

AppleIIP:
	set8	080h,0	;order
	set8	081h,0	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,35	;Cylinders
	set8	0a1h,1	;Heads

	set8	0a3h,0	;density	(data) 	dont care
	set16	0a4h,32	;SPT		(data) 	16
	set8	0a5h,0	;Sector Size	(data) 	128
	set8	0a6h,0	;clock		(data) 	dont care

	db	0ffh

AppleIID
	dw	32		; spt, sectors per track
	db	3		; allocation block shift factor, bsh
	db	7		; data allocation block mask, blm, allocation size (bls) = 2048
	db	0		; extent mask
	dw	0x7f		; dsm, maximum data block number
	dw	0x2f		; drm, number of directory entries - 1
	db	0C0h,0		; al0, al1, 4 blocks reserved to hold all entries
				; 256 * 32 = 4 * 2048
				; (drm+1) * 32 = (number of bits in al0 and al1) * bls
	dw	0Ch		; cks = (drm + 1)/4
	dw	3		; off, number of tracks skipped at beginning of disk
	db	0		; PSH
	db	0		; PHM

; - - - - - - - - - - - - - - - - - -
; drive parametr block for Epson CPM 2.2 and TPM II

eps1IMDL
	db	"Epson QX-10 CPM 2.2 and TPM II (2x40 = 4x16x256 + 76x10x512)(IMD)$"

eps1IMDP:

	set8	080h,0	;order 

	set16	09ah,0	;IDM flag	0

	set16	0a4h,40	;SPT		(data)  10
	set8	0a5h,0	;Sector Size	(data) 	128

	set16	0b4h,32	;SPT		(T0) 	32 (16 256)
	set8	0b5h,0	;Sector Size	(T0) 	128

	set16	0c4h,32	;SPT		(SYS)   32 (16 256)
	set8	0c5h,0	;Sector Size	(SYS) 	128

	db	0ffh

eps1L
	db	"Epson QX-10 CPM 2.2 and TPM II (2x40 = 4x16x256 + 76x10x512)$"

eps1P:
	set8	080h,0	;order
	set8	081h,1	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,40	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,2	;density	(data) 	Double
	set16	0a4h,40	;SPT		(data)  40 (10 512)
	set8	0a5h,0	;Sector Size	(data) 	128
	set8	0a6h,3	;clock		(data) 	5inch

	set16	0b2h,1	;#t0
	set8	0b3h,2	;density	(T0) 	Double
	set16	0b4h,32	;SPT		(T0) 	32 (16 256)
	set8	0b5h,0	;Sector Size	(T0) 	128
	set8	0b6h,3	;clock		(T0)	5inch

	set16	0c2h,3	;#sys
	set8	0c3h,2	;density	(SYS) 	Double
	set16	0c4h,32	;SPT		(SYS)   32 (16 256)
	set8	0c5h,0	;Sector Size	(SYS) 	128
	set8	0c6h,3	;clock		(SYS) 	5inch

	db	0ffh

eps1D
	dw	40		;spt
	db	4		;bsh
	db	15		;blm
	db	1		;exm
	dw	189		;dsm
	dw	127		;drm
	db	0c0h		;al0
	db	0		;al1
	dw	32		;cks
	dw	4		;off
	DB	0,0		;physical sector size and shift

; - - - - - - - - - - - - - - - - - -
; drive parametr block for Epson TPM III

eps3IMDL
	db	"Epson QX-10 TPM III (2x40 = 1x16x256 + 79x10x512)(IMD)$"

eps3IMDP:
	set8	080h,0	;order 
	set16	09ah,0	;IDM flag	0

	set16	0a4h,40	;SPT		(data)  40 (10 512)
	set8	0a5h,0	;Sector Size	(data) 	128

	set16	0b4h,32	;SPT		(T0) 	32 (16 256)
	set8	0b5h,0	;Sector Size	(T0) 	128

	set16	0c4h,40	;SPT		(SYS)   40 (10 512)
	set8	0c5h,0	;Sector Size	(SYS) 	128

	db	0ffh

eps3L
	db	"Epson QX-10 TPM III (2x40 = 1x16x256 + 79x10x512)$"

eps3P:
	set8	080h,0	;order
	set8	081h,1	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,40	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,2	;density	(data) 	Double
	set16	0a4h,40	;SPT		(data)  40 (10 512)
	set8	0a5h,0	;Sector Size	(data) 	128
	set8	0a6h,3	;clock		(data) 	5inch

	set16	0b2h,1	;#t0
	set8	0b3h,2	;density	(T0) 	Double
	set16	0b4h,32	;SPT		(T0) 	32 (16 256)
	set8	0b5h,0	;Sector Size	(T0) 	128
	set8	0b6h,3	;clock		(T0)	5inch

	set16	0c2h,1	;#sys
	set8	0c3h,2	;density	(SYS) 	Double
	set16	0c4h,40	;SPT		(SYS)   40 (10 512)
	set8	0c5h,0	;Sector Size	(SYS) 	128
	set8	0c6h,3	;clock		(SYS) 	5inch

	db	0ffh

; - - - - - - - - - - - - - - - - - -

eps3D
	dw	40		;spt
	db	4		;bsh
	db	15		;blm
	db	1		;exm
	dw	196		;dsm
	dw	127		;drm
	db	0c0h		;al0
	db	0		;al1
	dw	32		;cks
	dw	4		;off
	DB	0,0		;physical sector size and shift

; - - - - - - - - - - - - - - - - - -
; drive parametr block for Epson QX-10 CPM 3(256 bps)

eps2IMDL
	db	"Epson QX-10 CPM 2.2 and CPM 3 (2x40 80x16x256)(IMD)$"

eps2IMDP:
	set8	080h,0	;order 
	set16	09ah,0	;IDM flag	0

	set16	0a4h,32	;SPT		(data)  32 (16 256)
	set8	0a5h,0	;Sector Size	(data) 	128

	db	0ffh

eps2L
	db	"Epson QX-10 CPM CPM 2.2 and CPM 3 (2x40 80x16x256)$"

eps2P:
	set8	080h,0	;order
	set8	081h,0	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,40	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,2	;density	(data) 	Double
	set16	0a4h,32	;SPT		(data)  32 (16 256)
	set8	0a5h,0	;Sector Size	(data) 	128
	set8	0a6h,3	;clock		(data) 	5inch

	db	0ffh

eps2D
	dw	32		;spt
	db	4		;bsh
	db	15		;blm
	db	1		;exm
	dw	143		;dsm
	dw	63		;drm
	db	080h		;al0
	db	0		;al1
	dw	16		;cks
	dw	8		;off
	DB	0,0		;physical sector size and shift

; - - - - - - - - - - - - - - - - - -
; drive parametr block for Acorn 

ACdsdIMDL
	db	"Acorn CPM 2.2 (2x80 160x5x512)(IMD)$"

ACdsdIMDP:
	set8	080h,1	;order 
	set16	09ah,0	;IDM flag	0

	set16	0a4h,20	;SPT		(data)  20 (5 512)
	set8	0a5h,0	;Sector Size	(data) 	128

	db	0ffh

; - - - - - - - - - - - - - - - - - -
;default drive parametr block for Acorn

ACdsdL
	db	"Acorn CPM 2.2 (2x80 160x5x512)$"

ACdsdP:
	set8	080h,1	;order
	set8	081h,0	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,80	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,1	;density	(data) 	Single
	set16	0a4h,20	;SPT		(data)  20 (5 512)
	set8	0a5h,0	;Sector Size	(data) 	128
	set8	0a6h,4	;clock		(data) 	3inch

	db	0ffh

ACdsdD
	dw	20		;spt
	db	4		;bsh
	db	15		;blm
	db	1		;exm
	dw	195		;dsm
	dw	127		;drm
	db	0c0h		;al0
	db	0		;al1
	dw	32		;cks
	dw	3		;off
	DB	0,0		;physical sector size and shift

; - - - - - - - - - - - - - - - - - -

;default drive parametr block for 3$5" pc1440

; - - - - - - - - - - - - - - - - - -
PC1440IMDL
	db	"Z80 Emulator PC1440 3.5(IMD)$"

PC1440IMDP:

	set8	080h,0	;order 

	set16	09ah,0	;IDM flag	0
	set8 	082h,0	;DONT use prepost

	set16	0a4h,72	;SPT		(data)  72 (18 512)
	set8	0a5h,0	;Sector Size	(data) 	128

	db	0ffh

PC1440L
	db	"Z80 Emulator PC1440 3.5$"

PC1440P:
	set8	080h,0	;order
	set8	081h,0	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,80	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,2	;density	(data) 	Double=2
	set16	0a4h,72	;SPT		(data) 
	set8	0a5h,0	;Sector Size	(data) 	128=0
	set8	0a6h,4	;clock		(data) 	3inch=4

	db	0ffh


PC1440D
	dw	72		;spt
	db	4		;bsh
	db	15		;blm
	db	0		;exm
	dw	710		;dsm
	dw	255		;drm
	db	0f0h		;al0
	db	0		;al1
	dw	64		;cks
	dw	2		;off
	DB	0,0		;physical sector size and shift

; - - - - - - - - - - - - - - - - - -
;these have NO IMD format
; - - - - - - - - - - - - - - - - - -

;default drive parametr block for pc4104

; - - - - - - - - - - - - - - - - - -

PC4104L
	db	"Z80 Emulator PC4104$"

PC4104P:
	set8	080h,0	;order
	set8	081h,0	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,228	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,2	;density	(data) 	Double=2
	set16	0a4h,72	;SPT		(data) 
	set8	0a5h,0	;Sector Size	(data) 	128=0
	set8	0a6h,4	;clock		(data) 	3inch=4

	db	0ffh


PC4104D
	dw	72		;spt
	db	4		;bsh
	db	15		;blm
	db	0		;exm
	dw	2042		;dsm
	dw	1023		;drm
	db	0ffh		;al0
	db	0ffh		;al1
	dw	256		;cks
	dw	2		;off
	DB	0,0		;physical sector size and shift

;default drive parametr block for pc8190

; - - - - - - - - - - - - - - - - - -
PC8190L
	db	"Z80 Emulator PC8190$"

PC8190P:
	set8	080h,0	;order
	set8	081h,0	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,445	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,2	;density	(data) 	Double=2
	set16	0a4h,72	;SPT		(data) 
	set8	0a5h,0	;Sector Size	(data) 	128=0
	set8	0a6h,4	;clock		(data) 	3inch=4

	db	0ffh


PC8190D
	dw	72		;spt
	db	5		;bsh
	db	31		;blm
	db	1		;exm
	dw	2042		;dsm
	dw	2047		;drm
	db	0ffh		;al0
	db	0ffh		;al1
	dw	512		;cks
	dw	2		;off
	DB	0,0		;physical sector size and shift

; - - - - - - - - - - - - - - - - - -

;default drive parametr block for TD8LF720

; - - - - - - - - - - - - - - - - - -
LFT720IMDL
	db	"LFT 720 (IMD)$"

LFT720IMDP:

	set8	080h,1	;order 
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a4h,36	;SPT		(data)  72 (18 512)
	set8	0a5h,0	;Sector Size	(data) 	128

	db	0ffh

LFT720L
	db	"LFT 720$"

LFT720P:
	set8	080h,1	;order
	set8	081h,0	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,80	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,2	;density	(data) 	Double=2
	set16	0a4h,36	;SPT		(data) 
	set8	0a5h,0	;Sector Size	(data) 	128=0
	set8	0a6h,4	;clock		(data) 	3inch=4

	db	0ffh


LFT720D
	dw	36		;spt
	db	4		;bsh
	db	15		;blm
	db	0		;exm
	dw	356		;dsm
	dw	255		;drm
	db	0f0h		;al0
	db	0		;al1
	dw	64		;cks
	dw	1		;off
	DB	0,0		;physical sector size and shift


; - - - - - - - - - - - - - - - - - -	
;The following formats for the MITS fdc uses 137 byte sectors.
; - - - - - - - - - - - - - - - - - -
; This disk has 128 byte sectors for CPM stored in 137 byte sectors with 9 extra bytes
mits2L
	db	"AltairZ80 mits2$"

mits2P:
	set8	080h,0		;order
	set8	081h,0		;formatType
	set8 	082h,1		;use prepost

	set16	09ah,0		;IDM flag	0

	set16	0a0h,254	;Cylinders
	set8	0a1h,1		;Heads

	set8	0a3h,2		;density	(data) 	Double
	set16	0a4h,32		;SPT		(data) 
	set8	0a5h,0		;Sector Size	(data) 	128
	set8	0a6h,2		;clock		(data) 	8inch
	set8	0a8h,0		;pSector Size	(data) 	128

	set16	0d0h,0	;disk pre
	set16	0d1h,0	;disk post
	set16	0d2h,0	;track pre
	set16	0d3h,0	;track post
	set16	0d8h,3	;sector pre
	set16	0d9h,6	;sector post

	db	0ffh


mits2D
	dw	32		; spt, sectors per track
	db	4		; allocation block shift factor, bsh
	db	15		; data allocation block mask, blm, allocation size (bls) = 2048
	db	0		; extent mask
	dw	0x1ef		; dsm, maximum data block number
	dw	255		; drm, number of directory entries - 1
	db	0f0h,0		; al0, al1, 4 blocks reserved to hold all entries
				; 256 * 32 = 4 * 2048
				; (drm+1) * 32 = (number of bits in al0 and al1) * bls
	dw	32		; cks = (drm + 1)/4
	dw	6		; off, number of tracks skipped at beginning of disk
	db	0		; PSH
	db	0		; PHM

; - - - - - - - - - - - - - - - - - -
; This disk has 128 byte sectors for CPM stored in 137 byte sectors with 9 extra bytes
; - - - - - - - - - - - - - - - - - -
mitsL
	db	"AltairZ80 mits$"
mitsP:
	set8	080h,0	;order
	set8	081h,0	;formatType
	set8 	082h,1	;use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,35	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,2	;density	(data) 	Double
	set16	0a4h,32	;SPT		(data) 
	set8	0a5h,0	;Sector Size	(data) 	128
	set8	0a6h,3	;clock		(data) 	5inch
	set8	0a8h,0	;pSector Size	(data) 	128

	set16	0d0h,0	;disk pre
	set16	0d1h,0	;disk post
	set16	0d2h,0	;track pre
	set16	0d3h,0	;track post
	set16	0d8h,3	;sector pre
	set16	0d9h,6	;sector post

	db	0ffh


mitsD
	dw	32		; spt, sectors per track
	db	3		; allocation block shift factor, bsh
	db	7		; data allocation block mask, blm, allocation size (bls) = 1024
	db	0		; extent mask
	dw	254		; dsm, maximum data block number
	dw	255		; drm, number of directory entries - 1
	db	0ffh,0		; al0, al1, 8 blocks reserved to hold all entries
				; 256 * 32 = 8 * 1024
				; (drm+1) * 32 = (number of bits in al0 and al1) * bls
	dw	32		; cks = (drm + 1)/4
	dw	6		; off, number of tracks skipped at beginning of disk
	db	0		; PSH
	db	0		; PHM

; - - - - - - - - - - - - - - - - - -
;  for Udo Munk's Z80SIM 4MB HD

UMHD4L
	db	"Z80SIM 4MB HD$"

UMHD4P:
	set8	080h,0		;order
	set8	081h,0		;formatType
	set8 	082h,0		;DONT use prepost

	set16	09ah,0		;IDM flag	0

	set16	0a0h,255	;Cylinders
	set8	0a1h,1		;Heads

	set8	0a3h,0		;density	(data) 	Don't care
	set16	0a4h,128	;SPT		(data) 
	set8	0a5h,0		;Sector Size	(data) 	128
	set8	0a6h,1		;clock		(data) 	HD

	db	0ffh

UMHD4D
	DW	128	;sectors per track
	DB	4	;block shift factor
	DB	15	;block mask
	DB	0	;extent mask
	DW	2039	;disk size-1
	DW	1023	;directory max
	DB	255	;alloc 0
	DB	255	;alloc 1
	DW	256	;check size
	DW	0	;track offset
	DB	0,0	;physical sector size and shift

; - - - - - - - - - - - - - - - - - -
mithdL
	db	"AltairZ80 8MB SIMulated HD$"
mithdP	
	set8	080h,0	;order
	set8	081h,0	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,2048	;Cylinders
	set8	0a1h,1	;Heads

	set8	0a3h,0	;density	(data) 	Don't care
	set16	0a4h,32	;SPT		(data) 
	set8	0a5h,0	;Sector Size	(data) 	128
	set8	0a6h,1	;clock		(data) 	HD

	db	0ffh

mithdD
	dw	32		; SPT, sectors per track
	db	5		; BSH, data allocation block shift factor, for BLS=4,096
	db	31		; BLM, data allocation block mask, for BLS=4,096
	db	1		; extent mask for BLS=4,096 and DSM>255
	dw	2047-6		; DSM, maximum data block number
	dw	1023		; DRM, number of directory entries - 1
	db	0ffh,0		; AL0, AL1, 8 blocks reserved to hold all entries
				; 1024 * 32 = 8 * 4096
	dw	256		; CKS, set 0 since hard disk is fixed
	dw	6		; OFF, number of tracks skipped at beginning of disk
	db	0		; PSH
	db	0		; PHM


; - - - - - - - - - - - - - - - - - -
; XLT tables
;  here's where the magic happens
; - - - - - - - - - - - - - - - - - -
;26x128 stagger 6
	db	1	; 1 based
ibm8X
	db	01h,07h,0dh,13h,19h,05h
	db	0bh,11h,17h,03h,09h,0fh
	db	15h,02h,08h,0eh,14h,1ah
	db	06h,0ch,12h,18h,04h,0ah
	db	10h,16h
; - - - - - - - - - - - - - - - - - -
;32x(128+9) stagger 17
	db	1	; 1 based
mitsX:
	db	01,18,03,20,05,22,07,24
	db	09,26,11,28,13,30,15,32
	db	17,02,19,04,21,06,23,08
	db	25,10,27,12,29,14,31,16
; - - - - - - - - - - - - - - - - - -
;16x256 stagger ?? (got from Bios binary, almost matches DRI method SKEW=6)
;	0 base 	0,6,12,3,9,15,14,5,11,2,8,7,13,4,10,1	
;	1 base 	1,7,13,4,10,16,15,6,12,3,9,8,14,5,11,2	
;  set skew for 2 128 byte sectors at a time(1 base)
	db	1	; 1 based
AppleIIX:
	db	1,2,13,14,25,26,7,8,19,20,31,32,29,30,11,12
	db	23,24,5,6,17,18,15,16,27,28,9,10,21,22,3,4
; - - - - - - - - - - - - - - - - - -
;10x512 stagger 2
;PXLT=1,3,5,7,9,2,4,6,8,10
;LXLT=1,2,3,4,9,10,11,12,17,18,19,20,25,26,27,28,33,34,35,36,
;     5,6,7,8,13,14,15,16,21,22,23,24,29,30,31,32,37,38,39,40
	db	1	; 1 based
B1G40x128K2L128:	
	db	1,2,3,4,9,10,11,12,17,18,19,20,25,26,27,28,33,34,35,36,
	db	5,6,7,8,13,14,15,16,21,22,23,24,29,30,31,32,37,38,39,40
; - - - - - - - - - - - - - - - - - -
;5x512 stagger 2
;PXLT=1,3,5,2,4
;LXLT=1,2,3,4,9,10,11,12,17,18,19,20,5,6,7,8,13,14,15,16
	db	1	; 1 based
B1G20x128k2l128:
	db	1,2,3,4,9,10,11,12,17,18,19,20,5,6,7,8,13,14,15,16

; - - - - - - - - - - - - - - - - - -
; CompuPRO Parameters
; - - - - - - - - - - - - - - - - - -
;CompuPro 8-1024

lblF8S0	db	"CompuPro 8 SSSD- 128(IMD)$"
lblF8S1	db	"CompuPro 8 DSSD- 128(IMD)$"
lblF8D2	db	"CompuPro 8 SSDD- 256(IMD)$"
lblF8D3	db	"CompuPro 8 DSDD- 256(IMD)$"
lblF8D4	db	"CompuPro 8 SSDD- 512(IMD)$"
lblF8D5	db	"CompuPro 8 DSDD- 512(IMD)$"
lblF8D6	db	"CompuPro 8 SSDD- 1024(IMD)$"
lblF8D7	db	"CompuPro 8 DSDD- 1024(IMD)$"

; this assumes that IMD file has been processed by emulator(opened)
; we only need to change SPT and Logical sector size for Data tracks

EPBF8S0:
EPBF8S1:
	set8	080h,0	;order
	set16	09ah,0	;IDM flag	0
	set8 	082h,0	;DONT use prepost

	set16	0a4h,26	;SPT		(data)  26/26x128
	set8	0a5h,0	;Sector Size	(data) 	128
	
	db	0ffh

EPBF8D2:
EPBF8D3:
	set8	080h,0	;order
	set16	09ah,0	;IDM flag	0
	set8 	082h,0	;DONT use prepost

	set16	0a4h,52	;SPT		(data)  52/26x256
	set8	0a5h,0	;Sector Size	(data) 	128
	
	db	0ffh

EPBF8D4:
EPBF8D5:
	set8	080h,0	;order
	set16	09ah,0	;IDM flag	0
	set8 	082h,0	;DONT use prepost

	set16	0a4h,60	;SPT		(data)  60/15x512
	set8	0a5h,0	;Sector Size	(data) 	128
	
	db	0ffh

EPBF8D6:
EPBF8D7:
	set8	080h,0	;order
	set16	09ah,0	;IDM flag	0
	set8 	082h,0	;DONT use prepost

	set16	0a4h,64	;SPT		(data)  64/8x1024
	set8	0a5h,0	;Sector Size	(data) 	128
	
	db	0ffh



; - - - - - - - - - - - - - - - - - -

LBLD2N1
	db "CompuPro Fujitsu 20MB drive 8MB Logical Disk 1$"
LBLD2N2
	db "CompuPro Fujitsu 20MB drive 8MB Logical Disk 2$"
LBLD2N3
	db "CompuPro Fujitsu 20MB drive 4MB+ Logical Disk 3$"
;sectors have 3 prebyte
EPBD2N
	set8	080h,0	;order
	set8	081h,0	;formatType
	set8 	082h,1	; use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,243	;Cylinders
	set8	0a1h,8	;Heads

	set8	0a3h,0	;density	(data) 	Don't care
	set16	0a4h,88	;SPT		(data) 
	set8	0a5h,0	;Sector Size	(data) 	128
	set8	0a6h,1	;clock		(data) 	HD
	set8	0a8h,3	;pSector Size	(data) 	1024

	set16	0d0h,0	;disk pre
	set16	0d1h,0	;disk post

	set16	0d2h,0	;track pre
	set16	0d3h,0	;track post

	set16	0d8h,3	;sector pre
	set16	0d9h,0	;sector post
	
	db	0ffh

; - - - - - - - - - - - - - - - - - -
; these DPBs already are configured to deblock
; apparently Compupro did the deblocking BIOS unaware..

;	MAKEDPB	F8S0,	00h,	1,26,1,	  2,77,	1024,	 64, 64

DPBF8S0
	DW 	26 
 	DB 	3
	db	7
	db	0
 	DW 	0xf3,63
   	DB 	0xc0,0
  	DW 	16,2
;F8S0CSVZ EQU (64+3)/4
;F8S0ALVZ EQU (f4+7)/8

;       MAKEDPB	F8S1,	01h,	2,26,1, 2*2,77,	1024,	128,128

DPBF8S1
	DW 	26 
  	DB 	3,7,0
 	DW 	0x1e7,127
 	DB 	0xf0,0
 	DW 	32,4
	DB	0,0
 ;F8S1CSVZ EQU (128+3)/4
 ;F8S1ALVZ EQU (0x1e8+7)/8

;       MAKEDPB	F8D2,	02h,	1,26,2,   2,77,	2048,	128,128, 0 ;16K extents

DPBF8D2
	DW 	26 * 2
 	DB 	4,15,0
  	DW 	0xf3,128-1
   	DB 	0xc0,0
  	DW 	32,2
	DB	0,0
;F8D2CSVZ EQU (128+3)/4
;F8D2ALVZ EQU (0xf4+7)/8

;       MAKEDPB	F8D3,	03h,	2,26,2, 2*2,77,	2048,	256,256

DPBF8D3
	DW 	26 * 2
   	DB 	4,15,0
  	DW 	0x1e7,255
    	DB 	0xf0,0
  	DW 	64,2*2
	DB	0,0
;F8D3CSVZ EQU (256+3)/4
;F8D3ALVZ EQU (1e8+7)/8

;        MAKEDPB	F8D4,	04h,	1,15,4,	  2,77,	2048,	128,128

DPBF8D4
	DW 	15 * 4
    	DB 	4,15,0
  	DW 	0x119,127
     	DB 	0xc0,0
  	DW 	32,2
	DB	0,0
;F8D4CSVZ EQU (128+3)/4
;F8D4ALVZ EQU (0x11a+7)/8

;       MAKEDPB	F8D5,	05h,	2,15,4, 2*2,77,	2048,	256,256

DPBF8D5
	DW 	15 * 4
    	DB 	4,15,0
  	DW 	0x232,255
      	DB 	0xf0,0
  	DW 	64,2*2
	DB	0,0
;F8D5CSVZ EQU (256+3)/4
;F8D5ALVZ EQU (0x233+7)/8

;       MAKEDPB	F8D6,	06h,	1, 8,8,	  2,77,	2048,	128,128

DPBF8D6
	DW 	8 * 8
    	DB 	4,15,0
  	DW 	0x12b,127
    	DB 	0xc0,0
  	DW 	32,2
	DB	0,0
;F8D6CSVZ EQU (128+3)/4
;F8D6ALVZ EQU (0x12c+7)/8

;      MAKEDPB	F8D7,	07h,	2, 8,8, 2*2,77,	2048,	256,256

DPBF8D7
	DW 	8 * 8
    	DB 	4,15,0
  	DW 	0x257,255
      	DB 	0xf0,0
  	DW 	64,2*2
	DB	0,0
;F8D7CSVZ EQU (256+3)/4
;F8D7ALVZ EQU (DSMC+7)/8

;FD8CSVZ	EQU  64	;Max checksum vector size (4 dir entries / record)
;FD8ALVZ	EQU  0x4b	;Max allocation vector size (bytes = blocks / 8 bits)

; - - - - - - - - - - - - - - - - - -
;Memorex (Fujitsu) 20 Mbyte drive
; note- AL0 and AL1 are wrong, Alocate too many blocks, but that's OK

;       MAKEDPB	D2N1,	43h,	8,11,8,	  8*1, 94,  4096,  1024,0	;First 8M

DPBD2N1	DW 	88
    	DB 	5,31,1
  	DW 	0x7fd,1023
      	DB 	0xff,0xff
  	DW 	256,8
	DB	0,0
;D2N1CSVZ EQU (0+3)/4
;D2N1ALVZ EQU (0x7fe+7)/8

;       MAKEDPB	D2N2,	43h,	8,11,8,	 8*94,187,  4096,  1024,0	;Second 8M

DPBD2N2	DW 	88
  	DB 	5,31,1
  	DW 	0x7fd,1023
    	DB 	0xff,0xff
 	DW 	256,8*94
	DB	0,0
;D2N2CSVZ EQU (0+3)/4
;D2N2ALVZ EQU (0x7fe+7)/8

;      MAKEDPB	D2N3,	43h,	8,11,8,	8*187,243,  4096,  1024,0	;Third 4M+

DPBD2N3	DW 	88
    	DB 	5,31,	1
  	DW 	0x4cf,1023
      	DB 	0xff,0xff
 	DW 	256,8*187
	DB	0,0
;D2N3CSVZ EQU (0+3)/4
;D2N3ALVZ EQU (0x4d0+7)/8

; - - - - - - - - - - - - - - - - - -
;XLAT tables for CompuPRO
; - - - - - - - - - - - - - - - - - -
;these are compupro (already blocked but zero based)
; - - - - - - - - - - - - - - - - - -
	db	0	;  0 based
XLT8S0:
	DB	0,6,12,18,24,4,10,16,22,2,8,14,20
	DB	1,7,13,19,25,5,11,17,23,3,9,15,21
; - - - - - - - - - - - - - - - - - -
	db	0	; this indicates 0 based
XLT8D1:
	DB	 0, 1,18,19,36,37, 2, 3,20,21,38,39
	DB	 4, 5,22,23,40,41, 6, 7,24,25,42,43
	DB	 8, 9,26,27,44,45,10,11,28,29,46,47
	DB	12,13,30,31,48,49,14,15,32,33,50,51
  	DB	16,17,34,35
; - - - - - - - - - - - - - - - - - -
	db	0	;  0 based
XLT8D2:
	DB	 0, 1, 2, 3,16,17,18,19
	DB	32,33,34,35,48,49,50,51
	DB	 4, 5, 6, 7,20,21,22,23
	DB	36,37,38,39,52,53,54,55
	DB	 8, 9,10,11,24,25,26,27
	DB	40,41,42,43,56,57,58,59
	DB	12,13,14,15,28,29,30,31
  	DB	44,45,46,47
; - - - - - - - - - - - - - - - - - -
	db	0	;  0 based
XLT8D3:
	DB	 0, 1, 2, 3, 4, 5, 6, 7
	DB	24,25,26,27,28,29,30,31
	DB	48,49,50,51,52,53,54,55
	DB	 8, 9,10,11,12,13,14,15
	DB	32,33,34,35,36,37,38,39
	DB	56,57,58,59,60,61,62,63
	DB	16,17,18,19,20,21,22,23
	DB	40,41,42,43,44,45,46,47
; - - - - - - - - - - - - - - - - - -
	db	0	;  0 based
XLT5S0:
	DB	 0, 5,10,15, 4, 9,14, 3		; 0, 5,10,15, 2, 7,12,17
       DB	 8,13, 2, 7,12, 1, 6,11		; 4, 9,14, 1, 6,11,16, 3
	DB	00,00				; 8,13
; - - - - - - - - - - - - - - - - - -
	db	0	;  0 based
XLT5D1:
	DB	 0, 1,10,11,20,21,30,31		; 0, 1,10,11,20,21,30,31
	DB	 8, 9,18,19,28,29		; 4, 5,14,15,24,25,34,35
   	DB	 6, 7,16,17,26,27		; 8, 9,18,19,28,29
 	DB	 4, 5,14,15,24,25		; 2, 3,12,13,22,23,32,33
   	DB	 2, 3,12,13,22,23,00,00,00,00	; 6, 7,16,17,26,27
; - - - - - - - - - - - - - - - - - -
	db	0	;  0 based
XLT5D2:
	DB	 0, 1, 2, 3,16,17,18,19
     	DB	12,13,14,15,28,29,30,31
       DB	 8, 9,10,11,24,25,26,27
      DB	 4, 5, 6, 7,20,21,22,23
       DB	00,00,00,00,00,00,00,00	
; - - - - - - - - - - - - - - - - - -
	db	0	;  0 based
XLT5D3:
	DB	 0, 1, 2, 3, 4, 5, 6, 7
      DB	16,17,18,19,20,21,22,23
 	DB	32,33,34,35,36,37,38,39
     	DB	 8, 9,10,11,12,13,14,15
      DB	24,25,26,27,28,29,30,31


; - - - - - - - - - - - - - - - - - -

	ds	256
Stack	equ	$
	end	0100h
	