; This is Configure Disk (DCI) for IMD images only (requires Z80 Emulator 1.0.22 and up)
;	
;
; WARNING-- BIOS22D is modified to prevent older versions of this program from working
; The magic has changed.... (location)like-wise this program wont work on old BIOS22D
;
; This program will configure the Z80 Emulator to access Disk Images in the IMD format
; from OTHER emulator Packages... 
; IT DOES NOT CONFIGURE THE EMULATOR TO RUN SOFTWARE ON THOSE DISKS
;   YOU CAN READ/WRITE THE CONTENTS OF THE DISKS, 
;   BUT THE SOFTWARE ON THOSE DISKS WILL NOT RUN ON THE EMULATOR, 
; 	UNLESS THEY ARE FOR A MACHINE SUPPORTED BY THE Z80 EMULATOR
;
; WARNING----IMD disks contain a variable size disk preamble, based on the comment stored there.
;       open IMD file, and then select disk type with DCI. DCI only sets up bios DPB and XLT
; Some IMD disk images contain compressed sector data... the z80 emulator can NOT use compressed data, 
;   nor, can it understand sector and/or track remapping
;
;WARNING-- this program works with CPM2.2 only, and requires a Custom BIOS(BIOS22D,asm)  
;   which reserves extra space for the XLTs, DPBs, ALL, CHK vectors
;(it can work with CPM3 and/or MPM if and only if the bios for them is modified.)
;WARNING--do not define formats that use more than the available space in 
; XLT tables, CHK vectors and allocation Vectors..
;
;	XLT	CHK	ALL
; A:	0/128	64	91
; B:	0/128	64	91
; C:	128	256	256
; D:	128	256	256
;
; The XLT for a and b will use the reserved area for XBIOS
; That's why, by default, A and B are not used for configuration, 
;   you can change it if you know enough.
;
;	XLTs can be 1 or zero based, will convert 0 to 1 base during injection
;
;(note-most BIOSes put a pointer to a shared DPB for disks that are Identical)
;
; This program can be modified to work with ANY BIOS that uses separate DPBs
;   for each disk, or if you want to change multiple disks at a time, it can be made to work
;   with ANY BIOS whether or NOT there's individual DPBs. However, it may not work as you think.
; The program simply writes new DPB info into the DPB 
;   pointed to by the DPH (returned after SELDSK)
; It then writes new data to the an area for the XLT and 
;   then puts that address in the DPH
; It then reprograms the Z80 Emulator's Disk Controller for the type disk
; IT is designed to run with BIOS22D.ASM. BIOS22D.ASM has areas reserved 
;   specifically for this program
;
; This program sets sector size to 128 and then uses a modified XLT 
;        to access large sectors as 128 bytes, using the z80 emulator's auto-deblock
;
;This program requires AS8080 to assemble (symbols violate ASM/MAC rules)

	org 	100h

true	equ	-1
false	equ	not true

AS8080		equ	true

	if 	AS8080
		z80
	else
		maclib	z80
	endif

bdos	equ	05h

	jmp	start

;Storage used for testing OS version

bdos$ver 	dw	0
mpm$ver		dw	0
dir$bio		db	0	; direct bios bdos-0=no-1=yes
run$msg		db	'Running under $'
cpm$msg		db	'CP/M $'
mpm$msg		db	'MP/M $'
II$msg		db	'II $'
pri$msg		db	'Prior to 2.0$'
ukn$msg		db	'Unknown System$'
ext$msg		db	'Exiting$'
bds$msg 	db	'BDOS $'
msd$msg		db	'0.'
lsd$msg		db	'0 $'
noDB$msg 	db	'No '
DB$msg 		db	'BDOS Direct BIOS Support$'
bad$msg		db	'Can not run on this configuration$'
msg.die		db	CR,LF,LF
		db	"Requires Z80 Emulator Version 1.0.22 or higher$"
msg.cpu		db	CR,LF,LF
		db	"Requires Z80 CPU$"
NO$MAGIC	db	CR,LF,LF
		db	"NO MAGIC Requires Special BIOS22D.ASM to run$"

BS.DSK	EQU	01BH

DSK$REG$SEL	equ	0cah
DSK$REG$LOW	equ	0c8h
DSK$REG$HI	equ	0c9h

CR		equ	13
LF		equ	10

crlf		db	CR,LF,'$'

; Storage for Program

Opening		db	cr,lf,"Configure Disk Version 2.1 for IMD for Z80 Emulator 1.0.22 and up$"
Trm$Msg		db	"Finished",CR,LF,'$'
Ask$disk	db	"Select Disk to be reconfigured(letter only)....C or D - $"
Ask$Type	db	"Select Disk type (two hex characters)- $"
Notice		db	cr,lf
		DB	"This program will temporarily reconfigure a disk drive to access specific"
		db	cr,lf
		db	"  types of disks. The NEW configuration will remain in effect until the next"
		db	cr,lf
		db	"  COLD BOOT. You can read and write the disks. "
		db	cr,lf,cr,lf
		db	"NOTE-Selecting an IMD disk image only sets emulator for auto deblocking,"
		db	cr,lf
		db	"     and configures BIOS's DPB and XLT. You MUST open an IMD image, FIRST,"
		db	cr,lf
		db	"     so Emulator can process and set all other info."
		db	cr,lf
		db	"WARNING-Hard Disks do not use a Check Vector... change with caution"
		db	cr,lf,'$'

DiskNumber 	db	0
DiskType	db	0
Stack$Save	dw	0

DPB		dw	0
DPH		dw	0
XLT		dw	0
SPT		dw	0

;-------------------------
start:
	sspd	Stack$Save
	lxi	sp,Stack
	lxi	d,run$msg
	call	print

;-------------------------
; check for proper CPM/MPM version

; Check for CPM prior to 2, we can not use CPM prior to 2

	mvi	c,0ch		;get CPM/bdos version
	call	bdos
	shld	bdos$ver

chk$old	xra	a
	cmp	l		;L=0 for cpm prior to 2.0
	jnz	chk$cpm
	lxi	d,cpm$msg	;CPM
	call	print
	lxi	d,pri$msg	;old CPM
	call 	print
badexit call 	printNL
	lxi	d,bad$msg	;Can not run on old CPM
	call	print
	call	printNL		;newline
exit:	lxi	d,ext$msg	;tell them about exit
	call 	print
	call	Exit$PGM
	jmp	0		;warm boot
	
chk$cpm	xra	a
	cmp	h		;H=0 for CPM
	jnz	chk$mpm
	lxi	d,cpm$msg	;CPM 
	call	print
	lda	bdos$ver	;get saved bdos version
	call	cnv$htd		;convert to ascii
	lxi	d,msd$msg
	call	print
	lda	bdos$ver	;get saved bdos version
	cpi	030h		;>=3.0 has direct bios in bdos
	jnc	no$dbios
	mvi	a,1
	sta	dir$bio		;set direct bios flag
no$dbios:
	jmp	GOT$CPM2or3

; check for MPM, but can not run on MPM

chk$mpm	mvi	a,01h		;H=1 for MPM
	cmp	h
	jnz	unknown		;something's weird
	lxi	d,mpm$msg	
	call	print
	mvi	c,0a3h		;get MPM version
	call	bdos
	shld	mpm$ver
	xra	a		;H=0 for MPM 1
	cmp	h
	jnz	chk$mII
	jmp	badexit		;MPM
chk$mII
	mvi	a,1		;H=1 for MPM 2
	cmp	h
	jnz	unknown
	lxi	d,II$msg	;MPM II
	call 	print
	lda	mpm$ver
	call	cnv$htd		;convert to ascii
	lxi	d,msd$msg	;print MPM version
	call	print

	lxi	d,bds$msg	;print bdos indicator
	call	print
	lda	bdos$ver	;get saved bdos version
	call	cnv$htd		;convert to ascii
	lxi	d,msd$msg	;print bdos version
	call	print
	jmp	badexit

unknown	lxi	d,ukn$msg	;unknown OS
	call	print
	jmp	badexit

;Got something we can use CPM 2 or 3 (both require special bios)

GOT$CPM2or3:
	call	printNL		;newline
	lda 	dir$bio		;get saved direct bios flag
	ana	a
	jz	noDB
	lxi	d,nodb$msg	;tell no direct bios
	jmp	yesDB
noDB:
	lxi	d,db$msg	;tell direct bios available
yesDB:	call	print

;-------------------------
; check for proper emulator version

; if major and minor and rev = 0 then bad
; if rev=0xff then bad
; z80 Emulators prior to 1.0.17 return unused port value of 0 or 0xff

	in 	0xc4		;read major number
	cpi 	0		;port c4 not implemented in wrong vers
	jnz	NOT_000
	in 	0xc5		;read minor number
	cpi 	0		;port c5 not implemented in wrong vers
	jnz	NOT_000
	in 	0xc6		;read revision number
	cpi 	0		;port c6 not implemented in wrong vers
	jz	Ver.Bad
NOT_000	cpi	0xff		;returns either 0 or ff if bad
	jz	Ver.Bad

; Versioning ports available so find out what version
; We can run on Version 1.0.22 or greater using NEW disk interface

	in 	0xc4		;read major number
	cpi	1
	jc	Ver.Bad
	in 	0xc5		;read minor number
	cpi	0
	jc	Ver.Bad
	in 	0xc6		;read minor number
	cpi	22
	jc	Ver.Bad
	jmp	Ver.OK
Ver.Bad	lxi	de,msg.die	;death message
	call	PrintDE		;out message
	call	Exit$PGM	;exit if bad so disks dont get trashed
	jmp	0			
Ver.OK

;-------------------------
; check CPU (we need z80)

	in 	0c2h
	cpi	0
	jz	cpu.OK
	lxi	de,msg.cpu	;death message
	call	PrintDE		;out message
	call	Exit$PGM	;exit if bad so disks dont get trashed
	jmp	0			

cpu.Ok

;-------------------------
; check for correct BIOS
;  Correct Bios contains Magic 767676 at BIOS+036h
;WARNING version 2 moves magic from BIOS+33 to BIOS+36
;V2 BIOS22D has a bios format entry as per Jade Computer products bios. 
; This allows the JadeDD format program for Z80 EMu to initialize JADE disk images
; it also prevents old version of disk configure from working on wrong bios. 

	LDA	BS.PAG
	MOV	H,A
	mvi	L,036h
	mov	a,m
	CPI	076H
	JNZ	GotNoMagic
	inx	hl
	mov	a,m
	CPI	076H
	JNZ	GotNoMagic
	inx	hl
	mov	a,m
	CPI	076H
	JNZ	GotNoMagic
	jmp	RunPGM

GotNoMagic
	lxi	de,NO$MAGIC
	call	PrintDE
	call	Exit$PGM
	jmp 	0
;-------------------------

RunPGM:	

	call	NewLine
	lxi	d,Opening
	call 	PrintDE
	call	NewLine
	lxi	d,Notice
	call 	PrintDE

;find out what disk user wants to configure

Get.SelDisk:
	call	NewLine
	LXI 	d,Ask$disk
	CALL	PrintDE
	CALL	ReadOne
;	CPI	'A'		;no xlt for drives a or b
;	JZ	Got$disk	;uncomment this to allow pgm to use XBIOS area
;	CPI	'B'		;for drives a and b
;	JZ	Got$disk
	CPI	'C'
	JZ	Got$disk
	CPI	'D'
	JZ	Got$disk
;	CPI	'a'
;	JZ	Got$diskLC
;	CPI	'b'
;	JZ	Got$diskLC
	CPI	'c'
	JZ	Got$diskLC
	CPI	'd'
	JZ	Got$diskLC
	call 	NewLine
	jmp 	Get.SelDisk
Got$diskLC
	sui	'a'-'A'
Got$disk
	sui	'A'
	sta	DiskNumber
	

;-------------------------
;Find out what the user wants to configure disk as
; supports two digit hex value-- 0-9 and a-f ..
	call	NewLine
	call 	PrintMenu

Get.Type:
	Call	NewLine
	LXI 	d,Ask$Type
	CALL	PrintDE

	CALL	ReadOne		;read first char
	call	CHK.Valid
	
	cpi	0ffh
	jz	NOT$Type

	rlc
	rlc
	rlc
	rlc
	
	mov b,a

	CALL	ReadOne		;read second char
	call	CHK.Valid
	
	cpi	0ffh
	jz	NOT$Type

	ora	b	

	cpi	NumberOfDisks
	jc	Got$Type

NOT$Type
	call 	NewLine
	jmp 	Get.Type

Got$Type

	sta	DiskType

;-------------------------
; Get pointers to internal data in BIOS for disk config

;get DPH
	lda	DiskNumber
	mov	c,a
	call	SelDisk		; bios call returns DPH in HL
	shld	DPH
;get XLT (not needed, we use predefined locations for all, since could be 0000h)
	mov	e,m		;First entry in DPH points to XLT
	inx	hl
	mov	d,m
	sded	XLT
;get DPB
	lhld	DPH		;DPH + 10 points to DPB
	lxi	de,10
	dad	de
	mov	e,m
	inx	hl
	mov	d,m
	sded	DPB

;get SPT for XLT length 

;get SPT
	lhld	DPB		;First entry in DPB is SPT
	mov	e,m
	inx	hl
	mov	d,m
	sded	SPT

;-------------------------
; load disk config from EDP table
; this routine writes new disk config data from programs data tables
;   to the Z80 Emulator's Disk Controller config registers
	
;select drive
	lda	DiskType	
	call 	GetEDPptr	;get HL=EDPptr

	mvi	a,018h	;select
	out	DSK$REG$SEL
	lda	DiskNumber	
	out	DSK$REG$LOW

; config the disk

;hl should be ED pointer	

another	mov	a,m	;got size 1=low 2=low/high and FF=finished
	cpi	0ffh
	jz	finished
	cpi	2
	jz	do2
do1	inx	hl
	mov	a,m	;got register selector in a
	out	0cah	;out to select port
	inx	hl
	mov	a,m	;got value to out to register
	out 	0c8h	; out to low reg
	inx	hl
	jmp 	another
do2	inx	hl
	mov	a,m	;got register selector in a
	out	0cah	;out to select port
	inx	hl
	mov	a,m	;got value to out to low register
	out 	0c8h	; out to low reg
	inx	hl
	mov	a,m	;got value to out to high register
	out 	0c9h	; out to high reg
	inx	hl
	jmp 	another
finished


;set parameters
	mvi	a,000h	;select command Reg
	out	DSK$REG$SEL
	mvi	a,07fh	;command is NULL but causes parameters to be set
	out	DSK$REG$LOW

;-------------------------
;inject DPB from internal program area to DPB in BIOS
; assume CPM 2
; NEEDs work to run on CPM 3 (plus special BIOS)

DPBsize	equ	15	;17 for CPM3

	lda	DiskType	
	call	GetDPBptr	;hl=internal DPB
	lded	DPB		;de=DPB in bios
	lxi	b,DPBsize	;size of dpb
	ldir

; get SPT form internal DPB

	lda	DiskType	
	call	GetDPBptr	;hl=internal DPB
	mov	e,m		;SPT is first entry in DPB
	inx	hl
	mov	d,m
	sded	SPT		;SPT = new SPT

;get XLT pointer from internal table

	lda	DiskType	
	call	GetXLTptr
	mov	a,h
	ora	l
	jz	no$XLT		;zero if no XLT used

	lda	DiskNumber
Test$a	cpi	0
	jnz	Test$b
	mvi	e,000h	
	lda	bs.pag
	adi	7	;bios + 700
	mov	d,a	; use reserved Xbios page
	jmp	Set$XLT
Test$b
	lda	DiskNumber
	cpi	1
	jnz	Test$c
	mvi	e,080h
	lda	bs.pag
	adi	7	;bios + 780
	mov	d,a	; use reserved Xbios page
	jmp	Set$XLT
Test$c
	lda	DiskNumber
	cpi	2
	jnz	Test$d
	mvi	e,000h
	lda	bs.pag
	adi	3	;bios + 300
	mov	d,a
	jmp	Set$XLT
Test$d
	lda	DiskNumber
;	cpi	3		; if here, must be D
;	jnz	Test$e		; checked earlier so this never happens
	mvi	e,080h
	lda	bs.pag
	adi	3	;bios + 380
	mov	d,a
	

Set$XLT
	lhld	DPH		;set DPH's XLT to value in DE
	mov	m,e
	inx	hl
	mov	m,d

;DE=pointer to XLT in Bios
	lda	DiskType
	call	GetXLTptr	;HL=internal XLT, a= 0 or 1 based
	lbcd	SPT		;count of sectors/bytes in XLT
	cpi	0
	jz	ZeroBase
OneBase	ldir
	jmp	Exit$Here

ZeroBase
	mov	a,m
	inr	a		; for zero based XLTs
	stax	d
	inx	h
	inx	d
	dcx	b
	mov	a,b
	ora	c
	jnz	ZeroBase

	jmp	Exit$Here

no$XLT	lhld	DPH		;set DPH's XLT to 0
	mvi	m,0
	inx	hl
	mvi	m,0

;-------------------------
;Must exit here if after SELDISK Call
Exit$here
	mvi	c,13		;reset disk system
	call	bdos

	call	Exit$PGM
	jmp 	0		;should never happen

;-------------------------
; this get entered by Cntrl-C check in ReadOne
; also by normal Exit$Here
; it does NOT return to PGM
; Can exit here only if before SELDSK call

Exit$PGM:
	call	NewLine
	lxi	de,Trm$Msg
	call	PrintDE
	lspd	Stack$Save
	ret			; this should return to CPM
;-------------------------
;Entry	
;	C=disk
;Return
;	HL=ptr to DPH

SelDisk
	push	de
	push	bc
	push	a
	mvi	L,bs.dsk
	call	bios
	pop	a
	pop	bc
	pop	de
	ret

;-------------------------
BS.PAG	EQU	02H

;BIOS TRANSFER ROUTINE

BIOS	LDA	BS.PAG
	MOV	H,A
	PCHL
;-------------------------

; CONSOLE LINKAGE - BDOS CALLS

CNS.RD	EQU	1
CNS.WR	EQU	2

CNTL.C	EQU	3
REBOOT	EQU	0

ReadOne:
	push	b
	push	d
	push	h
	MVI	C,CNS.RD
	CALL	BDOS
	pop	h
	pop	d
	pop	b
	ANI	07FH
	CPI	CNTL.C
	CZ	Exit$PGM
	RET
	
WriteOne:
	PUSH	H
	MOV	E,A
	MVI	C,CNS.WR
	CALL	BDOS
	POP	H
	RET
	
;-------------------------
;entry 
;	A=char
;return 
;	HEX character value or FF if bad

Valid$Chars
	db	'0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f'
	db	'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'
;   YES it checks 0-9 twice, but i dont care
CHK.valid	
	push	b
	push	h
	lxi	h,Valid$Chars+31
	mvi	b,16
..loop	
	cmp	m		;match?
	jz	Char$OK		;OK
	dcx	h		;point to next chars
	dcr	b		;dec count of characters
	jnz	..loop		;again

;	lxi	h,Valid$Chars+15
	mvi	b,16
..loop	
	cmp	m		;match?
	jz	Char$OK		;OK
	dcx	h		;point to next chars
	dcr	b		;dec count of characters
	jnz	..loop		;again
	
Char$OK	
	dcr	b
	mov	a,b
	pop	h
	pop	b
	ret

;-------------------------
;convert Binary in A to Hex 
HEX2:
HEX2H	db	030h
HEX2L	db	030h
	db	'$'
BIN2HEX:	
	push	a		
	push	a
	ani	0f0h
	rrc
	rrc	
	rrc
	rrc
	cpi	0ah
	jc	notA_FH
	adi	041h-03ah
notA_FH	adi	030h
	sta	HEX2H
	pop	a
	ani	0fh
	cpi	0ah
	jc	notA_FL
	adi	041h-03ah
notA_FL	adi	030h
	sta 	HEX2L
	pop	a
	ret

;-------------------------
PrintHEX2:
	push	de
	call	BIN2HEX
	lxi	de,HEX2
	call	PrintDE
	pop	de
	ret
;-------------------------

GetDiskEntryPtr:

;Entry
;	A=Disk Number
;Returns 
;	DE=entry size
;	HL=ptr to disk entry
;	A=0

	lxi	hl,DiskTable
	lxi	de,8
..loop	ora	a
	rz
	dad	d
	dcr	a
	jmp	..loop
;-------------------------
GetHLDEptr:

;Entry
;	DE= offset
;	HL=PTR
;Returns
;	hl=ptr at HL + DE

	dad	de
	mov	e,m
	inx	hl
	mov	d,m
	mov	h,d
	mov	l,e
	ret
;-------------------------
GetLABptr:

;Entry
;	A=Disk Number
;Returns
;	hl=ptr to disk LABEL

	push	de
	push	a
	call	GetDiskEntryPtr
	lxi	de,0
	call 	GetHLDEptr	
	pop	a
	pop	de
	ret
;-------------------------
GetDPBptr:

;Entry
;	A=Disk Number
;Returns
;	hl=ptr to disk DPB

	push	de
	push	a
	call	GetDiskEntryPtr
	lxi	de,4
	call 	GetHLDEptr	
	pop	a
	pop	de
	ret
;-------------------------
GetEDPptr:

;Entry
;	A=Disk Number
;Returns
;	hl=ptr to disk Emu Disk Configuration

	push	de
	push	a
	call	GetDiskEntryPtr
	lxi	de,2
	call 	GetHLDEptr	
	pop	a
	pop	de
	ret

;-------------------------
GetXLTptr:

;Entry
;	A=Disk Number
;Returns
;	hl=ptr to disk Emu Disk Configuration
;	a=0 or 1 based

	push	de
	call	GetDiskEntryPtr
	lxi	d,6
	call 	GetHLDEptr
	dcx	h
	mov	a,m
	inx	h
	pop	de
	ret
;-------------------------
PrintHL:
	push	de
	mov	e,l
	mov	d,h
	call	PrintDE
	pop 	de
	ret
;-------------------------
PrintDE:
	push	hl
	push	bc
	push	a
	mvi	c,9
	call	bdos
	pop	a
	pop	bc
	pop	hl
	ret
;-------------------------
NL	db	13,10,'$'
NewLine:
	push	de
	lxi	de,NL
	call	PrintDE
	pop	de
	ret
;-------------------------
SP	db	' ','$'
PrintSpace:
	push	de
	lxi	de,SP
	call	PrintDE
	pop	de
	ret
;-------------------------


PrintMenu:
	call	NewLine
	mvi	a,0
..loop	call	PrintHex2
	call	PrintSpace
	call	GetLABptr
	call	PrintHL
	call	NewLine
	inr	a
	cpi	NumberOfDisks
	jnz	..loop
;	call	NewLine
	ret
	
;-------------------------
;Print NewLine and Print

printNL	lxi	d,crlf
print:	
	mvi	c,09h
	jmp	bdos

;-------------------------
;convert to bcd
cnv$htd:			
	push	psw
	ani	0f0h
	rrc
	rrc	
	rrc
	rrc
	adi	030h
	sta	msd$msg
	pop	psw
	ani	0fh
	adi	030h
	sta	lsd$msg
	ret
;-------------------------
;DPBs/DISK configuration
;-------------------------

; Label,EMU Disk Parameters,DPB,XLT

DiskTable	
	dw 	PC1440L,PC1440P,PC1440D,0
	dw 	ibm8L,ibm8P,ibm8D,ibm8X
;	dw 	jade50DSDDL,jade50DSDDP,jade50DSDDD,0
;	dw 	jade50DSSDL,jade50DSSDP,jade50DSSDD,ibm8X
;	dw 	jade50SSDDL,jade50SSDDP,jade50SSDDD,0
;	dw 	jade50SSSDL,jade50SSSDP,jade50SSSDD,ibm8X
;	dw 	jadeSSDDL,jadeSSDDP,jadeSSDDD,0
;	dw 	jadeSSSDL,jadeSSSDP,jadeSSSDD,ibm8X
;	dw 	jadeDDL,jadeDDP,jadeDDD,0
;	dw 	cdos5SSSD128L,cdos5SSSD128P,cdos5SSSD128D,cdos5SSSD128X
;	dw 	cdos5DSDD512L,cdos5DSDD512P,cdos5DSDD512D,cdos5DSDD512X
;	dw 	cdos8DSDD512L,cdos8DSDD512P,cdos8DSDD512D,cdos8DSDD512X
;	dw	AppleIIL,AppleIIP,AppleIID,AppleIIX
;	dw 	F1440L,F1440P,F1440D,0
;	dw	mits2L,mits2P,mits2D,mitsX	;uses 137 byte sectors
;	dw	mitsL,mitsP,mitsD,mitsX		;uses 137 byte sectors
;	dw	mithdL,mithdP,mithdD,0 
;	dw	UMHD4L,UMHD4P,UMHD4D,0
;	dw	LBLD2N1,EPBD2N,DPBD2N1,0 
;	dw	LBLD2N2,EPBD2N,DPBD2N2,0 
;	dw	LBLD2N3,EPBD2N,DPBD2N3,0 
;
;	dw	UMHD512L,UMHD512P,UMHD512D,0 	;too big for CPM 2
;
; following is to test pre/post/ auto deblocking
	dw 	cdos5DSDD512IMDL,cdos5DSDD512IMDP,cdos5DSDD512IMDD,cdos5DSDD512X
	dw 	cdos8DSDD512IMDL,cdos8DSDD512IMDP,cdos8DSDD512IMDD,cdos8DSDD512X
	dw 	LBLF8D6,EPBF8S6,DPBF8D6,XLT8D3

NumberOfDisks	equ 	($-DiskTable)/8
;-------------------------
;the parameters used to configure the z80 emulator's disk controller 
;  may not be completly correct, but work with auto deblock to read and write disks...
; we always use a sector size of 128...
; we set XLT 4 at a time (for 512 byte sectors).. 
; we multiply number of real sectors by 4 (for 512 byte sectors)
;  and allow the z80 emulator to do the deblocking
; only disk images that require pre/post have the real sector size set,
;   but then only for deblocking , 
;   CPM still uses 128 byte sector size but emulator knows it is 512
;-------------------------

Set8	macro	?Register,?Value
	db	1,?Register,?Value
	endm
Set16	macro	?Register,?Value
	db	2,?Register
	dw	?Value
	endm
;----------------------------

;default drive parametr block for IBM 3740

ibm8L	db	"Standard 8 IBM 3740 Single Sided Single Density(NOT IMD)$"

ibm8P:
	set8	080h,0	;order
	set8	081h,0	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,77	;Cylinders
	set8	0a1h,1	;Heads

	set8	0a3h,1	;density	(data) 	Single=1
	set16	0a4h,26	;SPT		(data) 
	set8	0a5h,0	;Sector Size	(data) 	128
	set8	0a6h,2	;clock		(data) 	8inch=2

	db	0ffh

ibm8D	dw	26		;spt
	db	3		;bsh
	db	7		;blm
	db	0		;exm
	dw	242		;dsm
	dw	63		;drm
	db	0c0h		;al0
	db	0		;al1
	dw	16		;cks
	dw	2		;off
	DB	0,0		;physical sector size and shift

;default drive parametr block for 3$5" pc1440

;-------------------------
PC1440L	db	"Z80 Emulator 3.5 PC1440(NOT IMD)$"

PC1440P:
	set8	080h,0	;order
	set8	081h,0	;formatType
	set8 	082h,0	;DONT use prepost

	set16	09ah,0	;IDM flag	0

	set16	0a0h,80	;Cylinders
	set8	0a1h,2	;Heads

	set8	0a3h,2	;density	(data) 	Double=2
	set16	0a4h,72	;SPT		(data) 
	set8	0a5h,0	;Sector Size	(data) 	128=0
	set8	0a6h,4	;clock		(data) 	3inch=4

	db	0ffh


PC1440D	dw	72		;spt
	db	4		;bsh
	db	15		;blm
	db	0		;exm
	dw	710		;dsm
	dw	255		;drm
	db	0f0h		;al0
	db	0		;al1
	dw	64		;cks
	dw	2		;off
	DB	0,0		;physical sector size and shift

;-------------------------

;-------------------------------
; IMD disks have variable preamble sizes, 
;first open the IMD file allow the emulator to set disk parameters
;  to whatever value is found in the IMD file.
;  then use Disk Configure to set only values needed to auto deblock

; NOTE -- allowing the emulator to set all values , sets them for CDOS to do deblocking
;  the values set here are for CPM (no deblocking), with the emulator doing the deblocking

cdos8DSDD512IMDL
	db	"CDOS 8 inch 512 Double Sided Double Density(IMD)$"

cdos8DSDD512IMDP:

	set16	09ah,0	;IDM flag 

	set16	0a4h,64	;SPT		(data)  16
	set8	0a5h,0	;Sector Size	(data) 	128
	
	db	0ffh

cdos8DSDD512IMDD
	DW    64	;sectors per track
	DB    4		;block shift factor
	DB    15	;block mask
	DB    0		;extent mask
	DW    607	;disk size-1
	DW    255	;directory max
	DB    0f0h	;alloc 0
	DB    0		;alloc 1
	DW    64	;check size
	DW    2		;track offset
	DB	0,0	;physical sector size and shift


cdos5DSDD512IMDL
	db	"CDOS 5 inch 512 Double Sided Double Density(IMD)$"

cdos5DSDD512IMDP:

	set16	09ah,0	;IDM flag 

	set16	0a4h,40	;SPT		(data)  10
	set8	0a5h,0	;Sector Size	(data) 	128
	
	db	0ffh

cdos5DSDD512IMDD
	DW    40	;sectors per track
	DB    4		;block shift factor
	DB    15	;block mask
	DB    0		;extent mask
	DW    194	;disk size-1
	DW    127	;directory max
	DB    0c0h	;alloc 0
	DB    0		;alloc 1
	DW    32	;check size
	DW    2		;track offset
	DB	0,0	;physical sector size and shift

;-------CompuPro 8-1024---
lblF8D6	db	"CompuPro 8 - 1024(IMD)$"

; this assumes that IMD file has been processed by emulator(opened)
; we only need to change SPT and Logical sector size for Data tracks

EPBF8S6:

	set16	09ah,0	;IDM flag	0

	set16	0a4h,64	;SPT		(data)  64/8
	set8	0a5h,0	;Sector Size	(data) 	128
	
	db	0ffh

;---------



;---------
; XLT tables
;  here's where the magic happens
;---------
	db	1	; 1 based
ibm8X	db	01h,07h,0dh,13h,19h,05h
	db	0bh,11h,17h,03h,09h,0fh
	db	15h,02h,08h,0eh,14h,1ah
	db	06h,0ch,12h,18h,04h,0ah
	db	10h,16h
;----------
	db	1	; 1 based
cdos5SSSD128X
 	db	1,6,11,16,3,8,13,18,5,10,15,2,7,12,17,4,9,14
;----------;512 byte sectors
;	1 base 01,12,07,02,13,08,03,14,09,04,15,10,05,16,11,06
;	0 base 00,11,06,01,12,07,02,13,08,03,14,09,04,15,10,05
;	 x4    00,44,24,04,48,28,08,52,32,12,56,36,16,60,40,20	
; set skew for 4 128 byte sectors at a time(1 base)
	db	1	; 1 based
cdos8DSDD512X	
	db	01,02,03,04,45,46,47,48,25,26,27,28,05,06,07,08
	db	49,50,51,52,29,30,31,32,09,10,11,12,53,54,55,56
	db	33,34,35,36,13,14,15,16,57,58,59,60,37,38,39,40
	db	17,18,19,20,61,62,63,64,41,42,43,44,21,22,23,24
;-----------;512 byte sectors
;	0 base	00 04 08 02 06 01 05 09 03 07 	
;	 x4	00,16,32,08,24,04,20,36,12,28
; set skew for 4 128 byte sectors at a time(1 base)
	db	1	; 1 based
cdos5DSDD512X
	db	01,02,03,04,17,18,19,20,33,34,35,36,09,10,11,12,25,26,27,28
	db	05,06,07,08,21,22,23,24,37,38,39,40,13,14,15,16,29,30,31,32
;------------;256 byte sectors
;these are compupro (already blocked but zero based)
;------------
	db	0	;  0 based
XLT8S0:	DB	0,6,12,18,24,4,10,16,22,2,8,14,20
	DB	1,7,13,19,25,5,11,17,23,3,9,15,21
;---------
	db	0	; this indicates 0 based
XLT8D1:	DB	 0, 1,18,19,36,37, 2, 3,20,21,38,39
	DB	 4, 5,22,23,40,41, 6, 7,24,25,42,43
	DB	 8, 9,26,27,44,45,10,11,28,29,46,47
	DB	12,13,30,31,48,49,14,15,32,33,50,51
  	DB	16,17,34,35
;----------
	db	0	;  0 based
XLT8D2:	DB	 0, 1, 2, 3,16,17,18,19
	DB	32,33,34,35,48,49,50,51
	DB	 4, 5, 6, 7,20,21,22,23
	DB	36,37,38,39,52,53,54,55
	DB	 8, 9,10,11,24,25,26,27
	DB	40,41,42,43,56,57,58,59
	DB	12,13,14,15,28,29,30,31
  	DB	44,45,46,47
;---------
	db	0	;  0 based
XLT8D3:	DB	 0, 1, 2, 3, 4, 5, 6, 7
	DB	24,25,26,27,28,29,30,31
	DB	48,49,50,51,52,53,54,55
	DB	 8, 9,10,11,12,13,14,15
	DB	32,33,34,35,36,37,38,39
	DB	56,57,58,59,60,61,62,63
	DB	16,17,18,19,20,21,22,23
	DB	40,41,42,43,44,45,46,47
;-------
	db	0	;  0 based
XLT5S0:	DB	 0, 5,10,15, 4, 9,14, 3		; 0, 5,10,15, 2, 7,12,17
        DB	 8,13, 2, 7,12, 1, 6,11		; 4, 9,14, 1, 6,11,16, 3
	DB	00,00				; 8,13
;-------
	db	0	;  0 based
XLT5D1:	DB	 0, 1,10,11,20,21,30,31		; 0, 1,10,11,20,21,30,31
	DB	 8, 9,18,19,28,29		; 4, 5,14,15,24,25,34,35
   	DB	 6, 7,16,17,26,27		; 8, 9,18,19,28,29
 	DB	 4, 5,14,15,24,25		; 2, 3,12,13,22,23,32,33
   	DB	 2, 3,12,13,22,23,00,00,00,00	; 6, 7,16,17,26,27
;-------
	db	0	;  0 based
XLT5D2:	DB	 0, 1, 2, 3,16,17,18,19
     	DB	12,13,14,15,28,29,30,31
       	DB	 8, 9,10,11,24,25,26,27
      	DB	 4, 5, 6, 7,20,21,22,23
       	DB	00,00,00,00,00,00,00,00	
;------
	db	0	;  0 based
XLT5D3:	DB	 0, 1, 2, 3, 4, 5, 6, 7
      	DB	16,17,18,19,20,21,22,23
 	DB	32,33,34,35,36,37,38,39
     	DB	 8, 9,10,11,12,13,14,15
      	DB	24,25,26,27,28,29,30,31

;------
; these DPBs already are configured to deblock
; apparently Compupro did the deblocking BIOS unaware..

;	MAKEDPB	F8S0,	00h,	1,26,1,	  2,77,	1024,	 64, 64

DPBF8S0	DW 	26 
 	DB 	3
	db	7
	db	0
 	DW 	0xf3,63
   	DB 	0xc0,0
  	DW 	16,2
;F8S0CSVZ EQU (64+3)/4
;F8S0ALVZ EQU (f4+7)/8

;       MAKEDPB	F8S1,	01h,	2,26,1, 2*2,77,	1024,	128,128

DPBF8S1	DW 	26 
  	DB 	3,7,0
 	DW 	0x1e7,127
 	DB 	0xf0,0
 	DW 	32,4
	DB	0,0
 ;F8S1CSVZ EQU (128+3)/4
 ;F8S1ALVZ EQU (0x1e8+7)/8

;       MAKEDPB	F8D2,	02h,	1,26,2,   2,77,	2048,	128,128, 0 ;16K extents

DPBF8D2	DW 	26 * 2
 	DB 	4,15,0
  	DW 	0xf3,128-1
   	DB 	0xc0,0
  	DW 	32,2
	DB	0,0
;F8D2CSVZ EQU (128+3)/4
;F8D2ALVZ EQU (0xf4+7)/8

;       MAKEDPB	F8D3,	03h,	2,26,2, 2*2,77,	2048,	256,256

DPBF8D3	DW 	26 * 2
   	DB 	4,15,0
  	DW 	0x1e7,255
    	DB 	0xf0,0
  	DW 	64,2*2
	DB	0,0
;F8D3CSVZ EQU (256+3)/4
;F8D3ALVZ EQU (1e8+7)/8

;        MAKEDPB	F8D4,	04h,	1,15,4,	  2,77,	2048,	128,128

DPBF8D4	DW 	15 * 4
    	DB 	4,15,0
  	DW 	0x119,127
     	DB 	0xc0,0
  	DW 	32,2
	DB	0,0
;F8D4CSVZ EQU (128+3)/4
;F8D4ALVZ EQU (0x11a+7)/8

;       MAKEDPB	F8D5,	05h,	2,15,4, 2*2,77,	2048,	256,256

DPBF8D5	DW 	15 * 4
    	DB 	4,15,0
  	DW 	0x232,255
      	DB 	0xf0,0
  	DW 	64,2*2
	DB	0,0
;F8D5CSVZ EQU (256+3)/4
;F8D5ALVZ EQU (0x233+7)/8

;       MAKEDPB	F8D6,	06h,	1, 8,8,	  2,77,	2048,	128,128

DPBF8D6	DW 	8 * 8
    	DB 	4,15,0
  	DW 	0x12b,127
    	DB 	0xc0,0
  	DW 	32,2
	DB	0,0
;F8D6CSVZ EQU (128+3)/4
;F8D6ALVZ EQU (0x12c+7)/8

;      MAKEDPB	F8D7,	07h,	2, 8,8, 2*2,77,	2048,	256,256

DPBF8D7	DW 	8 * 8
    	DB 	4,15,0
  	DW 	0x257,255
      	DB 	0xf0,0
  	DW 	64,2*2
	DB	0,0
;F8D7CSVZ EQU (256+3)/4
;F8D7ALVZ EQU (DSMC+7)/8

;FD8CSVZ	EQU  64	;Max checksum vector size (4 dir entries / record)
;FD8ALVZ	EQU  0x4b	;Max allocation vector size (bytes = blocks / 8 bits)
                ;



	ds	256
Stack	equ	$
	end	0100h
	