; Driver Module Definitions

LF	EQU	0AH
CR	EQU	0DH
TPA	EQU	0100H
CNTL.C	EQU	3
TRK.0	EQU	0
TRK.1	EQU	1
TRK.2	EQU	2
TRK.76	EQU	76
SEC.SZ	EQU	128
ID.SEC	EQU	1
REBOOT	EQU	0

;SYSTEM TRACK COPY DEFINITIONS

TK0.LP	EQU	01000H
TK0.FS	EQU	1
TK0.LS	EQU	26
TK0.NS	EQU	TK0.LS-TK0.FS+1
TK0.LC	EQU	TK0.LP-SEC.SZ*TK0.FS
TK0.SZ	EQU	SEC.SZ*TK0.NS
TK1.LP	EQU	TK0.LP+TK0.SZ
TK1.FS	EQU	1
TK1.LS	EQU	48

;INJECTION MODULE DEFINITIONS

FMT.EA	EQU	1700H
WD.TRK	EQU	05H
WD.DTA	EQU	07H
XP.DSH	EQU	080H
ZEROS	EQU	0
ONES	EQU	0FFH

; BDOS CALL VECTORS

BDOS	EQU	05H
CNS.RD	EQU	1
CNS.WR	EQU	2

;BIOS VECTOR DEFINITIONS

BS.DSK	EQU	01BH
BS.TRK	EQU	01EH
BS.SEC	EQU	021H
BS.DMA	EQU	024H
BS.RDS	EQU	027H
BS.WRS	EQU	02AH
BS.FMT	EQU	033H
BS.PAG	EQU	02H
LOG.VC	EQU	1

	I8080
	ORG	TPA

;PROGRAM BEGINS

BEGIN:	JMP	INIT

	DB	"JADE COMPUTER PRODUCTS"
	DB	"DOUBLE D 48 SPT - FORMAT"
	DB	"VERSION 2.2-Z80 EMULATOR"

INIT:
; check for proper emulator version

	in 	0xc4		;read major number
	cpi 	0		;port c4 not implemented in wrong vers
	jz	Ver.Bad
	cpi	0xff		;returns either 0 or ff if bad
	jnz	Ver.OK
Ver.Bad	lxi	h,msg.die	;death message
	call	msg.ot		;out message
	ret			;exit if bad so disks dont get trashed
msg.die	db	cr,lf,lf
	text	"Requires Z80 Emulator Version 1.0.17 or higher"
	db	cr,lf+0x80
Ver.OK

	LXI	SP,TPA
	LXI	H,MSG.BG
	CALL	MSG.OT

FUN.BG:	LXI 	H,MSG.FL
	CALL	MSG.OT
	CALL	CNS.IN
	CPI	'0'
	JZ	FUN.IDD
	CPI	'1'
	JZ	FUN.IDS
	CPI	'2'
	JZ	FUN.FDD
	CPI	'3'
	JZ	FUN.FSD
	CPI	'4'
	JZ	FUN.STD
	CPI	'5'
	JZ	FUN.STS
	CPI	'6'
	JZ	FUN.DTD
	CPI	'7'
	JZ	FUN.DTS
	CPI	'8'
	JZ	FUN.RS
	CPI	'9'
	JZ	FUN.WS
	CPI	'I'
	JZ	FUN.IBM
	CPI	'&'
	JZ	RST.6
	CPI	'/'
	JZ	RST.7
	LXI	H,MSG.SE
	CALL	MSG.OT
	JMP	FUN.BG

;FUNCTION  WRITE ID DOUBLE DENSITY

FUN.IDD	LDA	DD.FLG
	STA	F.FLAG
	LXI	H,MSG.ID
	CALL	SEL.DR
	JC	FUN.BG
	LXI	H,IDS.DD
	CALL	WRT.ID
	JMP	FUN.IDD

;FUNCTION  WRITE ID SINGLE DENSITY

FUN.IDS	LDA	SD.FLG
	STA	F.FLAG
	LXI	H,MSG.ID
	CALL	SEL.DR
	JC	FUN.BG
	LXI	H,IDS.SD
	CALL	WRT.ID
	JMP	FUN.IDS

;FUNCTION  FORMAT DOUBLE DENSITY

FUN.FDD	LDA	DD.FLG
	STA	F.FLAG
	LXI	H,MSG.FD
	CALL	SEL.DR
	JC	FUN.BG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.SD
	JC	FUN.FDD
	MVI	A,TRK.1
	STA	TRK.NO
..REPT	CALL	FMT.DD
	JC	FUN.FDD
	LDA	TRK.NO
	CPI	TRK.76
	JZ	WRID.DD
	INR	A
	STA	TRK.NO
	JMP	..REPT
WRID.DD	LXI	H,IDS.DD
	CALL	WRT.ID
	JMP	FUN.FDD

;FUNCTION  FORMAT SINGLE DENSITY

FUN.FSD	LDA	SD.FLG
	STA	F.FLAG
	LXI	H,MSG.FD
	CALL	SEL.DR
	JC	FUN.BG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.SD
	JC	FUN.FSD
	MVI	A,TRK.1
	STA	TRK.NO
	CALL	FMT.DD
	JC	FUN.FSD
	MVI	A,TRK.2
	STA	TRK.NO
..REPT	CALL	FMT.SD
	JC	FUN.FSD
	LDA	TRK.NO
	CPI	TRK.76
	JZ	WRID.SD
	INR	A
	STA	TRK.NO
	JMP	..REPT
WRID.SD	LXI	H,IDS.SD
	CALL	WRT.ID
	JMP	FUN.FSD


;FUNCTION  FORMAT STANDARD 3740

FUN.IBM	MVI	A,0
	STA	F.FLAG
	LXI	H,MSG.FD
	CALL	SEL.DR
	JC	FUN.BG
	MVI	A,TRK.0
	STA	TRK.NO
..REPT	CALL	FMT.SD
	JC	FUN.IBM
	LDA	TRK.NO
	CPI	TRK.76
	JZ	FUN.IBM
	INR	A
	STA	TRK.NO
	JMP	..REPT

;FUNCTION  FORMAT JADE SYSTEM TRACKS ONLY

FUN.STS	
	LDA	SD.FLG
	STA	F.FLAG
	LXI	H,MSG.FST
	CALL	SEL.DR
	JC	FUN.BG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.SD
	JC	FUN.STS
	MVI	A,TRK.1
	STA	TRK.NO
	CALL	FMT.DD
	JC	FUN.STS
	LXI	H,IDS.SD
	CALL	WRT.ID
	JMP	FUN.STS
FUN.STD
	LDA	DD.FLG
	STA	F.FLAG
	LXI	H,MSG.FST
	CALL	SEL.DR
	JC	FUN.BG
	MVI	A,TRK.0
	STA	TRK.NO
	CALL	FMT.SD
	JC	FUN.STD
	MVI	A,TRK.1
	STA	TRK.NO
	CALL	FMT.DD
	JC	FUN.STD
	LXI	H,IDS.DD
	CALL	WRT.ID
	JMP	FUN.STD

;FUNCTION  FORMAT DATA TRACKS ONLY DOUBLE DENSITY

FUN.DTD	LDA	DD.FLG
	STA	F.FLAG
	LXI	H,MSG.FDT
	CALL	SEL.DR
	JC	FUN.BG
	MVI	A,TRK.2
	STA	TRK.NO
..REPT	CALL	FMT.DD
	JC	FUN.DTD
	LDA	TRK.NO
	CPI	TRK.76
	JZ	FUN.DTD
	INR	A
	STA	TRK.NO
	JMP	..REPT

;FUNCTION  FORMAT DATA TRACKS ONLY SINGLE DENSITY

FUN.DTS	LDA	SD.FLG
	STA	F.FLAG
	LXI	H,MSG.FDT
	CALL	SEL.DR
	JC	FUN.BG
	MVI	A,TRK.2
	STA	TRK.NO
..REPT	CALL	FMT.SD
	JC	FUN.DTS
	LDA	TRK.NO
	CPI	TRK.76
	JZ	FUN.DTS
	INR	A
	STA	TRK.NO
	JMP	..REPT

;FUNCTION  READ SYSTEM TRACKS

FUN.RS	LXI	H,MSG.RS
	CALL	SEL.DR
	JC	FUN.BG
	MVI	A,BS.RDS
	STA	RW.OPV
	CALL	TRNSFR
	JMP	FUN.BG

;FUNCTION  WRITE SYSTEM TRACKS

FUN.WS	LXI	H,MSG.WS
	CALL	SEL.DR
	JC	FUN.BG
	MVI	A,BS.WRS
	STA	RW.OPV
	CALL	TRNSFR
	JMP	FUN.WS

;MESSAGE DISPLAY

MSG.OT	PUSH	PSW
..REPT	MOV	A,M
	CALL	CNS.OT
	MOV	A,M
	INX	H
	ANI	080H
	JZ	..REPT
	POP	PSW
	RET

; CONSOLE LINKAGE - BDOS CALLS

CNS.IN	MVI	C,CNS.RD
	CALL	BDOS
	ANI	07FH
	CPI	CNTL.C
	JZ	REBOOT
	RET
	
CNS.OT	PUSH	H
	MOV	E,A
	MVI	C,CNS.WR
	CALL	BDOS
	POP	H
	RET

; DISPLAY HEX VALUE

HXW.OT	MOV	A,H
	CALL	HXB.OT
	MOV	A,L
HXB.OT	PUSH	PSW
	RRC
	RRC
	RRC
	RRC
	CALL	HXN.OT
	POP	PSW
HXN.OT	ANI	00FH
	CPI	00AH
	JC	HX.NM
	ADI	'A'-'9'-1
HX.NM	ADI	'0'
	JMP	CNS.OT

;WRITE ID SECTOR

; SET DMA
WRT.ID	MOV	B,H
	MOV	C,L
	MVI	L,BS.DMA
	CALL	BIOS
; SET TRACK TO ZERO
	MVI	C,TRK.0
	MVI	L,BS.TRK
	CALL	BIOS
; SET SECTOR TO id SECTOR
	MVI	C,ID.SEC
	MVI	L,BS.SEC
	CALL	BIOS
;DO WRITE
	MVI	L,BS.WRS
	CALL	BIOS
	ORA	A
	JNZ	WRT.ERR

	LDA	DR.SEL
	MOV	C,A
	MVI	E,0	;LOG VECTOR SAYS TO LOG DRIVE
	MVI	L,BS.DSK
	CALL	BIOS
	ORA	A
	JNZ 	WRT.ERR

	LXI	H,DUM.BUF
	MOV	B,H
	MOV	C,L
	MVI	L,BS.DMA
	CALL	BIOS
	MVI	L,BS.RDS	; DO AN OPERATION TO SET spt
	CALL	BIOS		; JUST TO MAKE z80 EMU DRIVE PROPERTIES LOOK GOOD
	
	RZ
WRT.ERR	LXI	H,MSG.NC
	CALL	MSG.OT
	RET

;FORMAT TRACK

;NOTE--THESE ARE REPLACED WITH ROUTINES TO SIMPLY WRITE E5 TO EACH SECTOR OF THE TRACK
;SINCE THE BIOS FORMAT FOR Z80 EMULATOR DOES NOTHING AND RETURNS GOOD

FMT.DD
	MVI	A,48
	JMP	FMT.FMT
FMT.SD
	MVI	A,26
	JMP	FMT.FMT
FMT.FMT
	STA	SEC.NO

	LXI	H,SEC.DTA
	MOV	B,H
	MOV	C,L
	MVI	L,BS.DMA
	CALL	BIOS

	LDA	TRK.NO
	MOV	C,A	
	MVI	L,BS.TRK
	CALL	BIOS

FMT.NXS
	LDA	SEC.NO
	ANA	A
	RZ

	MOV	C,A	

	DCR 	A		;DEC SECTOR
	STA	SEC.NO		;NEXT SECTOR

	MVI	L,BS.SEC
	CALL	BIOS
	
	MVI	L,BS.WRS
	CALL	BIOS

	ORA	A
	JZ	FMT.NXS

	LXI	H,MSG.NC
	CALL	MSG.OT
	RET

; TRANFER SYSTEM TRACKS

; TRANSFER TRACK 0
;  TRACK 0 IS MOVED WITH SECTOR STAGGER
;  AND PLACED IN MEMORY STAGGERED 
;  SO THAT IN THE END , ITS IN ORDER
; APPARENTLY FOR SPEED ON REAL DD

TRNSFR	LXI	H,TK0.SL
	INX	H		;SKIP ID SECTOR
	SHLD	SYS.WP
	MVI	C,TRK.0
	MVI	L,BS.TRK
	CALL	BIOS
;SET SECTOR IN BIOS
..TK0S	LHLD	SYS.WP
	MOV	C,M
	MVI	L,BS.SEC
	CALL	BIOS
;SET ADDRESS IN BIOS
	LHLD	SYS.WP
	ANA	A
	MOV	A,M
	RAR
	MOV	D,A
	MVI	A,0
	RAR
	MOV	E,A
	LXI	H,TK0.LC
	DAD	D
	MOV	B,H
	MOV	C,L
	MVI	L,BS.DMA
	CALL	BIOS
;SECTOR TRANSFER
	LDA	RW.OPV
	MOV	L,A
	CALL	BIOS
	ORA	A
	JNZ	TF.EX
;INCREMENT NEXT SECTOR
	LHLD	SYS.WP
	MOV	A,M
	CPI	016H
	JZ	TR.TRK1
	INX	H
	SHLD	SYS.WP
	JMP	..TK0S

; TRANSFER TRACK 1

TR.TRK1	LXI	H,TK1.LP
	SHLD	SYS.WP
	MVI	A,TRK.1
	STA	SEC.NO
	MVI	C,TRK.1
	MVI	L,BS.TRK
	CALL	BIOS
;SET SECTOR AND DMA IN BIOS
..TK1S	LDA	SEC.NO
	MOV	C,A
	MVI	L,BS.SEC
	CALL	BIOS
	LHLD	SYS.WP
	MOV	B,H
	MOV	C,L
	MVI	L,BS.DMA
	CALL 	BIOS
;SECTOR TRANFER
	LDA	RW.OPV
	MOV	L,A
	CALL	BIOS
	ORA	A
	JNZ	TF.EX
;INC NEXT SECTOR
	LDA	SEC.NO
	CPI	TK1.LS
	RZ
	INR	A
	STA	SEC.NO
	LHLD	SYS.WP
	LXI	D,SEC.SZ
	DAD	D
	SHLD	SYS.WP
	JMP	..TK1S
;BAD STUFF 
TF.EX	LXI	H,MSG.NC
	CALL	MSG.OT
	RET

;SELECT DRIVE THRU BIOS

SEL.DR	SHLD	MSG.SV
..REPT	LHLD	MSG.SV
	CALL	MSG.OT
	CALL	CNS.IN
	CPI	CR
	JZ	SEL.EX
;SEE IF DRIVE LETTER IS GOOD
	STA	DR.LTR
	STA	LTR.SE
	SUI	'A'
	JC	SEL.IL
	CPI	04H
	JC	SEL.NB
	SUI	'a'-'A'
	JC	SEL.IL
	CPI	04H
	JC	SEL.NB
; EXIT TO RESELECT
SEL.IL	LXI	H,MSG.SE
	CALL	MSG.OT
	JMP	..REPT
; EXIT TO RESELECT
SEL.EX	STC
	RET
;VALID DRIVE
SEL.NB	STA	DR.SEL
	MOV	C,A
	MVI	E,LOG.VC
	MVI	L,BS.DSK
	CALL	BIOS
	LXI	H,MSG.XX
	CALL	MSG.OT
	CALL	CNS.IN
	CPI	CR
	JNZ	..REPT
	ANA	A
	RET

;BIOS TRANSFER ROUTINE

BIOS	LDA	BS.PAG
	MOV	H,A
	PCHL

;SOFTWARE TRAPS

RST.6	RST	6
RST.7	RST	7

;WORKING VARIABLES

SYS.WP	DW	0
RW.OPV	DB	0
MSG.SV	DW	0
TRK.NO	DB	0
SEC.NO	DB	0
F.FLAG	DB	0
DR.SEL 	DB	0

;3740 TRANSLATION

TK0.SL	DB	01H,07H,0DH,13H,19H,05H
	DB	0BH,11H,17H,03H,09H,0FH
	DB	15H,02H,08H,0EH,14H,1AH
	DB	06H,0CH,12H,18H,04H,0AH
	DB	10H,16H

;JADE SINGLE DENSITY ID SECTOR

IDS.SD	db	"JADE DD SINGLE DENSITY FORMAT "
	org	IDS.SD+020h
	dw	26
	db	3
	db	07h
	db	0
	dw	242
	dw	63
	db	0C0h
	db	0
	dw	16
	dw	2
	org	IDS.SD+030h
	db	6
SD.FLG	db	2
	ORG	IDS.SD+SEC.SZ

;JADE DOUBLE DENSITY ID SECTOR

IDS.DD	db	"JADE DD DOUBLE DENSITY FORMAT "
	org	IDS.DD+020h
	dw	48
	db	4
	db	0fh
	db	1
	dw	224
	dw	63
	db	080h
	db	0
	dw	16
	dw	2
	org	IDS.DD+030h
	db	6
DD.FLG	db	6
	ORG	IDS.DD+SEC.SZ

;MESSAGES

;CONSOLE SIGN IN
MSG.BG
	DB	CR,LF
	DB	CR,LF,"DOUBLE D - INITLIZE UTILITY for Z80 EMULATOR"
	DB	CR,LF,"For SINGLE SIDED, 48 SPT Disk Images"
	DB	CR,LF,"MUST SELECT TYPE OF DISK IMAGE FIRST"
	DB	CR,LF,"  JadeSSSD, JadeSSDD OR IBM3740"
	DB	CR,LF
	DB	CR,LF,"USE CTL-C FOR SYSTEM REBOOT",'.'+80H
;DISPLAY FUNCTION SELECTION
MSG.FL
	DB	CR,LF
	DB	CR,LF,"******* FUNCTIONS LIST *********"
	DB	CR,LF
	DB	CR,LF,"0. WRITE ID SECTOR DOUBLE DENSITY"
	DB	CR,LF,"1. WRITE ID SECTOR SINGLE DENSITY"
	DB	CR,LF,"2. INITILZE 26/48/48 SPT DOUBLE DENSITY"
	DB	CR,LF,"3. INITILZE 26/48/26 SPT SINGLE DENSITY"
	DB	CR,LF,"4. INITILZE 26/48 SPT SYSTEM TRACKS only DOUBLE DENSITY"
	DB	CR,LF,"5. INITILZE 26/48 SPT SYSTEM TRACKS only SINGLE DENSITY"
	DB	CR,LF,"6. INITILZE 48 SPT DATA TRACKS only DOUBLE DENSITY"
	DB	CR,LF,"7. INITILZE 26 SPT DATA TRACKS only SINGLE DENSITY"
	DB	CR,LF,"8. READ   SYSTEM TRACKS IMAGE"
	DB	CR,LF,"9. WRITE  SYSTEM TRACKS IMAGE"
	DB	CR,LF,"I. INITILZE STANDARD IBM3740 8 INCH"
	DB	CR,LF
	DB	CR,LF,"ENTER FUNCTION NUMBER:",' '+080H
;SELECTION ERROR
MSG.SE
	DB	CR,LF
	DB	CR,LF
LTR.SE	DB	' '
	DB	" IS NOT A VALID SELECTION",' '+80H
; WRITE ID ON DISK DRIVE
MSG.ID
	DB	CR,LF
	DB	CR,LF
	DB	"WRITE ID ON DRIVE (CR TO RESELECT):",' '+80H
; FORMAT ON DISK DRIVE
MSG.FD
	DB	CR,LF
	DB	CR,LF
	DB	"FORMAT  DRIVE (CR TO RESELECT):",' '+80H
; FORMAT ON DISK DRIVE
MSG.FST
	DB	CR,LF
	DB	CR,LF
	DB	"FORMAT SYSTEM TRACKS ON DRIVE (CR TO RESELECT):",' '+80H
; FORMAT ON DISK DRIVE
MSG.FDT
	DB	CR,LF
	DB	CR,LF
	DB	"FORMAT DATA TRACKS ON DRIVE (CR TO RESELECT):",' '+80H
; READ SYSTEM ON DISK DRIVE
MSG.RS
	DB	CR,LF
	DB	CR,LF
	DB	"READ SYSTEM FROM DRIVE:",' '+80H
; WRITE SYSTEM ON DISK DRIVE
MSG.WS
	DB	CR,LF
	DB	CR,LF
	DB	"WRITE SYSTEM TO DRIVE (CR TO RESELECT):",' '+80H
; TRANSFER INCOMPLETE
MSG.NC
	DB	CR,LF
	DB	CR,LF
	DB	"TRANSFER INCOMPLETE",' '+80H
; TYPE CR WHEN READY
MSG.XX
	DB	CR,LF
	DB	CR,LF,"TYPE CR WHEN DRIVE "
DR.LTR	DB	' '
	DB	" READY",'.'+80H

;SECTOR FORMAT DATA

SEC.DTA	
	REPT	8
	DB	0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5,0XE5
	ENDM

DUM.BUF	DS 	128
	END