/* 
 * Dos/PC Emulator
 * Copyright (C) 1991 Jim Hudgens
 * Copyright 2011 John Elliott
 * 
 * 
 * The file is part of GDE.
 * 
 * GDE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 * 
 * GDE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GDE; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

#include "gde.h"
#include "termios.h"


void termios_rdchar_blk(char *ral, char *rah)
{
        struct termios ts, ots;
	int fd = fileno(stdin);
	int i;
	char ch;
	
        tcgetattr(fd, &ts);          /* Switch the terminal to raw mode */
        tcgetattr(fd, &ots);
        cfmakeraw(&ts);
        tcsetattr(fd, TCSANOW, &ts);

        fflush(stdout);
        fflush(stdin);
        do
        {
                i = read(fd, &ch, 1);
        }
        while (i < 0);
        tcsetattr(fd, TCSANOW, &ots);

        fflush(stdin);

	*ral = ch;
	*rah = ascii_to_scancode[ch & 0xFF];
}


static int kbhit (void)
{
	struct timeval tv;
	fd_set rdfs;
	int fd = fileno(stdin);

	tv.tv_sec = 0;
	tv.tv_usec = 0;

	FD_ZERO(&rdfs);
	FD_SET (fd, &rdfs);

	select(1, &rdfs, NULL, NULL, &tv);
	return FD_ISSET(fd, &rdfs);
}


int termios_rdchar_nblk(char *ral, char *rah)
{
	if (!kbhit())
	{
		return 1;
	}
	termios_rdchar_blk(ral, rah);
	return 0;
}



int termios_rdstatus(void)
{
	return 0;
}


KBD_OPS kbd_ops_termios =
{
	termios_rdchar_blk,
	termios_rdchar_nblk,
	termios_rdstatus	
};

