/* 
 * Dos/PC Emulator
 * Copyright (C) 1991 Jim Hudgens
 * Copyright 2011 John Elliott
 * 
 * 
 * The file is part of GDE.
 * 
 * GDE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 * 
 * GDE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GDE; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

#include "gde.h"

/* Map ASCII to XT-style scancodes */
unsigned char ascii_to_scancode[256] = 
{
	0x00, 0x1E, 0x30, 0x2e, 0x20, 0x12, 0x21, 0x22,	/*  0 to  7 */
	0x0E, 0x17, 0x24, 0x25, 0x26, 0x1C, 0x31, 0x18,	/*  8 to  F */
	0x19, 0x10, 0x13, 0x1f, 0x14, 0x16, 0x2f, 0x11,	/* 10 to 17 */
	0x2D, 0x15, 0x2C, 0x01, 0x2b, 0x1B, 0x07, 0x0C,	/* 18 to 1F */
	0x39, 0x02, 0x03, 0x2B, 0x05, 0x06, 0x08, 0x28,	/* 20 to 27 */
	0x09, 0x0A, 0x09, 0x0D, 0x33, 0x0C, 0x34, 0x35,	/* 28 to 2F */
	0x0B, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,	/* 30 to 37 */
	0x09, 0x0A, 0x0B, 0x27, 0x27, 0x33, 0x0D, 0x34,	/* 38 to 3F */
	0x28, 0x1E, 0x30, 0x2E, 0x20, 0x12, 0x21, 0x22,	/* 40 to 47 */
	0x23, 0x17, 0x24, 0x25, 0x26, 0x32, 0x31, 0x18,	/* 48 to 4F */
	0x19, 0x10, 0x13, 0x1f, 0x14, 0x16, 0x2f, 0x11,	/* 50 to 57 */
	0x2D, 0x15, 0x2C, 0x1A, 0x56, 0x1B, 0x07, 0x0C,	/* 58 to 5F */
	0x29, 0x1E, 0x30, 0x2E, 0x20, 0x12, 0x21, 0x22,	/* 60 to 67 */
	0x23, 0x17, 0x24, 0x25, 0x26, 0x32, 0x31, 0x18,	/* 68 to 6F */
	0x19, 0x10, 0x13, 0x1f, 0x14, 0x16, 0x2f, 0x11,	/* 70 to 77 */
	0x2D, 0x15, 0x2C, 0x1A, 0x56, 0x1B, 0x29, 0x53,	/* 78 to 7F */
};

void stdio_rdchar_blk(char *ral, char *rah)
{
	int ch = getchar();

	*ral = ch;
	*rah = ascii_to_scancode[ch & 0xFF];
}

int stdio_rdchar_nblk(char *ral, char *rah)
{
	return -1;
}


int stdio_rdstatus(void)
{
	return 0;
}


KBD_OPS kbd_ops_stdio =
{
	stdio_rdchar_blk,
	stdio_rdchar_nblk,
	stdio_rdstatus	
};

