/* 
 * Dos/PC Emulator
 * Copyright (C) 1991 Jim Hudgens
 * Copyright 2011 John Elliott
 * 
 * 
 * The file is part of GDE.
 * 
 * GDE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 * 
 * GDE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GDE; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

#ifndef KBD_H_INCLUDED
#define KBD_H_INCLUDED 

typedef struct kbd_ops
{
#ifdef __STDC__
	   void  (*kbd_rdchar_blk)(char *ral,char *rah);
	   int  (*kbd_rdchar_nblk)(char *ral,char *rah); 
	   int  (*kbd_rdstatus)(void);
#else
	   void  (*kbd_rdchar_blk)();
	   int  (*kbd_rdchar_nblk)(); 
	   int  (*kbd_rdstatus)();
#endif
} KBD_OPS;


extern KBD_OPS kbd_ops_stdio;
extern KBD_OPS kbd_ops_termios;

extern unsigned char ascii_to_scancode[256];

#endif /* ndef KBD_H_INCLUDED */
