
/* 
 * Dos/PC Emulator
 * Copyright (C) 1991 Jim Hudgens
 * 
 * 
 * The file is part of GDE.
 * 
 * GDE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 * 
 * GDE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GDE; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

#ifdef DOSS_SUPPORT

#ifndef DOSS_EXTERNS_H
#define DOSS_EXTERNS_H

static char doss_externs_rcsid[]=
  "$Id: $";

/* $Log: $
 *
 */

#ifdef __STDC__
extern void  (*doss_svc[])(PC_ENV *m);
#else
extern void  (*doss_svc[])();
#endif

extern u_int16 sys_base;   /* base of allocable memory */


/* system file table */
extern struct doss_file_handle  doss_sys_file[];

/* system drive table */
extern struct doss_drive  doss_sys_drives[];

/* ufs switch table */
extern struct doss_fs   ufs;
/* ffs switch table */
/* [JCE] Change its name, since "ffs" is the name of a gcc builtin */
extern struct doss_fs   gde_ffs;

/*	doss_conio.c    */
void EXFUN(doss_conio_init,(PC_ENV *m));


/*	doss_dir.c      */
void EXFUN(doss_cvt_path,
	   (PC_ENV *m AND  int *drive AND  char *oldpath AND  char *newpath));

int EXFUN(doss_fsop_getcwd,
	  (PC_ENV *m AND  int drive AND  char *path));

int EXFUN(doss_fsop_setcwd,
	  (PC_ENV *m AND  char *path));

int EXFUN(doss_fsop_mkdir,
	  (PC_ENV *m AND  char *path));

int EXFUN(doss_fsop_rmdir,
	  (PC_ENV *m AND  char *path));

int EXFUN(doss_fsop_dirread,
	  (PC_ENV *m AND  char *pattern AND  int attrib AND  int first));

int EXFUN(doss_match_attrib,
	  (int pattr AND  int fattr));

void EXFUN(doss_load_fatr_dta,
	   (PC_ENV *m AND  u_int8 *dta AND  int nbytes));
void EXFUN(doss_copy_fatr_dta,
	   (PC_ENV *m AND  struct doss_file_handle *file));

void EXFUN(doss_split_path,
	   (char *oldpath AND  char *directory AND  char *filename));

void EXFUN(doss_split_filename,
	   (char *name AND  char *base AND  char *ext));

int EXFUN(doss_match_filename,
	  (PC_ENV *m AND  char *pattern AND  char *filename));

int EXFUN(doss_match_regex,
	  (char *pattern AND  char *name));

void EXFUN(doss_rewrite_regex,
	   (char *pattern AND  char *base AND  char *ext));

/*	doss_file.c   */

void EXFUN(doss_fs_init,(PC_ENV *m));
void EXFUN(doss_filetab_init,(PC_ENV *m));
int EXFUN(doss_fsop_fopen,
	  (PC_ENV *m AND  char *path AND  int mode AND  int *fh));

int EXFUN(doss_fsop_fclose,
	  (PC_ENV *m AND  int fh));
int EXFUN(doss_fsop_fcreat,
	  (PC_ENV *m AND  char *path AND  int attr AND  int *fh));

int EXFUN(doss_fsop_fread,
	  (PC_ENV *m AND  int fh AND  void *buf AND  int n AND  int *nread));

int EXFUN(doss_fsop_fwrite,
	  (PC_ENV *m AND  int fh AND  void *buf AND  int n AND  int *nwrite));

int EXFUN(doss_fsop_fseek,
	  (PC_ENV *m AND  int fh AND  int32 whence AND  int32 offset AND  int32 *at));

int EXFUN(doss_fsop_fdelete,
	  (PC_ENV *m AND  char *path));

int EXFUN(doss_fsop_getftime,
	  (PC_ENV *m AND  int ufh AND  u_int16 *date AND  u_int16 *time));

int EXFUN(doss_fsop_setftime,
	  (PC_ENV *m AND  int ufh AND  u_int16 date AND  u_int16 time));

int EXFUN(doss_fsop_getfattr,(PC_ENV *m AND  char *path AND  u_int16 *attr));
int EXFUN(doss_fsop_setfattr,(PC_ENV *m AND char *path AND  u_int16 attr));
int EXFUN(doss_fsop_ioctl_sf0,(PC_ENV *m AND  int fh AND  u_int16 *bits));

/*	doss_mem.c   */

void EXFUN(doss_memalloc_init,(PC_ENV *m));

int EXFUN(doss_allocate_memory,
	  (PC_ENV *m AND  struct doss_mcb **new AND u_int16 size AND 
	  u_int16 *avail));

int EXFUN(doss_deallocate_memory,
	  (PC_ENV *m AND  u_int16 seg));

int EXFUN(doss_psp_deallocate_memory,
	  (PC_ENV *m AND  u_int16 psp));

int EXFUN(doss_modify_allocation,
	  (PC_ENV *m AND  u_int16 seg AND  u_int16 newsize AND  u_int16 * avail));

void EXFUN(doss_modify_mem_owner,
	  (PC_ENV *m AND  u_int16 seg AND  u_int16 psp));

int EXFUN(doss_get_allocation_strategy,
	  (PC_ENV *m));

int EXFUN(doss_set_allocation_strategy ,(PC_ENV *m AND  int to));

int EXFUN(doss_check_memalloc,(PC_ENV *m));

void EXFUN(doss_trace_memory_allocation,(PC_ENV *m));


/*	doss_proc.c */

void EXFUN(doss_proc_init,(PC_ENV *m));

int EXFUN(doss_env_create,
	  (PC_ENV *m AND  u_int16 parent_seg AND  u_int16 *new_env_segaddr));

void EXFUN(doss_psp_create,
	   (PC_ENV *m AND  struct doss_proc *p AND  
	    int size AND  struct doss_ctail *ctail));

int EXFUN(doss_get_next_ufh,(PC_ENV *m));

int EXFUN(doss_set_fh,(PC_ENV *m AND  int ufh AND  int sfh));

int EXFUN(doss_ufh_to_sfh,(PC_ENV *m AND  int ufh));

int EXFUN(doss_load_com,(PC_ENV *m AND  int fh AND  struct doss_proc *p));

int EXFUN(executable_file_type,(char *s));

int EXFUN(doss_fetch_exehdr,
	  (PC_ENV *m AND  int fh AND  struct doss_exec_header *exehdr));

int EXFUN(doss_load_exec_body,
	  (PC_ENV *m AND  int fh AND  int esize AND  int estart_off AND 
	   u_int8 *load_addr));

int EXFUN(doss_reloc_exe,
	  (PC_ENV *m AND  int fh AND  struct doss_exec_header *exehdr AND 
	   u_int16 loadbase AND  u_int16 segbase));
int EXFUN(doss_load_exe,
	  (PC_ENV *m AND  int fh AND  struct doss_proc *p));

int EXFUN(doss_exec,
	  (PC_ENV *m AND  char *name AND  u_int16 p_env_seg AND 
	   struct doss_ctail *ctail));

int EXFUN(doss_exit,(PC_ENV *m AND  int eval));

/*	doss_syserr.c */

void EXFUN(doss_perror,
	   (PC_ENV *m AND  char *s));

/*	doss_time.c  */

int EXFUN(doss_get_clock,
	  (u_int8 *oh AND  u_int8 *om AND  u_int8 *os AND  u_int8 *ocs));

int EXFUN(doss_set_clock,
	  (int h AND  int m AND  int s AND  int cs));

/*   doss_conio.c */
void EXFUN(doss_conio_out_chr,(PC_ENV *m AND u_int8 chr AND u_int8 ioflg));
int EXFUN(doss_conio_in_chr,(PC_ENV *m AND u_int8 *chr AND u_int8 ioflg));
int EXFUN(doss_conio_in_status,(PC_ENV *m));
int EXFUN(doss_conio_is_conout,(PC_ENV *m,int fh));
int EXFUN(doss_conio_is_conin,(PC_ENV *m,int fh));


#endif   /* DOSS_EXTERNS */
#endif   /* DOSS_SUPPORT */
