/* 
 * Dos/PC Emulator
 * Copyright (C) 1991 Jim Hudgens
 * 
 * 
 * The file is part of GDE.
 * 
 * GDE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 * 
 * GDE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GDE; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

#ifdef DOSS_SUPPORT

#ifndef DOSS_H
#define DOSS_H


static char doss_h_rcsid[]=
  "$Id: $";

/* $Log: $
 *
 */

/* file related defines and structures */
#define DOSS_MAX_PATH    256
#define DOSS_MAX_DRIVES   20
#define DOSS_MAX_SYS_FH   255



/* directory related stuff */
struct doss_dtalst
 {
    struct doss_dtalst *next;
    u_int16  dta_seg,dta_off;
    char     dname[DOSS_MAX_PATH];
    int      drive;
    char     pattern[DOSS_MAX_PATH];
    int      attrib;
 };


/* memory allocation structures and definitions. */

/* following struct defines the memory allocation chain under DOSS.  */
struct doss_mcb 
 {
    struct doss_mcb  *next,*prev;
    u_int16  start_seg; /* base address of the header. */
    u_int16  n_para;    /* size of the block, not including header. */
    u_int16  proc_psp;  /* owner's psp address. */
 };

/* memory allocation strategy constants */

#define MEMALLOC_FIRST_FIT 0
#define MEMALLOC_BEST_FIT  1
#define MEMALLOC_LAST_FIT  2


/* PROC RELATED STUFF */

#define MEM_SIZE_PG_PSP_OFFSET        0x02
#define TERMINATE_VECTOR_PSP_OFFSET   0x0a
#define BREAK_VECTOR_PSP_OFFSET       0x0e
#define ERROR_VECTOR_PSP_OFFSET       0x12
#define ENV_SEGMENT_PSP_OFFSET        0x2c
#define PARAMETER_LENGTH_PSP_OFFSET   0x80
#define PARAMETER_TAIL_PSP_OFFSET     0x81


/* structures and constants defined for the PSP 
   cannot use a packed structure portably, so that
   this structure can be filled by the exec routine,
   and passed to a routine which puts the individual
   fields in memory, given the base address of the 
   psp. 
 */

struct doss_psp_header
 {
    u_int8  int20[2];
    u_int16  mem_size;
    u_int16  terminate_vector[2];
    u_int16  break_vector[2];
    u_int16  error_vector[2];
    u_int16  env_segment;
    u_int8   parameter_length;
    u_int8   parameter_tail[127];
 };


struct doss_exec_header
 {
    
    char   signature[2];
    
    u_int16 length_rem,           /* 0x02 */
            length_pag,           /* 0x04 */
            n_reloc_entries,      /* 0x06 */
            header_size_pg,       /* 0x08 */
            min_pg_needed,        /* 0x0a */
            max_pg_needed,        /* 0x0c */
            initial_ss,           /* 0x0e */
            initial_sp,           /* 0x10 */
            checksum,             /* 0x12 */
            initial_ip,           /* 0x14 */
            initial_cs,           /* 0x16 */
            reloc_offset,         /* 0x18 */
            overlay_num;          /* 0x1a */
 };

/* maximum number  of file handles */
#define DOSS_MAX_PROC_FH   20

struct doss_proc
 {
    u_int8  fh[DOSS_MAX_PROC_FH];
    struct doss_proc *parent_proc;
    struct doss_proc *child_proc;
    
    u_int16 saved_CS;
    u_int16 saved_IP;
    u_int16 ret_val;

    u_int16 env_seg;
    u_int16 psp_seg; /* essentially the proc segment. */
    u_int16 proc_sz; /* segments. */

    u_int16 dta_seg;
    u_int16 dta_off;

    struct doss_dtalst *dtalst;
 };




struct doss_exec_pb
 {
    u_int16  env_seg;
    u_int16  param_off,param_seg;
    u_int16  fcb1_off,fcb1_seg;
    u_int16  fcb2_off,fcb2_seg;
 };


/* command string for a process.  Stored in the top
128 bytes of the PCB  structure */

struct doss_ctail
 {
    u_int8   len;
    u_int8   cmd[127];
 };


#define DOSS_EXE_FILE_TYPE 2
#define DOSS_COM_FILE_TYPE 1
#define DOSS_OTH_FILE_TYPE 0


 
/* FILE RELATED DEFINITIONS */
/* File ACCESS FLAGS */

#define  DOSS_FS_ACC_RDONLY   0
#define  DOSS_FS_ACC_WRONLY   1
#define  DOSS_FS_ACC_RDWR     2

/* file attribute flag constants */

#define  DOSS_FS_ATTR_RO   0x1
#define  DOSS_FS_ATTR_HID  0x2
#define  DOSS_FS_ATTR_SYS  0x4
#define  DOSS_FS_ATTR_VOL  0x8
#define  DOSS_FS_ATTR_DIR  0x10
#define  DOSS_FS_ATTR_ARC  0x20

/* struct file_handle flags  */

#define  DOSS_FH_ISCONIN   0x1
#define  DOSS_FH_ISCONOUT   0x2
#define  DOSS_FH_ISCONIO   (DOSS_FH_ISCONIN|DOSS_FH_ISCONOUT)
#define  DOSS_FH_ISNULL    0x4
#define  DOSS_FH_ISCLK     0x8
#define  DOSS_FH_ISRAW     0x10
#define  DOSS_FH_ISCHAR    0x40
#define  DOSS_FH_IOCTL     0x4000
#define  DOSS_FH_VALID     0x8000

/* drive flags */
#define DOSS_VALID_DRIVE   0x1

/* Console I/O flags */
#define DOSS_CONIO_IECHO  0x1
#define DOSS_CONIO_IBLK   0x2
#define DOSS_CONIO_CTLBRK  0x4
#define DOSS_CONIO_OCOOK   0x8

/* three supported filesystem types:

      unix_fs.
           no FAT, no raw io.
	   drive mapped to a directory.
           all files inside the dir, and beneath the directory
	     are visible using normal msdos functions, as long 
	     as they are no more than 8+"."+3 characters.
	     Links, devices, and other unixism's are not seen.
	   Since using normal unix permissions, we 
	     must map permission problems into some sensible 
	     error code to dos.

      ufile_fs.
	   One big UNIX file is mapped to a drive. 
	   Has own fat, fakes the "raw" io.
           Looks to be one of the many diskette or hard drive 
	    formats.

      udevice_fs.
           Uses a 1) hard drive partition, or 2) a diskette drive on
	   the system.  For all practical purposes, this is as nearly
	   identical to a dos filesystem as can be.  Permissions
	   a real problem here.
*/


enum  fs_type   { unix_fs,  ufile_fs, udevice_fs };

#define FSOP_SUCCESS  SYSCALL_SUCCESS
#define FSOP_FAILURE  SYSCALL_FAILURE    

/* currently unused  */

#define MAXSECTBUF   10
#define MBRSIZE     512

#define BUF_INUSE    1
#define BUF_FAT      2
#define BUF_DIR      4

#define FS_FAT12     1
#define FS_FAT16     2
#define FS_FAT32     4

struct buf
 {
    struct buf *next;
    u_int      flags;
    u_int      blknum;
    u_int8     *base_addr;
 };

struct fs_attr
 {
    u_int   magic;
    u_int   bytes_per_sector;
    u_int   sectors_per_cluster;
    u_int   number_reserved_sectors;
    u_int   number_of_fats;
    u_int   number_of_root_dir_entries;
    u_int   number_of_sectors;
    u_int   media_descriptor;
    u_int   sectors_per_fat;
    u_int   sectors_per_track;
    u_int   number_of_heads;
    u_int   hidden_sectors;
/* calculated or cached information.... */
    u_int   dir_sector_start;
    u_int   number_of_dir_sectors;
    u_int   data_sector_start;
    u_int   number_data_sectors;
    u_int   fat_size;
    u_int8  *fat_table;
    u_int   nbuf;
    struct  buf *buffers, *free, *head;
 };

/* file system switch table. */
struct doss_fs
 {
    /* type of the filesystem. */
    enum    fs_type   fs_type;
    int   (*initialize_fs)();
    /* raw stuff, may not be supported on some filesystem types. */
    int   (*read_block)();
    int   (*write_block)();
    int   (*format)();
    int   (*disk_space)();
    int   (*get_fs_attr)();
    
    /* basic file operations. */
    int   (*create_file)();
    int   (*open_file)();
    int   (*close_file)();
    int   (*seek_file)();
    int   (*read_file)();
    int   (*write_file)();
    int   (*rename_file)();
    int   (*delete_file)();
/*    int   (*stat_file)(); */
/*    int   (*dprint_file)();*/
    int   (*get_attr)();
    int   (*set_attr)();
    
    /* directory operations */
    int   (*create_dir)();
    int   (*delete_dir)();
    int   (*open_dir)();
    int   (*read_dir)();
    int   (*seek_dir)();
    int   (*tell_dir)();
    int   (*close_dir)();
 };


/*  
  definition of a "drive" in our system.  
  Things we need to know:
     1)  what unit, and hence name, is this drive. 
     2)  what is its file descriptor.  This is important if 
         it represents a device or file.
	 (this is valid only if it is a device or file).
	 alternatively, give the path to the root of this filesystem
	 if it is mapped onto the unix filesystem.
     3)  what type of filesystem is it???
     4)  what are the operations defined for this filesystem type.
         (valid for all three filesystem types)
     5)  What are the attributes of this filesystem. 
         (valid only for files or devices).
     6)  What path is currently valid on this drive.
 
*/

struct doss_drive 
 {
    int   unit;
    int   flags;
    
    /* following 2 quantities define the drive to the system */
    /* fd represents the file descriptor used to access a 
       drive if that drive is a file or device.
       path represents the name of the object acting as the 
       drive; it's either a file, directory, or device. 
     */
       
    int   fd;
    char  *path;

    /* define the characteristics of the drive. */
    enum  fs_type  fs_type;
    struct doss_fs  *fs_ops;
    struct fs_attr *fs_attr;
    
    /* define the path on the drive. */
    char   curr_path[DOSS_MAX_PATH];
 };


/* element structure of the system file table. */
struct doss_file_handle
 {
    
    int  unit;         /* drive that file handle is open on. */
    int  flags;
    int  count;
    int  fd;           /* in case it is a unix_fs type of file. */
    int  curr_pos;     /* current position in file */
    int  access;       /* access mode. */
    int  attrib;
    int  mtime;
    int  mdate;
    int  size;
    char  path[DOSS_MAX_PATH];   /* location  of file.  */
 };




/* system error messages. */

extern int syscall_errno;

#define SYSCALL_FAILURE 1
#define SYSCALL_SUCCESS 0

#define DOSS_NOERROR       0
#define DOSS_EINVALFUNC    1
#define DOSS_ENOSUCHFILE   2
#define DOSS_ENOSUCHPATH   3
#define DOSS_ETOOMANYFILES 4
#define DOSS_EPERMDENIED   5
#define DOSS_EINVALHANDLE  6
#define DOSS_EMEMCORR      7  /* cannot happen. */
#define DOSS_ENOMEM        8
#define DOSS_EBADALLOC     9
#define DOSS_EINVALENV    10
#define DOSS_EINVALFORMAT 11
#define DOSS_EINVALACCESS 12
#define DOSS_EINVALDATA   13
#define DOSS_RESV1        14
#define DOSS_EINVALDRIVE  15
#define DOSS_EDIRNODEL    16
#define DOSS_EDIFFDEV     17
#define DOSS_ENOFILES     18
#define DOSS_ENODEVWRITE  19
#define DOSS_EUNKDEV      20
#define DOSS_EDEVNOTRDY   21
#define DOSS_EUNKCMD      22
#define DOSS_ECRCERR      23
#define DOSS_EBADREQ      24
#define DOSS_ESEEKERR     25
#define DOSS_EUNKMEDIA    26
#define DOSS_ESECTERR     27
#define DOSS_EPRNTPAPER   28
#define DOSS_EWRITEERR    29
#define DOSS_EREADERROR   30
#define DOSS_EGENFAILURE  31

/* and so on.   */
/* rest not needed ??? */




#endif   /* DOSS_H */
#endif   /* DOSS_SUPPORT */

