/************************************************************************

    VGAPATCH 1.00 - Patch the GEM/1 system file for VGA support

    Copyright (C) 2005  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/
#define INSTANTIATE
#include "vgapati.h"

WORD LSTCPY(LPBYTE s1, LPBYTE s2)
{
	WORD n = 0;
	do
	{
		s1[n] = s2[n];
		++n;
	} while (s2[n-1]);
	return n;
}

MLOCAL char txtbuf1[600];
MLOCAL char txtbuf2[600];

WORD rsc_alert(WORD defbtn, WORD rsrc, ...)
{
	LPBYTE str;

	va_list ap;
	va_start(ap, rsrc);

	rsrc_gaddr(R_STRING, rsrc, (LPVOID *)&str);	
	LSTCPY(ADDR(txtbuf1), str);
	vsprintf(txtbuf2, txtbuf1, ap);
	va_end(ap);
	return form_alert(defbtn, txtbuf2);
}

unsigned char match[]   = { 0xb1, 0x04, 0x89, 0x46, 0x04, 0xd3, 0xe0, 
			    0x33, 0xdb, 0x85, 0xc0, 0x79, 0x01, 0x4b };

unsigned char replace[] = { 0xb9, 0x04, 0x00, 0x31, 0xdb, 0xd1, 0xe0,
		            0xd1, 0xd3, 0xe2, 0xfa, 0x90, 0x90, 0x90 };


WORD attempt_patch(BYTE *filename)
{
	MLOCAL BYTE oldname[256];
	MLOCAL BYTE newname[256];
	char *dot;
	FILE *fpi, *fpo;
	unsigned char buf[16];
	int c, n, prelude, found;

	/* Chop off any existing .EXE extension and add .BAK */
	strcpy(oldname, filename);
	dot = oldname + strlen(oldname);
	while (dot > oldname)
	{
		if (*dot == '/' || *dot == '\\' || *dot == ':') break;
		if (*dot == '.')
		{
			*dot = 0;
			break;
		}
		--dot;		
	}
	strcpy(newname, oldname);
	strcat(oldname, ".BAK");
	strcat(newname, ".NEW");

	fpi = fopen(filename, "rb");
	if (!fpi)
	{
		rsc_alert(1, NOOPEN, filename);
		return;
	}
	fpo = fopen(newname, "wb");
	if (!fpo)
	{
		fclose(fpi);
		rsc_alert(1, NOOPEN, newname);
		return;
	}
	/* prelude = 1 while we're filling the buffer, 0 while we're 
	 * writing out. */
	prelude = 1;
	found = 0;
	for (n = 0; n < 16; n++) buf[n] = 0xFF;
	while ((c = fgetc(fpi)) != EOF)
	{
		for (n = 0; n < 15; n++) buf[n] = buf[n+1];
		buf[n] = c;
		if (!memcmp(buf, match, 14))
		{
			++found;
			memcpy(buf, replace, 14);
		}

		if (buf[0] != 0xFF) prelude = 0;
		if (!prelude)
		{
			if (fputc(buf[0], fpo) == EOF)
			{
				fclose(fpi);
				fclose(fpo);
				remove(newname);
				rsc_alert(1, WRERR, newname);
				return 0;
			}
		}
	}
	fclose(fpi);
	/* Flush anything left in the buffer */
	if (fwrite(buf, 1, 15, fpo) < 15 || fclose(fpo))
	{
		fclose(fpo);
		remove(newname);
		rsc_alert(1, WRERR, newname);
		return 0;
	}
	if (!found)
	{
		remove(newname);
		rsc_alert(1, NOMATCH, filename);
		return 0;
	}

	/* Remove-and-rename */
	remove(oldname);
	if (rename(filename, oldname))
	{
		remove(newname);
		rsc_alert(1, RENERR, filename, oldname);
		return 0;
	}
	if (rename(newname, filename))
	{
		remove(newname);
		rsc_alert(1, RENERR, newname, filename);
		return 0;
	}
	return 3 - rsc_alert(2, WORKED, found, (found == 1) ? " was" : "s were");
}

VOID hndl_about(LPTREE parent)
{
	LPTREE tree;
	WORD    xdial, ydial, wdial, hdial;
	WORD	exitobj;
	
	parent = &parent[ABOUT1];

	rsrc_gaddr(R_TREE, ABOUTBOX, (LPVOID *)&tree);
	form_center(tree, &xdial, &ydial, &wdial, &hdial);

	form_dial(0, parent->ob_x, parent->ob_y, parent->ob_width, parent->ob_height,
			xdial, ydial, wdial, hdial);
	form_dial(1, parent->ob_x, parent->ob_y, parent->ob_width, parent->ob_height,
			xdial, ydial, wdial, hdial);
	objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);
	exitobj = form_do(tree, 0) & 0x7FFF;

	tree[exitobj].ob_state &= ~SELECTED;
	form_dial(2, parent->ob_x, parent->ob_y, parent->ob_width, parent->ob_height,
			xdial, ydial, wdial, hdial);
	form_dial(3, parent->ob_x, parent->ob_y, parent->ob_width, parent->ob_height,
			xdial, ydial, wdial, hdial);
}


VOID vgapatch(VOID)				/* main event multi loop		*/
{
	LPTREE tree;
	WORD    xdial, ydial, wdial, hdial;
	WORD	xzoom, yzoom, wzoom, hzoom;
	WORD	exitobj;
	LPTEDI  tedi;
	BYTE	filename[256];

	wzoom = 4 * gl_wchar;
	hzoom = 2 * gl_hchar;
	xzoom = (scrn_area.g_w - wzoom) / 2;	
	yzoom = (scrn_area.g_h - hzoom) / 2;	
	rsrc_gaddr(R_TREE, DLGTRANS, (LPVOID *)&tree);
	form_center(tree, &xdial, &ydial, &wdial, &hdial);
	
	tedi = (LPTEDI)tree[FILENAME].ob_spec;
	LSTCPY(filename, tedi->te_ptext);
	tedi->te_ptext = ADDR(filename);

	form_dial(0, xzoom, yzoom, wzoom, hzoom, xdial, ydial, wdial, hdial);
	form_dial(1, xzoom, yzoom, wzoom, hzoom, xdial, ydial, wdial, hdial);
	objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);

	FOREVER
	{
		exitobj = form_do(tree, 0) & 0x7FFF;

		tree[exitobj].ob_state &= ~SELECTED;
		if (exitobj == CANCEL1) break;

		if (exitobj == ABOUT1)
		{
			hndl_about(tree);
			objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);
		}

		if (exitobj == BROWSE)
		{
			WORD fs_iexbutton;
			BYTE fs_iinsel[13];
			BYTE pathname[256];

			LSTCPY(pathname, tedi->te_ptext);
			fsel_input(ADDR(pathname), ADDR(fs_iinsel), &fs_iexbutton);
			if (fs_iexbutton)
			{
				char *s;
				s = strrchr(pathname, '\\');
				if (s && strchr(s, '/')) 
					s = strchr(s, '/');
				else if (!s) s = strrchr(pathname, '/');

				if (s) *s = 0;
				strcpy(filename, pathname);
				strcat(filename, "\\");
				strcat(filename, fs_iinsel);
			}	
			objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);
		}
		if (exitobj == OKAY1)
		{
			graf_mouse(HOUR_GLASS, 0x0L);
			if (attempt_patch(filename) == 1)
			{
				graf_mouse(ARROW, 0x0L);
				break;
			}
			else
			{
				graf_mouse(ARROW, 0x0L);
				objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);
			}
		}

	}

	form_dial(2, xzoom, yzoom, wzoom, hzoom, xdial, ydial, wdial, hdial);
	form_dial(3, xzoom, yzoom, wzoom, hzoom, xdial, ydial, wdial, hdial);
	wind_update(BEG_UPDATE);
}

/*************************************************************/



/*------------------------------*/
/*			edicon_term			*/
/*------------------------------*/
VOID vgapatch_term(WORD term_type)
{
	switch (term_type)	/* NOTE: all cases fall through		*/
	{
		case (0 /* normal termination */):
		
		case (2 /* not enough memory */): 
			graf_mouse(ARROW, 0x0L);
			v_clsvwk( vdi_handle );
		case (1 /* no .RSC file or no virt wksta */):
			wind_update(END_UPDATE);
			appl_exit();
		case (4 /* appl_init() failed */):
			break;
	}
}


/*************************************************************/



WORD vgapatch_init(WORD ARGC, BYTE *ARGV[])
{
	WORD	work_in[11];
	WORD	i;
	LPTREE	tree;

	memset(&g_xbuf, 0, sizeof(g_xbuf));
	g_xbuf.buf_len = sizeof(g_xbuf);
	
	gl_apid = appl_init(&g_xbuf);			/* init application	*/
	if (gl_apid == -1)
		return(4); 

	wind_update(BEG_UPDATE);
	graf_mouse(HOUR_GLASS, 0x0L);
	/* open virtual workstation */
	for (i=0; i<10; i++)
	{
		work_in[i]=1; /* initial defaults: line style,color,etc	*/
	}
	work_in[10]=2;	/* raster coordinates	*/

	/* Get the VDI handle for GEM AES screen workstation */
	gem_handle = graf_handle(&gl_wchar,&gl_hchar,&gl_wbox,&gl_hbox);
	vdi_handle = gem_handle;
	
	v_opnvwk(work_in,&vdi_handle,work_out);
	if (vdi_handle == 0)
		return(1);

	if (!rsrc_init( ADDR("VGAPATCH.RSC"), ABOUTBOX, DLGTRANS, 0))
	{    	
		/* No Resource File  */
		graf_mouse(ARROW, 0x0L);
		form_alert(1,"[3][Fatal Error !|VGAPATCH.RSC|File Not Found][ Abort ]");
		return(2);
	}

	scrn_width = work_out[0] + 1; 		/* # of pixels wide	*/
	scrn_height = work_out[1] + 1; 		/* # of pixels high	*/
	scrn_xsize = work_out[3];		/* pixel width (microns)*/
	scrn_ysize = work_out[4];		/* pixel height(microns)*/

	scrn_area.g_x = 0;
	scrn_area.g_y = 0;
	scrn_area.g_w = scrn_width;
	scrn_area.g_h = scrn_height;

	rsrc_gaddr(R_TREE, ABOUTBOX, (LPVOID *)&tree);
	trans_gimage(vdi_handle, tree, APPICON);  

	ad_rmsg = ADDR((BYTE *) &gl_rmsg[0]); /* init message address	*/

	/* Get Desktop work area	*/
	wind_get(DESK, WF_WXYWH, &gl_xfull, &gl_yfull, &gl_wfull, &gl_hfull);

	desk_area.g_x = gl_xfull;
	desk_area.g_y = gl_yfull;
	desk_area.g_w = gl_wfull;
	desk_area.g_h = gl_hfull;	

	/* get work area of window */
	/* Since we allow multiple windows, we can't just set a "work_area" to
	   the size of a window. Instead, we have to handle messages from the 
	   entire desk area */

	graf_mouse(ARROW, 0x0L);
	wind_update(END_UPDATE);
	
	return(0);	/* successful initialization */
}


/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****	 	Main Program					     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/

/*------------------------------*/
/*	GEMAIN			*/
/*------------------------------*/
WORD GEMAIN(WORD ARGC, BYTE *ARGV[])
{
	WORD	term_type;
	
	if (!(term_type = vgapatch_init(ARGC, ARGV)))
	{
		vgapatch();
	}
	vgapatch_term(term_type);

}




