/*
SDSDL: GEM video driver for SDL
Copyright 2012 John Elliott <jce@seasip.demon.co.uk>
Based on SDPSC9.VGA copyright 1987, 1999 Caldera Thin Clients, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/* Sound operations. Currently sdsdl wants to own sound output; there's no
 * operation to mix into an existing sound structure, as there is with 
 * video */

#include "sdsdl_i.h"


void mixaudio(void *param, Uint8 *stream, int len)
{
	DRIVERCOMMON *c = param;

	while (len)
	{
		*stream = c->soundbuf[c->sound_ptr];
		++stream;
		c->sound_ptr = (c->sound_ptr + 1) % c->sound_len;
		--len;
	}
}


void init_sound(DRIVERCOMMON *c)
{
	SDL_AudioSpec fmt;

	fmt.freq = 25000;
	fmt.format = AUDIO_U8;
	fmt.channels = 1;
	fmt.samples = 256;
	fmt.callback = mixaudio;
	fmt.userdata = c;
	if (SDL_OpenAudio(&fmt, NULL) < 0)
	{
		c->mute = 2;
	}
}

void term_sound(DRIVERCOMMON *c)
{
	SDL_CloseAudio();
}

void sd_sound(unsigned handle, unsigned frequency, unsigned duration)
{
        DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;

	if (!self->common->mute)
	{

		memset(self->common->soundbuf, 0, sizeof(self->common->soundbuf));
		self->common->sound_ptr = 0;
		if (frequency < 20)	/* Min frequency = 20Hz */
		{
			frequency = 20;
		}
		self->common->sound_len = 25000 / frequency;
		memset(self->common->soundbuf, 0xFF, 12500 / frequency);

		SDL_PauseAudio(0);
		SDL_Delay(duration * TIMER_MSEC);
		SDL_PauseAudio(1);
	}
	else
	{
		SDL_Delay(duration * TIMER_MSEC);
		
	}
}


unsigned sd_mute(unsigned handle, signed action)
{
        DRIVERDATA *self = lookup_handle(handle);

        if (!self) return 0;

	if (self->common->mute == 2)	/* Sound init failed */
	{
		return 1;
	}

	if (action == 1) self->common->mute = 1;
	if (action == 0) self->common->mute = 0;	
	return self->common->mute;
}



