/*
SDSDL: GEM video driver for SDL
Copyright 2012 John Elliott <jce@seasip.demon.co.uk>
Based on SDPSC9.VGA copyright 1987, 1999 Caldera Thin Clients, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#include "SDL.h"
#include "SDL_events.h"
#include "SDL_thread.h"
#include "sdsdl.h"
#include "config.h"

#include <assert.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifndef SDL_Colour
#define SDL_Colour SDL_Color
#endif

/* Device constants */
#define MAX_COLOUR          65536L
#define MAX_LINE_STYLE 		7
#define MAX_L_WIDTH     	40
#define MAX_MARK_INDEX  	6
#define MAX_FONT        	1
#define MX_FIL_STYLE    	4
#define MX_FIL_HAT_INDEX        12
#define MX_FIL_PAT_INDEX        24
#define MAX_MODE        	3
#define MAX_ARC_CT      	70

#define XSIZE 165
#define YSIZE 165

#define LEFT_OFFSET  0
#define RIGHT_OFFSET 3
#define MAX_CELL_WD  8
#define CELL_WD   ((LEFT_OFFSET + RIGHT_OFFSET + MAX_CELL_WD + 15)/ 8)
#define CELL_HT   (16)
#define CELL_SIZE (CELL_HT * CELL_WD)
#define TIMER_MSEC  20	/* Timer tick: 20ms */
#define KBD_QUEUE_MAX 200	/* Max number of keycodes to queue */

#include "fontdef.h"

typedef enum
{
	SQUARED = 0, ARROWED = 1, CIRCLED = 2
} LINEENDSTYLE;

typedef struct
{
	SDL_Surface *surface;
	SDL_Rect     window;
	int	     own_surface;

	SDL_Surface *backbuf;
	SDL_Cursor  *cursor;
	SDL_Cursor  *old_cursor;
	struct font_head *font_top;

	unsigned double_inited;
	Uint16 double_table[256];

	unsigned txtblt_rrot_inited;
	unsigned char txtblt_rrot_table_1[2048];
	unsigned char txtblt_rrot_table_2[2048];

	signed HIDE_CNT;
	unsigned btn_state, btn_state0;
	signed	mousex, mousey;
	signed	mousex0, mousey0;
	int	timer_running;
	SDL_Thread *timer_thread;
	void (*fontmgr)(struct font_head *pfont);

	TIMVEC timvec;
	BUTVEC butvec;
	MOTVEC motvec;
	CURVEC curvec;
	unsigned mute;
	Uint8 soundbuf[2500];	/* 1/10 sec */
	int sound_len;
	int sound_ptr;
	unsigned kbd_mod;
	unsigned kbd_queue[KBD_QUEUE_MAX];
	unsigned int kbd_queue_len;
	unsigned textmode;
} DRIVERCOMMON;


extern FONT_HEAD system6x6_hdr;
extern FONT_HEAD system8x8_hdr;
extern FONT_HEAD system8x14_hdr;
extern FONT_HEAD system8x16_hdr;

typedef struct driverdata
{
	struct driverdata *next;
	
	DRIVERCOMMON *common;
	unsigned handle;

	/* From monobj.c */
	unsigned line_index;
	Uint32   line_colour;
	unsigned line_qi;
	unsigned line_qc;
	unsigned line_width;
	unsigned line_qw;
	LINEENDSTYLE line_beg;
	LINEENDSTYLE line_end;
	LINEENDSTYLE s_begsty;
	LINEENDSTYLE s_endsty;
	Uint16   ud_lstyl;
	unsigned mark_height;
	unsigned mark_scale;
	unsigned mark_index;
	Uint32   mark_colour;
	unsigned mark_qi;
	unsigned mark_qc;
	unsigned fill_style;
	unsigned fill_index;
	Uint32   fill_colour, s_fill_colour;
	unsigned fill_cur;
	unsigned fill_qi;
	unsigned fill_qc;
	unsigned fill_qp;
	unsigned fill_miny, fill_maxy;
	unsigned fill_intersect;
	unsigned fill_per, s_fill_per;
	unsigned patmsk,   s_patmsk;
	const Uint16   *patptr, *s_patptr;
	unsigned NEXT_PAT, s_nxtpat;
	unsigned udpt_np;
	SDL_Surface *udpt_15bpp;
	SDL_Surface *udpt_native;
	Uint16   ud_patrn[16];	/* 16 words (mono ud pattern) */
	unsigned val_mode;
	unsigned chc_mode;
	unsigned loc_mode;
	unsigned str_mode;
	unsigned write_qm;
	unsigned num_qc_lines;
	signed   q_circle[MAX_L_WIDTH];
	unsigned WRT_MODE;
	unsigned text_mode;
	unsigned foffindex;
	Uint32   FG_BP_1;
	unsigned LSTLIN;
	Uint16   LN_MASK;
	Uint16   line_styl[MAX_LINE_STYLE];
	unsigned FLIP_Y;
	unsigned CLIP;
	SDL_Rect rectClip;
	unsigned xfm_mode;
	/* From opttext.c */
	unsigned rq_type;	/* 0=pixels 1=points */
	unsigned rq_size;
	unsigned rq_font;
	unsigned rq_attr;
	unsigned dbl;
	unsigned loaded;	/* fonts loaded flag */
	struct font_head font_inf;
	struct font_head *cur_head;
	struct font_head *cur_font;
	struct font_head *act_font;
	unsigned char def_buf[8 * CELL_SIZE];
	unsigned char *txbuf1, *txbuf2, *sav_buf1, *sav_buf2, *buff_ptr;
	unsigned ini_font_count;
	unsigned dev_tab[45];
	unsigned inq_tab[45];
	unsigned siz_tab[12];
	Uint32 text_colour;	/* TEXT_BP Text colour */
	SDL_Colour sdlc_text;
	unsigned text_qc;
	unsigned SPECIAL;
	unsigned rot_case;
	unsigned h_align;
	unsigned v_align;
	unsigned CHAR_DEL;
	unsigned WEIGHT;
	unsigned R_OFF;
	unsigned L_OFF;
	unsigned MONO_STATUS;
	unsigned CHR_HT;
	unsigned ACTDELY;
	unsigned tempdely;
	unsigned DDA_INC;
	unsigned T_SCLSTS;
	unsigned char *font_off;
	unsigned width;	/* Dimensions of text to output */
	unsigned height;
	unsigned isspace;
	signed y_position;
	signed lt_hoff;
	signed rt_hoff;
	signed X1, X2, Y1, Y2;
	signed DESTX, DESTY;
	Uint16 XACC_DDA;
	signed JUST_DEL_CHAR, JUST_DEL_CHAR_REM;
	signed JUST_DEL_WORD, JUST_DEL_WORD_REM;
	signed JUST_DEL_SIGN;
	signed form_offset;
	signed form_width;
	unsigned faux_depth;

/* Text mode emulation */
	unsigned text_x, text_y, text_rv;
	signed   text_charw, text_charh, text_cellw, text_cellh;
	unsigned char colour_map[768];
	unsigned short req_col[768];

} DRIVERDATA;

unsigned register_data(DRIVERDATA *p);
void     unregister_data(DRIVERDATA *p);

DRIVERDATA *lookup_handle(unsigned h);

void map_colour(DRIVERDATA *self, unsigned short gem_colour, SDL_Colour *c, Uint32 *pixel);
void map_colour_x(DRIVERDATA *self, SDL_Surface *s, unsigned short gem_colour, SDL_Colour *c, Uint32 *pixel);
void init_wk  (DRIVERDATA *self, unsigned work_in[11], unsigned work_out[57]);
void st_fl_ptr(DRIVERDATA *self);
void rectfill (DRIVERDATA *self, signed xy[4], int update);
void pline(DRIVERDATA *self, unsigned count, signed xy[]);
void plygn(DRIVERDATA *self, unsigned count, signed xy[]);
void wline(DRIVERDATA *self, unsigned count, signed xy[]);
void do_arrow(DRIVERDATA *self, unsigned count, signed xy[]);
int clip_line(DRIVERDATA *self, signed *x1, signed *y1,
				signed *x2, signed *y2);
unsigned code(DRIVERDATA *self, signed *x, signed *y);
void ABLINE(DRIVERDATA *self, signed x1, signed y1, 
			      signed x2, signed y2);
Uint16 do_line(DRIVERDATA *self, signed x1, signed y1, 
			      signed x2, signed y2);
Uint16 xline_swap(DRIVERDATA *self, signed x1, signed x2, signed y);
Uint16 xline_noswap(DRIVERDATA *self, signed x1, signed x2, signed y);
void CLC_FLIT(DRIVERDATA *self, signed y1, unsigned count, signed *ptsin);
signed SMUL_DIV(signed m1, signed m2, signed d1);
void s_fa_attr(DRIVERDATA *self);
void r_fa_attr(DRIVERDATA *self);
void do_circ(DRIVERDATA *self, signed cx, signed cy);
void perp_off(DRIVERDATA *self, signed *vx, signed *vy);
void arrow(DRIVERDATA *self, unsigned count, signed *xy, int inc);
signed vec_len(signed x, signed y);
Uint8 *concat(DRIVERDATA *self, signed x, signed y);
Uint8 *concat_x(DRIVERDATA *self, SDL_Surface *s, signed x, signed y);

unsigned get_pixel(SDL_Surface *s, int x, int y, SDL_Color *cr);
unsigned unmap_colour(DRIVERDATA *self, SDL_Color *cr, Uint32 pel);

/* Draw a patterned horizontal line */
void box_hline(DRIVERDATA *self, signed y, signed x, unsigned w, Uint16 pattern, Uint32 bg);

void update_rect(DRIVERDATA *self, signed xmin, signed xmax,
			signed ymin, signed ymax);

/* Text functions */
void text_init(DRIVERDATA *self, unsigned colour);
void cpy_head(DRIVERDATA *self);
void in_rot(DRIVERDATA *self);
void in_doub(DRIVERDATA *self);
void inc_lfu(DRIVERDATA* self);
void sel_font(DRIVERDATA *self);
double CLC_DDA(DRIVERDATA *self, double actual, double requested);
unsigned ACT_SIZ(DRIVERDATA *self, unsigned size);
unsigned chk_ade(DRIVERDATA *self, unsigned ch);
void clr_skew(DRIVERDATA *self);
void chk_fnt(DRIVERDATA *self);
void text_blt(DRIVERDATA *self, unsigned count, unsigned *text, int justified);
void text_blt_main(DRIVERDATA *self, unsigned count, unsigned *text,
			int mode, int justified);
int MONO8XHT(DRIVERDATA *self);
signed text_move(DRIVERDATA *self, Uint8 *dest, unsigned dest_pitch, 
		unsigned src_width, unsigned src_x);
void text_blit(DRIVERDATA *self, Uint8 *dest, unsigned src_pitch,
			unsigned char_width, unsigned src_x, unsigned dest_x,
			unsigned mode);
void text_scale(DRIVERDATA *self, Uint8 *buffer, unsigned *src_pitch,
			unsigned *char_width, unsigned src_size);
void text_grey(DRIVERDATA *self, Uint8 *buffer, unsigned src_height,
			unsigned src_pitch);
void text_bold(DRIVERDATA *self, Uint8 *buffer, unsigned src_height,
			unsigned src_pitch);
void text_italic(DRIVERDATA *self, Uint8 *buffer, unsigned src_height,
			unsigned src_pitch, unsigned src_width);
void text_rotate(DRIVERDATA *self, Uint8 *buffer, unsigned src_height,
			unsigned *src_pitch, unsigned src_width);

void txtblt_xor_rl_i(DRIVERDATA *self,
			Uint8 *dest, Uint8 *src, unsigned rotatecount,
			Uint8 leftmask, Uint8 rightmask, Uint8 midcount);
void txtblt_xor_rr_i(DRIVERDATA *self,
			Uint8 *dest, Uint8 *src, unsigned rotatecount,
			Uint8 leftmask, Uint8 rightmask, Uint8 midcount);

unsigned sd_pollkey(DRIVERDATA *self, unsigned *keys, signed max);

int handle_keydown(DRIVERDATA *self, SDL_Event *ev);
int handle_keyup(DRIVERDATA *self, SDL_Event *ev);

void dis_cur(DRIVERDATA *self);
void hide_cur(DRIVERDATA *self);

typedef enum
{
	LLUR = 0, ULLR = 1
} ARBCORNERTYPE;


void arb_corner(signed xy[4], ARBCORNERTYPE type);
signed short Isin(signed short angle);
signed short Icos(signed short angle);

void init_sound(DRIVERCOMMON *c);
void term_sound(DRIVERCOMMON *c);

extern const Uint16 def_line_sty[6];
extern const Uint16 oemmskpat, oempat[];
extern const Uint16 dithrmsk, dither[];
extern const Uint16 hat_0_msk, hatch0[];
extern const Uint16 hat_1_msk, hatch1[];
extern const Uint16 hollow, solid;
extern const Uint16 def_ud_patrn[16];

extern const signed m_dot[], m_plus[];

extern const unsigned DEV_TAB[45];
extern const unsigned INQ_TAB[45];
extern const unsigned SIZ_TAB[12];
#define DEF_CHWT  SIZ_TAB[0]
#define DEF_CHHT  SIZ_TAB[1]
#define DEF_LWID  SIZ_TAB[4]
#define DEF_MKWD  SIZ_TAB[8]
#define DEF_MKHT  SIZ_TAB[9]
#define MAX_MKWD  SIZ_TAB[10]
#define MAX_MKHT  SIZ_TAB[11]

