/*************************************************************************
**       Copyright 1999, Caldera Thin Clients, Inc.                     ** 
**       This software is licenced under the GNU Public License.        **
**       Please see LICENSE.TXT for further information.                ** 
**                                                                      ** 
**                  Historical Copyright                                ** 
**									**
**									**
**									**
**  Copyright (c) 1987, Digital Research, Inc. All Rights Reserved.	**
**  The Software Code contained in this listing is proprietary to	**
**  Digital Research, Inc., Monterey, California and is covered by U.S.	**
**  and other copyright protection.  Unauthorized copying, adaptation,	**
**  distribution, use or display is prohibited and may be subject to 	**
**  civil and criminal penalties.  Disclosure to others is prohibited.	**
**  For the terms and conditions of software code use refer to the 	**
**  appropriate Digital Research License Agreement.			**
**									**
*************************************************************************/

#include "sdsdl_i.h"

#define range(v, l, h, d) ( ( ((v < l) || (v > h))  ? d : v) )


void sd_gtext(unsigned handle, signed x, signed y, unsigned count, 
		unsigned *text, int fxn)
{		 	   
	int	need_extent;
	signed	delh, delv, rdel1, rdel2;
	Uint32	sav_bp;
	SDL_Colour sav_col;
	signed	extent[8];
	DRIVERDATA *self;

	if (!count) return;

	self = lookup_handle(handle);
	if (!self) return;
	
	/* Take horizontal alignment into account. */

	need_extent = (fxn != 11);
	if (self->h_align == 0) delh = 0;
	else
	{
	    if (need_extent)
		sd_qtextent(handle, count, text, extent);
	    need_extent = 0;
	    delh = (self->h_align == 1 ? self->width >> 1 : self->width);
	}  /* End else:  center or right alignment. */
	self->X1 = 1;
	switch (self->v_align)
	{
	case 0:
	default:
	        delv = 0;
	        delh += self->L_OFF;
		break;
	case 1:
	        delv = self->font_inf.half;
		if ( self->font_inf.top )
			self->X1 = self->font_inf.top;
		delh += self->L_OFF + (self->font_inf.half * self->R_OFF) / self->X1;
		break;
	case 2:
	        delv = self->font_inf.ascent;
		if( self->font_inf.top ) 
			self->X1 = self->font_inf.top;
		delh += self->L_OFF + (self->font_inf.ascent * self->R_OFF) / self->X1;
		break;
	case 3:
	        delv = -self->font_inf.bottom;
		if( self->font_inf.bottom ) 
			self->X1 = self->font_inf.bottom;
		delh -= ((self->font_inf.bottom - self->font_inf.descent) * self->L_OFF) / self->X1;
		break;
	case 4:
	        delv = -self->font_inf.descent;
		break;
	case 5:
	        delv = self->font_inf.top;
	        delh += self->L_OFF + self->R_OFF;
		break;
	}

	rdel1 = self->font_inf.top - delv;
	rdel2 = (self->ACTDELY - self->font_inf.top - 1) + delv;
	switch (self->rot_case)
	{
	case 0:
	    self->DESTX = x - delh;
	    self->DESTY = y - rdel1;
	    break;
	case 1:
	    self->DESTX = x - rdel1;
	    self->DESTY = y + delh;
	    break;
	case 2:
	    self->DESTX = x + delh;
	    self->DESTY = y - rdel2;
	    break;
	case 3:
	    self->DESTX = x - rdel2;
	    self->DESTY = y - delh;
	    break;
	}
	if (self->SPECIAL != 0 || !self->MONO_STATUS || !MONO8XHT(self))
	{
	    if ( (self->SPECIAL & SKEW) && (self->WRT_MODE == 0 || self->WRT_MODE == 3) )
	    {
		if (need_extent) sd_qtextent(handle, count, text, extent);

	        need_extent = 0;
		switch (self->rot_case)
		{
		case 0:
		    self->X1 = self->DESTX;
		    self->X2 = self->X1 + self->width;
		    self->Y2 = self->Y1 = self->DESTY + self->ACTDELY - 1;
		    break;
		case 1:
		    self->Y2 = self->DESTY;
		    self->Y1 = self->Y2 - self->width;
		    self->X1 = self->X2 = self->DESTX + self->ACTDELY - 1;
		    break;
		case 2:
		    self->X2 = self->DESTX;
		    self->X1 = self->X2 - self->width;
		    self->Y2 = self->Y1 = self->DESTY;
		    break;
		case 3:
		    self->Y1 = self->DESTY;
		    self->Y2 = self->Y1 + self->width;
		    self->X1 = self->X2 = self->DESTX;
		    break;
	        }

		clr_skew(self);
	    }  /* End if:  skewed and replace or inverse transparent mode. */
	    if (self->SPECIAL & UNDER)
	    {
		if (need_extent) sd_qtextent(handle, count, text, extent);
		switch (self->rot_case)
		{
		case 0:
		    self->X1 = self->DESTX + self->L_OFF;
		    self->X2 = self->X1 + self->width;
		    self->Y1 = self->DESTY + self->font_inf.top + 1;
		    self->Y2 = self->Y1 + self->font_inf.ul_size - 1;
		    break;
		case 1:
		    self->X1 = self->DESTX + self->font_inf.top + 1;
		    self->X2 = self->X1 + self->font_inf.ul_size - 1;
		    self->Y2 = self->DESTY - self->L_OFF;
		    self->Y1 = self->Y2 - self->width;
		    break;
		case 2:
		    self->X2 = self->DESTX - self->L_OFF;
		    self->X1 = self->X2 - self->width;
		    self->Y2 = self->DESTY + self->ACTDELY - self->font_inf.top - 1;
		    self->Y1 = self->Y2 - self->font_inf.ul_size + 1;
		    break;
		case 3:
		    self->X2 = self->DESTX + self->ACTDELY - self->font_inf.top - 1;
		    self->X1 = self->X2 - self->font_inf.ul_size + 1;
		    self->Y1 = self->DESTY + self->L_OFF;
		    self->Y2 = self->Y1 + self->width;
		    break;
	        }
	    }  /* End if:  underlined. */
	    self->XACC_DDA = 0x7FFF;	/* init the horizontal dda */
	    sav_bp = self->text_colour;
	    sav_col = self->sdlc_text;
	    text_blt(self, count, text, (fxn == 11));
	    self->sdlc_text = sav_col;
	    self->text_colour = sav_bp;
	}
} 


void text_init(DRIVERDATA *self, unsigned colour)
{
	unsigned id_save;
	unsigned temp_max, temp_top;
	struct font_head *def_save = NULL;	/* font head pointer */
	unsigned char *scratch;

	if (self->common->font_top == NULL)
	{
		self->common->font_top = &system6x6_hdr;
	}
	

	self->cur_head = &self->font_inf;

	/* Set the default text scratch buffer addresses. */
	scratch = self->def_buf;

	self->buff_ptr = self->txbuf1 = self->sav_buf1 = &self->def_buf[0];
	self->txbuf2 = self->sav_buf2 = &self->def_buf[4 * CELL_SIZE];

	self->siz_tab[0] = self->siz_tab[1] = 0x7FFFFFFFL; /* min cell size */
	self->siz_tab[2] = self->siz_tab[3] = 0;	   /* max cell size */
	
	self->cur_font = self->common->font_top;
	id_save = self->cur_font->font_id;

	for ( self->dev_tab[5] = 0, self->ini_font_count = 1 ; 1 ;
	      self->cur_font = self->cur_font->next_font )
	{
		if ( self->cur_font->flags & DEFAULT )
			def_save = self->cur_font;

		if ( self->cur_font->font_id != id_save)
		{
			++self->ini_font_count;
			id_save = self->cur_font->font_id;
		}
		if (self->cur_font->font_id == 1) /* System font */
		{
			temp_max = self->cur_font->max_char_width;
			temp_top = self->cur_font->top + 1;
			if (self->siz_tab[0] > temp_max) 
				self->siz_tab[0] = temp_max;
			if (self->siz_tab[1] > temp_top) 
				self->siz_tab[1] = temp_top;
			if (self->siz_tab[2] < temp_max) 
				self->siz_tab[2] = temp_max;
			if (self->siz_tab[3] < temp_top) 
				self->siz_tab[3] = temp_top;
			++self->dev_tab[5];	/* number of sizes */
 		}

		if (self->cur_font->next_font == NULL) break;
	}

	self->dev_tab[10] = self->ini_font_count;	/* number of faces */

	self->act_font = self->cur_font = def_save;
	cpy_head(self);

	self->text_qc = range(colour, 0, MAX_COLOUR - 1, 1);

	map_colour(self, self->text_qc, &self->sdlc_text, &self->text_colour);

	self->SPECIAL = self->rot_case = self->h_align = self->v_align = 0;
	in_rot(self);
	in_doub(self);	

	/* rq_size was set to 1 in the original source from Ventura.
	   GEM WRITE chose the 8 point system font.  
	   Sel_Size searched for a system font 1 pixel high as it's
	   default.
	   rq_size is now set for a 10 point system font as the default
	   jn 9-15-87 */

	self->rq_font = 1;				/* jn 9-15-87 */
	self->rq_size = 10 ;			/* jn 9-15-87 */
	self->rq_attr = 0;
	self->dbl = 0;
	self->rq_type = 1;
	self->loaded = 0;
	self->CHAR_DEL = self->WEIGHT = self->R_OFF = self->L_OFF = 
	self->MONO_STATUS = 0;	

	self->CHR_HT  = self->font_inf.top + self->font_inf.bottom + 1;
	self->ACTDELY = self->font_inf.form_height;
}


unsigned sd_stheight(unsigned handle, unsigned size, 
		signed *char_width, signed *char_height,
		signed *cell_width, signed *cell_height)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!handle) return 0;
	if (self->xfm_mode == 0)
	    size = (self->common->window.h) - size;
	self->rq_size = size;
	if( self->rq_size == 0 )
		self->rq_size = 1;	/* it must be at least one pel high */
	self->rq_type = 0;
	sel_font(self);	

	*char_width  = self->font_inf.max_char_width;
	*char_height = self->font_inf.top + 1;
	*cell_width  = self->font_inf.max_cell_width;
	*cell_height = self->CHR_HT;
	inc_lfu(self);
	self->FLIP_Y = 1;
	return 1;
} 


unsigned sd_stpoint(unsigned handle, unsigned size, 
		signed *char_width, signed *char_height,
		signed *cell_width, signed *cell_height)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!handle) return 0;
	self->rq_size = size;
	self->rq_type = 1;
	sel_font(self);
	*char_width  = self->font_inf.max_char_width;
	*char_height = self->font_inf.top + 1;
	*cell_width  = self->font_inf.max_cell_width;
	*cell_height = self->CHR_HT;
	inc_lfu(self);
	self->FLIP_Y = 1;
	return self->font_inf.point;
} 

void make_header(DRIVERDATA *self)
{
	signed	i;

	cpy_head(self);
	self->font_inf.point <<= 1;
	i = ACT_SIZ(self, self->font_inf.top );
	if( self->DDA_INC == 0xffff ) 
	{
		i++;
	}
	else
	{
		if( i == ACT_SIZ(self, self->font_inf.top + 1 ) ) i--;	
	}		
	self->font_inf.top = i;
	self->font_inf.ascent = ACT_SIZ(self, self->font_inf.ascent ) + 1;
	self->font_inf.half = ACT_SIZ(self, self->font_inf.half ) + 1;
	self->font_inf.descent = ACT_SIZ(self,self->font_inf.descent );
	self->font_inf.bottom = ACT_SIZ( self,self->font_inf.bottom );
	self->font_inf.max_char_width = ACT_SIZ(self, self->font_inf.max_char_width );
	self->font_inf.max_cell_width = ACT_SIZ(self, self->font_inf.max_cell_width );
	self->font_inf.left_offset = ACT_SIZ(self, self->font_inf.left_offset );
	self->font_inf.right_offset = ACT_SIZ(self, self->font_inf.right_offset );
	self->font_inf.thicken = ACT_SIZ(self, self->font_inf.thicken );
	self->font_inf.ul_size = ACT_SIZ(self, self->font_inf.ul_size );
	self->ACTDELY = ACT_SIZ(self, self->font_inf.form_height );

	self->SPECIAL |= SCALE;
	self->cur_font = self->cur_head;
}


unsigned sd_steffects(unsigned handle, unsigned effects)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!handle) return 0;

	self->rq_attr = effects & 0x000f;	
	sel_font(self);	
	return self->rq_attr;
} 

void sd_stalignment(unsigned handle, unsigned horiz, unsigned vert,
				unsigned *h_out, unsigned *v_out)
{
	DRIVERDATA *self = lookup_handle(handle);

        if (!self) return;
	self->h_align = *h_out = horiz;
	self->v_align = *v_out = vert;
} 

signed sd_strotation(unsigned handle, signed angle)
{
	DRIVERDATA *self = lookup_handle(handle);

        if (!self) return 0;
	while (angle < 0) angle += 3600;
	while (angle >= 3600) angle -= 3600;
	self->rot_case = (angle + 450) / 900;
	self->SPECIAL = (self->SPECIAL & ~ROTATE) | (self->rot_case << 6);

	return 900 * self->rot_case;
}


unsigned sd_stfont(unsigned handle, unsigned font)
{
	DRIVERDATA *self = lookup_handle(handle);

        if (!self) return 0;

	self->rq_font = font;
	sel_font(self);
	return self->font_inf.font_id & 0xff;
}

static FONT_HEAD *sel_effect(DRIVERDATA *self, FONT_HEAD *f_ptr)
{
	unsigned	size;
	unsigned char	eff;
	unsigned char	find;
	unsigned char	font;
	FONT_HEAD	*bold;
	FONT_HEAD	*italic;
	FONT_HEAD	*normal;
	FONT_HEAD	*ptr;

	/* Determine what is being searched for. */
	font = f_ptr->font_id;
	size = f_ptr->point;
	find = self->rq_attr & (SKEW | THICKEN);
	normal = italic = bold = NULL;
	self->SPECIAL = self->SPECIAL & 0xfff0;
	self->SPECIAL = self->SPECIAL | self->rq_attr;
	/* Scan for a font matching the effect exactly. */
	for (ptr = f_ptr; ptr && ((ptr->font_id & 0xff) == font) &&
			(ptr->point == size); ptr = ptr->next_font) {
		eff = (Uint8)((ptr->font_id >> 8) & 0x00ff);
		if (eff == find) {
			self->SPECIAL &= (~find);
			return(ptr);
		}  /* End if:  effect found. */

		if (eff == 0x0)
			normal = ptr;
		else if (eff == THICKEN)
			bold = ptr;
		else if (eff == SKEW)
			italic = ptr;
	}  /* End for:  over fonts. */

	/* No exact match was found.  If the effect is bold-italic, */
	/* return italic (if possible) or bold (if possible).       */
	if (find == (SKEW | THICKEN)) {
		if (italic) {
			self->SPECIAL &= (~SKEW);
			return(italic);
		}  /* End if:  returning italic. */
		else if (bold) {
			self->SPECIAL &= (~THICKEN);
			return(bold);
		}  /* End elseif:  returning bold. */
	}  /* End if:  bold-italic. */

	/* Running out of alternatives.  Set the style and try to */
	/* return normal.                                         */
	if (normal)
		return(normal);
	else
		return(f_ptr);
}  /* End "sel_effect". */


FONT_HEAD *sel_size(DRIVERDATA *self, FONT_HEAD *f_ptr)
{
	unsigned	close_size = 0;
	unsigned	this_size = 0;
	unsigned char	font = 0;
	unsigned	ptsize = 0;
	unsigned	curptsz = 0;
	FONT_HEAD	*ptszptr;
	FONT_HEAD	*close_ptr;
	FONT_HEAD	*ptr;

	/* Look for a font whose size matches exactly. */
	font = f_ptr->font_id;
	ptsize = f_ptr->point;
	ptszptr = f_ptr;
	for (ptr = f_ptr; ptr && ((ptr->font_id & 0xff) == font);
			ptr = ptr->next_font) {
		curptsz = ptr->point;
		if (self->rq_type)
			this_size = curptsz;
		else
			this_size = ptr->top + 1;
		if( ptsize != curptsz )	/* return head of size chain */
		{
		    ptsize = curptsz;
		    ptszptr = ptr;
		}
		if (this_size == self->rq_size)
			return(ptszptr);
		else if (this_size > self->rq_size)
			break;
	}  /* End for:  over fonts. */

	/* No exact match.  Look for a doubling match. */
	ptsize = f_ptr->point;
	ptszptr = f_ptr;
	for (ptr = f_ptr; ptr && ((ptr->font_id & 0xff) == font);
			ptr = ptr->next_font) {
		curptsz = ptr->point;
		if (self->rq_type)
			this_size = curptsz;
		else
			this_size = ptr->top + 1;
		if( ptsize != curptsz )	/* return head of size chain */
		{
		    ptsize = curptsz;
		    ptszptr = ptr;
		}
		this_size <<= 1;
		if (this_size == self->rq_size) {
			self->dbl = 1;
			return(ptszptr);
		}  /* End if:  exact doubling match. */
		else if (this_size > self->rq_size)
			break;
	}  /* End for:  over fonts. */

	/* No doubling match.  Return the next size lower (this */
	if (self->rq_type)
		close_size = f_ptr->point;
	else
		close_size = f_ptr->top + 1;
	close_ptr = f_ptr;
	ptsize = f_ptr->point;
	ptszptr = f_ptr;
	for (ptr = f_ptr; ptr && ((ptr->font_id & 0xff) == font);
			ptr = ptr->next_font) {
		curptsz = ptr->point;
		if (self->rq_type)
			this_size = curptsz;
		else
			this_size = ptr->top + 1;
		if( ptsize != curptsz )	/* return head of size chain */
		{
		    ptsize = curptsz;
		    ptszptr = ptr;
		}
		if (this_size < self->rq_size) {
/* DJH 3/23/87 */
/* fixed potential doubling instead of scaling bug < to <= */
			if (self->rq_size - this_size <= self->rq_size - close_size) {
/* DJH */
				close_ptr = ptszptr;
				close_size = this_size;
				self->dbl = 0;
			}  /* End if:  smaller found. */
		}  /* End if:  normal candidate. */

/*----------------------------------------------------------------
* jn 11-10-87
* Put doubling back in
* the following comment was Dons.
* DJH 3/23/87 removed doubling to make sure largest size is used 
* He used his initials to close the comment 
*-----------------------------------------------------------------*/
#if 1

		if ((this_size <<= 1) < self->rq_size) {
			if (self->rq_size - this_size < self->rq_size - close_size) {
				close_ptr = ptr;
				close_size = this_size;
				self->dbl = 1;
			}  /* End if:  smaller found. */
			self->dbl = 1;
		}  /* End if:  double candidate. */

#endif
	}  /* End for:  over fonts. */
	if( (this_size << 1) < self->rq_size )
	    self->dbl = 1;
	return(close_ptr);
}  /* End "sel_size". */



void sel_font(DRIVERDATA *self)
{	
	FONT_HEAD *ptr;

	/* Find a matching face identifier.  If there is no matching */
	/* face, use the first non-dummy face.                       */
	for (ptr = self->common->font_top; 
		ptr && ((ptr->font_id & 0xff) != self->rq_font);
		ptr = ptr->next_font)
		;

	if (!ptr) ptr = self->common->font_top;

	/* Find the first font in the face which is the closest in size */
	/* (note:  it may be a doubled font -- dbl will be set).        */
	self->dbl = 0;
	ptr = sel_size(self, ptr);

	/* Find the closest matching attribute. */
	self->act_font = self->cur_font = sel_effect(self, ptr);

	/* If the font needs to be doubled, build a header. */
	self->SPECIAL &= ~SCALE;
	cpy_head(self);
	self->ACTDELY = self->font_inf.form_height;
	if ( (self->dbl) || (self->font_inf.top + 1 != self->rq_size ) )
	{
	    if( self->dbl )
	    {
	        self->DDA_INC = 0xFFFF;
	        self->T_SCLSTS = 1;
		make_header(self);
	    }
	    else
	    {
		if( !self->rq_type )
		{
	            self->DDA_INC = CLC_DDA(self, self->font_inf.top + 1, 
				self->rq_size);
	            make_header(self);
		}
	    }
	}
	self->CHR_HT = self->font_inf.top + 1 + self->font_inf.bottom;
		self->CHAR_DEL = self->WEIGHT = self->R_OFF = self->L_OFF = 0;	
		if (self->SPECIAL & THICKEN)
		    self->CHAR_DEL = self->WEIGHT = self->font_inf.thicken;
		if (self->SPECIAL & SKEW)
		{
			self->L_OFF = self->font_inf.left_offset;
			self->R_OFF = self->font_inf.right_offset;
			self->CHAR_DEL += (self->L_OFF + self->R_OFF);
		}
		self->MONO_STATUS = (self->font_inf.max_cell_width == 8 ? MONOSPACE & self->font_inf.flags : 0);

}  /* End "sel_font". */

unsigned sd_stcolor(unsigned handle, unsigned colour)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return 0;
	self->text_qc = range(colour, 0, self->dev_tab[13] - 1, 1);

	map_colour(self, self->text_qc, &self->sdlc_text, &self->text_colour);
	return self->text_qc;
}


void sd_qtattributes(unsigned handle, unsigned attributes[])
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;

	attributes[0] = self->font_inf.font_id;
	attributes[1] = self->text_qc;
	attributes[2] = 900*( (self->SPECIAL & ROTATE) >> 6 );
	attributes[3] = self->h_align;
	attributes[4] = self->v_align;
	attributes[5] = self->WRT_MODE;

	attributes[6] = self->font_inf.max_char_width;
	attributes[7] = self->font_inf.top + 1;
	attributes[8] = self->font_inf.max_cell_width;
	attributes[9] = attributes[7] + self->font_inf.bottom;

	self->FLIP_Y = 1;	
}


void sd_qtextent(unsigned handle, unsigned count, unsigned *text,
		 signed *dimensions)
{
	signed i, j, horsts, ix;
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;

	if ( 0 == count) return;

	self->width = 0;	

	for (i = 0 ; i < count; i++)
	{	
	if ((j = chk_ade(self, text[i])) == 1) {	/* jn 10-27-87 */
	  chk_fnt(self) ;
	}
	else if (j == 2) {			/* jn 11-22-87 */
	  text[i] = ' ' ;
	  if (chk_ade(self, text[i]) == 1) {
	    chk_fnt(self) ;
	  }
	}
	horsts = self->font_inf.flags & HORZ_OFF;
	ix = text[i] - self->font_inf.first_ade;
	self->width += self->font_inf.off_table[ix + 1] - self->font_inf.off_table[ix];
	if( horsts )
	{
	    ix <<= 1;
	    self->width -= self->font_inf.hor_table[ix] + self->font_inf.hor_table[ix + 1];
	}
	}	


	if ( (self->SPECIAL & SCALE) != 0 )
	    self->width = ACT_SIZ(self, self->width);

	if ((self->SPECIAL & THICKEN) && !(self->font_inf.flags & MONOSPACE))
	self->width += count * self->WEIGHT;
	self->height = self->CHR_HT;

	for (i = 0 ; i < 8 ; i++) dimensions[i] = 0;

	switch (self->rot_case)
	{
	case 0:
	    dimensions[2] = dimensions[4] = self->width;
	    dimensions[5] = dimensions[7] = self->height;
	    break;
	case 1:
	    dimensions[0] = dimensions[2] = self->height;
	    dimensions[3] = dimensions[5] = self->width;
	    break;
	case 2:
	    dimensions[0] = dimensions[6] = self->width;
	    dimensions[1] = dimensions[3] = self->height;
	    break;
	case 3:
	    dimensions[4] = dimensions[6] = self->height;
	    dimensions[1] = dimensions[7] = self->width;
	    break;
	}  /* End switch. */
	self->FLIP_Y = 1;	
}

signed sd_qtwidth(unsigned handle, unsigned ch, signed *cell_width,
                        signed *left_delta, signed *right_delta)
{
	unsigned k = ch;
	signed result;
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return -1;
	
	if (chk_ade(self, k) == 1) 	/* jn 1-5-88, make sure font is in ram */
	{
	    chk_fnt(self);		
	}

	if (k < self->font_inf.first_ade || k > self->font_inf.last_ade)
	{
		result = -1;
	}
	else
	{
		result = k;
		k -= self->font_inf.first_ade;
		*cell_width = self->font_inf.off_table[k+1] - 
				self->font_inf.off_table[k];
		if  ( (self->SPECIAL & SCALE) != 0 )
		{
			*cell_width = ACT_SIZ(self, *cell_width);
		}
		if ( self->font_inf.flags & HORZ_OFF )
		{
			*left_delta = self->font_inf.hor_table[k << 1];
			*right_delta = self->font_inf.hor_table[(k << 1) + 1];
		}
		else
		{
			*left_delta = *right_delta = 0;
		}
	}
	self->FLIP_Y = 1;	
	return result;
}


unsigned sd_qtname(unsigned handle, unsigned font, unsigned *result)
{
	unsigned i, id;
	char *name;
	struct font_head *tmp_font;

	DRIVERDATA *self = lookup_handle(handle);

	for (i = 0; i < 33; i++) result[i] = 0;
	if (!self) return 0;
	tmp_font = self->common->font_top;

	/* id = ID of first font */
	id = tmp_font->font_id & 0xFF;
	while (font > 1)
	{
/* Skip to the first font with a different ID */
		while ((tmp_font->font_id & 0xFF) == id)
		{
			/* Oh dear, no more fonts */
			if (!tmp_font->next_font) 
			{
				return 0;
			}
			tmp_font = tmp_font->next_font;
		}
		id = tmp_font->font_id & 0xFF;
		--font;
	}
/* tmp_font points to the required font */
	result[0] = (tmp_font->font_id & 0xff) ;
	for (i = 1, name = tmp_font->name ; (result[i++] = *name++) ;)
	;
	while(i < 33) result[i++] = 0;
	return 1;
} 


void sd_qtfontinfo(unsigned handle, unsigned *minADE, unsigned *maxADE,
                        signed *distances, signed *maxwidth, signed *effects)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;

	*minADE = 32;	/* XXX maxADE may be higher these days. Originally */
	*maxADE = 255;	/* this actually returned font_inf.first_ade and   */
			/* font_inf.last_ade, but that doesn't work with   */
			/* multisegment fonts */
	
	*maxwidth = self->font_inf.max_cell_width;
	distances[0] = self->font_inf.bottom;
	distances[1] = self->font_inf.descent;
	distances[2] = self->font_inf.half;
	distances[3] = self->font_inf.ascent;
	distances[4] = self->font_inf.top;
	if ( !(self->font_inf.flags & MONOSPACE) )
		effects[0] = self->WEIGHT;
	else	effects[0] = 0;
	effects[1] = self->R_OFF;
	effects[2] = self->L_OFF;
	effects[3] = 0;
	self->FLIP_Y = 1;	
} 

unsigned sd_load_fonts(unsigned handle, PFONT pfont, unsigned char *textbuf, 
			unsigned len, FONTMGRFUNC pfunc)
{
	DRIVERDATA *self = lookup_handle(handle);
	unsigned id, result;
	PFONT this_font;

	if (!self) return 0;

  /* The scratch text buffer segment is passed in CONTRL[8].  The size of */
  /* the buffer is passed in CONTRL[9].  Use them to set the text scratch */
  /* buffer addresses.                                                    */
	if (textbuf && len)
	{
		self->txbuf1 = textbuf;
		self->txbuf2 = textbuf + (len / 2);
	}
	self->common->fontmgr = pfunc;

  /* If the font offset and segment are not already linked into the */
  /* font chain, link them in.                                      */
	for (this_font = self->common->font_top;
	     this_font->next_font != NULL && this_font->next_font != pfont;
	     this_font = this_font->next_font)
	{
	}
	result = 0;
	if (this_font->next_font == NULL)
	{
	/* Patch the last link to point to the first new font. */
		this_font->next_font = pfont;
		id = this_font->font_id & 0xff ;
	/* Find out how many distinct font id numbers have just been linked in. */
		while ((this_font = this_font->next_font))
		{
	  /* Update the count of font id numbers, if necessary. */
	  		if ((this_font->font_id & 0xff) != id)
	  		{
				id = this_font->font_id & 0xff ;
				++result;
			}
		}
	}
	self->dev_tab[10] += result;
	self->loaded = 1;
	return result;
}  /* End "dt_loadfont". */

void sd_unload_fonts(unsigned handle, PFONT pfont)
{
	DRIVERDATA *self = lookup_handle(handle);
	PFONT this_font;

  /* The font segment chain to be unloaded is passed in CONTRL[7].  Plug */
  /* it into a pointer.  If it is zero, bail out.                        */
	if (!self || !pfont) return;

  /* Find a pointer to the font segment and offset in the chain and */
  /* break the link.                                                */
	for (this_font = self->common->font_top;
	     this_font->next_font != NULL && this_font->next_font != pfont;
	     this_font = this_font->next_font)
	{
	}
	if (this_font->next_font == pfont) 
	{
		this_font->next_font = NULL;
	}
	/* Reset the default text font and scratch buffer addresses. */
	self->txbuf1 = self->sav_buf1;
	self->txbuf2 = self->sav_buf2;
	self->cur_font = self->common->font_top;
	cpy_head(self);

  /* Re-initialize the number of fonts indicated in the device table. */
	self->dev_tab[10] = self->ini_font_count;
	self->loaded = 0;
}  /* End "dt_unloadfont". */

