/*
SDSDL: GEM video driver for SDL
Copyright 2012 John Elliott <jce@seasip.demon.co.uk>
Based on SDPSC9.VGA copyright 1987, 1999 Caldera Thin Clients, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#include "sdsdl_i.h"


int sd_handle_event(unsigned handle, EVPTR ev1)
{
/* The cast is necessary for building against SDL 1.2.3, where SDL_Event
 * is not the same as union SDL_Event. 1.2.14 gets it right. */

	SDL_Event *ev = (SDL_Event *)ev1;

	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	switch (ev->type)
	{
		case SDL_KEYDOWN:
			return handle_keydown(self, ev);
		case SDL_KEYUP:
			return handle_keyup(self, ev);

		case SDL_MOUSEBUTTONDOWN:
			switch (ev->button.button)
			{
				case 1: self->common->btn_state |= 1; break;	
				case 2: self->common->btn_state |= 4; break;	
				case 3: self->common->btn_state |= 2; break;	
			}
			if (self->common->butvec)
			{
				(*self->common->butvec)(self->common->btn_state);
			}
			break;
		case SDL_MOUSEBUTTONUP:
			switch (ev->button.button)
			{
				case 1: self->common->btn_state &= ~1; break;	
				case 2: self->common->btn_state &= ~4; break;	
				case 3: self->common->btn_state &= ~2; break;	
			}
			if (self->common->butvec)
			{
				(*self->common->butvec)(self->common->btn_state);
			}
			return 1;
		case SDL_MOUSEMOTION:
			self->common->mousex = ev->motion.x - self->common->window.x;
			self->common->mousey = ev->motion.y - self->common->window.y;
			if (self->common->motvec)
			{
				(*self->common->motvec)(self->common->mousex,
							self->common->mousey);
			}
			if (self->common->curvec)
			{
				(*self->common->curvec)(self->common->mousex,
							self->common->mousey);
			}
			return 1;	

	}
	return 0;
}



void sd_qmouse(unsigned handle, unsigned *buttons, signed *x, signed *y)
{
	DRIVERDATA *self = lookup_handle(handle);
	Uint8 b = SDL_GetMouseState(x, y);

	if (self)
	{
		*x -= self->common->window.x;
		*y -= self->common->window.y;
	}
	*buttons = 0;
	if (b & SDL_BUTTON(1)) *buttons |= 1;
	if (b & SDL_BUTTON(2)) *buttons |= 4;
	if (b & SDL_BUTTON(3)) *buttons |= 2;
}


void sd_exbutv(unsigned handle, BUTVEC vec, BUTVEC *old)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (self)
	{
		if (old) *old = self->common->butvec;
		self->common->butvec = vec;
	}
}

void sd_exmotv(unsigned handle, MOTVEC vec, MOTVEC *old)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (self)
	{
		if (old) *old = self->common->motvec;
		self->common->motvec = vec;
	}
}


void sd_excurv(unsigned handle, CURVEC vec, CURVEC *old)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (self)
	{
		if (old) *old = self->common->curvec;
		self->common->curvec = vec;
	}
}


unsigned sdrq_locator(unsigned handle, unsigned loc_number, 
				signed initx, signed inity,
				signed *xres, signed *yres,
				unsigned *term, unsigned *status)
{
	DRIVERDATA *self = lookup_handle(handle);
	*status = 0;
	*xres = initx;
	*yres = inity;
	*term = 0;

	if (!self) return 0;

	if (!self->loc_mode)	/* Request mode: wait for something  */
	{			/* to happen */
		SDL_Event ev;

		while (self->common->btn_state0 == self->common->btn_state &&
		       self->common->mousex0    == self->common->mousex    &&
		       self->common->mousey0    == self->common->mousey)
		{
                        SDL_WaitEvent(&ev);
                       
			if (ev.type == SDL_QUIT) return *status;

                        sd_handle_event(handle, &ev);
                }
	}

	if (self->common->mousex != self->common->mousex0 ||
	    self->common->mousey != self->common->mousey0)
	{
		*xres = self->common->mousex0 = self->common->mousex;
		*yres = self->common->mousey0 = self->common->mousey;

		*status |= 1;
	}
	if (self->common->btn_state0 != self->common->btn_state)
	{
		self->common->btn_state0 = self->common->btn_state;
		*term = self->common->btn_state0;
		*status |= 2;
	}
	return *status;
}

/* We have no valuator devices */
unsigned sdrq_valuator(unsigned handle, unsigned val_number, unsigned value,
				unsigned *val_out, unsigned *term,
				unsigned *status)
{
	*val_out = value;
	*term = 0;
	*status = 0;
	return 0;
}




