/*************************************************************************
**       Copyright 1999, Caldera Thin Clients, Inc.                     ** 
**       This software is licenced under the GNU Public License.        **
**       Please see LICENSE.TXT for further information.                ** 
**                                                                      ** 
**                  Historical Copyright                                ** 
**									**
**									**
**									**
**  Copyright (c) 1987, Digital Research, Inc. All Rights Reserved.	**
**  The Software Code contained in this listing is proprietary to	**
**  Digital Research, Inc., Monterey, California and is covered by U.S.	**
**  and other copyright protection.  Unauthorized copying, adaptation,	**
**  distribution, use or display is prohibited and may be subject to 	**
**  civil and criminal penalties.  Disclosure to others is prohibited.	**
**  For the terms and conditions of software code use refer to the 	**
**  appropriate Digital Research License Agreement.			**
**									**
*************************************************************************/

/*History
Fix #	Name	Date	Fix description
1	DH	5/29/85	Polyline had edge shorten flag inverted (LSTLIN)
*/
#include "sdsdl_i.h"

static void quad_xform(int quad, int x, int y, int *tx, int *ty);
static void gdp_rbox(DRIVERDATA *self, int filled, signed xy[]);
static void gdp_ell(DRIVERDATA *self, signed xc, signed yc, signed xrad, 
		signed yrad, signed sang, signed eang, unsigned fill,
		unsigned pie);
static void gdp_arc(DRIVERDATA *self, signed xc, signed yc, signed xrad, 
		signed beg_ang, signed end_ang, unsigned fill, unsigned pie);
static void clc_arc(DRIVERDATA *self, signed xc, signed yc, signed xrad, 
		signed yrad, signed beg_ang, signed end_ang, 
		signed del_ang, unsigned n_steps, unsigned fill, unsigned pie);
static void calc_pts(DRIVERDATA *self, signed j, signed *ptsin, signed angle,
			signed xc, signed yc, signed xrad, signed yrad);
static unsigned clc_nsteps(DRIVERDATA *self, signed xrad, signed yrad);

#if 0
/* OPEN_WORKSTATION: */
	VOID
v_opnwk()
{
	extern	WORD	dseg_seg,end_dseg;  /*Data seg and size returned at OW */
	text_init();
	init_wk();
	INIT_G();			/* go into graphics mode */

	CONTRL[7] = dseg_seg;
	CONTRL[8] = end_dseg;
}

d_opnvwk() 
{
	text_init();
	init_wk();
}


d_clsvwk()
{
} 

#endif
/* EXTENDED INQUIRE */
void sd_qextnd(unsigned handle, unsigned owflag, unsigned work_out[57])
{
	unsigned i, bufsize;
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;

	self->FLIP_Y = 1;

	switch (owflag)
	{
		case 0:	
			for (i=0;i<45;i++) work_out[i     ] = self->dev_tab[i];
			for (i=0;i<12;i++) work_out[i + 45] = self->siz_tab[i];
			work_out[0] = self->common->window.w - 1;
			work_out[1] = self->common->window.h - 1;
			break;
		default:
			for (i=0;i<45;i++) work_out[i     ] = self->inq_tab[i];
			for (i=0;i<12;i++) work_out[i + 45] = 0;
			work_out[19] = self->CLIP;
			work_out[20] = work_out[45] = self->rectClip.x;
			work_out[21] = work_out[46] = self->rectClip.y;
			work_out[22] = work_out[47] = self->rectClip.x +
						      self->rectClip.w;
			work_out[23] = work_out[48] = self->rectClip.y +
						      self->rectClip.h;
			if (self->common->backbuf)
			{
				bufsize = self->common->backbuf->w *
					  self->common->backbuf->pitch;
				work_out[26] = bufsize;
				work_out[27] = bufsize >> 16;
			}
			break;	
	}
}

#if 0
/* CLOSE_WORKSTATION: */
v_clswk()
{
	DINIT_G();
}

/* ESCAPE: */
v_escape()
{
	CHK_ESC();
}
#endif

void sd_assertvalid(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;

}

/* POLYLINE: */
void sd_pline(unsigned handle, unsigned count, signed xy[] )
{
/* SDL and the window manager should take care of the mouse pointer for us;
 * no need to hide/show it when drawing */
/*	unsigned pln_sts = 0; */
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;

/*
	if ( self->IDE_CNT == 0 )
	{
	    pln_sts = 1;
	    HIDE_CUR();
	} */
	self->LN_MASK = self->line_styl[self->line_index];
	self->FG_BP_1 = self->line_colour;

	if (self->line_width == 1)
	{
	  pline(self, count, xy);
          if ( (self->line_beg | self->line_end ) & ARROWED )
		do_arrow(self, count, xy);
	}  /* End if:  normal polyline. */
	else wline(self, count, xy);
/*	if ( pln_sts == 1 )
	    DIS_CUR(); */
}


extern const signed m_dot[], m_plus[], m_star[], m_square[], m_cross[], m_dmnd[];
/* POLYMARKER: */
void sd_pmarker(unsigned handle, unsigned markcount, signed xy[])
{
#define MARKSEGMAX 5
	DRIVERDATA *self = lookup_handle(handle);
	static const signed *markhead[] =
	{
	  m_dot, m_plus, m_star, m_square, m_cross, m_dmnd
	};

	unsigned i, j, k, num_lines, x_center, y_center;
	unsigned sav_index, sav_width, sav_beg, sav_end, sav_clip;
	Uint32 sav_colour;
	const signed *mark_ptr;
	signed points[2 * MARKSEGMAX];

	if (!self) return;


	/* Save the current polyline attributes which will be used. */
	sav_index = self->line_index;
	sav_colour= self->line_colour;
	sav_width = self->line_width;
	sav_beg = self->line_beg;
	sav_end = self->line_end;
	sav_clip = self->CLIP;

	/* Set the appropriate polyline attributes. */
	self->line_index = 0;
	self->line_colour = self->mark_colour;
	self->line_width = 1;
	self->line_beg = 0;
	self->line_end = 0;
	self->CLIP = 1;

	/* Loop over the number of points. */
	for (i = 0; i < markcount; i++)
	{
	  /* Get the (x, y) position for the marker. */
	  x_center = xy[i*2];
	  y_center = xy[i*2+1];

	  /* Get the pointer to the appropriate marker type definition. */
	  mark_ptr = markhead[self->mark_index];
	  num_lines = *mark_ptr++;

	  /* Loop over the number of polylines which define the marker. */
	  for (j = 0; j < num_lines; j++)
	  {
		unsigned count = *mark_ptr++;

	    /* How many points?  Get them. */
		for (k = 0; k < 2 * count;)
		{
			points[k++] = x_center + self->mark_scale * (*mark_ptr++);
			points[k++] = y_center + self->mark_scale * (*mark_ptr++);
		}  /* End for:  extract points. */
	    /* Output the polyline. */
	    sd_pline(handle, count, points);
	  }  /* End for:  over the number of polylines defining the marker. */
	}  /* End for:  over marker points. */

	/* Restore the current polyline attributes. */
	self->line_index = sav_index;
	self->line_colour = sav_colour;
	self->line_width = sav_width;
	self->line_beg = sav_beg;
	self->line_end = sav_end;
	self->CLIP = sav_clip;
}  /* End "v_pmarker". */


/* FILLED_AREA: */
void sd_fillarea(unsigned handle, unsigned count, signed xy[])	
{
	DRIVERDATA *self = lookup_handle(handle);

	if (self) plygn(self, count, xy);
}

void sd_bar(unsigned handle, signed *xy)
{
	DRIVERDATA *self = lookup_handle(handle);
	signed pts[10];

	if (!self) return;
	sd_recfl(handle, xy);

	if (self->fill_per)
	{
		self->LN_MASK = (Uint16)-1;
		pts[1] = pts[3] = pts[9] = xy[1];
		pts[0] = pts[6] = pts[8] = xy[0];
		pts[2] = pts[4]          = xy[2];
		pts[5] = pts[7]          = xy[3];
		pline(self, 5, pts);
	} 
}

void sd_arc(unsigned handle, signed xc, signed yc, signed xrad,
		unsigned sang, unsigned eang)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;

	gdp_arc(self, xc, yc, xrad, sang, eang, 0, 0);
}

void sd_pieslice(unsigned handle, signed xc, signed yc, signed xrad,
		unsigned sang, unsigned eang)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;

	gdp_arc(self, xc, yc, xrad, sang, eang, 1, 1);
}

void sd_circle(unsigned handle, signed xc, signed yc, signed xrad)
{
	DRIVERDATA *self = lookup_handle(handle);
	signed yrad;
	unsigned n_steps;

	if (!self) return;

	yrad = SMUL_DIV (xrad, XSIZE, YSIZE);
	n_steps = clc_nsteps(self, xrad, yrad);

	clc_arc(self, xc, yc, xrad, yrad, 0, 3600, 3600, n_steps, 1, 0);
}

void sd_ellipse(unsigned handle, signed xc, signed yc, signed xrad, signed yrad)
{
	DRIVERDATA *self = lookup_handle(handle);
	unsigned n_steps;

	if (!self) return;

	if ( self->xfm_mode < 2) /* if xform != raster then flip */
	{
	  yrad = self->common->window.h - yrad;	
	}
	n_steps = clc_nsteps(self, xrad, yrad);
	clc_arc(self, xc, yc, xrad, yrad, 0, 3600, 3600, n_steps, 1, 0);
}



void sd_ellarc(unsigned handle, signed xc, signed yc, signed xrad, 
		signed yrad, unsigned sang, unsigned eang)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return;
	gdp_ell(self, xc, yc, xrad, yrad, sang, eang, 0, 0);
}

void sd_ellpie(unsigned handle, signed xc, signed yc, signed xrad, 
		signed yrad, unsigned sang, unsigned eang)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return;
	gdp_ell(self, xc, yc, xrad, yrad, sang, eang, 1, 1);
}


/* GDP Rounded Box */
void sd_rbox(unsigned handle, signed xy[])
{
	unsigned ltmp_end, rtmp_end;	

	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return;

	ltmp_end = self->line_beg;
	rtmp_end = self->line_end;

	self->line_beg = SQUARED;
	self->line_end = SQUARED;

	gdp_rbox(self, 0, xy);
	
	self->line_beg = ltmp_end;
	self->line_end = rtmp_end;
}

void sd_rfbox(unsigned handle, signed xy[])
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return;

	gdp_rbox(self, 1, xy);
}

/* INQUIRE CURRENT POLYLINE ATTRIBUTES */
void sd_qlattributes(unsigned handle, unsigned *attr, signed *lwidth)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return;

	attr[0] = self->line_qi;
	attr[1] = self->line_qc;
	attr[2] = self->write_qm;
	attr[3] = self->line_beg;
	attr[4] = self->line_end;
	*lwidth = self->line_qw;
}

/* INQUIRE CURRENT Polymarker ATTRIBUTES */
void sd_qmattributes(unsigned handle, unsigned *attr, signed *pts)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return;

	attr[0] = self->mark_qi;
	attr[1] = self->mark_qc;
	attr[2] = self->write_qm;
	pts[0]  = self->mark_scale * DEF_MKWD;
	pts[1]  = self->mark_scale * DEF_MKHT;
	self->FLIP_Y = 1;
}

/* INQUIRE CURRENT Fill Area ATTRIBUTES */
void sd_qfattributes(unsigned handle, unsigned *attr)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return;

	attr[0] = self->fill_style;
	attr[1] = self->fill_qc;
	attr[2] = self->fill_qi;
	attr[3] = self->write_qm;
	attr[4] = self->fill_per;
}	


void pline(DRIVERDATA *self, unsigned count, signed xy[])
{
	unsigned i, j;
	signed x1, y1, x2, y2;
	signed xmin, xmax, ymin, ymax;

	xmin = xmax = xy[0];
	ymin = ymax = xy[1];

	j = 0;
	self->LSTLIN = 0;
	for (i = (count - 1); i > 0; i--)
	{
	    if (i == 1)	      
	        self->LSTLIN = 1;
	    x1 = xy[j++];
	    y1 = xy[j++];	
            x2 = xy[j];
	    y2 = xy[j+1];

	    if (x2 < xmin) xmin = x2;
	    if (x2 > xmax) xmax = x2;
	    if (y2 < ymin) ymin = y2;
	    if (y2 > ymax) ymax = y2;

/* [1.0.1] Always call clip_line(); even if we aren't clipping to a rectangle, 
 * there's still the edge of the screen. */
	    if ( clip_line(self, &x1, &y1, &x2, &y2) )
            {	
		    ABLINE(self, x1, y1, x2, y2);
	    }
	}	
	xmin -= MAX_L_WIDTH; if (xmin < 0) xmin = 0;			
	ymin -= MAX_L_WIDTH; if (ymin < 0) ymin = 0;			
	xmax += MAX_L_WIDTH; if (xmax >= self->common->window.w) 
				xmax = self->common->window.w - 1;
	ymax += MAX_L_WIDTH; if (ymax >= self->common->window.h) 
				ymax = self->common->window.h - 1;
	update_rect(self, xmin, xmax, ymin, ymax);
}



int clip_line(DRIVERDATA *self, signed *x1, signed *y1, 
				signed *x2, signed *y2)
{
	signed	deltax, deltay;
	unsigned x1y1_clip_flag, x2y2_clip_flag, line_clip_flag;
	signed *x,*y;

	while (( x1y1_clip_flag = code( self, x1, y1 )) | 
	       ( x2y2_clip_flag = code( self, x2, y2)))
	{
	    if ( ( x1y1_clip_flag & x2y2_clip_flag )) 
 	    {
		/* Both points are outside the clip area */
		return 0;
	    }
	    if ( x1y1_clip_flag )
	    {
		line_clip_flag = x1y1_clip_flag;
		x = x1; y = y1;
	    }
  	    else
	    {
		line_clip_flag = x2y2_clip_flag;
		x = x2; y = y2;
	    }
	    deltax = (*x2) - (*x1);
	    deltay = (*y2) - (*y1);
	    if ( line_clip_flag & 1 )	/* left ? */
	    {
		*y = (*y1) + SMUL_DIV(deltay, (self->rectClip.x - (*x1)), 
			deltax );
		*x = self->rectClip.x;
	    }
	    else if ( line_clip_flag & 2 )	/* right ? */
	    {
		*y = (*y1) + SMUL_DIV( deltay, (self->rectClip.x + self->rectClip.w - 1 - (*x1)), 
			deltax );
		*x = self->rectClip.x + self->rectClip.w - 1;
	    }
	    else if ( line_clip_flag & 4 )	/* top ? */
	    {
		*x = (*x1) + SMUL_DIV( deltax, (self->rectClip.y - (*y1)), deltay);
		*y = self->rectClip.y;
	    }
	    else if ( line_clip_flag & 8 )	/* bottom ? */
	    {
		*x = (*x1) + SMUL_DIV( deltax, (self->rectClip.y + self->rectClip.h - 1 - (*y1)), deltay );
		*y = self->rectClip.y + self->rectClip.h - 1;
	    }
	}
	return 1;		/* segment now cliped  */
}

unsigned code( DRIVERDATA *self, signed *x, signed *y )
{
	unsigned clip_flag = 0;
	
	if ( *x < self->rectClip.x)
	{
	    clip_flag = 1;
	}
	else if ( *x >= self->rectClip.x + self->rectClip.w)
	{
	    clip_flag = 2;
	}
	if ( *y < self->rectClip.y )
	{
	    clip_flag |= 4;
	}
	else if ( *y >= self->rectClip.y + self->rectClip.h )
	{
	    clip_flag |= 8;
	}
	return clip_flag;
}


void plygn(DRIVERDATA *self, unsigned count, signed xy[])	
{
	unsigned i, j, k, ymx_clip, y1;
	signed *ptsin;

	self->FG_BP_1 = self->fill_colour;
	self->LSTLIN  = 0;
	self->fill_miny = self->fill_maxy = xy[1];
	j = 3;
	/* [JCE] We need to check (count - 1) points, otherwise we read one 
 	 * off the end of the array */
	for (i = (count - 1); i > 0; i--)
	{
	  k = xy[j++];
	  j++;
	  if ( k < self->fill_miny )
	    self->fill_miny = k;
	  else if ( k > self->fill_maxy )
	    self->fill_maxy = k;
	}
	k = self->fill_miny; 
	if ( self->CLIP )
	{
	    if ( self->fill_miny < self->rectClip.y )
	    {
		/* plygon starts before clip */
	  	if ( self->fill_maxy >= self->rectClip.y )
		{		    	
      			/* plygon partial overlap */
			self->fill_miny = self->rectClip.y;
		}
		else return;   	/* plygon entirely before clip */
	    }
	    ymx_clip = self->rectClip.y + self->rectClip.h - 1;
	    if ( self->fill_maxy > ymx_clip )
	    {
		/* plygon ends after clip */
		if ( self->fill_miny <= ymx_clip )
		{
			/* plygon partial overlap */
			self->fill_maxy = ymx_clip;	
		}
		else return;	/* plygon entirely after clip */ 
	    }
	    if ( self->fill_miny != k )		/* plygon fills n -1 scans */
		--self->fill_miny;
        }
	ptsin = malloc(2 * (count + 1) * sizeof(unsigned));
	if (!ptsin) return;

	memcpy(ptsin, xy, 2 * count * sizeof(unsigned));	
	j = 2 * count;
/* Close the polygon */
	ptsin[j] = ptsin[0];
	ptsin[j+1] = ptsin[1];
	for (y1 = self->fill_maxy; y1 > self->fill_miny; y1--)
	{
	    self->fill_intersect = 0;
	    CLC_FLIT(self, y1, count + 1, ptsin);
	}
	if ( self->fill_per )
	{
	    self->LN_MASK = 0xffff;
	    pline(self, count + 1, ptsin);
	}
	free(ptsin);
}

static void gdp_rbox(DRIVERDATA *self, int filled, signed xy[])
{
	signed	i,j, rdeltax, rdeltay;
	signed  shape[42];	/* 21 points define the rectangle */
	signed xrad, yrad, xc, yc;

	arb_corner(xy, LLUR);

	self->X1 = xy[0]; self->Y1 = xy[1];
	self->X2 = xy[2]; self->Y2 = xy[3];
	rdeltax = (self->X2 - self->X1)/2; 
	rdeltay = (self->Y1 - self->Y2)/2;
	xrad = self->common->window.w >> 6;
	if ( xrad > rdeltax )
	    xrad = rdeltax;
	yrad = SMUL_DIV( xrad, XSIZE, YSIZE );
	if ( yrad > rdeltay )
	    yrad = rdeltay;
	shape[0] = 0; shape[1] = yrad;
	shape[2] = SMUL_DIV ( Icos(675), xrad, 32767 ) ;
	shape[3] = SMUL_DIV ( Isin(675), yrad, 32767 ) ;
	shape[4] = SMUL_DIV ( Icos(450), xrad, 32767 ) ;
	shape[5] = SMUL_DIV ( Isin(450), yrad, 32767 ) ;
	shape[6] = SMUL_DIV ( Icos(225), xrad, 32767 ) ;
	shape[7] = SMUL_DIV ( Isin(225), yrad, 32767 ) ;
	shape[8] = xrad; shape[9] = 0;
	xc = self->X2 - xrad; yc = self->Y1 - yrad;
	j = 10;
	for ( i = 9; i >= 0 ; i-- )
	{ 
	    shape[j+1] = yc + shape[i--];
	    shape[j] = xc + shape[i];
	    j += 2;
	}
	xc = self->X1 + xrad; 
	j = 20;
	for ( i = 0; i < 10; i++ )
	{ 
	    shape[j++] = xc - shape[i++];
	    shape[j++] = yc + shape[i];
	}
	yc = self->Y2 + yrad;
	j = 30;
	for ( i = 9; i >= 0; i-- )
	{ 
	    shape[j+1] = yc - shape[i--];
	    shape[j] = xc - shape[i];
	    j += 2;
	}
	xc = self->X2 - xrad;
	j = 0;
	for ( i = 0; i < 10; i++ )
	{ 
	    shape[j++] = xc + shape[i++];
	    shape[j++] = yc - shape[i];
	}
	shape[40] = shape[0];
	shape[41] = shape[1]; 
    	if (!filled)
	{
		self->LN_MASK = self->line_styl[self->line_index];
		self->FG_BP_1 = self->line_colour;

		if (self->line_width == 1)
		{
			pline(self, 21, shape);
		}
		else
		{
			wline(self, 21, shape);
		}
	}
    	else
	{
		plygn(self, 21, shape);
	}
	return;
}

static void gdp_arc(DRIVERDATA *self, signed xc, signed yc, signed xrad, 
		signed beg_ang, signed end_ang, unsigned fill, unsigned pie)
{
	signed del_ang = end_ang - beg_ang;
	signed yrad;
	unsigned n_steps;

	while ( del_ang < 0 ) del_ang += 3600; 
	del_ang %= 3600;

	yrad = SMUL_DIV ( xrad, XSIZE, YSIZE );
	n_steps = clc_nsteps(self, xrad, yrad);
	n_steps = SMUL_DIV ( del_ang, n_steps, 3600 );
	if ( n_steps == 0 )
	  return;
	clc_arc(self, xc, yc, xrad, yrad, beg_ang, end_ang, del_ang, n_steps,
		fill, pie);
}

static unsigned clc_nsteps(DRIVERDATA *self, signed xrad, signed yrad)
{
	unsigned n_steps;

	if ( xrad > yrad )
	    n_steps = xrad;
	else
	    n_steps = yrad;
	n_steps = n_steps >> 2;
	if ( n_steps < 16 )
	    n_steps = 16;
	else
	{
	    if ( n_steps > MAX_ARC_CT )
	        n_steps = MAX_ARC_CT;
	}
	return n_steps;
}

static void gdp_ell(DRIVERDATA *self, signed xc, signed yc, signed xrad, 
		signed yrad, signed beg_ang, signed end_ang, unsigned fill,
		unsigned pie)
{
	signed del_ang = end_ang - beg_ang;
	unsigned n_steps = 0;

	while (del_ang < 0) del_ang += 3600;
	del_ang %= 3600;

	if ( self->xfm_mode < 2) /* if xform != raster then flip */
	{
	  yrad = self->common->window.h - yrad;	
	}
	n_steps = clc_nsteps(self, xrad, yrad);	
	n_steps = SMUL_DIV ( del_ang, n_steps, 3600 );
	if ( n_steps == 0 )
	  return;
	clc_arc(self, xc, yc, xrad, yrad, beg_ang, end_ang, del_ang, n_steps,
		fill, pie);
	return;
}


static void clc_arc(DRIVERDATA *self, signed xc, signed yc, signed xrad, 
		signed yrad, signed beg_ang, signed end_ang, signed del_ang,
		unsigned n_steps, unsigned fill, unsigned pie)
{
	signed i, j;
	signed *ptsin;
	signed start, angle;
	int iptscnt = 0;

	if ( self->CLIP )
	{
		if ((xc + xrad) <   self->rectClip.x                     ||
	 	    (xc - xrad) >= (self->rectClip.x + self->rectClip.w) ||
		    (yc + yrad) <   self->rectClip.y                     ||
		    (yc - yrad) >= (self->rectClip.y + self->rectClip.h))
		{
			return;
		}
	}
	ptsin = malloc((4 * n_steps + 4) * sizeof(signed));
	if (!ptsin) return;
	memset(ptsin, 0, (4 * n_steps + 4) * sizeof(signed));

	start = angle = beg_ang ;	
    	i = j = 0 ;
	calc_pts(self, j, ptsin, angle, xc, yc, xrad, yrad);
	for ( i = 1; i < n_steps; i++ )
    	{
		j += 2;
		angle = SMUL_DIV( del_ang, i , n_steps ) + start;
        	calc_pts(self, j, ptsin, angle, xc, yc, xrad, yrad);
        }
	j += 2;
    	i = n_steps ;
    	angle = end_ang ;
    	calc_pts(self, j, ptsin, angle, xc, yc, xrad, yrad);

/*----------------------------------------------------------------------*/
/* If pie wedge	draw to center and then close. If arc or circle, do 	*/
/* nothing because loop should close circle.				*/

        iptscnt = n_steps + 1 ;	/* since loop in Clc_arc starts at 0 */
	if (pie) /* pie wedge */
	{
		n_steps++;
		j += 2;
		ptsin[ j ] = xc; ptsin[ j + 1 ] = yc;
		iptscnt = n_steps + 1;
	}
	if (fill) 
	{
		plygn(self, iptscnt, ptsin);
	}
	else
	{
		self->LN_MASK = self->line_styl[self->line_index];
		self->FG_BP_1 = self->line_colour;

		if (self->line_width == 1)
		{
		  pline(self, iptscnt, ptsin);
       		  if ( (self->line_beg | self->line_end ) & ARROWED )
			do_arrow(self, iptscnt, ptsin);
		}  /* End if:  normal polyline. */
		else wline(self, iptscnt, ptsin);
	}
	free(ptsin);
}

static void calc_pts(DRIVERDATA *self, signed j, signed *ptsin, signed angle,
			signed xc, signed yc, signed xrad, signed yrad)
{
	signed k;

	k = SMUL_DIV ( Icos(angle), xrad, 32767 ) + xc ;
	ptsin[j  ] = k;
	ptsin[j+1] = yc - SMUL_DIV (Isin(angle), yrad, 32767); 
}

void st_fl_ptr(DRIVERDATA *self)
{
	self->patmsk = 0;
	switch ( self->fill_style )
	{
		case 0:
			self->patptr = &hollow;
			break;

		case 1:
			self->patptr = &solid;
			break;

		case 2:
			if ( self->fill_index < 8 )
			{
			    self->patmsk = dithrmsk;
			    self->patptr = &dither[ self->fill_index * (self->patmsk+1) ];
			}
			else
			{
			    self->patmsk = oemmskpat;
			    self->patptr = &oempat[ (self->fill_index - 8) * (self->patmsk+1) ]; 
			}
			break;
		case 3:
			if ( self->fill_index < 6 )
			{
			    self->patmsk = hat_0_msk;
			    self->patptr = &hatch0[ self->fill_index * (self->patmsk+1) ];
			}
			else
			{
			    self->patmsk = hat_1_msk;
			    self->patptr = &hatch1[ (self->fill_index - 6) * (self->patmsk+1) ];
			}
			break;
		case 4:
			self->patmsk = 0x000f;
			self->patptr = self->ud_patrn;
			break;
	}
}

#define ABS(x) ((x) >= 0 ? (x) : -(x))

void wline(DRIVERDATA *self, unsigned numpts, signed xy[])
{
	unsigned i, j, k;
	unsigned wx1, wy1, wx2, wy2;
	signed vx, vy;
	signed poly[10];

  /* Don't attempt wide lining on a degenerate polyline. */
  if ( numpts < 2)
    return;

  /* If the ends are arrowed, output them. */
  if ( (self->line_beg | self->line_end) & ARROWED)
    do_arrow(self, numpts, xy);

  /* Set up the attribute environment.  Save attribute globals which need */
  /* to be saved.                                                         */
  s_fa_attr(self);

  /* Use a local array (poly) rather than ptsin */
#if 0
  /* Since the PTSIN array has to be overwritten for the call to plygn, */
  /* save the values stored in the elements which will be overwritten.  */
  for (i = 2; i < 10; i++)
    PTSOUT[i] = PTSIN[i];
#endif
  /* Initialize the starting point for the loop. */
  j = 0;
  wx1 = xy[j++];
  wy1 = xy[j++];

  /* If the end style for the first point is not squared, output a circle. */
  if (self->s_begsty != SQUARED)
    do_circ(self, wx1, wy1);

  /* Loop over the number of points passed in. */
  for (i = 1; i < numpts; i++)
  {
    /* Get the ending point for the line segment and the vector from the */
    /* start to the end of the segment.                                  */
    wx2 = xy[j++];
    wy2 = xy[j++];

    vx = wx2 - wx1;
    vy = wy2 - wy1;

    /* Ignore lines of zero length. */
    if ( (vx == 0) && (vy == 0) )
      continue;

    /* Calculate offsets to fatten the line.  If the line segment is */
    /* horizontal or vertical, do it the simple way.                 */
    if (vx == 0)
    {
      vx = self->q_circle[0];
      vy = 0;
    }  /* End if:  vertical. */

    else if (vy == 0)
    {
      vx = 0;
      vy = self->num_qc_lines - 1;
    }  /* End else if:  horizontal. */

    else
    {
      /* Find the offsets in x and y for a point perpendicular to the line */
      /* segment at the appropriate distance.                              */
      k = SMUL_DIV(-vy, YSIZE, XSIZE);
      vy = SMUL_DIV(vx, XSIZE, YSIZE);
      vx = k;
      perp_off(self, &vx, &vy);
    }  /* End else:  neither horizontal nor vertical. */

    /* Prepare the control and points parameters for the polygon call. */
    poly[0] = wx1 + vx;
    poly[1] = wy1 + vy;
    poly[2] = wx1 - vx;
    poly[3] = wy1 - vy;
    poly[4] = wx2 - vx;
    poly[5] = wy2 - vy;
    poly[6] = wx2 + vx;
    poly[7] = wy2 + vy;
    plygn(self, 4, poly);

    /* If the terminal point of the line segment is an internal joint, */
    /* or the end style is not squared, output a filled circle.        */
    if ( (self->s_endsty != SQUARED) || (i < numpts - 1) )
      do_circ(self, wx2, wy2);

    /* The line segment end point becomes the starting point for the next */
    /* line segment.                                                      */
    wx1 = wx2;
    wy1 = wy2;
  }  /* End for:  over number of points. */

  /* Restore the attribute environment. */
  r_fa_attr(self);
}  /* End "wline". */



void perp_off(DRIVERDATA *self, signed *vx, signed *vy)
{
  int  x, y, u, v, quad, magnitude, min_val, x_val, y_val;

  /* Mirror transform the vector so that it is in the first quadrant. */
  if (*vx >= 0)
    quad = (*vy >= 0) ? 1 : 4;
  else
    quad = (*vy >= 0) ? 2 : 3;

  quad_xform(quad, *vx, *vy, &x, &y);

  /* Traverse the circle in a dda-like manner and find the coordinate pair   */
  /* (u, v) such that the magnitude of (u*y - v*x) is minimized.  In case of */
  /* a tie, choose the value which causes (u - v) to be minimized.  If not   */
  /* possible, do something.                                                 */
  min_val = 32767;
  u = self->q_circle[0];
  v = 0;
  x_val = u;
  y_val = v;
  while (1)
  {
    /* Check for new minimum, same minimum, or finished. */
    if ( ( (magnitude = ABS(u*y - v*x)) < min_val ) ||
         ( (magnitude == min_val) && (ABS(x_val - y_val) > ABS(u - v) ) ) )
    {
      min_val = magnitude;
      x_val = u;
      y_val = v;
    }  /* End if:  new minimum. */

    else
      break;

    /* Step to the next pixel. */
    if (v == self->num_qc_lines - 1)
    {
      if (u == 1)
        break;
      else
        u--;
    }  /* End if:  doing top row. */

    else
    {
      if (self->q_circle[v + 1] >= u - 1)
      {
        v++;
        u = self->q_circle[v];
      }  /* End if:  do next row up. */
      else
      {
        u--;
      }  /* End else:  continue on row. */
    }  /* End else:  other than top row. */
  }  /* End FOREVER loop. */

  /* Transform the solution according to the quadrant. */
  quad_xform(quad, x_val, y_val, vx, vy);
}  /* End "perp_off". */


void quad_xform(int quad, int x, int y, int *tx, int *ty)
{
  switch (quad)
  {
    case 1:
    case 4:
      *tx = x;
      break;

    case 2:
    case 3:
      *tx = -x;
      break;
  }  /* End switch. */

  switch (quad)
  {
    case 1:
    case 2:
      *ty = y;
      break;

    case 3:
    case 4:
      *ty = -y;
      *ty = -y;
      break;
  }  /* End switch. */
}  /* End "quad_xform". */



void do_circ(DRIVERDATA *self, signed cx, signed cy)
{
  signed k, x1, y1, x2, y2;

  /* Only perform the act if the circle has radius. */
  if (self->num_qc_lines > 0)
  {
    /* Do the horizontal line through the center of the circle. */
    x1 = cx - self->q_circle[0];
    x2 = cx + self->q_circle[0];
    y1 = y2 = cy;
    if (clip_line(self, &x1, &y1, &x2, &y2) )
      ABLINE(self, x1, y1, x2, y2);

    /* Do the upper and lower semi-circles. */
    for (k = 1; k < self->num_qc_lines; k++)
    {
      /* Upper semi-circle. */
      x1 = cx - self->q_circle[k];
      x2 = cx + self->q_circle[k];
      y1 = y2 = cy - k;
      if (clip_line(self, &x1, &y1, &x2, &y2) )
        ABLINE(self, x1, y1, x2, y2);

      /* Lower semi-circle. */
      x1 = cx - self->q_circle[k];
      x2 = cx + self->q_circle[k];
      y1 = y2 = cy + k;
      if (clip_line(self, &x1, &y1, &x2, &y2) )
        ABLINE(self, x1, y1, x2, y2);
    }  /* End for. */
  }  /* End if:  circle has positive radius. */
}  /* End "do_circ". */

extern const Uint16 solid;

void s_fa_attr(DRIVERDATA *self)
{
  /* Set up the fill area attribute environment. */
  self->LN_MASK = self->line_styl[0];
  self->s_fill_colour = self->fill_colour;
  self->fill_colour = self->line_colour;
  self->s_fill_per = self->fill_per;
  self->fill_per = 1;
  self->s_patptr = self->patptr;
  self->s_nxtpat = self->NEXT_PAT;
  self->NEXT_PAT = 0;	
  self->patptr = &solid;
  self->s_patmsk = self->patmsk;
  self->patmsk = 0;
  self->s_begsty = self->line_beg;
  self->s_endsty = self->line_end;
  self->line_beg = self->line_end = SQUARED;
}  /* End "s_fa_attr". */


void r_fa_attr(DRIVERDATA *self)
{
  /* Restore the fill area attribute environment. */
  self->NEXT_PAT = self->s_nxtpat;
  self->fill_colour = self->s_fill_colour;
  self->fill_per = self->s_fill_per;
  self->patptr = self->s_patptr;
  self->patmsk = self->s_patmsk;
  self->line_beg = self->s_begsty;
  self->line_end = self->s_endsty;
}  /* End "r_fa_attr". */


void do_arrow(DRIVERDATA *self, unsigned count, signed xy[])
{
  unsigned new_x_start, new_y_start, x_start, y_start;

  /* Set up the attribute environment. */
  s_fa_attr(self);

  /* Function "arrow" will alter the end of the line segment.  Save the */
  /* starting point of the polyline in case two calls to "arrow" are    */
  /* necessary.                                                         */
  new_x_start = x_start = xy[0];
  new_y_start = y_start = xy[1];

  if (self->s_begsty & ARROWED)
  {
    arrow(self, count, xy, 2);
    new_x_start = xy[0];
    new_y_start = xy[1];
  }  /* End if:  beginning point is arrowed. */

  if (self->s_endsty & ARROWED)
  {
    xy[0] = x_start;
    xy[1] = y_start;
    arrow(self, count, &xy[count-2], -2);
    xy[0] = new_x_start;
    xy[1] = new_y_start;
  }  /* End if:  ending point is arrowed. */

  /* Restore the attribute environment. */
  r_fa_attr(self);
}  /* End "do_arrow". */


void arrow(DRIVERDATA *self, unsigned count, signed *xy, int inc)
{
  unsigned i, arrow_len, arrow_wid, line_len = 0;
  signed *xybeg, triangle[6];
  signed dx = 0, dy = 0;
  signed base_x, base_y, ht_x, ht_y;

  /* Set up the arrow-head length and width as a function of line width. */
  arrow_wid = (arrow_len = (self->line_width == 1) ? 8 : 
				3*self->line_width - 1)/2;

  /* Initialize the beginning pointer. */
  xybeg = xy;

  /* Find the first point which is not so close to the end point that it */
  /* will be obscured by the arrowhead.                                  */
  for (i = 1; i < count; i++)
  {
    /* Find the deltas between the next point and the end point.  Transform */
    /* to a space such that the aspect ratio is uniform and the x axis      */
    /* distance is preserved.                                               */
    xybeg += inc;
    dx = *xy - *xybeg;
    dy = SMUL_DIV(*(xy + 1) - *(xybeg + 1), YSIZE, XSIZE);

    /* Get the length of the vector connecting the point with the end point. */
    /* If the vector is of sufficient length, the search is over.            */
    if ( (line_len = vec_len(ABS(dx), ABS(dy))) >= arrow_len)
      break;
  }  /* End for:  over i. */

  /* If the longest vector is insufficiently long, don't draw an arrow. */
  if (line_len < arrow_len)
    return;

  /* Rotate the arrow-head height and base vectors.  Perform calculations */
  /* in 1000x space.                                                      */
  ht_x = SMUL_DIV(arrow_len, SMUL_DIV(dx, 1000, line_len), 1000);
  ht_y = SMUL_DIV(arrow_len, SMUL_DIV(dy, 1000, line_len), 1000);
  base_x = SMUL_DIV(arrow_wid, SMUL_DIV(dy, -1000, line_len), 1000);
  base_y = SMUL_DIV(arrow_wid, SMUL_DIV(dx, 1000, line_len), 1000);

  /* Transform the y offsets back to the correct aspect ratio space. */
  ht_y = SMUL_DIV(ht_y, XSIZE, YSIZE);
  base_y = SMUL_DIV(base_y, XSIZE, YSIZE);

  /* Build a polygon to send to plygn.  Build into a local array first since */
  /* xy will probably be pointing to the PTSIN array.                        */
  triangle[0] = *xy + base_x - ht_x;
  triangle[1] = *(xy + 1) + base_y - ht_y;
  triangle[2] = *xy - base_x - ht_x;
  triangle[3] = *(xy + 1) - base_y - ht_y;
  triangle[4] = *xy;
  triangle[5] = *(xy + 1);
  plygn(self, 3, triangle);

  /* Adjust the end point and all points skipped. */
  *xy -= ht_x;
  *(xy + 1) -= ht_y;
  while ( (xybeg -= inc) != xy)
  {
    *xybeg = *xy;
    *(xybeg + 1) = *(xy + 1);
  }  /* End while. */
}  /* End "arrow". */



void init_wk(DRIVERDATA *self, unsigned work_in[11], unsigned work_out[57])
{
	unsigned i;

	self->line_qi = work_in[1];
	if ((self->line_qi > MAX_LINE_STYLE) || (self->line_qi < 1))
		self->line_qi = 1; 
	self->line_index = ( self->line_qi - 1);

	self->line_qc = work_in[2];
	if ((self->line_qc >= MAX_COLOUR) || (self->line_qc < 0))
		self->line_qc = 1; 
	map_colour(self, self->line_qc, NULL, &self->line_colour);

	self->mark_qi = work_in[3];
	if ((self->mark_qi > MAX_MARK_INDEX) || (self->mark_qi < 1))
		self->mark_qi = 3;
	self->mark_index = self->mark_qi - 1;

	self->mark_qc = work_in[4];
	if ((self->mark_qc >= MAX_COLOUR) || (self->mark_qc < 0))
		self->mark_qc = 1; 
	map_colour(self, self->mark_qc, NULL, &self->mark_colour);

	self->mark_height = DEF_MKHT;
	self->mark_scale = 1;

	self->fill_style = work_in[7];
	if ((self->fill_style > MX_FIL_STYLE) || (self->fill_style < 0))
		self->fill_style = 0; 

	self->NEXT_PAT = 0;
	self->fill_qi = work_in[8];
	if (self->fill_style == 2 )
	{
	    if ((self->fill_qi > MX_FIL_PAT_INDEX) || (self->fill_qi < 1))
	  	self->fill_qi = 1; 
	}
	else 
	{
	    if ((self->fill_qi > MX_FIL_HAT_INDEX) || (self->fill_qi < 1))
	  	self->fill_qi = 1; 
	}
	self->fill_index = self->fill_qi - 1;

	self->fill_qc = work_in[9];
	if ((self->fill_qc >= MAX_COLOUR) || (self->fill_qc < 0))
		self->fill_qc = 1; 
	map_colour(self, self->fill_qc, NULL, &self->fill_colour);

	self->xfm_mode = work_in[10];

        st_fl_ptr(self);
	self->WRT_MODE  = 0;	 	/* default is replace mode	*/
	self->write_qm = 1;
	self->line_qw = self->line_width = DEF_LWID;
					/* default to squared ends	*/
	self->line_beg = self->line_end = 0;	
	self->loc_mode = 0; 		/* default is request mode	*/
	self->val_mode = 0;       	/* default is request mode	*/
	self->chc_mode = 0; 		/* default is request mode	*/
	self->str_mode = 0; 		/* default is request mode	*/
	self->fill_per = 1;		/* set fill perimeter on */
	self->rectClip.x = 0;
	self->rectClip.y = 0;
	self->rectClip.w = self->common->window.w;
	self->rectClip.h = self->common->window.h;
	self->CLIP = 0;
	self->FLIP_Y = 1;

	assert(self->CLIP == 0);
	work_out[0] = self->common->window.w - 1;
	work_out[1] = self->common->window.h - 1;
	for (i=2;i<45;i++) work_out[i     ] = self->dev_tab[i];
	for (i=0;i<12;i++) work_out[i + 45] = self->siz_tab[i];
	assert(self->CLIP == 0);
	
}


void sd_cellarray(unsigned handle, signed *xy, unsigned row_len,
                unsigned el_used, unsigned num_rows, unsigned wr_mode,
                unsigned *colours)
{
/* NOTE: Length of colours array must equal num_rows * row_len */
	int r, c;
	unsigned oldmode, oldcol, oldstyle;
	signed rectxy[4];
	signed rw, rh;
	DRIVERDATA *self = lookup_handle(handle);
	if (!self || !el_used || !num_rows) return;
	
	oldmode  = self->write_qm;
	oldcol   = self->fill_qc;
	oldstyle = self->fill_style;
	sd_swrmode(handle, wr_mode);

	arb_corner(xy, ULLR);
	rw = xy[2] + 1 - xy[0];
	rh = xy[3] + 1 - xy[1];
	for (r = 0; r < num_rows; r++)
	{
		for (c = 0; c < el_used; c++)
		{
			rectxy[0] = xy[0] + (rw * c) / el_used;
			rectxy[1] = xy[1] + (rh * r) / num_rows;
			rectxy[2] = xy[0] + (rw * (c+1)) / el_used;
			rectxy[3] = xy[1] + (rh * (r+1)) / num_rows;

			sd_sfinterior(handle, 1);
			sd_sfcolor(handle, colours[r * row_len + c]);
			sd_recfl(handle, rectxy);
		}

	}	
	sd_sfinterior(handle, oldstyle);
	sd_swrmode(handle, oldmode);
	sd_sfcolor(handle, oldcol);
}



unsigned sd_qcellarray(unsigned handle, signed *xy, unsigned row_len,
                unsigned num_rows, unsigned *el_used, unsigned *rows_used,
		unsigned *stat, unsigned *colours)
{
/* NOTE: Length of colours array must equal num_rows * row_len */
	int r, c;
	signed rectxy[2];
	signed rw, rh;
	unsigned pel, ink;
	DRIVERDATA *self = lookup_handle(handle);
	if (!self || !row_len || !num_rows) 
	{
		*stat = 1;
		return 1;
	}
	
	arb_corner(xy, ULLR);
	rw = xy[2] + 1 - xy[0];
	rh = xy[3] + 1 - xy[1];
	*el_used = row_len;
	*rows_used = num_rows;
	*stat = 0;
	for (r = 0; r < num_rows; r++)
	{
		rectxy[1] = xy[1] + (rh * r) / num_rows;

/* Gone off the bottom of the screen? */
		if (rectxy[1] >= self->common->window.h)
		{
			*rows_used = num_rows = r;
			*stat = 1;
			break;
		}
		for (c = 0; c < row_len; c++)
		{
			rectxy[0] = xy[0] + (rw * c) / row_len;

/* Gone off the right edge of the screen? */
			if (rectxy[0] >= self->common->window.w)
			{
				*el_used = row_len = c;
				*stat = 1;
				break;			
			}
			else
			{
				sd_get_pixel(handle, rectxy[0], rectxy[1], 
							&pel, &ink);
				colours[row_len * r + c] = ink;
			}
		}
	}
	return *stat;
}


