
/*************************************************************************
**       Copyright 1999, Caldera Thin Clients, Inc.                     ** 
**       This software is licenced under the GNU Public License.        **
**       Please see LICENSE.TXT for further information.                ** 
**                                                                      ** 
**                  Historical Copyright                                ** 
**									**
**									**
**									**
**  Copyright (c) 1987, Digital Research, Inc. All Rights Reserved.	**
**  The Software Code contained in this listing is proprietary to	**
**  Digital Research, Inc., Monterey, California and is covered by U.S.	**
**  and other copyright protection.  Unauthorized copying, adaptation,	**
**  distribution, use or display is prohibited and may be subject to 	**
**  civil and criminal penalties.  Disclosure to others is prohibited.	**
**  For the terms and conditions of software code use refer to the 	**
**  appropriate Digital Research License Agreement.			**
**									**
*************************************************************************/

#include "sdsdl_i.h"

#if 0
/* filled area variables */

WORD	y,odeltay,deltay,deltay1,deltay2;
WORD	fill_miny,fill_maxy;
WORD	fill_intersect;
WORD	*patptr;
WORD	patmsk;

/* gdp area variables */
WORD	xc, yc, xrad, yrad, del_ang, beg_ang, end_ang;
WORD	start, angle, n_steps;

/* attribute environment save variables */
WORD	s_fill_per, *s_patptr, s_patmsk, s_nxtpat;
WORD	s_begsty, s_endsty;

extern  WORD	NEXT_PAT;
extern	WORD	udpt_np;
extern	WORD	LINE_STYL[7];
extern	WORD 	DITHER[128];
extern	WORD	HATCH[128];
extern	WORD	UD_PATRN;
extern	WORD	SOLID;
extern	WORD	HOLLOW;
extern	WORD	HATCHMSK;
extern	WORD	DITHRMSK;

extern 	WORD	DEV_TAB[45];		/* initial intout array for open workstation*/
extern 	WORD	SIZ_TAB[14];		/* initial ptsout array for open workstation*/
extern	WORD	INQ_TAB[45];		/* extended inquire values */
extern	WORD	CLIP, XMN_CLIP, XMX_CLIP, YMN_CLIP, YMX_CLIP;

extern 	WORD	CONTRL[11],INTIN[128],PTSIN[256],INTOUT[58],PTSOUT[12];

extern	WORD	FG_BP_1;
extern	WORD	BG_BP_1,BG_BP_2,BG_BP_3,BG_BP_4;
extern	WORD	LN_MASK,LSTLIN;
extern	WORD	HIDE_CNT;
extern	WORD	MOUSE_BT;
extern	WORD	FLIP_Y;
extern	WORD	WRT_MODE;
extern	WORD	REAL_COL[3][MAX_COLOR];
extern	WORD	REQ_COL[3][MAX_COLOR];
extern	WORD	MAP_COL[16];
extern	WORD	X1,Y1,X2,Y2;
extern	WORD	GCURX,GCURY,TERM_CH;
extern	WORD	COPYTRAN;
/* Assembly Language Support Routines */
extern	VOID	ABLINE(),HABLINE(),CLEARMEM();
extern	VOID	CHK_ESC(),INIT_G(),DINIT_G();
extern	VOID	HIDE_CUR(),DIS_CUR();
extern	VOID	GLOC_KEY(),GCHC_KEY(),GCHR_KEY(),GSHIFT_S();
extern	VOID	CLC_FLIT();
extern  VOID	TRAN_FM(),EX_TIMV();
extern  VOID	S_COLMAP(), I_COLMAP();
/* GSX 2.0 functions in assembler without C head */
extern	VOID	XFM_CRFM(),XFM_UDFL();
extern	VOID	RECTFILL(),COPY_RFM();
extern	VOID	VEX_BUTV(),VEX_MOTV(),VEX_CURV();

/* C Support routines */
extern	WORD 	isin();
extern	WORD 	icos();
extern	VOID	st_fl_ptr();
extern  VOID	init_text();
#endif

/* CLEAR_WORKSTATION: */
void sd_clrwk(unsigned handle)
{
	Uint32 pixel;
	SDL_Rect rect;

	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return;

	rect = self->common->window;
	map_colour(self, 0, NULL, &pixel);
	SDL_FillRect(self->common->surface, &rect, pixel);
	SDL_UpdateRect(self->common->surface, 0,0,0,0);
}

/* UPDATE_WORKSTATION: */
void sd_updwk(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return;
	SDL_UpdateRect(self->common->surface, 0,0,0,0);
}


/* S_LINE_TYPE: */
unsigned sd_sltype(unsigned handle, unsigned type)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	if ((type > MAX_LINE_STYLE) || (type < 1)) type = 0;
	else --type;

	self->line_index = type;
	self->line_qi = (self->line_index + 1);
	return self->line_qi;
} 



/*-------------
 * S_LINE_WIDTH
 *-------------*/
unsigned sd_slwidth(unsigned handle, unsigned width)
{
	int i, j, x, y, d, low, high;

	/* Limit the requested line width to a reasonable value. */
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	if (width < 1)
	  width = 1;
	else if (width > MAX_L_WIDTH)
	  width = MAX_L_WIDTH;

	/* Make the line width an odd number (one less, if even). */

	width = ((width - 1)/2)*2 + 1;

	/* Set the line width internals and the return parameters.  
	   Return if the line width is being set to one. */

	self->line_qw = self->line_width = width;
	if (width == 1) return 1;

	/* Initialize the circle DDA.  "y" is set to the radius. */

	x = 0;
	y = (self->line_width + 1)/2;
	d = 3 - 2*y;

	for ( i = 0 ; i < MAX_L_WIDTH ; i++ ) 
	{
	  self->q_circle[i] = 0 ;
	}
	/* Do an octant, starting at north.  
	   The values for the next octant (clockwise) will
	   be filled by transposing x and y. */

	 while (x < y) {
	   self->q_circle[y] = x;
	   self->q_circle[x] = y;

	   if (d < 0) {
	     d = d + (4 * x) + 6;
	   }
	   else {
	     d = d + (4 * (x - y)) + 10;
	     y--;
	   }
	   x++;
	 }  /* End while loop. */

	 if (x == y)
	   self->q_circle[x] = x;

	 /* Calculate the number of vertical pixels required. */

	 self->num_qc_lines = (self->line_width / 2) + 1;

	 /* Fake a pixel averaging when converting to 
	    non-1:1 aspect ratio. */

	low = 0;
	for (i = 0; i < self->num_qc_lines; i++) {
	  high = (2 * i + 1)  / 2;
	  d = 0;

	  for (j = low; j <= high; j++) {
	    d += self->q_circle[j];
	  }

	  self->q_circle[i] = d/(high - low + 1);
	  low = high + 1;
	} 
	return self->line_width;
}

 
/* S_END_STYLE: */
void sd_slends(unsigned handle, unsigned requested[2], unsigned actual[2])
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return;

	self->line_beg = requested[0];
	self->line_end = requested[1];

	if (self->line_beg < 0 || self->line_beg > 2)
		self->line_beg = 0;
	if (self->line_end < 0 || self->line_end > 2)
		self->line_end = 0;

	actual[0] = self->line_beg;
	actual[1] = self->line_end;
}  /* End "vsl_ends". */

/* S_LINE_COLOR: */
unsigned sd_slcolor(unsigned handle, unsigned colour)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	if (colour >= self->dev_tab[13] || colour < 0) 
		colour = 1;
	self->line_qc = colour;
	map_colour(self, colour, NULL, &self->line_colour);
	return self->line_qc;	
}

/* S_MARK_TYPE: */
unsigned sd_smtype(unsigned handle, unsigned type)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	self->mark_qi = type;
	if ((self->mark_qi > MAX_MARK_INDEX) || (self->mark_qi < 1))
	  self->mark_qi = 3; 
	self->mark_index = self->mark_qi - 1;
	return self->mark_qi;
}

/* S_MARK_SCALE: */
unsigned sd_smheight(unsigned handle, unsigned height)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	/* Limit the requested marker height to a reasonable value. */
	if (height < DEF_MKHT) height = DEF_MKHT;
	else if (height > MAX_MKHT) height = MAX_MKHT;

	/* Set the marker height internals and the return parameters. */
	self->mark_height = height;
	self->mark_scale = (self->mark_height + DEF_MKHT/2)/DEF_MKHT;
//	FLIP_Y = 1;
	return self->mark_scale * DEF_MKHT;
}  /* End "vsm_height". */



/* S_MARK_COLOR: */
unsigned sd_smcolor (unsigned handle, unsigned colour)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	if (colour >= self->dev_tab[13] || colour < 0) 
		colour = 1;
	self->mark_qc = colour;
	map_colour(self, colour, NULL, &self->mark_colour);
	return self->mark_qc;	
}

 
/* S_FILL_STYLE: */
unsigned sd_sfinterior(unsigned handle, unsigned fill)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	self->fill_style = fill;
	if ((self->fill_style > MX_FIL_STYLE) || (self->fill_style < 0))
	{
		self->fill_style = 0; 
	}
	self->NEXT_PAT = 0;
	if ( self->fill_style == 4 )
	{
		self->NEXT_PAT = self->udpt_np;
	}
	st_fl_ptr(self);	
	return self->fill_style;
}
	
/* S_FILL_INDEX: */
unsigned sd_sfstyle(unsigned handle, unsigned fill)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	self->fill_qi = fill;
	if (self->fill_style == 2 )
	{
	    if ((self->fill_qi > MX_FIL_PAT_INDEX) || (self->fill_qi < 1))
	  	self->fill_qi = 1; 
	}
	else 
	{
	    if ((self->fill_qi > MX_FIL_HAT_INDEX) || (self->fill_qi < 1))
	  	self->fill_qi = 1; 
	}
	self->fill_index = self->fill_qi - 1;
	st_fl_ptr(self);
	return self->fill_qi;
}

/* S_FILL_COLOR: */
unsigned sd_sfcolor (unsigned handle, unsigned colour)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	if (colour >= self->dev_tab[13] || colour < 0) 
		colour = 1;
	self->fill_qc = colour;
	map_colour(self, colour, NULL, &self->fill_colour);

	return self->fill_qc;	
}

#if 0

#if ibmvdi
/* LOCATOR_INPUT: */
v_locator()
{
	WORD	i;

	INTIN[0] = 1;

        /* Set the initial locator position. */
	if ( loc_mode == 0 )
	{
	    HIDE_CNT = 1;
	    DIS_CUR();
	    while ( (i = GLOC_KEY()) != 1 ); /* loop till some event */
	    CONTRL[4] = 1;
	    INTOUT[0] = TERM_CH & 0x00ff;
	    CONTRL[2] = 1;
	    PTSOUT[0] = X1;
	    PTSOUT[1] = Y1;
	    HIDE_CUR();
	}
	else
	{
	  i = GLOC_KEY();
	  CONTRL[2] = 1;
	  CONTRL[4] = 0;
	  switch ( i )
	    {
	      case 0:
	        CONTRL[2] = 0;
		break;

	      case 1:
	        CONTRL[2] = 0;
		CONTRL[4] = 1;
		INTOUT[0] = TERM_CH & 0x00ff;
		break;

	      case 2:
		PTSOUT[0] = X1;
		PTSOUT[1] = Y1;
		break;

	     case 3:
		CONTRL[4] = 1;
		PTSOUT[0] = X1;
		PTSOUT[1] = Y1;	
		break;
	    }
	}
}
#else
v_locator()
{
}
#endif
#endif
/* SHOW CURSOR */
void sd_show_c(unsigned handle, unsigned reset)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (self)
	{	
		if (reset == 0) self->common->HIDE_CNT = 1;
		dis_cur(self);
	}
}

/* HIDE CURSOR */
void sd_hide_c(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (self) hide_cur(self);
}
#if 0
/* RETURN MOUSE BUTTON STATUS */
vq_mouse_status() 
{
	INTOUT[0] = MOUSE_BT;
	CONTRL[4] = 1;
	CONTRL[2] = 1;
	PTSOUT[0] = GCURX;
	PTSOUT[1] = GCURY;
}

/* VALUATOR_INPUT: */
v_valuator()
{
}
#if ibmvdi
/* CHOICE_INPUT: */
v_choice()
{
	WORD	i;
	if ( chc_mode == 0 )
	{
	  CONTRL[4]=1;
	  while ( GCHC_KEY() != 1 );
	    INTOUT[0]=TERM_CH &0x00ff;
	}
	else
	{
	  i = GCHC_KEY();
	  CONTRL[4]=i;
	  if (i == 1)
	    INTOUT[0]=TERM_CH &0x00ff;
	  if (i == 2)
	    INTOUT[1]=TERM_CH & 0x00ff;
	}	
}
#else
v_choice()
{
}
#endif

#endif
/* STRING_INPUT: */
unsigned sd_string(unsigned handle, signed maxlen, unsigned echo, 
		signed echo_xy[2], unsigned *result)
{
	unsigned i, k = 0, mask;
	unsigned count;
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return 0;
	mask = 0x00ff;
	if ( maxlen < 0 )
	{
	    maxlen = -maxlen;
	    mask = 0xffff;
	}
	if ( !self->str_mode )  /* Request mode */
	{
		count = 0;

		while (count < maxlen)
		{
/* Read in keys until either (a) buffer is full, or (b) CR is encountered.
 * This may need to handle debouncing. */
			k = sd_pollkey(self, &result[count], maxlen - count);
			for (i = count; i < k; i++)
			{
				if ((result[i] & 0xFF) == 0x0D)
				{
					return i;	
				}
			}
			count += k;
		}
		return k;
	}
	else  /* Sample mode */
	{
		count = sd_pollkey(self, result, maxlen);
		for (k = 0; k < count; k++)
		{
			result[k] &= mask;
		}
		return count;
	}
}



/* SET_WRITING_MODE: */
unsigned sd_swrmode(unsigned handle, unsigned mode)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	self->WRT_MODE = mode - 1;
	if (self->WRT_MODE > MAX_MODE) self->WRT_MODE = 0;
	
	return self->write_qm = (self->WRT_MODE + 1);
}

unsigned sd_sinmode(unsigned handle, unsigned dev_type, unsigned mode)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	switch (dev_type)
	{
		case 1: self->loc_mode = mode - 1; break;
		case 2: self->val_mode = mode - 1; break;
		case 3: self->chc_mode = mode - 1; break;
		case 4: self->str_mode = mode - 1; break;
	}
	return mode;
}

/* INQUIRE INPUT MODE: */
unsigned sd_qinmode(unsigned handle, unsigned dev_type)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	switch (dev_type)
	{
		case 1: return self->loc_mode;
		case 2: return self->val_mode;
		case 3: return self->chc_mode;
		case 4: return self->str_mode;
		default: return 0;
	}
}

 
/* ST_FILLPERIMETER: */
unsigned sd_sfperimeter  (unsigned handle, unsigned perimeter)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return 0;

	if ( perimeter == 0)
	{
		self->fill_per = 0;
		return 0;
	}
	else
	{
		self->fill_per = 1;
		return 1;
	}
}


/* ST_UD_LINE_STYLE: */
void sd_udstyle(unsigned handle, unsigned pattern)
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return;

	self->line_styl[MAX_LINE_STYLE - 1] = pattern;
}

/* Set Clip Region */
void sd_sclip(unsigned handle, unsigned enable, signed xy[4])
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return;

	self->CLIP = enable;

	if (self->CLIP)
	{
		arb_corner(xy, ULLR);
		self->rectClip.x = xy[0];
		self->rectClip.y = xy[1];
		self->rectClip.w = xy[2] - xy[0] + 1;
		self->rectClip.h = xy[3] - xy[1] + 1;

		/* [1.0.1] Ensure the clip rect doesn't go outside the screen */
		if (self->rectClip.x < 0) self->rectClip.x = 0;
		if (self->rectClip.y < 0) self->rectClip.y = 0;
		if (self->rectClip.x >= self->common->window.w) 
			self->rectClip.x = self->common->window.w - 1;
		if (self->rectClip.y >= self->common->window.h) 
			self->rectClip.y = self->common->window.h - 1;
		if (self->rectClip.x + self->rectClip.w > self->common->window.w)
			self->rectClip.w = self->common->window.w - self->rectClip.x;
		if (self->rectClip.y + self->rectClip.h > self->common->window.h)
			self->rectClip.h = self->common->window.h - self->rectClip.y;
	}
	else
	{
		self->rectClip.x = 0;
		self->rectClip.y = 0;
		self->rectClip.w = self->common->window.w;
		self->rectClip.h = self->common->window.h;
	} /* End else:  clipping turned off. */
}



void arb_corner(signed xy[4], ARBCORNERTYPE type)
{
	/* Local declarations. */
	unsigned temp;

	/* Fix the x coordinate values, if necessary. */
	if (xy[0] > xy[2])
	{
		temp = xy[0];
		xy[0] = xy[2];
		xy[2] = temp;
	}  /* End if:  "x" values need to be swapped. */

	/* Fix y values based on whether traditional (ll, ur) or raster-op */
	/* (ul, lr) format is desired.                                     */
	if ( ( (type == LLUR) && (xy[1] < xy[3]) ) ||
	     ( (type == ULLR) && (xy[1] > xy[3]) ) )
	{
		temp = xy[1];
		xy[1] = xy[3];
		xy[3] = temp;
	}  /* End if:  "y" values need to be swapped. */
}  /* End "arb_corner". */

#if 0
dro_cpyfm()
{
  arb_corner(PTSIN, ULLR);
  arb_corner(&PTSIN[4], ULLR);
  COPYTRAN = 0; 	
  COPY_RFM();
}  /* End "dr_cpyfm". */

drt_cpyfm()
{
  arb_corner(PTSIN, ULLR);
  arb_corner(&PTSIN[4], ULLR);
  COPYTRAN = 0xffff; 	
  COPY_RFM();
}  /* End "dr_cpyfm". */

#endif

void sd_recfl(unsigned handle, signed xy[4])
{
	DRIVERDATA *self = lookup_handle(handle);
	if (!self) return;
  /* Perform arbitrary corner fix-ups and invoke the rectangle fill routine. */

	arb_corner(xy, LLUR);
	self->FG_BP_1 = self->fill_colour;
	self->LSTLIN = 0;
	rectfill(self, xy, 1);
}  /* End "dr_recfl". */

#if 0

/* transform form entry code */
r_trnfm()
{
  TRAN_FM();
} /* end of trnsform form */
/* exchange timer vector */
dex_timv()
{
  EX_TIMV();
} /* end of timer vector */
#endif



