/************************************************************************
 *       Copyright 1999, Caldera Thin Clients, Inc.                     * 
 *       This software is licenced under the GNU Public License.        *
 *       Please see LICENSE.TXT for further information.                * 
 *                                                                      * 
 *                  Historical Copyright                                * 
 *									*
 *									*
 *									*
 *  Copyright (c) 1987, Digital Research, Inc. All Rights Reserved.	*
 *  The Software Code contained in this listing is proprietary to	*
 *  Digital Research, Inc., Monterey, California and is covered by U.S.	*
 *  and other copyright protection.  Unauthorized copying, adaptation,	*
 *  distribution, use or display is prohibited and may be subject to 	*
 *  civil and criminal penalties.  Disclosure to others is prohibited.	*
 *  For the terms and conditions of software code use refer to the 	*
 *  appropriate Digital Research License Agreement.			*
 *									*
 ************************************************************************/

#include "sdsdl_i.h"
/*
	dseg
public	dither,hatch0,hatch1,oempat,ud_patrn,hollow,solid
public	oemmskpa,hat_0_ms,hat_1_ms,dithrmsk,udpatmsk,line_sty,ud_lstyl
public	udpt_np, NEXT_PAT
public	mxhot,myhot,mmask
public	mous_col_map,mous_col,mous_ci_mask,mous_ci_data
;
;	Display routine assumes that the mouse form definition
;	follows the mouse mask data definition
mous_col_map	db	10101010b	; dmdmdmdm pel index bits white/black
mous_col	db	0	
;
mxhot		dw	3		; mouse form hot spot
myhot		dw	1
mous_plct	dw	1
mous_ci_mask	dw	0
mous_ci_data	dw	1
mmask				dw	3000h, 3800h, 3c00h, 3e00h
				dw	3f00h, 3f80h, 3fc0h, 3fe0h
				dw	3ff0h, 3ff8h, 33d8h, 03c0h
				dw	01e0h, 01e0h, 01e0h, 0000h
;	mouse form definiton must follow mouse mask data (16 words)
mform	dw	00000h, 01000h, 01800h, 01c00h, 01e00h, 01f00h, 01f80h, 01fc0h
	dw	01b60h, 01310h, 00180h, 00180h, 000c0h, 000c0h, 00000h, 00000h 
;*/

const Uint16 def_line_sty[] = { 0xFFFF, 0xFFF0, 0xC0C0, 0xFF18, 0xFF00, 0xF191 };

/**********
 pattern fills 
 **********/

const Uint16 def_ud_patrn[16] = 
{
	0x0000, 0x0000, 0x3ffc, 0x2004, 0x2004, 0x2e74, 0x2e54, 0x2e54,
	0x2e54, 0x2e54, 0x2e74, 0x2004, 0x2004, 0x3ffc, 0x0000, 0x0000
};

const Uint16 oemmskpat = 7;	/* 8 rows per pattern */
const Uint16 oempat[] =
{
	/* brick */
	0xffff, 0x8080, 0x8080, 0x8080, 0xffff, 0x0808, 0x0808, 0x0808,
	/* diagonal bricks */
	0x2020, 0x4040, 0x8080, 0x4141, 0x2222, 0x1414, 0x0808, 0x1010,
	/* grass */
	0x0000, 0x0000, 0x1010, 0x2828, 0x0000, 0x0000, 0x0101, 0x8282,
	/* trees */
	0x0202, 0x0202, 0xaaaa, 0x5050, 0x2020, 0x2020, 0xaaaa, 0x0505,
	/* dashed x's */
	0x4040, 0x8080, 0x0000, 0x0808, 0x0404, 0x0202, 0x0000, 0x2020,
	/* cobble stone */
	0x6606, 0xc6c6, 0xd8d8, 0x1818, 0x8181, 0x8db1, 0x0c33, 0x6000,
	/* sand */
	0x0000, 0x0000, 0x0400, 0x0000, 0x0010, 0x0000, 0x8000, 0x0000,
	/* rough weave */
	0xf8f8, 0x6c6c, 0xc6c6, 0x8f8f, 0x1f1f, 0x3636, 0x6363, 0xf1f1, 
	/* quilt */
	0xaaaa, 0x0000, 0x8888, 0x1414, 0x2222, 0x4141, 0x8888, 0x0000, 
	/* patterned cross */
	0x0808, 0x0000, 0xaaaa, 0x0000, 0x0808, 0x0000, 0x8888, 0x0000, 
	/* balls */
	0x7777, 0x9898, 0xf8f8, 0xf8f8, 0x7777, 0x8989, 0x8f8f, 0x8f8f, 
	/* vertical scales */
	0x8080, 0x8080, 0x4141, 0x3e3e, 0x0808, 0x0808, 0x1414, 0xe3e3, 
	/* diagonal scales */
	0x8181, 0x4242, 0x2424, 0x1818, 0x0606, 0x0101, 0x8080, 0x8080, 
	/* checker board */
	0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0, 0x0f0f, 0x0f0f, 0x0f0f, 0x0f0f,
	/* filled diamond */
	0x0808, 0x1c1c, 0x3e3e, 0x7f7f, 0xffff, 0x7f7f, 0x3e3e, 0x1c1c, 
	/* herringbone */
	0x1111, 0x2222, 0x4444, 0xffff, 0x8888, 0x4444, 0x2222, 0xffff,
};


/*
 *dither pattern
 */

const Uint16 dithrmsk = 3;	/* 4 words per pattern */
const Uint16 dither[] =
{
	0x0000, 0x4444, 0x0000, 0x1111,	/* intensity level two */
	0x0000, 0x5555, 0x0000, 0x5555,	/* intensity level four */
	0x8888, 0x5555, 0x2222, 0x5555, /* intensity level six */
	0xAAAA, 0x5555, 0xAAAA, 0x5555, /* intensity level eight */
	0xAAAA, 0xDDDD, 0xAAAA, 0x7777, /* intensity level ten */
	0xAAAA, 0xFFFF, 0xAAAA, 0xFFFF, /* intensity level twelve */
	0xEEEE, 0xFFFF, 0xBBBB, 0xFFFF, /* intensity level fourteen */
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, /* intensity level sixteen */
};

const Uint16 hat_0_msk = 7;	/* 8 words per pattern */
const Uint16 hatch0[] =
{
	/* narrow +45 deg */
	0x0101, 0x0202, 0x0404, 0x0808, 0x1010, 0x2020, 0x4040, 0x8080,
	/* medium spaced thick 45 deg */
	0x6060, 0xc0c0, 0x8181, 0x0303, 0x0606, 0x0c0c, 0x1818, 0x3030,
	/* medium +-45 deg */
	0x4242, 0x8181, 0x8181, 0x4242, 0x2424, 0x1818, 0x1818, 0x2424,
	/* medium spaced vertical */
	0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 
	/* medium spaced horizontal */
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	/* medium spaced cross */
	0xFFFF, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 
};


const Uint16 hat_1_msk = 0x0f;	/* 16 words in pattern */

const Uint16 hatch1[] =
{
/* wide +45 deg */
	0x0001, 0x0002, 0x0004, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080,
	0x0100, 0x0200, 0x0400, 0x0800, 0x1000, 0x2000, 0x4000, 0x8000,
/* widely spaced thick 45 deg */
	0x8003, 0x0007, 0x000e, 0x001c, 0x0038, 0x0070, 0x00e0, 0x01c0,
	0x0380, 0x0700, 0x0e00, 0x1c00, 0x3800, 0x7000, 0xe000, 0xc001,
/* widely +- 45 deg */
	0x8001, 0x4002, 0x2004, 0x1008, 0x0810, 0x0420, 0x0240, 0x0180,
	0x0180, 0x0240, 0x0420, 0x0810, 0x1008, 0x2004, 0x4002, 0x8001,
/* widely spaced vertical */
	0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 
	0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 
/* widely spaced horizontal */
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
/* widely spaced horizontal/vert cross */
	0xFFFF, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 
	0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 
};

const Uint16 hollow = 0;
const Uint16 solid = 0xffff;
