/************************************************************************
 *       Copyright 1999, Caldera Thin Clients, Inc.                     * 
 *       This software is licenced under the GNU Public License.        *
 *       Please see LICENSE.TXT for further information.                * 
 *                                                                      * 
 *                  Historical Copyright                                * 
 *									*
 *									*
 *									*
 *  Copyright (c) 1987, Digital Research, Inc. All Rights Reserved.	*
 *  The Software Code contained in this listing is proprietary to	*
 *  Digital Research, Inc., Monterey, California and is covered by U.S.	*
 *  and other copyright protection.  Unauthorized copying, adaptation,	*
 *  distribution, use or display is prohibited and may be subject to 	*
 *  civil and criminal penalties.  Disclosure to others is prohibited.	*
 *  For the terms and conditions of software code use refer to the 	*
 *  appropriate Digital Research License Agreement.			*
 *									*
 ************************************************************************/
/*
 * Default system fonts (suitable for CPI substitution)
 */

#include "sdsdl_i.h"


/*
if font_use8
*/
static unsigned system6x6_wtbl[] =
{
	0x000, 0x006, 0x00C, 0x012, 0x018, 0x01E, 0x024, 0x02A, 
	0x030, 0x036, 0x03C, 0x042, 0x048, 0x04E, 0x054, 0x05A,
	0x060, 0x066, 0x06C, 0x072, 0x078, 0x07E, 0x084, 0x08A,
	0x090, 0x096, 0x09C, 0x0A2, 0x0A8, 0x0AE, 0x0B4, 0x0BA,
	0x0C0, 0x0C6, 0x0CC, 0x0D2, 0x0D8, 0x0DE, 0x0E4, 0x0EA, 
	0x0F0, 0x0F6, 0x0FC, 0x102, 0x108, 0x10E, 0x114, 0x11A, 
	0x120, 0x126, 0x12C, 0x132, 0x138, 0x13E, 0x144, 0x14A, 
	0x150, 0x156, 0x15C, 0x162, 0x168, 0x16E, 0x174, 0x17A, 
	0x180, 0x186, 0x18C, 0x192, 0x198, 0x19E, 0x1A4, 0x1AA, 
	0x1B0, 0x1B6, 0x1BC, 0x1C2, 0x1C8, 0x1CE, 0x1D4, 0x1DA, 
	0x1E0, 0x1E6, 0x1EC, 0x1F2, 0x1F8, 0x1FE, 0x204, 0x20A, 
	0x210, 0x216, 0x21C, 0x222, 0x228, 0x22E, 0x234, 0x23A, 
	0x240, 0x246, 0x24C, 0x252, 0x258, 0x25E, 0x264, 0x26A, 
	0x270, 0x276, 0x27C, 0x282, 0x288, 0x28E, 0x294, 0x29A, 
	0x2A0, 0x2A6, 0x2AC, 0x2B2, 0x2B8, 0x2BE, 0x2C4, 0x2CA, 
	0x2D0, 0x2D6, 0x2DC, 0x2E2, 0x2E8, 0x2EE, 0x2F4, 0x2FA, 
	0x300, 0x306, 0x30C, 0x312, 0x318, 0x31E, 0x324, 0x32A, 
	0x330, 0x336, 0x33C, 0x342, 0x348, 0x34E, 0x354, 0x35A, 
	0x360, 0x366, 0x36C, 0x372, 0x378, 0x37E, 0x384, 0x38A, 
	0x390, 0x396, 0x39C, 0x3A2, 0x3A8, 0x3AE, 0x3B4, 0x3BA, 
	0x3C0, 0x3C6, 0x3CC, 0x3D2, 0x3D8, 0x3DE, 0x3E4, 0x3EA, 
	0x3F0, 0x3F6, 0x3FC, 0x402, 0x408, 0x40E, 0x414, 0x41A, 
	0x420, 0x426, 0x42C, 0x432, 0x438, 0x43E, 0x444, 0x44A, 
	0x450, 0x456, 0x45C, 0x462, 0x468, 0x46E, 0x474, 0x47A, 
	0x480, 0x486, 0x48C, 0x492, 0x498, 0x49E, 0x4A4, 0x4AA, 
	0x4B0, 0x4B6, 0x4BC, 0x4C2, 0x4C8, 0x4CE, 0x4D4, 0x4DA, 
	0x4E0, 0x4E6, 0x4EC, 0x4F2, 0x4F8, 0x4FE, 0x504, 0x50A, 
	0x510, 0x516, 0x51C, 0x522, 0x528, 0x52E, 0x534, 0x53A, 
	0x540, 0x546, 0x54C, 0x552, 0x558, 0x55E, 0x564, 0x56A, 
	0x570, 0x576, 0x57C, 0x582, 0x588, 0x58E, 0x594, 0x59A, 
	0x5A0, 0x5A6, 0x5AC, 0x5B2, 0x5B8, 0x5BE, 0x5C4, 0x5CA, 
	0x5D0, 0x5D6, 0x5DC, 0x5E2, 0x5E8, 0x5EE, 0x5F4, 0x5FA, 
	0x600,
};

static unsigned system8xn_wtbl[] =
{
	0x000, 0x008, 0x010, 0x018, 0x020, 0x028, 0x030, 0x038,
	0x040, 0x048, 0x050, 0x058, 0x060, 0x068, 0x070, 0x078,
	0x080, 0x088, 0x090, 0x098, 0x0A0, 0x0A8, 0x0B0, 0x0B8,
	0x0C0, 0x0C8, 0x0D0, 0x0D8, 0x0E0, 0x0E8, 0x0F0, 0x0F8,
	0x100, 0x108, 0x110, 0x118, 0x120, 0x128, 0x130, 0x138,
	0x140, 0x148, 0x150, 0x158, 0x160, 0x168, 0x170, 0x178,
	0x180, 0x188, 0x190, 0x198, 0x1A0, 0x1A8, 0x1B0, 0x1B8,
	0x1C0, 0x1C8, 0x1D0, 0x1D8, 0x1E0, 0x1E8, 0x1F0, 0x1F8,
	0x200, 0x208, 0x210, 0x218, 0x220, 0x228, 0x230, 0x238,
	0x240, 0x248, 0x250, 0x258, 0x260, 0x268, 0x270, 0x278,
	0x280, 0x288, 0x290, 0x298, 0x2A0, 0x2A8, 0x2B0, 0x2B8,
	0x2C0, 0x2C8, 0x2D0, 0x2D8, 0x2E0, 0x2E8, 0x2F0, 0x2F8,
	0x300, 0x308, 0x310, 0x318, 0x320, 0x328, 0x330, 0x338,
	0x340, 0x348, 0x350, 0x358, 0x360, 0x368, 0x370, 0x378,
	0x380, 0x388, 0x390, 0x398, 0x3A0, 0x3A8, 0x3B0, 0x3B8,
	0x3C0, 0x3C8, 0x3D0, 0x3D8, 0x3E0, 0x3E8, 0x3F0, 0x3F8,
	0x400, 0x408, 0x410, 0x418, 0x420, 0x428, 0x430, 0x438,
	0x440, 0x448, 0x450, 0x458, 0x460, 0x468, 0x470, 0x478,
	0x480, 0x488, 0x490, 0x498, 0x4A0, 0x4A8, 0x4B0, 0x4B8,
	0x4C0, 0x4C8, 0x4D0, 0x4D8, 0x4E0, 0x4E8, 0x4F0, 0x4F8,
	0x500, 0x508, 0x510, 0x518, 0x520, 0x528, 0x530, 0x538,
	0x540, 0x548, 0x550, 0x558, 0x560, 0x568, 0x570, 0x578,
	0x580, 0x588, 0x590, 0x598, 0x5A0, 0x5A8, 0x5B0, 0x5B8,
	0x5C0, 0x5C8, 0x5D0, 0x5D8, 0x5E0, 0x5E8, 0x5F0, 0x5F8,
	0x600, 0x608, 0x610, 0x618, 0x620, 0x628, 0x630, 0x638,
	0x640, 0x648, 0x650, 0x658, 0x660, 0x668, 0x670, 0x678,
	0x680, 0x688, 0x690, 0x698, 0x6A0, 0x6A8, 0x6B0, 0x6B8,
	0x6C0, 0x6C8, 0x6D0, 0x6D8, 0x6E0, 0x6E8, 0x6F0, 0x6F8,
	0x700, 0x708, 0x710, 0x718, 0x720, 0x728, 0x730, 0x738,
	0x740, 0x748, 0x750, 0x758, 0x760, 0x768, 0x770, 0x778,
	0x780, 0x788, 0x790, 0x798, 0x7A0, 0x7A8, 0x7B0, 0x7B8,
	0x7C0, 0x7C8, 0x7D0, 0x7D8, 0x7E0, 0x7E8, 0x7F0, 0x7F8,
	0x800
};

static unsigned char system6x6_data[] = 
{	
	0xf8,
	0x82,
	0x08,
	0x20,
	0x0c,
	0x08,
	0x05,
	0xc3,
	0x06,
	0x00,
	0x04,
	0x04,
	0x60,
	0x68,
	0x80,
	0x78,
	0xe2,
	0x08,
	0x20,
	0x81,
	0x08,
	0x00,
	0x00,
	0x00,
	0x00,
	0x86,
	0xd4,
	0x7b,
	0x22,
	0x0c,
	0x10,
	0x84,
	0x88,
	0x00,
	0x00,
	0x02,
	0x70,
	0x8f,
	0x1c,
	0x33,
	0xe7,
	0x3e,
	0x71,
	0xc0,
	0x00,
	0x10,
	0x02,
	0x1c,
	0x71,
	0xcf,
	0x1c,
	0xe3,
	0xef,
	0x9c,
	0x89,
	0xc3,
	0xa2,
	0x82,
	0x28,
	0x9c,
	0xf1,
	0xcf,
	0x1e,
	0xfa,
	0x28,
	0xa2,
	0x8a,
	0x2f,
	0x9c,
	0x81,
	0xc2,
	0x00,
	0x60,
	0x08,
	0x00,
	0x08,
	0x03,
	0x00,
	0x80,
	0x80,
	0xa0,
	0x60,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x20,
	0x00,
	0x00,
	0x00,
	0x00,
	0x06,
	0x23,
	0x00,
	0x08,
	0x79,
	0x41,
	0x08,
	0x51,
	0x02,
	0x00,
	0x61,
	0x42,
	0x14,
	0x20,
	0x88,
	0x98,
	0x10,
	0x03,
	0x88,
	0x51,
	0x01,
	0x10,
	0x51,
	0x48,
	0x8e,
	0x30,
	0x2e,
	0x06,
	0x18,
	0x41,
	0x02,
	0x49,
	0xa3,
	0x0c,
	0x20,
	0x96,
	0xc8,
	0x80,
	0x80,
	0x00,
	0x48,
	0x88,
	0x88,
	0x01,
	0xe6,
	0x24,
	0x48,
	0xe2,
	0x08,
	0x79,
	0xe7,
	0xbd,
	0x00,
	0x0c,
	0x80,
	0x00,
	0x02,
	0x06,
	0x21,
	0x02,
	0x24,
	0x60,
	0x62,
	0x14,
	0x60,
	0x62,
	0x28,
	0xa3,
	0x01,
	0x88,
	0x89,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x01,
	0xcf,
	0x80,
	0x78,
	0x00,
	0x00,
	0x39,
	0xc7,
	0x03,
	0x00,
	0x20,
	0x1c,
	0xf8,
	0x88,
	0x02,
	0x00,
	0x82,
	0x1a,
	0x20,
	0x00,
	0x02,
	0xe3,
	0x00,
	0x1a,
	0xa9,
	0xc2,
	0x04,
	0x41,
	0xec,
	0x9c,
	0x06,
	0xa4,
	0x84,
	0x23,
	0xe6,
	0x0c,
	0x70,
	0xed,
	0x80,
	0xe9,
	0x07,
	0x1c,
	0x70,
	0x80,
	0x90,
	0x21,
	0x22,
	0x00,
	0x00,
	0x84,
	0xbe,
	0xa3,
	0x45,
	0x08,
	0x20,
	0x43,
	0x08,
	0x00,
	0x00,
	0x04,
	0x99,
	0x80,
	0xa2,
	0x52,
	0x08,
	0x02,
	0x8a,
	0x22,
	0x04,
	0x21,
	0xe1,
	0x22,
	0xba,
	0x28,
	0xa2,
	0x92,
	0x08,
	0x20,
	0x88,
	0x81,
	0x24,
	0x83,
	0x6c,
	0xa2,
	0x8a,
	0x28,
	0xa0,
	0x22,
	0x28,
	0xa2,
	0x52,
	0x21,
	0x10,
	0x40,
	0x45,
	0x00,
	0x21,
	0xcf,
	0x1e,
	0x79,
	0xc4,
	0x9e,
	0xf0,
	0x00,
	0x24,
	0x23,
	0x4f,
	0x1c,
	0xf1,
	0xef,
	0x1c,
	0x72,
	0x28,
	0xa2,
	0x8a,
	0x27,
	0x88,
	0x20,
	0x80,
	0x14,
	0x80,
	0x02,
	0x14,
	0x00,
	0x85,
	0x1c,
	0x90,
	0x01,
	0x00,
	0x50,
	0x42,
	0x18,
	0x21,
	0xe5,
	0x14,
	0x00,
	0x82,
	0x88,
	0x00,
	0x00,
	0x15,
	0x41,
	0xc9,
	0x09,
	0x20,
	0x82,
	0x04,
	0xb2,
	0x44,
	0x92,
	0x03,
	0x64,
	0x90,
	0x40,
	0x04,
	0xa4,
	0xb1,
	0x48,
	0x9e,
	0x72,
	0x82,
	0x1a,
	0xb1,
	0x0d,
	0xb6,
	0xea,
	0xdb,
	0x57,
	0x00,
	0x0d,
	0x0c,
	0x00,
	0x05,
	0x08,
	0x50,
	0x85,
	0x00,
	0x10,
	0x85,
	0x00,
	0x10,
	0x85,
	0x16,
	0x58,
	0x82,
	0x14,
	0x02,
	0x20,
	0x00,
	0x00,
	0x00,
	0x00,
	0x4a,
	0x28,
	0x9e,
	0x81,
	0xf8,
	0xb2,
	0x56,
	0x28,
	0x84,
	0x51,
	0xc7,
	0x22,
	0x01,
	0xc4,
	0x04,
	0x10,
	0x80,
	0x24,
	0x50,
	0x00,
	0x04,
	0x90,
	0x8f,
	0xe4,
	0xda,
	0xaa,
	0xbe,
	0xf9,
	0xe2,
	0xbe,
	0x8a,
	0xe4,
	0x84,
	0x71,
	0xc7,
	0x1c,
	0x79,
	0xef,
	0x80,
	0x7d,
	0xc2,
	0x08,
	0xaa,
	0xa7,
	0xfe,
	0x23,
	0xf7,
	0x3e,
	0x00,
	0x80,
	0x14,
	0x70,
	0x86,
	0x80,
	0x20,
	0x47,
	0xbe,
	0x03,
	0xe0,
	0x08,
	0xa8,
	0x87,
	0x0c,
	0x93,
	0xcf,
	0x04,
	0x71,
	0xe0,
	0x00,
	0x40,
	0x00,
	0x8c,
	0xbb,
	0xef,
	0x20,
	0x8b,
	0xcf,
	0x26,
	0xf8,
	0x81,
	0x38,
	0x82,
	0xaa,
	0xa2,
	0xf2,
	0xaf,
	0x1c,
	0x22,
	0x25,
	0x2a,
	0x21,
	0xc2,
	0x10,
	0x20,
	0x40,
	0x00,
	0x02,
	0x28,
	0xa0,
	0x8b,
	0xee,
	0x22,
	0x88,
	0x80,
	0xb8,
	0x22,
	0xa8,
	0xa2,
	0x8a,
	0x28,
	0xbc,
	0x22,
	0x28,
	0xaa,
	0x72,
	0x21,
	0x30,
	0x20,
	0x64,
	0xa2,
	0x82,
	0x2f,
	0x9c,
	0x71,
	0xc7,
	0x20,
	0xfb,
	0xef,
	0x88,
	0x00,
	0x05,
	0x14,
	0xfa,
	0xf7,
	0x8c,
	0x30,
	0xc0,
	0x22,
	0x89,
	0xc8,
	0x95,
	0xe2,
	0x6e,
	0x0c,
	0x50,
	0x03,
	0x12,
	0xf3,
	0x23,
	0x8c,
	0x60,
	0x00,
	0x20,
	0x20,
	0x89,
	0x12,
	0x78,
	0xc7,
	0x28,
	0xba,
	0xc5,
	0x08,
	0x71,
	0xc2,
	0x08,
	0x7f,
	0x1a,
	0xd5,
	0x00,
	0x02,
	0x1e,
	0x7b,
	0xf2,
	0x14,
	0x73,
	0xef,
	0xbe,
	0x39,
	0xc7,
	0x1c,
	0x71,
	0xc7,
	0x0c,
	0x22,
	0x28,
	0x80,
	0x8a,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0xb2,
	0xc8,
	0x12,
	0x42,
	0x48,
	0x8c,
	0x57,
	0xe8,
	0x9c,
	0xaa,
	0x6e,
	0x22,
	0xf8,
	0x82,
	0xa8,
	0x2a,
	0x8f,
	0x80,
	0x20,
	0x80,
	0x28,
	0x91,
	0x0f,
	0xea,
	0xd8,
	0x87,
	0x04,
	0x41,
	0xe1,
	0x9c,
	0x4a,
	0x27,
	0x9c,
	0xf8,
	0x86,
	0x0c,
	0x70,
	0xed,
	0x80,
	0x28,
	0xe7,
	0x1c,
	0x21,
	0xc0,
	0x90,
	0x3d,
	0x2f,
	0x9c,
	0x00,
	0x00,
	0x3e,
	0x29,
	0x69,
	0x00,
	0x20,
	0x43,
	0x08,
	0x30,
	0x02,
	0x10,
	0xc8,
	0x88,
	0x22,
	0xf8,
	0x28,
	0x88,
	0x88,
	0x22,
	0x04,
	0x21,
	0xe1,
	0x00,
	0x82,
	0x28,
	0xa2,
	0x92,
	0x08,
	0x22,
	0x88,
	0x89,
	0x24,
	0x82,
	0xa9,
	0xa2,
	0x82,
	0x69,
	0x02,
	0x22,
	0x25,
	0x36,
	0x50,
	0x84,
	0x10,
	0x10,
	0x40,
	0x00,
	0x02,
	0x28,
	0xa0,
	0x8a,
	0x04,
	0x1e,
	0x88,
	0x80,
	0xa4,
	0x22,
	0xa8,
	0xa2,
	0xf1,
	0xe8,
	0x02,
	0x22,
	0x25,
	0x36,
	0x51,
	0xe2,
	0x08,
	0x20,
	0x8b,
	0x22,
	0x7a,
	0x28,
	0x22,
	0x8a,
	0x28,
	0x9c,
	0x82,
	0x08,
	0x08,
	0x20,
	0x47,
	0x1c,
	0xf2,
	0x89,
	0x12,
	0x49,
	0x24,
	0xa2,
	0x7a,
	0x28,
	0x95,
	0x4a,
	0xab,
	0xa8,
	0x70,
	0x84,
	0x92,
	0x8a,
	0xa0,
	0x00,
	0x88,
	0x00,
	0x10,
	0x40,
	0x84,
	0xa4,
	0x89,
	0x2f,
	0x9e,
	0xa2,
	0x87,
	0x1c,
	0x88,
	0xed,
	0x88,
	0x2a,
	0xdb,
	0x40,
	0x00,
	0x0d,
	0x9e,
	0x00,
	0x00,
	0x1c,
	0xfb,
	0xcf,
	0x3c,
	0x10,
	0x82,
	0x08,
	0x8a,
	0x28,
	0x86,
	0x1a,
	0x28,
	0xa2,
	0xfa,
	0x20,
	0x00,
	0x00,
	0x00,
	0x00,
	0xb2,
	0x28,
	0x12,
	0x82,
	0x48,
	0x88,
	0x56,
	0x25,
	0x22,
	0x52,
	0xa8,
	0x22,
	0x00,
	0x05,
	0x14,
	0x2a,
	0x80,
	0x1a,
	0x00,
	0x82,
	0x18,
	0x03,
	0xcf,
	0xf2,
	0xa8,
	0x82,
	0x08,
	0x20,
	0x07,
	0x88,
	0x31,
	0xc2,
	0x18,
	0x00,
	0x04,
	0x04,
	0x60,
	0x68,
	0xbf,
	0x28,
	0x22,
	0x08,
	0x20,
	0x81,
	0x08,
	0x00,
	0x00,
	0x08,
	0x00,
	0x80,
	0x14,
	0x72,
	0x66,
	0x80,
	0x10,
	0x84,
	0x88,
	0x40,
	0x02,
	0x20,
	0x71,
	0xcf,
	0x9c,
	0x13,
	0xc7,
	0x10,
	0x71,
	0xc0,
	0x08,
	0x10,
	0x02,
	0x08,
	0x72,
	0x2f,
	0x1c,
	0xe3,
	0xe8,
	0x1c,
	0x89,
	0xc6,
	0x22,
	0xfa,
	0x28,
	0x9c,
	0x81,
	0xc8,
	0xbc,
	0x21,
	0xc2,
	0x22,
	0x88,
	0x8f,
	0x9c,
	0x09,
	0xc0,
	0x00,
	0x01,
	0xef,
	0x1e,
	0x79,
	0xe4,
	0x02,
	0x88,
	0x88,
	0xa2,
	0x72,
	0x28,
	0x9c,
	0x80,
	0x28,
	0x1c,
	0x19,
	0xc2,
	0x22,
	0x88,
	0x27,
	0x86,
	0x23,
	0x00,
	0x3e,
	0xa1,
	0xc7,
	0x9e,
	0x79,
	0xe7,
	0x88,
	0x79,
	0xe7,
	0x88,
	0x20,
	0x48,
	0xa2,
	0xf9,
	0x69,
	0x8c,
	0x30,
	0xc3,
	0x1c,
	0x09,
	0xc7,
	0x0e,
	0xf1,
	0xc9,
	0x10,
	0x88,
	0x83,
	0x0c,
	0x8a,
	0x67,
	0x9e,
	0x70,
	0x00,
	0x08,
	0x80,
	0x80,
	0x00,
	0x78,
	0xc2,
	0x08,
	0x79,
	0xe8,
	0xa2,
	0x70,
	0x22,
	0x08,
	0x29,
	0xea,
	0xc0,
	0x6c,
	0x0d,
	0x8c,
	0x00,
	0x00,
	0x22,
	0x8b,
	0xef,
	0xbe,
	0x39,
	0xc7,
	0x1c,
	0x71,
	0xc7,
	0x0c,
	0x31,
	0xc7,
	0x1c,
	0x22,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x4a,
	0xc8,
	0x24,
	0x79,
	0x8f,
	0x08,
	0x39,
	0xcd,
	0x9c,
	0x01,
	0xc7,
	0x22,
	0xfb,
	0xea,
	0x0a,
	0x21,
	0x02,
	0x24,
	0x00,
	0x00,
	0x10,
	0x00,
	0x0f,
	0xec,
	0xf8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x3f,
	0x01,
	0xc0,
	0x3f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x20,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x3f,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x1c,
	0x00,
	0x07,
	0x00,
	0x00,
	0x00,
	0x00,
	0x80,
	0x20,
	0x00,
	0x00,
	0x00,
	0x00,
	0x01,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x40,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x70,
	0x00,
	0x00,
	0x02,
	0x08,
	0x80,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x01,
	0xc0,
	0x00,
	0x00,
	0x07,
	0x80,
	0x26,
	0xa0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x02,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x02,
	0x00,
	0x00,
	0x00,
	0x08,
	0x00,
	0x00,
	0x00,
	0x00,
	0x02,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x20,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
};

static unsigned char system8x8_data[] = 
{
	0x7E,
	0x10,
	0x38,
	0x08,
	0x10,
	0x00,
	0xf8,
	0x10,
	0x01,
	0x00,
	0x00,
	0x1e,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x06,
	0x81,
	0x00,
	0x7e,
	0x3c,
	0x18,
	0x18,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0xfe,
	0x00,
	0x18,
	0x36,
	0x36,
	0x18,
	0x00,
	0x38,
	0x18,
	0x0c,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x06,
	0x7c,
	0x18,
	0x3c,
	0x3c,
	0x1c,
	0x7e,
	0x1c,
	0x7e,
	0x3c,
	0x3c,
	0x00,
	0x00,
	0x0c,
	0x00,
	0x30,
	0x3c,
	0x7c,
	0x38,
	0xf8,
	0x3c,
	0xf8,
	0xfe,
	0xfe,
	0x3c,
	0xc6,
	0x18,
	0x06,
	0xc6,
	0x60,
	0x82,
	0xc6,
	0x38,
	0xfc,
	0x38,
	0xf8,
	0x7c,
	0x7e,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x66,
	0xfe,
	0x3c,
	0xc0,
	0x3c,
	0x10,
	0x00,
	0x1c,
	0x00,
	0xc0,
	0x00,
	0x06,
	0x00,
	0x1e,
	0x00,
	0xc0,
	0x18,
	0x0c,
	0x60,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x0e,
	0x18,
	0x70,
	0x62,
	0x10,
	0x3c,
	0xc6,
	0x0c,
	0x30,
	0xcc,
	0xc0,
	0x10,
	0x00,
	0x30,
	0xcc,
	0xc0,
	0x66,
	0x18,
	0x60,
	0x6c,
	0x78,
	0x0c,
	0x00,
	0x3e,
	0x78,
	0xc6,
	0xc0,
	0x30,
	0x60,
	0xc6,
	0xc6,
	0xcc,
	0x3a,
	0x1e,
	0x04,
	0xf0,
	0x0e,
	0x0c,
	0x06,
	0x0c,
	0x0c,
	0x72,
	0x32,
	0x7c,
	0x7c,
	0x00,
	0x66,
	0xee,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xe4,
	0x78,
	0x66,
	0x00,
	0x00,
	0x7e,
	0xc0,
	0x64,
	0x72,
	0x3c,
	0x0c,
	0x18,
	0x7e,
	0x7e,
	0x7e,
	0xfb,
	0x00,
	0x00,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x1c,
	0x0c,
	0x78,
	0x60,
	0x38,
	0x6c,
	0x30,
	0x06,
	0x3c,
	0x6c,
	0x60,
	0x0c,
	0x38,
	0x6c,
	0x6c,
	0x60,
	0x0c,
	0x38,
	0x66,
	0x7c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x7c,
	0xfe,
	0x00,
	0xfe,
	0x00,
	0x00,
	0x00,
	0x3c,
	0x7c,
	0x7c,
	0x0e,
	0x00,
	0x18,
	0x00,
	0x7c,
	0x00,
	0x18,
	0x30,
	0x0c,
	0x1c,
	0x18,
	0x18,
	0x00,
	0x1c,
	0x1c,
	0x00,
	0x07,
	0x7c,
	0x3c,
	0x00,
	0x3a,
	0xc3,
	0x38,
	0x38,
	0x0c,
	0x30,
	0x7e,
	0xf8,
	0x38,
	0x03,
	0x38,
	0x18,
	0x1c,
	0x00,
	0x00,
	0x40,
	0x04,
	0x70,
	0x0e,
	0xc3,
	0x00,
	0xfc,
	0x42,
	0x3c,
	0x3c,
	0x3c,
	0x18,
	0x08,
	0x20,
	0x00,
	0x24,
	0x38,
	0xfe,
	0x00,
	0x18,
	0x36,
	0x36,
	0x3e,
	0xc6,
	0x6c,
	0x18,
	0x18,
	0x18,
	0x66,
	0x18,
	0x00,
	0x00,
	0x00,
	0x0c,
	0xc6,
	0x38,
	0x66,
	0x66,
	0x34,
	0x60,
	0x30,
	0x06,
	0x66,
	0x66,
	0x00,
	0x00,
	0x18,
	0x00,
	0x18,
	0x66,
	0x82,
	0x6c,
	0xcc,
	0x66,
	0xcc,
	0xc0,
	0xc0,
	0x66,
	0xc6,
	0x18,
	0x06,
	0xcc,
	0x60,
	0xc6,
	0xe6,
	0x6c,
	0xc6,
	0x6c,
	0xcc,
	0xc6,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x66,
	0x0c,
	0x30,
	0x60,
	0x0c,
	0x38,
	0x00,
	0x18,
	0x00,
	0xc0,
	0x00,
	0x06,
	0x00,
	0x30,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x60,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x18,
	0x18,
	0x92,
	0x38,
	0x66,
	0x00,
	0x10,
	0xcc,
	0x00,
	0x20,
	0x28,
	0x00,
	0xcc,
	0x00,
	0x20,
	0x00,
	0x66,
	0x10,
	0x00,
	0xcc,
	0x10,
	0x00,
	0x6c,
	0xcc,
	0x00,
	0x20,
	0xcc,
	0x10,
	0x00,
	0x38,
	0x00,
	0x6c,
	0x30,
	0x7c,
	0xd8,
	0x18,
	0x10,
	0x08,
	0x10,
	0x10,
	0x4e,
	0x4c,
	0x06,
	0xc6,
	0x18,
	0xcc,
	0x66,
	0x18,
	0x18,
	0x18,
	0x00,
	0x00,
	0x9c,
	0xcc,
	0x66,
	0x0c,
	0x00,
	0xcc,
	0x60,
	0x98,
	0x9c,
	0x42,
	0x18,
	0x18,
	0xfc,
	0x81,
	0x81,
	0x55,
	0x00,
	0x00,
	0xd8,
	0x00,
	0x00,
	0x00,
	0x36,
	0x10,
	0xc6,
	0x10,
	0x6c,
	0x00,
	0x08,
	0x08,
	0x66,
	0x00,
	0x10,
	0x10,
	0xc6,
	0x38,
	0x38,
	0x10,
	0x10,
	0x6c,
	0x00,
	0xc6,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc0,
	0x00,
	0x60,
	0x00,
	0x00,
	0x00,
	0x18,
	0xc6,
	0xc6,
	0x18,
	0x00,
	0x18,
	0x00,
	0xc6,
	0x7e,
	0x18,
	0x18,
	0x18,
	0x36,
	0x18,
	0x18,
	0x72,
	0x36,
	0x3e,
	0x00,
	0x04,
	0x66,
	0x06,
	0x00,
	0x6c,
	0x99,
	0x7c,
	0x38,
	0xfe,
	0x7f,
	0x7e,
	0xf8,
	0x7c,
	0x06,
	0x54,
	0x24,
	0x10,
	0x18,
	0x7e,
	0x60,
	0x0c,
	0x7c,
	0x3e,
	0xe7,
	0x00,
	0xfc,
	0x78,
	0x7e,
	0x7e,
	0x7e,
	0x18,
	0x0c,
	0x60,
	0xc0,
	0x66,
	0x38,
	0x7c,
	0x00,
	0x18,
	0x36,
	0xfe,
	0x60,
	0xcc,
	0x38,
	0x18,
	0x30,
	0x0c,
	0x3c,
	0x18,
	0x00,
	0x00,
	0x00,
	0x18,
	0xce,
	0x18,
	0x06,
	0x06,
	0x6c,
	0x7c,
	0x60,
	0x06,
	0x66,
	0x66,
	0x18,
	0x18,
	0x30,
	0x7e,
	0x0c,
	0x06,
	0x9e,
	0xc6,
	0xcc,
	0xc0,
	0xc6,
	0xc0,
	0xc0,
	0xc0,
	0xc6,
	0x18,
	0x06,
	0xd8,
	0x60,
	0xee,
	0xb6,
	0xc6,
	0xc6,
	0xc6,
	0xcc,
	0xe0,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0x6c,
	0x66,
	0x18,
	0x30,
	0x30,
	0x0c,
	0x6c,
	0x00,
	0x0c,
	0x7c,
	0xfc,
	0x7c,
	0x7e,
	0x7c,
	0x30,
	0x7e,
	0xfc,
	0x18,
	0x0c,
	0x66,
	0x18,
	0xcc,
	0xfc,
	0x7c,
	0xfc,
	0x7e,
	0xdc,
	0x3e,
	0x7e,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x7e,
	0x18,
	0x18,
	0x18,
	0x8c,
	0x6c,
	0xc0,
	0xc6,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x3e,
	0x7c,
	0x7c,
	0x7c,
	0x18,
	0x00,
	0x00,
	0x38,
	0x38,
	0xfe,
	0xec,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc6,
	0x6c,
	0xc6,
	0xce,
	0x30,
	0xce,
	0xd8,
	0x18,
	0x7c,
	0x00,
	0x00,
	0xc6,
	0x00,
	0xe6,
	0x7e,
	0xc6,
	0x00,
	0xee,
	0xcc,
	0x30,
	0x0c,
	0x00,
	0x33,
	0xcc,
	0x7c,
	0x00,
	0x3c,
	0x3e,
	0x6c,
	0xcc,
	0x38,
	0x38,
	0x7c,
	0x78,
	0x00,
	0x7e,
	0xfc,
	0x9d,
	0xb9,
	0x51,
	0x00,
	0x00,
	0x30,
	0x18,
	0x00,
	0x00,
	0x1c,
	0x7c,
	0x38,
	0xfe,
	0xfe,
	0xfe,
	0x18,
	0x18,
	0x18,
	0x18,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x3e,
	0xc6,
	0xc6,
	0x82,
	0x66,
	0xdc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x76,
	0xdc,
	0xc0,
	0xfe,
	0x30,
	0x7e,
	0x66,
	0xfe,
	0x7e,
	0xc6,
	0xc6,
	0x0c,
	0x66,
	0x7e,
	0x3c,
	0xc6,
	0x00,
	0x7e,
	0x0e,
	0x70,
	0x36,
	0x18,
	0x00,
	0x9c,
	0x1c,
	0x3e,
	0x00,
	0x04,
	0x66,
	0x1c,
	0x3c,
	0xce,
	0xf9,
	0xfe,
	0x38,
	0xff,
	0xff,
	0x7e,
	0xf8,
	0xfe,
	0x06,
	0x92,
	0x24,
	0x10,
	0x3c,
	0x3c,
	0x78,
	0x3c,
	0x7e,
	0x7e,
	0xff,
	0x00,
	0x7c,
	0x24,
	0x18,
	0x18,
	0x18,
	0x18,
	0xfe,
	0xfe,
	0xc0,
	0xff,
	0x7c,
	0x7c,
	0x00,
	0x18,
	0x00,
	0x6c,
	0x3c,
	0x18,
	0x76,
	0x00,
	0x30,
	0x0c,
	0xff,
	0x7e,
	0x00,
	0x7e,
	0x00,
	0x30,
	0xd6,
	0x18,
	0x1c,
	0x1c,
	0xcc,
	0x06,
	0x7c,
	0x0c,
	0x3c,
	0x3e,
	0x18,
	0x18,
	0x60,
	0x00,
	0x06,
	0x0c,
	0xb6,
	0xc6,
	0xfc,
	0xc0,
	0xc6,
	0xf8,
	0xf8,
	0xc0,
	0xfe,
	0x18,
	0x06,
	0xf0,
	0x60,
	0xd6,
	0xda,
	0xc6,
	0xc6,
	0xc6,
	0xf8,
	0x38,
	0x18,
	0xc6,
	0xc6,
	0xd6,
	0x38,
	0x3c,
	0x30,
	0x30,
	0x18,
	0x0c,
	0xc6,
	0x00,
	0x00,
	0x06,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x7e,
	0xc6,
	0xc6,
	0x18,
	0x0c,
	0x6c,
	0x18,
	0xfe,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xe6,
	0x60,
	0x30,
	0xc6,
	0xc6,
	0xd6,
	0x6c,
	0xc6,
	0x0c,
	0x70,
	0x18,
	0x0e,
	0x00,
	0xc6,
	0xc0,
	0xc6,
	0xc6,
	0x06,
	0x06,
	0x06,
	0x06,
	0x60,
	0xc6,
	0xc6,
	0xc6,
	0x18,
	0x18,
	0x18,
	0x6c,
	0x6c,
	0xc0,
	0x12,
	0xfe,
	0x7c,
	0x7c,
	0x7c,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xd6,
	0x7c,
	0xd6,
	0xfc,
	0x7e,
	0x06,
	0x18,
	0x7c,
	0xc6,
	0x7c,
	0xb6,
	0xc6,
	0xc6,
	0x18,
	0x00,
	0x00,
	0x60,
	0x06,
	0x18,
	0x66,
	0x66,
	0x06,
	0x7c,
	0x18,
	0x60,
	0x92,
	0xce,
	0x6c,
	0x6c,
	0xc6,
	0x24,
	0x00,
	0x18,
	0x7c,
	0xb1,
	0xa5,
	0x00,
	0x00,
	0x00,
	0x60,
	0x3c,
	0x7e,
	0xff,
	0x00,
	0x06,
	0x6c,
	0xc0,
	0xc0,
	0xc0,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xe2,
	0x60,
	0xc6,
	0xc6,
	0xc6,
	0x66,
	0xc6,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xdc,
	0xc6,
	0xc0,
	0x6c,
	0x18,
	0xc8,
	0x66,
	0x30,
	0xdb,
	0xfe,
	0xc6,
	0x7e,
	0xdb,
	0xdb,
	0x62,
	0xc6,
	0x7e,
	0x18,
	0x18,
	0x18,
	0x30,
	0x18,
	0x7e,
	0x00,
	0x00,
	0x1c,
	0x18,
	0x44,
	0x66,
	0x30,
	0x3c,
	0xd6,
	0xe3,
	0x38,
	0xfe,
	0xfe,
	0x7f,
	0x7e,
	0xf9,
	0x7c,
	0xcc,
	0x92,
	0x24,
	0x10,
	0x7e,
	0x18,
	0x60,
	0x0c,
	0x7c,
	0x3e,
	0xe7,
	0x00,
	0x0c,
	0x24,
	0x18,
	0x7e,
	0x18,
	0x18,
	0x0c,
	0x60,
	0xc0,
	0x66,
	0x7c,
	0x38,
	0x00,
	0x18,
	0x00,
	0xfe,
	0x06,
	0x30,
	0xdc,
	0x00,
	0x30,
	0x0c,
	0x3c,
	0x18,
	0x00,
	0x00,
	0x00,
	0x60,
	0xe6,
	0x18,
	0x30,
	0x06,
	0xfe,
	0x06,
	0x66,
	0x18,
	0x66,
	0x06,
	0x00,
	0x00,
	0x30,
	0x7e,
	0x0c,
	0x18,
	0x9e,
	0xfe,
	0xc6,
	0xc0,
	0xc6,
	0xc0,
	0xc0,
	0xce,
	0xc6,
	0x18,
	0xc6,
	0xd8,
	0x60,
	0xd6,
	0xce,
	0xc6,
	0xfc,
	0xd6,
	0xd8,
	0x0e,
	0x18,
	0xc6,
	0x6c,
	0xd6,
	0x6c,
	0x18,
	0x60,
	0x30,
	0x0c,
	0x0c,
	0x00,
	0x00,
	0x00,
	0x7e,
	0xc6,
	0xc0,
	0xc6,
	0xfe,
	0x30,
	0xc6,
	0xc6,
	0x18,
	0x0c,
	0x78,
	0x18,
	0xd6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0x3c,
	0x30,
	0xc6,
	0x6c,
	0xd6,
	0x38,
	0xc6,
	0x18,
	0x18,
	0x18,
	0x18,
	0x00,
	0xc6,
	0x66,
	0xc6,
	0xfe,
	0x7e,
	0x7e,
	0x7e,
	0x7e,
	0x60,
	0xfe,
	0xfe,
	0xfe,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xf8,
	0x7e,
	0xcc,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xe6,
	0x30,
	0xe6,
	0xce,
	0x18,
	0x7e,
	0x18,
	0xc6,
	0xc6,
	0x66,
	0xda,
	0x7e,
	0x7c,
	0x30,
	0x00,
	0x00,
	0x30,
	0x0c,
	0x18,
	0xcc,
	0x33,
	0x7e,
	0xc6,
	0x7e,
	0x60,
	0x9e,
	0xcc,
	0xc6,
	0xc6,
	0xc6,
	0x24,
	0x00,
	0x18,
	0x0c,
	0xb1,
	0xb9,
	0x00,
	0xee,
	0x00,
	0xc0,
	0x18,
	0x7e,
	0xff,
	0x00,
	0x7e,
	0xc6,
	0xf8,
	0xf8,
	0xf8,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0x38,
	0x3c,
	0xc6,
	0xc6,
	0xc6,
	0x3c,
	0xc6,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc8,
	0xc6,
	0xc0,
	0x6c,
	0x30,
	0xcc,
	0x66,
	0x30,
	0x7e,
	0xc6,
	0xc6,
	0xc6,
	0xdb,
	0xdb,
	0x38,
	0xc6,
	0x00,
	0x18,
	0x30,
	0x0c,
	0x30,
	0x18,
	0x00,
	0x72,
	0x00,
	0x00,
	0x00,
	0xe4,
	0x66,
	0x3e,
	0x3c,
	0xe6,
	0xff,
	0x38,
	0x7c,
	0x0c,
	0x30,
	0x7e,
	0x05,
	0x38,
	0x6c,
	0x8a,
	0x7e,
	0x70,
	0x00,
	0x00,
	0x40,
	0x04,
	0x70,
	0x0e,
	0xc3,
	0x00,
	0x0c,
	0x1e,
	0x7e,
	0x3c,
	0x18,
	0x7e,
	0x08,
	0x20,
	0xfe,
	0x24,
	0xfe,
	0x38,
	0x00,
	0x00,
	0x00,
	0xd8,
	0x7c,
	0x66,
	0xcc,
	0x00,
	0x18,
	0x18,
	0x66,
	0x18,
	0x38,
	0x00,
	0x18,
	0xc0,
	0xc6,
	0x18,
	0x60,
	0x66,
	0x0c,
	0x66,
	0x66,
	0x30,
	0x66,
	0x0c,
	0x18,
	0x38,
	0x18,
	0x00,
	0x18,
	0x00,
	0x80,
	0xc6,
	0xc6,
	0x66,
	0xcc,
	0xc0,
	0xc0,
	0x66,
	0xc6,
	0x18,
	0xc6,
	0xcc,
	0x60,
	0xc6,
	0xc6,
	0x6c,
	0xc0,
	0x6c,
	0xcc,
	0xc6,
	0x18,
	0xc6,
	0x38,
	0x6c,
	0xc6,
	0x18,
	0xc0,
	0x30,
	0x06,
	0x0c,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0x30,
	0x7e,
	0xc6,
	0x18,
	0x0c,
	0x6c,
	0x18,
	0xd6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0x06,
	0x30,
	0xc6,
	0x38,
	0x6c,
	0x6c,
	0x7c,
	0x30,
	0x18,
	0x18,
	0x18,
	0x00,
	0xc6,
	0x3c,
	0xc6,
	0xc0,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x3e,
	0xc0,
	0xc0,
	0xc0,
	0x18,
	0x18,
	0x18,
	0xfe,
	0xfe,
	0xc0,
	0x90,
	0xcc,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x7c,
	0x6c,
	0xc6,
	0x6c,
	0x30,
	0x7c,
	0xcc,
	0x18,
	0xc6,
	0x18,
	0xc6,
	0xc6,
	0x66,
	0xce,
	0x00,
	0x00,
	0x60,
	0x00,
	0x00,
	0x18,
	0x18,
	0x18,
	0x66,
	0x66,
	0xc6,
	0xc6,
	0x18,
	0x3e,
	0x90,
	0xcc,
	0xfe,
	0xfe,
	0xc6,
	0x1e,
	0x00,
	0x18,
	0x0c,
	0x9d,
	0xa5,
	0x00,
	0x66,
	0xdb,
	0xb6,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xfe,
	0xc0,
	0xc0,
	0xc0,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0x8e,
	0x06,
	0xc6,
	0xc6,
	0xc6,
	0x18,
	0xfc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xdc,
	0xfc,
	0xc0,
	0x6c,
	0x60,
	0xcc,
	0x7c,
	0x30,
	0x18,
	0xc6,
	0x6c,
	0xc6,
	0x66,
	0x7e,
	0x62,
	0xc6,
	0x7e,
	0x00,
	0x00,
	0x00,
	0x30,
	0xd8,
	0x18,
	0x9c,
	0x00,
	0x00,
	0x00,
	0x34,
	0x00,
	0x00,
	0x3c,
	0x6c,
	0xe7,
	0x38,
	0x38,
	0x08,
	0x10,
	0x7e,
	0x03,
	0x10,
	0x38,
	0x44,
	0x18,
	0xf0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x06,
	0x81,
	0xff,
	0x0c,
	0x42,
	0x3c,
	0x18,
	0x18,
	0x3c,
	0x00,
	0x00,
	0x00,
	0x00,
	0xfe,
	0x10,
	0x00,
	0x18,
	0x00,
	0xd8,
	0x18,
	0xc6,
	0x76,
	0x00,
	0x0c,
	0x30,
	0x00,
	0x00,
	0x18,
	0x00,
	0x18,
	0x80,
	0x7c,
	0x7e,
	0x7e,
	0x3c,
	0x0c,
	0x3c,
	0x3c,
	0x30,
	0x3c,
	0x38,
	0x18,
	0x18,
	0x0c,
	0x00,
	0x30,
	0x18,
	0x78,
	0xc6,
	0xfc,
	0x3c,
	0xf8,
	0xfe,
	0xc0,
	0x3e,
	0xc6,
	0x18,
	0x7c,
	0xc6,
	0x7e,
	0xc6,
	0xc2,
	0x38,
	0xc0,
	0x3c,
	0xc6,
	0x7c,
	0x18,
	0x7c,
	0x10,
	0x6c,
	0xc6,
	0x18,
	0xfe,
	0x3c,
	0x02,
	0x3c,
	0x00,
	0x00,
	0x00,
	0x7e,
	0xfc,
	0x7c,
	0x7e,
	0x7c,
	0x30,
	0x06,
	0xc6,
	0x18,
	0x0c,
	0x66,
	0x0c,
	0xc6,
	0xc6,
	0x7c,
	0xfc,
	0x7e,
	0xc0,
	0x7c,
	0x1e,
	0x7e,
	0x10,
	0x6c,
	0xc6,
	0x18,
	0x7e,
	0x0e,
	0x18,
	0x70,
	0x00,
	0xfe,
	0x0c,
	0x7e,
	0x7c,
	0x7e,
	0x7e,
	0x7e,
	0x7e,
	0x0c,
	0x7c,
	0x7c,
	0x7c,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xfe,
	0xee,
	0xce,
	0x7c,
	0x7c,
	0x7c,
	0x7e,
	0x7e,
	0x18,
	0x38,
	0x7c,
	0xb8,
	0x7e,
	0x40,
	0xce,
	0x70,
	0x7e,
	0x18,
	0x7c,
	0x7e,
	0x66,
	0xc6,
	0xfe,
	0xfe,
	0x66,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x33,
	0xcc,
	0x7e,
	0x7c,
	0x18,
	0x0c,
	0x6e,
	0x7e,
	0xc6,
	0xc6,
	0x7c,
	0x42,
	0x00,
	0x18,
	0x0c,
	0x81,
	0x81,
	0x00,
	0xcc,
	0xdb,
	0x36,
	0x00,
	0x00,
	0x00,
	0x00,
	0x7e,
	0xc6,
	0xfe,
	0xfe,
	0xfe,
	0x18,
	0x18,
	0x18,
	0x18,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x18,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x76,
	0xc0,
	0xc0,
	0x66,
	0xfe,
	0x78,
	0x60,
	0x1c,
	0x3c,
	0x7c,
	0xee,
	0x7c,
	0x00,
	0x18,
	0x3c,
	0xc6,
	0x00,
	0x7e,
	0x7e,
	0x7e,
	0x30,
	0xd8,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x1c,
	0x00,
	0x00,
	0x00,
	0xb8,
	0x7e,
	0x38,
	0x10,
	0x00,
	0x00,
	0x00,
	0x0f,
	0x00,
	0x18,
	0x38,
	0x00,
	0x60,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x00,
	0x3c,
	0x18,
	0x7e,
	0x00,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xfc,
	0x00,
	0x00,
	0x78,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xf0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x38,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x38,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xf0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x3c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x3c,
	0x00,
	0x00,
	0x00,
	0x7e,
	0x7e,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x70,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x0c,
	0x00,
	0x00,
	0x00,
	0x00,
};

static unsigned char system8x14_data[] =
{
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x38,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0x38,
	0x0e,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0x6c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x76,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xe0,
	0x76,
	0x76,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x38,
	0x70,
	0x38,
	0x66,
	0x70,
	0x0e,
	0x38,
	0x66,
	0x70,
	0x0e,
	0x38,
	0x6c,
	0x00,
	0x70,
	0x0e,
	0x38,
	0x6c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x0e,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x7e,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x3e,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x06,
	0x10,
	0x00,
	0x60,
	0x44,
	0x00,
	0x10,
	0x00,
	0x60,
	0x00,
	0x10,
	0x60,
	0xc6,
	0x44,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x10,
	0x60,
	0x00,
	0xc6,
	0x6c,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x06,
	0x0c,
	0x06,
	0x06,
	0x00,
	0xdc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0xdc,
	0xdc,
	0x3e,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x20,
	0x00,
	0x00,
	0x00,
	0x00,
	0x06,
	0x6c,
	0x18,
	0x6c,
	0x66,
	0x18,
	0x18,
	0x6c,
	0x66,
	0x18,
	0x18,
	0x6c,
	0x38,
	0x00,
	0x18,
	0x18,
	0x6c,
	0x6c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x1b,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x07,
	0x00,
	0x00,
	0x00,
	0x06,
	0xc3,
	0x08,
	0x1c,
	0x10,
	0x08,
	0x7e,
	0xf8,
	0x00,
	0x03,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x40,
	0x01,
	0x00,
	0x00,
	0x7e,
	0x63,
	0x18,
	0x18,
	0x18,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x08,
	0x00,
	0x00,
	0x18,
	0x66,
	0x36,
	0x10,
	0x60,
	0x78,
	0x38,
	0x0c,
	0x60,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x7c,
	0x18,
	0x7c,
	0x7c,
	0x0c,
	0xfe,
	0x0c,
	0xfe,
	0x7c,
	0x7c,
	0x00,
	0x00,
	0x0c,
	0x00,
	0x60,
	0x3c,
	0x7c,
	0x38,
	0xfc,
	0x7c,
	0xf8,
	0x7e,
	0x7e,
	0x7c,
	0xc6,
	0x18,
	0x06,
	0xc6,
	0x60,
	0x82,
	0xc6,
	0x7c,
	0xfc,
	0x7c,
	0xfc,
	0x7c,
	0x7e,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xfe,
	0x3c,
	0x40,
	0x78,
	0x38,
	0x00,
	0x38,
	0x00,
	0xc0,
	0x00,
	0x06,
	0x00,
	0x1e,
	0x00,
	0xc0,
	0x18,
	0x0c,
	0xc0,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x1c,
	0x18,
	0x70,
	0x76,
	0x10,
	0x7c,
	0x6c,
	0x0c,
	0x38,
	0x6c,
	0x30,
	0x44,
	0x00,
	0x38,
	0x6c,
	0x30,
	0x6c,
	0x38,
	0x30,
	0x00,
	0x44,
	0x00,
	0x00,
	0x3e,
	0x76,
	0x6c,
	0x30,
	0x38,
	0x30,
	0x6c,
	0x00,
	0x00,
	0x7c,
	0x3c,
	0x00,
	0xf0,
	0x1e,
	0x0c,
	0x18,
	0x0c,
	0x0c,
	0x76,
	0x00,
	0x3c,
	0x3c,
	0x00,
	0x66,
	0xee,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x76,
	0x76,
	0xc6,
	0x10,
	0x00,
	0x7e,
	0x00,
	0x00,
	0x00,
	0x63,
	0x0c,
	0x18,
	0x7f,
	0x7e,
	0x7e,
	0xf1,
	0x00,
	0x00,
	0x50,
	0x00,
	0x00,
	0x00,
	0x3c,
	0x0c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x6c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x78,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x78,
	0xfe,
	0x00,
	0xfe,
	0x00,
	0x00,
	0x00,
	0x3c,
	0x38,
	0x7c,
	0x3e,
	0x00,
	0x00,
	0x00,
	0x7c,
	0x00,
	0x00,
	0x60,
	0x0c,
	0x1b,
	0x18,
	0x00,
	0x00,
	0x3c,
	0x38,
	0x00,
	0x04,
	0x7c,
	0x3c,
	0x00,
	0x7c,
	0x99,
	0x1c,
	0x1c,
	0x18,
	0x18,
	0x7e,
	0xf8,
	0x10,
	0x03,
	0x00,
	0x18,
	0x0f,
	0x00,
	0x00,
	0x20,
	0x04,
	0x60,
	0x03,
	0x81,
	0x00,
	0xfc,
	0x30,
	0x3c,
	0x3c,
	0x3c,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x08,
	0x7f,
	0x00,
	0x18,
	0x66,
	0x36,
	0x7c,
	0x92,
	0xcc,
	0x18,
	0x18,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x0c,
	0xc6,
	0x38,
	0xc6,
	0xc6,
	0x1c,
	0xc0,
	0x18,
	0x06,
	0xc6,
	0xc6,
	0x00,
	0x00,
	0x18,
	0x00,
	0x30,
	0x66,
	0x86,
	0x6c,
	0xc6,
	0xc6,
	0xcc,
	0x60,
	0x60,
	0xc6,
	0xc6,
	0x18,
	0x06,
	0xc6,
	0x60,
	0xc6,
	0xe6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x06,
	0x30,
	0x60,
	0x18,
	0x6c,
	0x00,
	0x30,
	0x00,
	0xc0,
	0x00,
	0x06,
	0x00,
	0x33,
	0x00,
	0xc0,
	0x18,
	0x0c,
	0xc0,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x18,
	0x18,
	0xdc,
	0x38,
	0xc6,
	0x6c,
	0x18,
	0x6c,
	0x6c,
	0x18,
	0x38,
	0x00,
	0x6c,
	0x6c,
	0x18,
	0x6c,
	0x6c,
	0x18,
	0x38,
	0x38,
	0x7e,
	0x00,
	0x68,
	0xdc,
	0x6c,
	0x18,
	0x6c,
	0x18,
	0x6c,
	0x7c,
	0xc6,
	0xc6,
	0x66,
	0x00,
	0x88,
	0x30,
	0x18,
	0x30,
	0x18,
	0x18,
	0xdc,
	0xc6,
	0x06,
	0x66,
	0x00,
	0xcc,
	0x66,
	0x18,
	0x30,
	0x00,
	0x00,
	0x00,
	0xdc,
	0xdc,
	0xc6,
	0x10,
	0x00,
	0xc8,
	0x38,
	0x38,
	0x7c,
	0x30,
	0x18,
	0x18,
	0xdb,
	0x81,
	0x81,
	0x5b,
	0x00,
	0x00,
	0x50,
	0x00,
	0x00,
	0x00,
	0x66,
	0x18,
	0x38,
	0x7e,
	0x7e,
	0x7e,
	0x18,
	0x18,
	0x18,
	0x18,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x38,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0x62,
	0x00,
	0x62,
	0x00,
	0x00,
	0x00,
	0x18,
	0x6c,
	0xc6,
	0x30,
	0x00,
	0x10,
	0x00,
	0xc6,
	0x00,
	0x18,
	0x30,
	0x18,
	0x18,
	0x18,
	0x18,
	0x00,
	0x66,
	0x7c,
	0x00,
	0x04,
	0x66,
	0x66,
	0x00,
	0xc6,
	0x99,
	0x3e,
	0x1c,
	0x1c,
	0x38,
	0x7e,
	0xf8,
	0x38,
	0x06,
	0x3c,
	0x24,
	0x0e,
	0x00,
	0x00,
	0x30,
	0x0c,
	0x70,
	0x07,
	0xc3,
	0x00,
	0xfc,
	0x1c,
	0x7e,
	0x7e,
	0x7e,
	0x18,
	0x0c,
	0x18,
	0x00,
	0x24,
	0x1c,
	0x7f,
	0x00,
	0x18,
	0x66,
	0xfe,
	0xd6,
	0x94,
	0xcc,
	0x18,
	0x30,
	0x18,
	0x6c,
	0x18,
	0x00,
	0x00,
	0x00,
	0x08,
	0xc6,
	0x78,
	0xc6,
	0x06,
	0x3c,
	0xc0,
	0x30,
	0x06,
	0xc6,
	0xc6,
	0x18,
	0x18,
	0x30,
	0x00,
	0x18,
	0x66,
	0x9e,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x60,
	0x60,
	0xc0,
	0xc6,
	0x18,
	0x06,
	0xcc,
	0x60,
	0xee,
	0xf6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x18,
	0xc6,
	0xc6,
	0xd6,
	0xc6,
	0xc6,
	0x0c,
	0x30,
	0x20,
	0x18,
	0xc6,
	0x00,
	0x30,
	0x00,
	0xc0,
	0x00,
	0x06,
	0x00,
	0x30,
	0x00,
	0xc0,
	0x00,
	0x00,
	0xc0,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x18,
	0x18,
	0x00,
	0x6c,
	0xc6,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x6c,
	0x6c,
	0x60,
	0x00,
	0xc8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc6,
	0xce,
	0x60,
	0x06,
	0x88,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xe6,
	0x3e,
	0x66,
	0x30,
	0xcc,
	0x66,
	0x30,
	0x18,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0x7c,
	0x00,
	0xc8,
	0x6c,
	0x6c,
	0xc6,
	0x1c,
	0x00,
	0x7e,
	0xdb,
	0x9d,
	0xbd,
	0x55,
	0x00,
	0x00,
	0x2e,
	0x18,
	0x00,
	0x00,
	0x66,
	0x00,
	0x6c,
	0x60,
	0x60,
	0x60,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x00,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0x60,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x7e,
	0xc6,
	0xc6,
	0x18,
	0x66,
	0x10,
	0x00,
	0xc6,
	0xfe,
	0x18,
	0x18,
	0x30,
	0x18,
	0x18,
	0x18,
	0x76,
	0x66,
	0x7c,
	0x00,
	0x04,
	0x66,
	0x06,
	0x00,
	0xce,
	0xf3,
	0x7f,
	0x1c,
	0xfe,
	0x7f,
	0x7e,
	0xf8,
	0x7c,
	0x06,
	0x42,
	0x42,
	0x08,
	0x08,
	0x7f,
	0x38,
	0x1c,
	0x7c,
	0x1f,
	0xe7,
	0x00,
	0xfc,
	0x36,
	0x18,
	0x18,
	0x18,
	0x18,
	0x06,
	0x30,
	0x60,
	0x66,
	0x1c,
	0x3e,
	0x00,
	0x18,
	0x24,
	0x6c,
	0xd0,
	0x68,
	0xd8,
	0x30,
	0x30,
	0x18,
	0x38,
	0x18,
	0x00,
	0x00,
	0x00,
	0x18,
	0xce,
	0x18,
	0x06,
	0x06,
	0x6c,
	0xfc,
	0x60,
	0x0c,
	0xc6,
	0xc6,
	0x18,
	0x18,
	0x60,
	0xfe,
	0x0c,
	0x0c,
	0xb6,
	0xc6,
	0xc6,
	0xc0,
	0xc6,
	0x60,
	0x60,
	0xc0,
	0xc6,
	0x18,
	0x06,
	0xd8,
	0x60,
	0xd6,
	0xde,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x60,
	0x18,
	0xc6,
	0xc6,
	0xd6,
	0x6c,
	0xc6,
	0x18,
	0x30,
	0x30,
	0x18,
	0x00,
	0x00,
	0x18,
	0x7c,
	0xdc,
	0x7c,
	0x7e,
	0x7c,
	0x30,
	0x7e,
	0xdc,
	0x18,
	0x0c,
	0xc6,
	0x18,
	0xec,
	0xdc,
	0x7c,
	0xdc,
	0x7e,
	0xdc,
	0x7c,
	0xfc,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xfe,
	0x30,
	0x18,
	0x18,
	0x00,
	0xc6,
	0xc0,
	0xc6,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0x60,
	0x7c,
	0xc8,
	0x7c,
	0x7c,
	0x7c,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xde,
	0x60,
	0x7c,
	0xf8,
	0x30,
	0x7c,
	0x18,
	0x7c,
	0xc6,
	0xdc,
	0xf6,
	0x66,
	0x66,
	0x30,
	0xee,
	0xcc,
	0x60,
	0x0c,
	0x30,
	0x66,
	0xcc,
	0x7c,
	0x7c,
	0x6c,
	0xd6,
	0x7c,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0x36,
	0x00,
	0x18,
	0xdb,
	0xb1,
	0xa5,
	0x51,
	0x00,
	0x00,
	0x38,
	0x3c,
	0x00,
	0x00,
	0x3c,
	0x7c,
	0xc6,
	0x60,
	0x60,
	0x60,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0x60,
	0x7c,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x76,
	0xc8,
	0x60,
	0xfe,
	0x18,
	0x7f,
	0x66,
	0xfe,
	0xdb,
	0xc6,
	0xc6,
	0x0c,
	0xdb,
	0x7c,
	0x7c,
	0xc6,
	0x00,
	0x7e,
	0x0c,
	0x60,
	0x18,
	0x18,
	0x00,
	0xdc,
	0x3c,
	0x38,
	0x00,
	0x04,
	0x66,
	0x3c,
	0x3c,
	0xde,
	0xe7,
	0x1c,
	0x1c,
	0xff,
	0xff,
	0x7e,
	0xf8,
	0xfe,
	0xcc,
	0x91,
	0x42,
	0x08,
	0x1c,
	0x3e,
	0x3c,
	0x3c,
	0x7f,
	0x7f,
	0xff,
	0x00,
	0x7c,
	0x63,
	0x18,
	0x18,
	0x18,
	0x18,
	0x7f,
	0x7f,
	0x60,
	0xff,
	0x3e,
	0x3e,
	0x00,
	0x18,
	0x00,
	0x6c,
	0x7c,
	0x10,
	0x70,
	0x00,
	0x30,
	0x18,
	0xfe,
	0x7e,
	0x00,
	0x7e,
	0x00,
	0x10,
	0xd6,
	0x18,
	0x1c,
	0x3c,
	0xcc,
	0x06,
	0xfc,
	0x18,
	0x7c,
	0x7e,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x06,
	0x18,
	0xb6,
	0xc6,
	0xfc,
	0xc0,
	0xc6,
	0x7c,
	0x7c,
	0xde,
	0xfe,
	0x18,
	0x06,
	0xf0,
	0x60,
	0xd6,
	0xce,
	0xc6,
	0xc6,
	0xc6,
	0xfc,
	0x38,
	0x18,
	0xc6,
	0xc6,
	0xd6,
	0x38,
	0x6c,
	0x30,
	0x30,
	0x10,
	0x18,
	0x00,
	0x00,
	0x00,
	0x06,
	0xe6,
	0xc6,
	0xc6,
	0xc6,
	0x7e,
	0xc6,
	0xe6,
	0x18,
	0x0c,
	0xcc,
	0x18,
	0xd6,
	0xe6,
	0xc6,
	0xe6,
	0xc6,
	0xe6,
	0xc6,
	0x60,
	0xc6,
	0xc6,
	0xc6,
	0x6c,
	0xc6,
	0x0c,
	0xe0,
	0x18,
	0x0e,
	0x00,
	0xc6,
	0xc0,
	0xc6,
	0xc6,
	0x06,
	0x06,
	0x06,
	0x06,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0x7c,
	0x16,
	0xfe,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xf6,
	0xf8,
	0xce,
	0x92,
	0x7c,
	0x06,
	0x18,
	0xc6,
	0xc6,
	0xe6,
	0xde,
	0x66,
	0x66,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x06,
	0x00,
	0xcc,
	0x66,
	0x06,
	0xc6,
	0xfe,
	0xd0,
	0xd6,
	0xce,
	0xc6,
	0xc6,
	0xc6,
	0x63,
	0x00,
	0x18,
	0x5b,
	0xb1,
	0xbd,
	0x00,
	0x00,
	0x00,
	0xe0,
	0x3c,
	0x7e,
	0xff,
	0x00,
	0x06,
	0xc6,
	0x7c,
	0x7c,
	0x7c,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0x38,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x6c,
	0xdc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0xdc,
	0x60,
	0x6c,
	0x0c,
	0xcc,
	0x66,
	0x30,
	0xdb,
	0xfe,
	0xc6,
	0x7c,
	0xdb,
	0xd6,
	0xc6,
	0xc6,
	0xfe,
	0x18,
	0x18,
	0x30,
	0x18,
	0x18,
	0x7e,
	0x00,
	0x00,
	0x00,
	0x18,
	0x04,
	0x66,
	0x60,
	0x3c,
	0xf6,
	0xe7,
	0x1c,
	0x1c,
	0xfe,
	0x7f,
	0x7e,
	0xf8,
	0x7c,
	0xcc,
	0x8f,
	0x42,
	0x08,
	0x3e,
	0x1c,
	0x38,
	0x1c,
	0x7c,
	0x1f,
	0xe7,
	0x00,
	0x0c,
	0x63,
	0x18,
	0x7e,
	0x18,
	0x18,
	0x06,
	0x30,
	0x60,
	0x66,
	0x3e,
	0x1c,
	0x00,
	0x18,
	0x00,
	0xfe,
	0x16,
	0x2c,
	0xda,
	0x00,
	0x30,
	0x18,
	0x38,
	0x18,
	0x00,
	0x00,
	0x00,
	0x30,
	0xe6,
	0x18,
	0x70,
	0x06,
	0xcc,
	0x06,
	0xc6,
	0x30,
	0xc6,
	0x0c,
	0x00,
	0x00,
	0x60,
	0xfe,
	0x0c,
	0x18,
	0xb6,
	0xfe,
	0xc6,
	0xc0,
	0xc6,
	0x60,
	0x60,
	0xc6,
	0xc6,
	0x18,
	0x06,
	0xd8,
	0x60,
	0xd6,
	0xc6,
	0xc6,
	0xfc,
	0xc6,
	0xd8,
	0x0c,
	0x18,
	0xc6,
	0xc6,
	0xd6,
	0x6c,
	0x38,
	0x60,
	0x30,
	0x18,
	0x18,
	0x00,
	0x00,
	0x00,
	0x7e,
	0xc6,
	0xc0,
	0xc6,
	0xfe,
	0x30,
	0xc6,
	0xc6,
	0x18,
	0x0c,
	0xd8,
	0x18,
	0xd6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x70,
	0x60,
	0xc6,
	0xc6,
	0xd6,
	0x38,
	0xc6,
	0x18,
	0x20,
	0x18,
	0x08,
	0x00,
	0xc6,
	0xc0,
	0xc6,
	0xfe,
	0x7e,
	0x7e,
	0x7e,
	0x7e,
	0xc0,
	0xfe,
	0xfe,
	0xfe,
	0x18,
	0x18,
	0x18,
	0xfe,
	0xfe,
	0x60,
	0x7e,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xe6,
	0x60,
	0xde,
	0xbc,
	0x30,
	0x7e,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xce,
	0x3b,
	0x3c,
	0x30,
	0x00,
	0x00,
	0x60,
	0x0c,
	0x30,
	0xcc,
	0x66,
	0x7e,
	0xc6,
	0x30,
	0xd0,
	0xde,
	0xc8,
	0xfe,
	0xfe,
	0xc6,
	0x63,
	0x00,
	0x18,
	0x1b,
	0xb1,
	0xa9,
	0x00,
	0x00,
	0x00,
	0x44,
	0x18,
	0x7e,
	0xff,
	0x00,
	0x7e,
	0xfe,
	0x60,
	0x60,
	0x60,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0x0c,
	0x70,
	0xc6,
	0xc6,
	0xc6,
	0x38,
	0xc6,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0xc6,
	0x60,
	0x6c,
	0x18,
	0xc6,
	0x66,
	0x30,
	0xdb,
	0xc6,
	0xc6,
	0xc6,
	0xdb,
	0xd6,
	0x70,
	0xc6,
	0x00,
	0x18,
	0x30,
	0x18,
	0x18,
	0x18,
	0x00,
	0x76,
	0x00,
	0x00,
	0x18,
	0x44,
	0x66,
	0x7e,
	0x3c,
	0xe6,
	0xff,
	0x1c,
	0x7f,
	0x1c,
	0x38,
	0x7e,
	0xf9,
	0x38,
	0x6c,
	0x81,
	0x42,
	0x08,
	0x7f,
	0x08,
	0x30,
	0x0c,
	0x70,
	0x07,
	0xc3,
	0x00,
	0x0c,
	0x36,
	0x7e,
	0x3c,
	0x18,
	0x7e,
	0x0c,
	0x18,
	0x7f,
	0x24,
	0x7f,
	0x1c,
	0x00,
	0x00,
	0x00,
	0xd8,
	0xd6,
	0x52,
	0xcc,
	0x00,
	0x30,
	0x18,
	0x6c,
	0x18,
	0x00,
	0x00,
	0x00,
	0x20,
	0xc6,
	0x18,
	0xc0,
	0x06,
	0xfe,
	0xc6,
	0xc6,
	0x60,
	0xc6,
	0x18,
	0x00,
	0x00,
	0x30,
	0x00,
	0x18,
	0x00,
	0x9e,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x60,
	0x60,
	0xc6,
	0xc6,
	0x18,
	0x06,
	0xcc,
	0x60,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0xf6,
	0xcc,
	0xc6,
	0x18,
	0xc6,
	0x6c,
	0x6c,
	0xc6,
	0x30,
	0xc0,
	0x30,
	0x08,
	0x18,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc6,
	0xc0,
	0xc6,
	0xc0,
	0x30,
	0xce,
	0xc6,
	0x18,
	0x0c,
	0xf8,
	0x18,
	0xd6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0x1c,
	0x60,
	0xc6,
	0x6c,
	0xd6,
	0x38,
	0x6c,
	0x30,
	0x30,
	0x18,
	0x18,
	0x00,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0xc0,
	0xc0,
	0xc0,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0x60,
	0xd0,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x6c,
	0xc6,
	0xc6,
	0xc6,
	0x60,
	0xf6,
	0x96,
	0x30,
	0xc6,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x30,
	0x18,
	0x30,
	0xcc,
	0x66,
	0xc6,
	0xc6,
	0xfe,
	0xd6,
	0xd0,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0x36,
	0x00,
	0x18,
	0x1b,
	0x9d,
	0xa5,
	0x00,
	0xee,
	0x00,
	0xaa,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc6,
	0x60,
	0x60,
	0x60,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x1c,
	0xc6,
	0xc6,
	0xc6,
	0x30,
	0xc6,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0xc6,
	0x60,
	0x6c,
	0x30,
	0xc6,
	0x66,
	0x30,
	0x7e,
	0xc6,
	0x6c,
	0xc6,
	0x66,
	0xd6,
	0xc0,
	0xc6,
	0xfe,
	0x00,
	0x60,
	0x0c,
	0x18,
	0x18,
	0x18,
	0xdc,
	0x00,
	0x00,
	0x00,
	0xe4,
	0x00,
	0x00,
	0x3c,
	0xc6,
	0xe7,
	0x1c,
	0x3e,
	0x18,
	0x18,
	0x7e,
	0x05,
	0x10,
	0x38,
	0x42,
	0xff,
	0x78,
	0x00,
	0x00,
	0x20,
	0x04,
	0x60,
	0x03,
	0x81,
	0x00,
	0x0c,
	0x1c,
	0x3c,
	0x18,
	0x18,
	0x3c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x7f,
	0x08,
	0x00,
	0x18,
	0x00,
	0xd8,
	0x7c,
	0x92,
	0xcc,
	0x00,
	0x30,
	0x18,
	0x00,
	0x00,
	0x38,
	0x00,
	0x18,
	0x60,
	0xc6,
	0x18,
	0xc0,
	0xc6,
	0x0c,
	0xc6,
	0xc6,
	0x60,
	0xc6,
	0x30,
	0x18,
	0x38,
	0x18,
	0x00,
	0x30,
	0x18,
	0x80,
	0xc6,
	0xc6,
	0xc6,
	0xcc,
	0x60,
	0x60,
	0xc6,
	0xc6,
	0x18,
	0xc6,
	0xc6,
	0x60,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0xdc,
	0xcc,
	0xc6,
	0x18,
	0xc6,
	0x38,
	0x6c,
	0xc6,
	0x30,
	0xc0,
	0x30,
	0x0c,
	0x18,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc6,
	0xc6,
	0xce,
	0xc6,
	0x30,
	0x76,
	0xc6,
	0x18,
	0x0c,
	0xcc,
	0x18,
	0xd6,
	0xc6,
	0xc6,
	0xc6,
	0xce,
	0xc0,
	0xc6,
	0x66,
	0xce,
	0x38,
	0x6c,
	0x6c,
	0x38,
	0x60,
	0x30,
	0x18,
	0x18,
	0x00,
	0xc6,
	0xc6,
	0xce,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0x60,
	0xd0,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0xce,
	0xce,
	0x38,
	0xc6,
	0xc6,
	0xc6,
	0x40,
	0xe6,
	0x92,
	0x30,
	0xc6,
	0x18,
	0xc6,
	0xce,
	0xc6,
	0xc6,
	0x00,
	0x00,
	0x60,
	0x00,
	0x00,
	0x18,
	0x30,
	0x30,
	0x66,
	0xcc,
	0xc6,
	0xc6,
	0x30,
	0x7c,
	0xd0,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0x1c,
	0x00,
	0x18,
	0x1b,
	0x81,
	0x81,
	0x00,
	0x66,
	0xdb,
	0xaa,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc6,
	0x60,
	0x60,
	0x60,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x30,
	0xe6,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0xe6,
	0x60,
	0x6c,
	0x62,
	0xc6,
	0x66,
	0x30,
	0x18,
	0x6c,
	0x6c,
	0xc6,
	0x00,
	0xd6,
	0xc6,
	0xc6,
	0x00,
	0x7e,
	0x00,
	0x00,
	0x18,
	0x18,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x34,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xe7,
	0x1c,
	0x1c,
	0x10,
	0x08,
	0x7e,
	0x03,
	0x00,
	0x18,
	0x3c,
	0x10,
	0xf0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x40,
	0x01,
	0x00,
	0xff,
	0x0c,
	0x06,
	0x18,
	0x7e,
	0x18,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x00,
	0x00,
	0x10,
	0x0c,
	0x76,
	0x00,
	0x18,
	0x30,
	0x00,
	0x00,
	0x18,
	0x00,
	0x18,
	0x40,
	0x7c,
	0x18,
	0xfe,
	0x7c,
	0x0c,
	0x7c,
	0x7c,
	0x60,
	0x7c,
	0x60,
	0x18,
	0x18,
	0x0c,
	0x00,
	0x60,
	0x18,
	0x7c,
	0xc6,
	0xfc,
	0x7c,
	0xf8,
	0x7e,
	0x60,
	0x7a,
	0xc6,
	0x18,
	0x7c,
	0xc6,
	0x7e,
	0xc6,
	0xc6,
	0x7c,
	0xc0,
	0x7c,
	0xc6,
	0x7c,
	0x18,
	0x7c,
	0x10,
	0x44,
	0xc6,
	0x30,
	0xfe,
	0x30,
	0x04,
	0x18,
	0x00,
	0x00,
	0x00,
	0x7e,
	0xfc,
	0x7c,
	0x76,
	0x7c,
	0x30,
	0x06,
	0xc6,
	0x18,
	0x0c,
	0xc6,
	0x0e,
	0xc6,
	0xc6,
	0x7c,
	0xfc,
	0x76,
	0xc0,
	0x7c,
	0x3c,
	0x76,
	0x10,
	0x44,
	0xc6,
	0x30,
	0xfe,
	0x30,
	0x18,
	0x18,
	0x00,
	0xfe,
	0x7c,
	0x76,
	0x7c,
	0x7e,
	0x7e,
	0x7e,
	0x7e,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0x7e,
	0x7e,
	0xce,
	0x7c,
	0x7c,
	0x7c,
	0x76,
	0x76,
	0x30,
	0x7c,
	0x7c,
	0x7c,
	0xfe,
	0x7c,
	0x94,
	0x30,
	0x7e,
	0x18,
	0x7c,
	0x76,
	0xc6,
	0xc6,
	0x7e,
	0x7e,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x7e,
	0x7c,
	0x30,
	0x10,
	0x7e,
	0x7e,
	0xc6,
	0xc6,
	0x7c,
	0x06,
	0x00,
	0x18,
	0x1b,
	0x7e,
	0x7e,
	0x00,
	0x66,
	0xdb,
	0x44,
	0x00,
	0x00,
	0x00,
	0x00,
	0x7e,
	0xc6,
	0x7e,
	0x7e,
	0x7e,
	0x18,
	0x18,
	0x18,
	0x18,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x30,
	0xdc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x76,
	0xdc,
	0xf0,
	0x66,
	0xfe,
	0x7c,
	0x7c,
	0x1c,
	0x3c,
	0x38,
	0xee,
	0x7c,
	0x00,
	0x7c,
	0x7c,
	0xc6,
	0x00,
	0x00,
	0xfe,
	0xfe,
	0x18,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x1c,
	0x00,
	0x00,
	0x00,
	0x7c,
	0x7e,
	0x1c,
	0x08,
	0x00,
	0x00,
	0x7e,
	0x0f,
	0x00,
	0x00,
	0x00,
	0x30,
	0x60,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x0c,
	0x63,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x0c,
	0x60,
	0x00,
	0x00,
	0x18,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x3c,
	0x06,
	0x78,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0x00,
	0x00,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x00,
	0x1c,
	0x18,
	0x70,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x00,
	0x00,
	0xc0,
	0x00,
	0xc0,
	0x00,
	0xe0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x63,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0xd8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x0c,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x0c,
	0x3e,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x7c,
	0x00,
	0x00,
	0x78,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x70,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x70,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x78,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x3e,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0xd8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x70,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
};


unsigned char system8x16_data[] =
{
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0x38,
	0x0e,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0x6c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x76,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xe0,
	0x76,
	0x76,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x38,
	0x70,
	0x38,
	0x66,
	0x70,
	0x0e,
	0x38,
	0x66,
	0x70,
	0x0e,
	0x38,
	0x6c,
	0x00,
	0x70,
	0x0e,
	0x38,
	0x6c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x0e,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x38,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0x44,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0x6c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xdc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0xdc,
	0xdc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x6c,
	0x18,
	0x6c,
	0x66,
	0x18,
	0x18,
	0x6c,
	0x66,
	0x18,
	0x18,
	0x6c,
	0x38,
	0x00,
	0x18,
	0x18,
	0x6c,
	0x6c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x1b,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x7e,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x3e,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x06,
	0x10,
	0x00,
	0x60,
	0x44,
	0x00,
	0x10,
	0x00,
	0x60,
	0x00,
	0x10,
	0x60,
	0x00,
	0x44,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x10,
	0x60,
	0x00,
	0x00,
	0x00,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x06,
	0x0c,
	0x06,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x3e,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x1b,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x07,
	0x00,
	0x00,
	0x00,
	0x06,
	0xc3,
	0x08,
	0x1c,
	0x10,
	0x08,
	0x7e,
	0xf8,
	0x00,
	0x03,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x40,
	0x01,
	0x00,
	0x00,
	0x7e,
	0x63,
	0x18,
	0x18,
	0x18,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x08,
	0x00,
	0x00,
	0x18,
	0x66,
	0x36,
	0x10,
	0x62,
	0x78,
	0x38,
	0x0c,
	0x60,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x04,
	0x7c,
	0x18,
	0x7c,
	0x7c,
	0x0c,
	0xfe,
	0x0c,
	0xfe,
	0x7c,
	0x7c,
	0x00,
	0x00,
	0x0c,
	0x00,
	0x60,
	0x3c,
	0x7c,
	0x38,
	0xfc,
	0x7c,
	0xf8,
	0x7e,
	0x7e,
	0x7c,
	0xc6,
	0x18,
	0x06,
	0xc6,
	0x60,
	0x82,
	0xc6,
	0x7c,
	0xfc,
	0x7c,
	0xfc,
	0x7c,
	0x7e,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xfe,
	0x3c,
	0x40,
	0x78,
	0x38,
	0x00,
	0x38,
	0x00,
	0xc0,
	0x00,
	0x06,
	0x00,
	0x1e,
	0x00,
	0xc0,
	0x18,
	0x0c,
	0xc0,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x1c,
	0x18,
	0x70,
	0x76,
	0x10,
	0x7c,
	0x6c,
	0x0c,
	0x38,
	0x6c,
	0x30,
	0x44,
	0x00,
	0x38,
	0x6c,
	0x30,
	0x6c,
	0x38,
	0x30,
	0x38,
	0x38,
	0x7e,
	0x00,
	0x3e,
	0x76,
	0x6c,
	0x30,
	0x38,
	0x30,
	0x6c,
	0x7c,
	0xc6,
	0x7c,
	0x3c,
	0x00,
	0xf0,
	0x1e,
	0x0c,
	0x18,
	0x0c,
	0x0c,
	0x76,
	0xc6,
	0x3c,
	0x3c,
	0x00,
	0x66,
	0xee,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x76,
	0x76,
	0xc6,
	0x10,
	0x00,
	0x7e,
	0x38,
	0x38,
	0x7c,
	0x63,
	0x0c,
	0x18,
	0x7f,
	0x7e,
	0x7e,
	0xf1,
	0x00,
	0x00,
	0x20,
	0x00,
	0x00,
	0x00,
	0x3c,
	0x0c,
	0x38,
	0x7e,
	0x7e,
	0x7e,
	0x18,
	0x18,
	0x18,
	0x18,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x6c,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x78,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x78,
	0xfe,
	0x00,
	0xfe,
	0x00,
	0x00,
	0x00,
	0x3c,
	0x38,
	0x7c,
	0x3e,
	0x00,
	0x00,
	0x00,
	0x7c,
	0x00,
	0x00,
	0x60,
	0x0c,
	0x18,
	0x18,
	0x00,
	0x00,
	0x3c,
	0x38,
	0x00,
	0x04,
	0x7c,
	0x3c,
	0x00,
	0x7c,
	0x99,
	0x1c,
	0x1c,
	0x18,
	0x18,
	0x7e,
	0xf8,
	0x10,
	0x03,
	0x00,
	0x18,
	0x0f,
	0x00,
	0x00,
	0x20,
	0x04,
	0x60,
	0x03,
	0x81,
	0x00,
	0xfc,
	0x30,
	0x3c,
	0x3c,
	0x3c,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x08,
	0x7f,
	0x00,
	0x18,
	0x66,
	0x36,
	0x7c,
	0x94,
	0xcc,
	0x18,
	0x18,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x0c,
	0xc6,
	0x38,
	0xc6,
	0xc6,
	0x1c,
	0xc0,
	0x18,
	0x06,
	0xc6,
	0xc6,
	0x00,
	0x00,
	0x18,
	0x00,
	0x30,
	0x66,
	0x86,
	0x6c,
	0xc6,
	0xc6,
	0xcc,
	0x60,
	0x60,
	0xc6,
	0xc6,
	0x18,
	0x06,
	0xc6,
	0x60,
	0xc6,
	0xe6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x06,
	0x30,
	0x60,
	0x18,
	0x6c,
	0x00,
	0x30,
	0x00,
	0xc0,
	0x00,
	0x06,
	0x00,
	0x33,
	0x00,
	0xc0,
	0x18,
	0x0c,
	0xc0,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x18,
	0x18,
	0xdc,
	0x38,
	0xc6,
	0x6c,
	0x18,
	0x6c,
	0x6c,
	0x18,
	0x38,
	0x00,
	0x6c,
	0x6c,
	0x18,
	0x6c,
	0x6c,
	0x18,
	0x6c,
	0x6c,
	0x60,
	0x00,
	0x68,
	0xdc,
	0x6c,
	0x18,
	0x6c,
	0x18,
	0x6c,
	0xc6,
	0xc6,
	0xc6,
	0x66,
	0x00,
	0x88,
	0x30,
	0x18,
	0x30,
	0x18,
	0x18,
	0xdc,
	0xe6,
	0x06,
	0x66,
	0x00,
	0xcc,
	0x66,
	0x18,
	0x30,
	0x00,
	0x00,
	0x00,
	0xdc,
	0xdc,
	0xc6,
	0x10,
	0x00,
	0xc8,
	0x6c,
	0x6c,
	0xc6,
	0x30,
	0x18,
	0x18,
	0xdb,
	0x81,
	0x81,
	0x5b,
	0x00,
	0x00,
	0x50,
	0x00,
	0x00,
	0x00,
	0x66,
	0x18,
	0x6c,
	0x60,
	0x60,
	0x60,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x38,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0x62,
	0x00,
	0x62,
	0x00,
	0x00,
	0x00,
	0x18,
	0x6c,
	0xc6,
	0x30,
	0x00,
	0x10,
	0x00,
	0xc6,
	0x00,
	0x18,
	0x30,
	0x18,
	0x18,
	0x18,
	0x18,
	0x00,
	0x66,
	0x7c,
	0x00,
	0x04,
	0x66,
	0x66,
	0x00,
	0xc6,
	0x99,
	0x3e,
	0x1c,
	0x1c,
	0x38,
	0x7e,
	0xf8,
	0x38,
	0x06,
	0x3c,
	0x24,
	0x0e,
	0x00,
	0x00,
	0x30,
	0x0c,
	0x70,
	0x07,
	0xc3,
	0x00,
	0xfc,
	0x1c,
	0x7e,
	0x7e,
	0x7e,
	0x18,
	0x0c,
	0x18,
	0x00,
	0x24,
	0x1c,
	0x7f,
	0x00,
	0x18,
	0x66,
	0xfe,
	0xd6,
	0x94,
	0xcc,
	0x18,
	0x30,
	0x18,
	0x6c,
	0x18,
	0x00,
	0x00,
	0x00,
	0x08,
	0xc6,
	0x78,
	0xc6,
	0x06,
	0x3c,
	0xc0,
	0x30,
	0x06,
	0xc6,
	0xc6,
	0x18,
	0x18,
	0x30,
	0x00,
	0x18,
	0x66,
	0x9e,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x60,
	0x60,
	0xc0,
	0xc6,
	0x18,
	0x06,
	0xcc,
	0x60,
	0xee,
	0xf6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x0c,
	0x30,
	0x20,
	0x18,
	0xc6,
	0x00,
	0x30,
	0x00,
	0xc0,
	0x00,
	0x06,
	0x00,
	0x30,
	0x00,
	0xc0,
	0x00,
	0x00,
	0xc0,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x18,
	0x18,
	0x00,
	0x6c,
	0xc6,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc6,
	0x60,
	0x00,
	0xc8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc6,
	0xce,
	0x60,
	0x06,
	0x88,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xf6,
	0x06,
	0x66,
	0x30,
	0xcc,
	0x66,
	0x30,
	0x18,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0x7c,
	0x00,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0x1c,
	0x00,
	0x7e,
	0xdb,
	0x9d,
	0xbd,
	0x55,
	0x00,
	0x00,
	0x50,
	0x18,
	0x00,
	0x00,
	0x66,
	0x00,
	0xc6,
	0x60,
	0x60,
	0x60,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x00,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0x60,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x7e,
	0xc6,
	0xc6,
	0x18,
	0x66,
	0x10,
	0x00,
	0xc6,
	0xfe,
	0x18,
	0x18,
	0x30,
	0x18,
	0x18,
	0x18,
	0x76,
	0x66,
	0x7c,
	0x00,
	0x04,
	0x66,
	0x06,
	0x00,
	0xce,
	0xf3,
	0x7f,
	0x1c,
	0xfe,
	0x7f,
	0x7e,
	0xf8,
	0x7c,
	0x06,
	0x42,
	0x42,
	0x08,
	0x08,
	0x7f,
	0x38,
	0x1c,
	0x7c,
	0x1f,
	0xe7,
	0x00,
	0xfc,
	0x36,
	0x18,
	0x18,
	0x18,
	0x18,
	0x06,
	0x30,
	0x60,
	0x66,
	0x1c,
	0x3e,
	0x00,
	0x18,
	0x24,
	0x6c,
	0xd0,
	0x68,
	0xd8,
	0x30,
	0x30,
	0x18,
	0x38,
	0x18,
	0x00,
	0x00,
	0x00,
	0x18,
	0xce,
	0x18,
	0x06,
	0x06,
	0x6c,
	0xfc,
	0x60,
	0x0c,
	0xc6,
	0xc6,
	0x18,
	0x18,
	0x60,
	0xfe,
	0x0c,
	0x06,
	0xb6,
	0xc6,
	0xc6,
	0xc0,
	0xc6,
	0x60,
	0x60,
	0xc0,
	0xc6,
	0x18,
	0x06,
	0xd8,
	0x60,
	0xd6,
	0xde,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x60,
	0x18,
	0xc6,
	0xc6,
	0xd6,
	0x6c,
	0xc6,
	0x0c,
	0x30,
	0x30,
	0x18,
	0x00,
	0x00,
	0x18,
	0x7c,
	0xdc,
	0x7c,
	0x7e,
	0x7c,
	0x30,
	0x7e,
	0xdc,
	0x18,
	0x0c,
	0xc6,
	0x18,
	0xec,
	0xdc,
	0x7c,
	0xdc,
	0x7e,
	0xdc,
	0x7c,
	0xfc,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xfe,
	0x30,
	0x18,
	0x18,
	0x00,
	0xc6,
	0xc0,
	0xc6,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0x60,
	0x7c,
	0xc8,
	0x7c,
	0x7c,
	0x7c,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xce,
	0x60,
	0x7c,
	0xf8,
	0x30,
	0x7c,
	0x18,
	0x7c,
	0xc6,
	0xdc,
	0xde,
	0x3e,
	0x66,
	0x30,
	0xee,
	0xcc,
	0x60,
	0x0c,
	0x30,
	0x66,
	0xcc,
	0x7c,
	0x7c,
	0x6c,
	0xd6,
	0x7c,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0x36,
	0x00,
	0x18,
	0xdb,
	0xb1,
	0xa5,
	0x51,
	0x00,
	0x00,
	0x2e,
	0x3c,
	0x00,
	0x00,
	0x3c,
	0x7c,
	0xc6,
	0x60,
	0x60,
	0x60,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0x60,
	0x7c,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x76,
	0xc8,
	0x60,
	0xfe,
	0x18,
	0x7f,
	0x66,
	0xfe,
	0xdb,
	0xc6,
	0xc6,
	0x0c,
	0xdb,
	0x7c,
	0x7c,
	0xc6,
	0x00,
	0x7e,
	0x0c,
	0x60,
	0x18,
	0x18,
	0x00,
	0xdc,
	0x3c,
	0x38,
	0x00,
	0x04,
	0x66,
	0x3c,
	0x3c,
	0xce,
	0xe7,
	0x1c,
	0x1c,
	0xff,
	0xff,
	0x7e,
	0xf8,
	0xfe,
	0xc6,
	0xa1,
	0x42,
	0x08,
	0x1c,
	0x7f,
	0x3c,
	0x3c,
	0x7f,
	0x7f,
	0xff,
	0x00,
	0x7c,
	0x63,
	0x18,
	0x18,
	0x18,
	0x18,
	0x7f,
	0x7f,
	0x60,
	0xff,
	0x3e,
	0x3e,
	0x00,
	0x18,
	0x00,
	0x6c,
	0x7c,
	0x10,
	0x70,
	0x00,
	0x30,
	0x18,
	0xfe,
	0x7e,
	0x00,
	0x7e,
	0x00,
	0x10,
	0xde,
	0x18,
	0x0c,
	0x3c,
	0x6c,
	0x06,
	0xfc,
	0x18,
	0x7c,
	0x7e,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x06,
	0x0c,
	0xb6,
	0xc6,
	0xfc,
	0xc0,
	0xc6,
	0x7c,
	0x7c,
	0xde,
	0xfe,
	0x18,
	0x06,
	0xf0,
	0x60,
	0xd6,
	0xce,
	0xc6,
	0xc6,
	0xc6,
	0xfc,
	0x30,
	0x18,
	0xc6,
	0xc6,
	0xd6,
	0x38,
	0x6c,
	0x18,
	0x30,
	0x10,
	0x18,
	0x00,
	0x00,
	0x00,
	0x06,
	0xe6,
	0xc6,
	0xc6,
	0xc6,
	0x7e,
	0xc6,
	0xe6,
	0x18,
	0x0c,
	0xcc,
	0x18,
	0xd6,
	0xe6,
	0xc6,
	0xe6,
	0xc6,
	0xe6,
	0xc6,
	0x60,
	0xc6,
	0xc6,
	0xc6,
	0x6c,
	0xc6,
	0x0c,
	0x20,
	0x18,
	0x08,
	0x00,
	0xc6,
	0xc0,
	0xc6,
	0xc6,
	0x06,
	0x06,
	0x06,
	0x06,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0x7c,
	0x16,
	0xfe,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xde,
	0xf8,
	0xce,
	0x92,
	0x7c,
	0x06,
	0x18,
	0xc6,
	0xc6,
	0xe6,
	0xce,
	0x66,
	0x66,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x06,
	0x00,
	0xcc,
	0x66,
	0x06,
	0xc6,
	0xfe,
	0xd0,
	0xd6,
	0xce,
	0xc6,
	0xc6,
	0xc6,
	0x63,
	0x00,
	0x18,
	0x5b,
	0xb1,
	0xbd,
	0x00,
	0x00,
	0x00,
	0x38,
	0x3c,
	0x7e,
	0xff,
	0x00,
	0x06,
	0xc6,
	0x7c,
	0x7c,
	0x7c,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0x30,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x6c,
	0xdc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0xdc,
	0x60,
	0x6c,
	0x0c,
	0xcc,
	0x66,
	0x30,
	0xdb,
	0xfe,
	0xc6,
	0x7c,
	0xdb,
	0xd6,
	0xc6,
	0xc6,
	0xfe,
	0x18,
	0x18,
	0x30,
	0x18,
	0x18,
	0x7e,
	0x00,
	0x00,
	0x00,
	0x18,
	0x04,
	0x66,
	0x60,
	0x3c,
	0xde,
	0xe7,
	0x1c,
	0x1c,
	0xfe,
	0x7f,
	0x7e,
	0xf8,
	0x7c,
	0xcc,
	0x91,
	0x42,
	0x08,
	0x3e,
	0x3e,
	0x38,
	0x1c,
	0x7c,
	0x1f,
	0xff,
	0x00,
	0x0c,
	0x63,
	0x18,
	0x7e,
	0x18,
	0x18,
	0x06,
	0x30,
	0x60,
	0x66,
	0x3e,
	0x1c,
	0x00,
	0x18,
	0x00,
	0x6c,
	0x16,
	0x20,
	0xda,
	0x00,
	0x30,
	0x18,
	0x38,
	0x18,
	0x00,
	0x00,
	0x00,
	0x30,
	0xf6,
	0x18,
	0x18,
	0x06,
	0xcc,
	0x06,
	0xc6,
	0x30,
	0xc6,
	0x06,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x06,
	0x18,
	0xb6,
	0xfe,
	0xc6,
	0xc0,
	0xc6,
	0x60,
	0x60,
	0xc6,
	0xc6,
	0x18,
	0x06,
	0xd8,
	0x60,
	0xd6,
	0xc6,
	0xc6,
	0xfc,
	0xc6,
	0xd8,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xd6,
	0x38,
	0x38,
	0x30,
	0x30,
	0x18,
	0x18,
	0x00,
	0x00,
	0x00,
	0x06,
	0xc6,
	0xc0,
	0xc6,
	0xc6,
	0x30,
	0xc6,
	0xc6,
	0x18,
	0x0c,
	0xd8,
	0x18,
	0xd6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x60,
	0x60,
	0xc6,
	0xc6,
	0xd6,
	0x38,
	0xc6,
	0x18,
	0xe0,
	0x18,
	0x0e,
	0x00,
	0xc6,
	0xc0,
	0xc6,
	0xc6,
	0x06,
	0x06,
	0x06,
	0x06,
	0xc0,
	0xc6,
	0xc6,
	0xc6,
	0x18,
	0x18,
	0x18,
	0xfe,
	0xfe,
	0x60,
	0x16,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xf6,
	0x60,
	0xde,
	0xbc,
	0x30,
	0x06,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x66,
	0x3c,
	0x30,
	0x00,
	0x00,
	0x60,
	0x0c,
	0x30,
	0xcc,
	0x66,
	0x06,
	0xc6,
	0x30,
	0xd0,
	0xd6,
	0xc8,
	0xfe,
	0xfe,
	0xc6,
	0x63,
	0x00,
	0x18,
	0x1b,
	0xb1,
	0xa9,
	0x00,
	0x00,
	0x00,
	0xe0,
	0x18,
	0x7e,
	0xff,
	0x00,
	0x06,
	0xfe,
	0x60,
	0x60,
	0x60,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0x18,
	0x60,
	0xc6,
	0xc6,
	0xc6,
	0x38,
	0xc6,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0xc6,
	0x60,
	0x6c,
	0x0c,
	0xc6,
	0x66,
	0x30,
	0xdb,
	0xc6,
	0xc6,
	0xc6,
	0xdb,
	0xd6,
	0xc0,
	0xc6,
	0x00,
	0x18,
	0x30,
	0x18,
	0x18,
	0x18,
	0x00,
	0x76,
	0x00,
	0x00,
	0x18,
	0x04,
	0x66,
	0x60,
	0x3c,
	0xf6,
	0xe7,
	0x1c,
	0x1c,
	0x1c,
	0x38,
	0x7e,
	0xf8,
	0x38,
	0x6c,
	0x8f,
	0x42,
	0x08,
	0x7f,
	0x1c,
	0x30,
	0x0c,
	0x70,
	0x07,
	0xe7,
	0x00,
	0x0c,
	0x63,
	0x18,
	0x7e,
	0x18,
	0x18,
	0x0c,
	0x18,
	0x60,
	0x24,
	0x3e,
	0x1c,
	0x00,
	0x18,
	0x00,
	0xfe,
	0x16,
	0x4c,
	0xcc,
	0x00,
	0x30,
	0x18,
	0x6c,
	0x18,
	0x00,
	0x00,
	0x00,
	0x20,
	0xe6,
	0x18,
	0x30,
	0x06,
	0xcc,
	0x06,
	0xc6,
	0x30,
	0xc6,
	0x0c,
	0x00,
	0x00,
	0x60,
	0xfe,
	0x0c,
	0x18,
	0xb6,
	0xc6,
	0xc6,
	0xc0,
	0xc6,
	0x60,
	0x60,
	0xc6,
	0xc6,
	0x18,
	0x06,
	0xcc,
	0x60,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0xc6,
	0xcc,
	0x0c,
	0x18,
	0xc6,
	0xc6,
	0xd6,
	0x6c,
	0x30,
	0x60,
	0x30,
	0x08,
	0x18,
	0x00,
	0x00,
	0x00,
	0x7e,
	0xc6,
	0xc0,
	0xc6,
	0xfe,
	0x30,
	0xc6,
	0xc6,
	0x18,
	0x0c,
	0xf8,
	0x18,
	0xd6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0x38,
	0x60,
	0xc6,
	0xc6,
	0xd6,
	0x38,
	0xc6,
	0x30,
	0x20,
	0x18,
	0x08,
	0x00,
	0xc6,
	0xc0,
	0xc6,
	0xfe,
	0x7e,
	0x7e,
	0x7e,
	0x7e,
	0xc0,
	0xfe,
	0xfe,
	0xfe,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0x60,
	0x7e,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xe6,
	0x60,
	0xfe,
	0x94,
	0x30,
	0x7e,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x3b,
	0x00,
	0x30,
	0x00,
	0x00,
	0x30,
	0x18,
	0x30,
	0xcc,
	0x66,
	0x7e,
	0xc6,
	0x30,
	0xd0,
	0xde,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0x63,
	0x00,
	0x18,
	0x1b,
	0xb1,
	0xa5,
	0x00,
	0x00,
	0x00,
	0x44,
	0x00,
	0x7e,
	0xff,
	0x00,
	0x7e,
	0xc6,
	0x60,
	0x60,
	0x60,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0x0c,
	0x38,
	0xc6,
	0xc6,
	0xc6,
	0x30,
	0xc6,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0xc6,
	0x60,
	0x6c,
	0x18,
	0xc6,
	0x66,
	0x30,
	0xdb,
	0xc6,
	0xc6,
	0xc6,
	0xdb,
	0xd6,
	0x70,
	0xc6,
	0xfe,
	0x00,
	0x60,
	0x0c,
	0x18,
	0x18,
	0x00,
	0xdc,
	0x00,
	0x00,
	0x18,
	0x44,
	0x66,
	0x7e,
	0x3c,
	0xe6,
	0xff,
	0x1c,
	0x7f,
	0x18,
	0x18,
	0x7e,
	0xf9,
	0x10,
	0x6c,
	0x81,
	0x42,
	0x08,
	0x7f,
	0x08,
	0x20,
	0x04,
	0x60,
	0x03,
	0xc3,
	0x00,
	0x0c,
	0x36,
	0x7e,
	0x3c,
	0x18,
	0x7e,
	0x00,
	0x00,
	0x7f,
	0x00,
	0x7f,
	0x08,
	0x00,
	0x00,
	0x00,
	0xd8,
	0xd6,
	0x52,
	0xcc,
	0x00,
	0x30,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0xc6,
	0x18,
	0x60,
	0x06,
	0xfe,
	0xc6,
	0xc6,
	0x60,
	0xc6,
	0x18,
	0x00,
	0x00,
	0x30,
	0x00,
	0x18,
	0x00,
	0x9e,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x60,
	0x60,
	0xc6,
	0xc6,
	0x18,
	0x06,
	0xcc,
	0x60,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0xf6,
	0xcc,
	0xc6,
	0x18,
	0xc6,
	0x6c,
	0x6c,
	0xc6,
	0x30,
	0x60,
	0x30,
	0x0c,
	0x18,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc6,
	0xc0,
	0xc6,
	0xc0,
	0x30,
	0xce,
	0xc6,
	0x18,
	0x0c,
	0xd8,
	0x18,
	0xd6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0x0c,
	0x60,
	0xc6,
	0x6c,
	0xd6,
	0x38,
	0x6c,
	0x60,
	0x30,
	0x18,
	0x18,
	0x00,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0xc0,
	0xc0,
	0xc0,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0x60,
	0xd0,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x6c,
	0xc6,
	0xc6,
	0xe6,
	0x60,
	0xf6,
	0x92,
	0x30,
	0xc6,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x00,
	0x00,
	0x60,
	0x00,
	0x00,
	0x18,
	0x30,
	0x30,
	0xcc,
	0x66,
	0xc6,
	0xc6,
	0xfe,
	0xd6,
	0xd0,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0x36,
	0x00,
	0x18,
	0x1b,
	0x9d,
	0xa5,
	0x00,
	0xee,
	0x00,
	0xaa,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc6,
	0x60,
	0x60,
	0x60,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x0c,
	0xc6,
	0xc6,
	0xc6,
	0x30,
	0xc6,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0xc6,
	0x60,
	0x6c,
	0x30,
	0xc6,
	0x66,
	0x30,
	0x7e,
	0xc6,
	0x6c,
	0xc6,
	0x66,
	0xd6,
	0xc0,
	0xc6,
	0x00,
	0x7e,
	0x00,
	0x00,
	0x18,
	0x18,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0xe4,
	0x00,
	0x00,
	0x3c,
	0xe6,
	0xe7,
	0x1c,
	0x3e,
	0x10,
	0x08,
	0x7e,
	0x05,
	0x00,
	0x38,
	0x42,
	0xff,
	0x78,
	0x00,
	0x00,
	0x00,
	0x00,
	0x40,
	0x01,
	0x81,
	0x00,
	0x0c,
	0x1c,
	0x3c,
	0x18,
	0x18,
	0x3c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x7f,
	0x08,
	0x00,
	0x18,
	0x00,
	0xd8,
	0x7c,
	0x92,
	0xcc,
	0x00,
	0x30,
	0x18,
	0x00,
	0x00,
	0x38,
	0x00,
	0x18,
	0x40,
	0xc6,
	0x18,
	0xc0,
	0xc6,
	0x0c,
	0xc6,
	0xc6,
	0x60,
	0xc6,
	0x30,
	0x18,
	0x38,
	0x18,
	0x00,
	0x30,
	0x18,
	0x80,
	0xc6,
	0xc6,
	0xc6,
	0xcc,
	0x60,
	0x60,
	0xc6,
	0xc6,
	0x18,
	0xc6,
	0xc6,
	0x60,
	0xc6,
	0xc6,
	0xc6,
	0xc0,
	0xdc,
	0xc6,
	0xc6,
	0x18,
	0xc6,
	0x38,
	0x6c,
	0xc6,
	0x30,
	0xc0,
	0x30,
	0x04,
	0x18,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc6,
	0xc6,
	0xce,
	0xc6,
	0x30,
	0x76,
	0xc6,
	0x18,
	0x0c,
	0xcc,
	0x18,
	0xd6,
	0xc6,
	0xc6,
	0xc6,
	0xce,
	0xc0,
	0xc6,
	0x66,
	0xce,
	0x38,
	0x6c,
	0x6c,
	0x38,
	0xc0,
	0x30,
	0x18,
	0x18,
	0x00,
	0xc6,
	0xc6,
	0xce,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0x60,
	0xd0,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0xce,
	0xce,
	0x38,
	0xc6,
	0xc6,
	0xc6,
	0x40,
	0xe6,
	0x92,
	0x30,
	0xc6,
	0x18,
	0xc6,
	0xce,
	0xc6,
	0xc6,
	0x00,
	0x7e,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x66,
	0xcc,
	0xc6,
	0xc6,
	0x30,
	0x7c,
	0xd0,
	0xc8,
	0xc6,
	0xc6,
	0xc6,
	0x1c,
	0x00,
	0x18,
	0x1b,
	0x81,
	0x81,
	0x00,
	0x66,
	0xdb,
	0xaa,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xc6,
	0x60,
	0x60,
	0x60,
	0x18,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0xc6,
	0x30,
	0xe6,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0xe6,
	0x60,
	0x6c,
	0x62,
	0xc6,
	0x66,
	0x30,
	0x18,
	0x6c,
	0x6c,
	0xc6,
	0x00,
	0xd6,
	0xc6,
	0xc6,
	0x00,
	0x00,
	0xfe,
	0xfe,
	0x18,
	0x18,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x34,
	0x00,
	0x00,
	0x00,
	0xc6,
	0xe7,
	0x1c,
	0x1c,
	0x00,
	0x00,
	0x7e,
	0x03,
	0x00,
	0x18,
	0x3c,
	0x10,
	0xf0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x0c,
	0x06,
	0x18,
	0x7e,
	0x18,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x00,
	0x00,
	0x10,
	0x0c,
	0x76,
	0x00,
	0x18,
	0x30,
	0x00,
	0x00,
	0x18,
	0x00,
	0x18,
	0xc0,
	0x7c,
	0x18,
	0xfe,
	0x7c,
	0x0c,
	0x7c,
	0x7c,
	0x60,
	0x7c,
	0x60,
	0x18,
	0x18,
	0x0c,
	0x00,
	0x60,
	0x18,
	0x7c,
	0xc6,
	0xfc,
	0x7c,
	0xf8,
	0x7e,
	0x60,
	0x7a,
	0xc6,
	0x18,
	0x7c,
	0xc6,
	0x7e,
	0xc6,
	0xc6,
	0x7c,
	0xc0,
	0x7c,
	0xc6,
	0x7c,
	0x18,
	0x7c,
	0x10,
	0x44,
	0xc6,
	0x30,
	0xfe,
	0x30,
	0x06,
	0x18,
	0x00,
	0x00,
	0x00,
	0x7e,
	0xfc,
	0x7c,
	0x76,
	0x7c,
	0x30,
	0x06,
	0xc6,
	0x18,
	0x0c,
	0xc6,
	0x0e,
	0xc6,
	0xc6,
	0x7c,
	0xfc,
	0x76,
	0xc0,
	0x7c,
	0x3c,
	0x76,
	0x10,
	0x44,
	0xc6,
	0x30,
	0xfe,
	0x30,
	0x18,
	0x18,
	0x00,
	0xfe,
	0x7c,
	0x76,
	0x7c,
	0x7e,
	0x7e,
	0x7e,
	0x7e,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x18,
	0x18,
	0x18,
	0xc6,
	0xc6,
	0x7e,
	0x7e,
	0xce,
	0x7c,
	0x7c,
	0x7c,
	0x76,
	0x76,
	0x30,
	0x7c,
	0x7c,
	0x7c,
	0xfe,
	0x7c,
	0x94,
	0x30,
	0x7e,
	0x18,
	0x7c,
	0x76,
	0xc6,
	0xc6,
	0x7e,
	0x00,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x7e,
	0x7c,
	0x30,
	0x10,
	0x7e,
	0x7e,
	0xc6,
	0xc6,
	0x7c,
	0x06,
	0x00,
	0x18,
	0x1b,
	0x7e,
	0x7e,
	0x00,
	0x66,
	0xdb,
	0x44,
	0x00,
	0x00,
	0x00,
	0x00,
	0x7e,
	0xc6,
	0x7e,
	0x7e,
	0x7e,
	0x18,
	0x18,
	0x18,
	0x18,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x7c,
	0x30,
	0xdc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x76,
	0xdc,
	0xf0,
	0x66,
	0xfe,
	0x7c,
	0x7c,
	0x1c,
	0x3c,
	0x38,
	0xee,
	0x7c,
	0x00,
	0x7c,
	0x7c,
	0xc6,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x1c,
	0x00,
	0x00,
	0x00,
	0x7c,
	0x7e,
	0x1c,
	0x08,
	0x00,
	0x00,
	0x7e,
	0x0f,
	0x00,
	0x00,
	0x00,
	0x30,
	0x60,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x0c,
	0x63,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x0c,
	0x60,
	0x00,
	0x00,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x3c,
	0x00,
	0x78,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc6,
	0x00,
	0x00,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x00,
	0x1c,
	0x18,
	0x70,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x00,
	0x00,
	0xc0,
	0x00,
	0xc0,
	0x00,
	0xe0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x63,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xcc,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x60,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0xd8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x0c,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x0c,
	0x3e,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x7c,
	0x00,
	0x00,
	0x78,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x06,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x70,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x70,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x78,
	0x00,
	0x00,
	0x00,
	0x00,
	0x30,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x3e,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0xc0,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0xd8,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xff,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x70,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
};


FONT_HEAD system8x16_hdr = 
{
	1,		/* id */
	11,		/* point */
	"System",	/* name */
	0,		/* MinADE */
	0xFF,		/* MaxADE */
	13,		/* Top line distance */
	12,		/* Ascent line distance */
	6,		/* Half line distance */
	2,		/* Descent line distance */
	2,		/* Bottom line distance */
	7,		/* Widest char width */
	8,		/* Widest cell width */
	1,		/* Left offset */
	5,		/* Right offset */
	1,		/* Cell thickening */
	1,		/* Underline size */
	0x55555555,	/* Lightening mask */
	0x55555555,	/* Skewing mask */
	9,		/* Flags: DEFAULT | MONOSPACE */
	NULL,		/* hor_table */
	system8xn_wtbl,	/* offset table */
	system8x16_data,	/* data table */
	0x100,		/* Form width */
	0x10,		/* Form height */
	NULL,		/* next font */
};

FONT_HEAD system8x14_hdr = 
{
	1,		/* id */
	10,		/* point */
	"System",	/* name */
	0,		/* MinADE */
	0xFF,		/* MaxADE */
	10,		/* Top line distance */
	8,		/* Ascent line distance */
	5,		/* Half line distance */
	2,		/* Descent line distance */
	3,		/* Bottom line distance */
	7,		/* Widest char width */
	8,		/* Widest cell width */
	1,		/* Left offset */
	5,		/* Right offset */
	1,		/* Cell thickening */
	1,		/* Underline size */
	0x55555555,	/* Lightening mask */
	0x55555555,	/* Skewing mask */
	9,		/* Flags: DEFAULT | MONOSPACE */
	NULL,		/* hor_table */
	system8xn_wtbl,	/* offset table */
	system8x14_data,	/* data table */
	0x100,		/* Form width */
	0x0E,		/* Form height */
	&system8x16_hdr,	/* next font */
};


FONT_HEAD system8x8_hdr = 
{
	1,		/* id */
	10,		/* point */
	"System",	/* name */
	0,		/* MinADE */
	0xFF,		/* MaxADE */
	6,		/* Top line distance */
	6,		/* Ascent line distance */
	4,		/* Half line distance */
	1,		/* Descent line distance */
	1,		/* Bottom line distance */
	7,		/* Widest char width */
	8,		/* Widest cell width */
	0,		/* Left offset */
	3,		/* Right offset */
	1,		/* Cell thickening */
	1,		/* Underline size */
	0x55555555,	/* Lightening mask */
	0x55555555,	/* Skewing mask */
	8,		/* Flags: MONOSPACE */
	NULL,		/* hor_table */
	system8xn_wtbl,	/* offset table */
	system8x8_data,	/* data table */
	0x100,		/* Form width */
	0x10,		/* Form height */
	&system8x14_hdr	/* Next font */
};



FONT_HEAD system6x6_hdr = 
{
	1,		/* id */
	8,		/* point */
	"System",	/* name */
	0,		/* MinADE */
	0xFF,		/* MaxADE */
	4,		/* Top line distance */
	4,		/* Ascent line distance */
	3,		/* Half line distance */
	1,		/* Descent line distance */
	1,		/* Bottom line distance */
	5,		/* Widest char width */
	6,		/* Widest cell width */
	0,		/* Left offset */
	2,		/* Right offset */
	1,		/* Cell thickening */
	1,		/* Underline size */
	0x55555555,	/* Lightening mask */
	0x55555555,	/* Skewing mask */
	0,		/* Flags */
	NULL,		/* hor_table */
	system6x6_wtbl,	/* offset table */
	system6x6_data,	/* data table */
	0xC0,		/* Form width */
	0x06,		/* Form height */
	&system8x16_hdr,/* next font */
};

