/*
SDSDL: GEM video driver for SDL
Copyright 2012 John Elliott <jce@seasip.demon.co.uk>
Based on SDPSC9.VGA copyright 1987, 1999 Caldera Thin Clients, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/* Handle 'escape' functions */

#include "sdsdl_i.h"

#define WHITE 0
#define BLACK 1
#define FONT_H 16

/* Since SDL doesn't actually have a text mode, simulate it using graphics 
 * mode. */
void sd_qchcells(unsigned handle, signed *rows, signed *cols)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;

	sd_stheight(handle, FONT_H, &self->text_charw, &self->text_charh,
					&self->text_cellw, &self->text_cellh);

	*cols = self->common->window.w / self->text_cellw;
	*rows = self->common->window.h / self->text_cellh;
}

void sd_enter_cur(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;
	SDL_BlitSurface(self->common->surface, NULL, self->common->backbuf, NULL);
	sd_stheight(handle, FONT_H, &self->text_charw, &self->text_charh,
					&self->text_cellw, &self->text_cellh);
	sd_rvoff(handle);
	sd_curhome(handle);
	sd_eeos(handle);
	sd_swrmode(handle, 1);	// Replace mode
	sd_steffects(handle, 0);
	self->common->textmode = 1;
}


void sd_exit_cur(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;
	self->common->textmode = 0;
	SDL_BlitSurface(self->common->backbuf, NULL, self->common->surface, NULL);
//	sd_clrwk(handle);
}


void sd_curup(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;
	if (self->text_y > 0) --self->text_y;
}


void sd_curdown(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);
	signed rows, cols;

	if (!self) return;
	sd_qchcells(handle, &rows, &cols);
	if (self->text_y < (rows-1)) ++self->text_y;
}



void sd_curleft(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;
	if (self->text_x > 0) --self->text_x;
}


void sd_curright(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);
	signed rows, cols;

	if (!self) return;
	sd_qchcells(handle, &rows, &cols);
	if (self->text_x < (cols-1)) ++self->text_x;
}


void sd_curhome(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;
	self->text_x = 0;
	self->text_y = 0;
}


void sd_eeos(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);
	signed xy[4];

	if (!self) return;

	sd_eeol(handle);
	xy[0] = 0;
	xy[1] = (self->text_y + 1) * self->text_cellh;
	xy[2] = self->common->window.w - 1;
	xy[3] = self->common->window.h - 1;

	if (xy[1] <= xy[3])
	{
		sd_swrmode(handle, 1);
		sd_sfcolor(handle, BLACK);
		sd_sfinterior(handle, 1);
		sd_recfl(handle, xy);
	}
}


void sd_eeol(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);
	signed xy[4];

	if (!self) return;

	xy[0] = self->text_x * self->text_cellw;
	xy[1] = self->text_y * self->text_cellh;
	xy[2] = self->common->window.w - 1;
	xy[3] = xy[1] + self->text_cellh - 1;

	if (xy[0] <= xy[2])
	{
		sd_sfcolor(handle, BLACK);
		sd_sfinterior(handle, 1);
		sd_recfl(handle, xy);
	}
}


void sd_scuraddress(unsigned handle, unsigned row, unsigned col)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;
	self->text_y = row;
	self->text_x = col;
}



void sd_qcuraddress(unsigned handle, unsigned *row, unsigned *col)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;
	*row = self->text_x;
	*col = self->text_y;
}



void sd_curtext(unsigned handle, unsigned count, unsigned *str)
{
	DRIVERDATA *self = lookup_handle(handle);
	unsigned n;
	signed xy[4];

	if (!self) return;

	sd_swrmode(handle, 2);	// TRAN mode
	sd_stcolor(handle, self->text_rv ? BLACK : WHITE);
	for (n = 0; n < count; n++)
	{
		xy[0] = self->text_x * self->text_cellw;
		xy[1] = self->text_y * self->text_cellh;
		xy[2] = xy[0] + self->text_cellw - 1;
		xy[3] = xy[1] + self->text_cellh - 1;

		sd_sfcolor(handle, self->text_rv ? WHITE : BLACK);
		sd_sfinterior(handle, 1);
		sd_recfl(handle, xy);
		sd_gtext(handle, xy[0], xy[1], 1, &str[n], 8);
		++self->text_x;
		/* Wrap at right-hand edge */
		if (self->text_x * self->text_cellw > 
			(self->common->window.w - self->text_cellw))
		{
			self->text_x = 0;
			++self->text_y;
		}
		/* Off the bottom: Scroll */
		if (self->text_y * self->text_cellh > 
			(self->common->window.h - self->text_cellh))
		{
			SDL_Rect rcs, rcd;
			rcs = self->common->window;
			rcd = self->common->window;
			rcs.y += self->text_cellh;
			rcs.h -= self->text_cellh;
			rcd.h -= self->text_cellh;
			if (SDL_BlitSurface(self->common->surface, &rcs,
					self->common->surface, &rcd));
			{
				fprintf(stderr, "Scroll failed: %s\n", SDL_GetError());
				return;
			}
			--self->text_y;
			self->text_x = 0;
			sd_eeol(handle);	
		}
	}
	sd_swrmode(handle, 1);	// Replace mode
}


void sd_rvon(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;

	self->text_rv = 1;
}

void sd_rvoff(unsigned handle)
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;

	self->text_rv = 0;
}


unsigned sd_qtabstatus(unsigned handle)
{
	return 1;	/* Always have a mouse */
}

void sd_hardcopy(unsigned handle)
{

}

void sd_dspcur(unsigned handle, signed x, signed y)
{
	sd_show_c(handle, 1);	
}


void sd_rmcur(unsigned handle)
{
	sd_hide_c(handle);
}


void sd_form_adv(unsigned handle)
{
	sd_clrwk(handle);
}

void sd_output_window(unsigned handle, signed xy[])
{
	DRIVERDATA *self = lookup_handle(handle);

	if (!self) return;

	update_rect(self, xy[0], xy[1], xy[2], xy[3]);
}

void sd_clear_disp_list(unsigned handle)
{

}

void sd_bit_image(unsigned handle, unsigned len_filename,
        unsigned *filename, 
        unsigned aspect, unsigned xscale, unsigned yscale,      
        unsigned h_align, unsigned v_align, signed xy[])
{
	/* XXX Implement this at some point, probably with SDL_Image */
}


