/*
SDSDL: GEM video driver for SDL
Copyright 2012 John Elliott <jce@seasip.demon.co.uk>
Based on SDPSC9.VGA copyright 1987, 1999 Caldera Thin Clients, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/* This file maps sd_dispatch() to individual drawing functions. */

#include "sdsdl_i.h"

#define HANDLE       pb->contrl->handle
#define INTIN_COUNT  pb->contrl->intin_count
#define INTOUT_COUNT pb->contrl->intout_count
#define PTSIN_COUNT  pb->contrl->ptsin_count
#define PTSOUT_COUNT pb->contrl->ptsout_count


void sd_escape(GSXPB *pb)
{
	int n;

	switch (pb->contrl->subfunction)
	{
		case 1:	sd_qchcells(HANDLE, (signed *)&pb->intout[0],
					    (signed *)&pb->intout[1]);
			INTOUT_COUNT = 2;
			break;
		case 2:  sd_exit_cur(HANDLE); break;
		case 3:  sd_enter_cur(HANDLE); break;
		case 4:  sd_curup(HANDLE); break;
		case 5:  sd_curdown(HANDLE); break;
		case 6:  sd_curright(HANDLE); break;
		case 7:  sd_curleft(HANDLE); break;
		case 8:  sd_curhome(HANDLE); break;
		case 9:  sd_eeos(HANDLE); break;
		case 10: sd_eeol(HANDLE); break;
		case 11: sd_scuraddress(HANDLE, pb->intin[0], pb->intin[1]);
			 break;
		case 12: sd_curtext(HANDLE, INTIN_COUNT, pb->intin); break;
		case 13: sd_rvon(HANDLE); break;
		case 14: sd_rvoff(HANDLE); break;
		case 15: sd_qcuraddress(HANDLE, &pb->intout[0], &pb->intout[1]);
			 INTOUT_COUNT = 2;
			 break;
		case 16: pb->intout[0] = sd_qtabstatus(HANDLE); 
			 INTOUT_COUNT = 1;
			 break;
		case 17: sd_hardcopy(HANDLE); break;
		case 18: sd_dspcur(HANDLE, pb->ptsin[0], pb->ptsin[1]); break;
		case 19: sd_rmcur (HANDLE); break;
		case 20: sd_form_adv(HANDLE); break;
		case 21: sd_output_window(HANDLE, pb->ptsin); break;
		case 22: sd_clear_disp_list(HANDLE); break;
		case 23: sd_bit_image(HANDLE, INTIN_COUNT - 5, &pb->intin[5],
				pb->intin[0], pb->intin[1], pb->intin[2],
				pb->intin[3], pb->intin[4], pb->ptsin); break;
			
		case 60: pb->intout[0] = sd_spalette(HANDLE, pb->intin[0]); 
			 INTOUT_COUNT = 1;
			 break;
		case 61: sd_sound(HANDLE, pb->intin[0], pb->intin[1]); break;
		case 62: pb->intout[0] = sd_mute(HANDLE, pb->intin[0]); 	
			 INTOUT_COUNT = 1;
			 break;
		default:
			fprintf(stderr, "sd_escape: Unsupported escape %d (", pb->contrl->subfunction);
			for (n = 0; n < INTIN_COUNT; n++)
			{
				if (n) fprintf(stderr, ", ");
				fprintf(stderr, "%d", pb->intin[n]);
			}
			fprintf(stderr, ") [");
			for (n = 0; n < 2 * PTSIN_COUNT; n++)
			{
				if (n) fprintf(stderr, ", ");
				fprintf(stderr, "%d", pb->ptsin[n]);
			}
			fprintf(stderr, "]\n");
			break;
	}

}


void sd_gdp(GSXPB *pb)
{
	int n;

	switch (pb->contrl->subfunction)
	{
		case  1: sd_bar(HANDLE, pb->ptsin);
			break;
		case  2: sd_arc(HANDLE, pb->ptsin[0], pb->ptsin[1],
			pb->ptsin[6], pb->intin[0], pb->intin[1]);
			break;
		case  3: sd_pieslice(HANDLE, pb->ptsin[0], pb->ptsin[1],
			pb->ptsin[6], pb->intin[0], pb->intin[1]);
			break;
		case  4: sd_circle(HANDLE, pb->ptsin[0], pb->ptsin[1],
				pb->ptsin[4]); break;
		case  5: sd_ellipse(HANDLE, pb->ptsin[0], pb->ptsin[1],
				pb->ptsin[2], pb->ptsin[3]); break;
		case  6: sd_ellarc(HANDLE, pb->ptsin[0], pb->ptsin[1],
			pb->ptsin[2], pb->ptsin[3], pb->intin[0], pb->intin[1]);
			break;
		case  7: sd_ellpie(HANDLE, pb->ptsin[0], pb->ptsin[1],
			pb->ptsin[2], pb->ptsin[3], pb->intin[0], pb->intin[1]);
			break;
	
		case  8: sd_rbox (HANDLE, pb->ptsin); break;
		case  9: sd_rfbox(HANDLE, pb->ptsin); break;
		case 10:
			sd_justified(HANDLE, pb->ptsin[0], pb->ptsin[1], 
				     INTIN_COUNT - 2, &pb->intin[2],
				     pb->ptsin[2], pb->intin[0], pb->intin[1],
				     &INTOUT_COUNT, pb->intout,
					pb->contrl->function);
			break;
		default:
			fprintf(stderr, "sd_gdp: Unsupported GDP %d (", pb->contrl->subfunction);
			for (n = 0; n < INTIN_COUNT; n++)
			{
				if (n) fprintf(stderr, ", ");
				fprintf(stderr, "%d", pb->intin[n]);
			}
			fprintf(stderr, ") [");
			for (n = 0; n < 2 * PTSIN_COUNT; n++)
			{
				if (n) fprintf(stderr, ", ");
				fprintf(stderr, "%d", pb->ptsin[n]);
			}
			fprintf(stderr, "]\n");
			break;
	}

}




unsigned sd_dispatch(GSXPB *pb)
{
	unsigned result = 0;
	unsigned buf[57];
	unsigned n;

	INTOUT_COUNT = 0;
	PTSOUT_COUNT = 0;

	switch (pb->contrl->function)
	{
		case 1: result = sd_opnwk(pb->intin, &HANDLE, buf);
			memcpy(pb->intout, &buf[0],  45 * sizeof(unsigned));
			memcpy(pb->ptsout, &buf[45], 12 * sizeof(unsigned));
			INTOUT_COUNT = 45;
			PTSOUT_COUNT = 6;
			break;
		case 2:	sd_clswk(HANDLE); break;
		case 3:	sd_clrwk(HANDLE); break;
		case 4: sd_updwk(HANDLE); break;
		case 5: sd_escape(pb); break;
		case 6: sd_pline(HANDLE, PTSIN_COUNT, pb->ptsin); break;
		case 7: sd_pmarker(HANDLE, PTSIN_COUNT, pb->ptsin); break;
		case 8: sd_gtext(HANDLE, pb->ptsin[0], pb->ptsin[1],
				INTIN_COUNT, pb->intin, 8); break;
		case 9: sd_fillarea(HANDLE, PTSIN_COUNT, pb->ptsin); break;
		case 10: sd_cellarray(HANDLE, pb->ptsin, pb->contrl->extra[0],
					pb->contrl->extra[1], 
					pb->contrl->extra[2],
					pb->contrl->extra[3], pb->intin);
					break;
		case 11: sd_gdp(pb); break;
		case 12: pb->intout[0] = sd_stheight(HANDLE,
				pb->ptsin[1], &pb->ptsout[0], &pb->ptsout[1],
				&pb->ptsout[2], &pb->ptsout[3]);
			 PTSOUT_COUNT = 2;
			 INTOUT_COUNT = 1;
			 break;
		case 13: pb->intout[0] = sd_strotation(HANDLE,
				pb->intin[0]);
			 INTOUT_COUNT = 1;
			 break;
		case 14: sd_setcolor(HANDLE, pb->intin[0],
				&pb->intin[1]); 
			 break;
		case 15: pb->intout[0] = sd_sltype(HANDLE, pb->intin[0]); 
			 INTOUT_COUNT = 1;
			 break;
		case 16: pb->ptsout[0] = sd_slwidth(HANDLE, pb->ptsin[0]); 
			 pb->ptsout[1] = 0;
			 PTSOUT_COUNT = 1;
			 break;
		case 17: pb->intout[0] = sd_slcolor(HANDLE, pb->intin[0]); 
			 INTOUT_COUNT = 1;
			 break;
		case 18: pb->intout[0] = sd_smtype(HANDLE, pb->intin[0]); 
			 INTOUT_COUNT = 1;
			 break;
		case 19: pb->ptsout[0] = sd_smheight(HANDLE, pb->ptsin[0]); 
			 PTSOUT_COUNT = 1;
			 break;
		case 20: pb->intout[0] = sd_smcolor(HANDLE, pb->intin[0]); 
			 INTOUT_COUNT = 1;
			 break;
		case 21: pb->intout[0] = sd_stfont(HANDLE, pb->intin[0]); 
			 INTOUT_COUNT = 1;
			 break;
		case 22: pb->intout[0] = sd_stcolor(HANDLE, pb->intin[0]); 
			 INTOUT_COUNT = 1;
			 break;
		case 23: pb->intout[0] = sd_sfinterior(HANDLE, pb->intin[0]); 
			 INTOUT_COUNT = 1;
			 break;
		case 24: pb->intout[0] = sd_sfstyle(HANDLE, pb->intin[0]); 
			 INTOUT_COUNT = 1;
			 break;
		case 25: pb->intout[0] = sd_sfcolor(HANDLE, pb->intin[0]); 
			 INTOUT_COUNT = 1;
			 break;
		case 26: pb->intout[0] = sd_qcolor(HANDLE, pb->intin[0], 
					pb->intin[1], &pb->intout[1]);
			 INTOUT_COUNT = 4;
			 break;
		case 27: n = sd_qcellarray(HANDLE, pb->ptsin, 
					pb->contrl->extra[0],
					pb->contrl->extra[1], 
					&pb->contrl->extra[2], 
					&pb->contrl->extra[3],
					&pb->contrl->extra[4], pb->intout);
			 INTOUT_COUNT = pb->contrl->extra[2] * 
					pb->contrl->extra[3];
			 break;
 		case 28: /* vrq_locator */
			 sdrq_locator(HANDLE, pb->intin[0],
				pb->ptsin[0], pb->ptsin[1],
				&pb->ptsout[0], &pb->ptsout[1],
				&pb->intout[0], &n);
			 PTSOUT_COUNT = (n & 1);
			 INTOUT_COUNT = (n >> 1) & 1;
			 break;
 		case 29: /* vrq_valuator */
			 sdrq_valuator(HANDLE, 
				pb->intin[0], pb->intin[1],
				&pb->intout[0], &pb->intout[1],
				&n);
			 INTOUT_COUNT = n;
			 break;
 		case 30: /* vrq_choice */
			 sdrq_choice(HANDLE, pb->intin[0],
					pb->intin[1], &pb->intout[0], &n);
			 INTOUT_COUNT = n;
			 break;
 		case 31: INTOUT_COUNT = sd_string(HANDLE, pb->intin[0],
				pb->intin[1], pb->ptsin, pb->intout);
			 break;
		case 32: pb->intout[0] = sd_swrmode(HANDLE, pb->intin[0]); 
			 INTOUT_COUNT = 1;
			 break;
 		case 33: pb->intout[0] = sd_sinmode(HANDLE, pb->intin[0], 
						pb->intin[1]);
			 INTOUT_COUNT = 1;
			 break;
		case 34: break;	/* No-op */
		case 35: sd_qlattributes(HANDLE, pb->intout, &pb->ptsout[0]);
			 INTOUT_COUNT = 5;
			 PTSOUT_COUNT = 1;
			 break;
		case 36: sd_qmattributes(HANDLE, pb->intout, &pb->ptsout[0]);
			 INTOUT_COUNT = 3;
			 PTSOUT_COUNT = 1;
			 break;
		case 37: sd_qfattributes(HANDLE, pb->intout);
			 INTOUT_COUNT = 5;
			 break;
 		case 38: /* vqt_attributes */	
			sd_qtattributes(HANDLE, buf);
			memcpy(pb->intout, &buf[0], 6 * sizeof(unsigned));
			memcpy(pb->ptsout, &buf[6], 4 * sizeof(unsigned));
			INTOUT_COUNT = 6;
			PTSOUT_COUNT = 2;
			break;
		case 39: sd_stalignment(HANDLE, pb->intin[0], pb->intin[1],
					&pb->intout[0], &pb->intout[1]);
			 INTOUT_COUNT = 2;
			 break;
		case 100: result = sd_opnvwk(pb->intin, &HANDLE, buf);
			memcpy(pb->intout, &buf[0],  45 * sizeof(unsigned));
			memcpy(pb->ptsout, &buf[45], 12 * sizeof(unsigned));
			INTOUT_COUNT = 45;
			PTSOUT_COUNT = 6; 
			break;
		case 101: sd_clsvwk(HANDLE); break;
		case 102: sd_qextnd(HANDLE, pb->intin[0], buf);
			memcpy(pb->intout, &buf[0],  45 * sizeof(unsigned));
			memcpy(pb->ptsout, &buf[45], 12 * sizeof(unsigned));
			INTOUT_COUNT = 45;
			PTSOUT_COUNT = 6;
			break;
		case 103: sd_contourfill(HANDLE, pb->ptsin[0], pb->ptsin[1],
				(signed)(pb->intin[0]));
			break;
		case 104: pb->intout[0] = sd_sfperimeter(HANDLE, pb->intin[0]);
			  INTOUT_COUNT = 1;
			  break;
		case 105: sd_get_pixel(HANDLE, pb->ptsin[0], pb->ptsin[1],
				&pb->intout[0], &pb->intout[1]);
			  INTOUT_COUNT = 2;
			  break;
		case 106: pb->intout[0] = sd_steffects(HANDLE, pb->intin[0]);
			  INTOUT_COUNT = 1;
			  break;
		case 107: pb->intout[0] = sd_stpoint(HANDLE, pb->intin[0],
				&pb->ptsout[0],	&pb->ptsout[1],	&pb->ptsout[2],	
				&pb->ptsout[3]);
			  INTOUT_COUNT = 1;
			  PTSOUT_COUNT = 2;
			  break;
		case 108: sd_slends(HANDLE, pb->intin, pb->intout);
			  INTOUT_COUNT = 2;
			  break;
		case 109: sd_rocpyfm(HANDLE, pb->intin[0], pb->ptsin,
				pb->contrl->ptr1, pb->contrl->ptr2);
			  break;
		case 110: sd_trnfm(HANDLE, pb->contrl->ptr1, pb->contrl->ptr2);
			  break;
		case 111: sd_scform(HANDLE, pb->intin); break;
		case 112: sd_udpat(HANDLE, pb->intin, INTIN_COUNT / 16); break;
		case 113: sd_udstyle(HANDLE, pb->intin[0]); break;
		case 114: sd_recfl(HANDLE, pb->ptsin); break;
		case 115: pb->intout[0] = sd_qinmode(HANDLE, pb->intin[0]);
			  INTOUT_COUNT = 1;
			  break;
		case 116: /* vqt_extent */
			sd_qtextent(HANDLE, INTIN_COUNT, pb->intin, pb->ptsout);
			PTSOUT_COUNT = 1;
			break;
		case 117: /* vqt_width */
			sd_qtwidth(HANDLE, pb->intin[0], &pb->ptsout[0],
					&pb->ptsout[2], &pb->ptsout[4]);
			PTSOUT_COUNT = 3;
			break;
		case 118: sd_extimv(HANDLE, pb->contrl->ptr1, (TIMVEC *)&pb->contrl->ptr2); break;
		case 119: /* vst_load_fonts
			   * ptr1 -> font(s) to load
			   * ptr2 -> text buffer
			   * extra[0] = text buffer size
			   * ptr3 -> font manager */
			  pb->intout[0] = sd_load_fonts(HANDLE, 
						pb->contrl->ptr1,
						pb->contrl->ptr2,
						pb->contrl->extra[0],
						pb->contrl->ptr3);
			  INTOUT_COUNT = 1;
			  break;
		case 120: /* vst_unload_fonts */
			  sd_unload_fonts(HANDLE, pb->contrl->ptr1);
			  break;
		case 121: sd_rtcpyfm(HANDLE, pb->intin[0], pb->ptsin,
				pb->contrl->ptr1, pb->contrl->ptr2,
				pb->intin[1], pb->intin[2]);
			  break;
		case 122: sd_show_c(HANDLE, pb->intin[0]); break;
		case 123: sd_hide_c(HANDLE); break;
		case 124: sd_qmouse(HANDLE, &pb->intout[0], &pb->ptsout[0],
				&pb->ptsout[1]); /* vq_mouse */
			  INTOUT_COUNT = 1;
			  PTSOUT_COUNT = 1;
			  break;
		case 125: sd_exbutv(HANDLE, pb->contrl->ptr1, (BUTVEC *)&pb->contrl->ptr2); break;
		case 126: sd_exmotv(HANDLE, pb->contrl->ptr1, (MOTVEC *)&pb->contrl->ptr2); break;
		case 127: sd_excurv(HANDLE, pb->contrl->ptr1, (CURVEC *)&pb->contrl->ptr2); break;
		case 128: /* vq_key_s */
			pb->intout[0] = sd_qkeys(HANDLE); 
			INTOUT_COUNT = 1;
			break;			
		case 129: /* vsf_clip */
			sd_sclip(HANDLE, pb->intin[0], pb->ptsin); break;
		case 130: /* vqt_name */
			sd_qtname(HANDLE, pb->intin[0], pb->intout);
			INTOUT_COUNT = 33;
			break;
		case 131: /* vqt_font_info */
			{
				signed distances[5];
				signed effects[5];	
				sd_qtfontinfo(HANDLE, &pb->intout[0], 
						      &pb->intout[1],
						distances, &pb->ptsout[0],
						effects);
				pb->ptsout[1] = distances[0];	
				pb->ptsout[3] = distances[1];	
				pb->ptsout[5] = distances[2];	
				pb->ptsout[7] = distances[3];	
				pb->ptsout[9] = distances[4];	
				pb->ptsout[2] = effects[0];
				pb->ptsout[4] = effects[1];
				pb->ptsout[6] = effects[2];
				pb->ptsout[8] = effects[3];
				PTSOUT_COUNT = 5;
				INTOUT_COUNT = 2;
			}	
			break;
		case 132: /* vqt_justified */
			sd_qtjustified(HANDLE, pb->ptsin[0], pb->ptsin[1], 
				pb->ptsin[2], INTIN_COUNT - 2, &pb->intin[2],
				pb->intin[0], pb->intin[1], pb->ptsout);
			INTOUT_COUNT = INTIN_COUNT - 2;
			break;
// There are more in GEM/3.1 & later.

		case 1000: sd_delay(HANDLE, pb->intin[0]); break;

		default:
			fprintf(stderr, "sd_dispatch: Unsupported function %d (", pb->contrl->function);
			for (n = 0; n < INTIN_COUNT; n++)
			{
				if (n) fprintf(stderr, ", ");
				fprintf(stderr, "%d", pb->intin[n]);
			}
			fprintf(stderr, ") [");
			for (n = 0; n < 2 * PTSIN_COUNT; n++)
			{
				if (n) fprintf(stderr, ", ");
				fprintf(stderr, "%d", pb->ptsin[n]);
			}
			fprintf(stderr, "]\n");
			break;
	}
	return result;
}
