/*
SDSDL: GEM video driver for SDL
Copyright 2012 John Elliott <jce@seasip.demon.co.uk>
Based on SDPSC9.VGA copyright 1987, 1999 Caldera Thin Clients, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#include "sdsdl_i.h"

const unsigned DEV_TAB[45] = 
{
/*
 * Device tables.
 */
	0,	/* 1	x resolution */
	0,	/* 2	y resolution */
	0,	/* 3	0=exact,1=not exact */
	165,	/* 4	width of pixel */
	165,	/* 5	height of pixel */
	0,	/* 6	character sizes */
	8,	/* 7	linestyles */
	40,	/* 8	linewidths */
	8,	/* 9	marker types */
	8,	/* 10	marker size */
	0,	/* 11	text font */
	24,	/* 12	area patterns */
	12,	/* 13	crosshatch patterns */
	32768,	/* 14	colors at one time */
	10,	/* 15	number of GDP's */
	1,	/* 16	GDP bar */
	2,	/* 17	GDP arc */
	3,	/* 18	GDP pie */
	4,	/* 19	GDP circle */
	5,	/* 20	GDP ellipse */
	6,	/* 21	GDP elliptical arc */
	7,	/* 22	GDP elliptical pie */
	8, 	/* 23	GDP rounded rectangle */
	9, 	/* 24	GDP filled rounded rectangle */
	10,	/* 25	GDP justified text */
/* GDP attributes */
	3,	/* 26	GDP #1 */
	0,	/* 27	GDP #2 */
	3,	/* 28	GDP #3 */
	3,	/* 29	GDP #4 */
	3,	/* 30	GDP #5 */
	0,	/* 31	GDP #6 */
	3,	/* 32	GDP #7 */
	0, 	/* 33	GDP #8 */
	3, 	/* 34	GDP #9 */
	2, 	/* 35	GDP #10 */
	1,	/* 36	Color capability */
	1,	/* 37	Text Rotation */
	1,	/* 38	Polygonfill */
	0,	/* 39	Cell Array */
	-1,	/* 40	Pallette size */
	2,	/* 41	# of locator devices return 2 */
	1,	/* 42	# of valuator devices */
	1,	/* 43	# of choice devices */
	1,	/* 44	# of string devices */
	2,	/* 45	Workstation Type 2 = out/in */
};

const unsigned INQ_TAB[45] =
{
	4,		/* 0  type of alpha/graphic controllers */
	1,		/* 1  number of background colors */
	1,		/* 2  text styles supported */
	0,		/* 3  scale rasters = false */
	15,		/* 4  number of planes */
	0,		/* 5  no palette */
	50,		/* 6  performance factor */
	0,		/* 7  contour fill capability */
	1,		/* 8  character rotation capability */
	4,		/* 9  number of writing modes */
	2,		/* 10 highest input mode */
	1,		/* 11 text alignment flag */
	0,		/* 12 Inking capability */
	0,		/* 13 rubber banding */
	0x5DA,		/* 14 maximum vertices */
	0x80,		/* 15 maximum intin size */
	3,		/* 16 number of buttons on mouse */
	0,		/* 17 styles for wide lines */
	0,		/* 18 writing modes for wide lines */
	0,		/* 19 clipping flag */
};

/*
 * Marker definitions.
 */
const signed m_dot[] = 
{
	1,		/* number of polylines */
	2,		/* segments in polyline */
	0, 0, 0, 0
};


const signed m_plus[] =
{
	2,		/* number of polylines */
	2,		/* segments in polyline */
	0, -4, 0, 4,
	2,		/* segments in polyline */
	-5, 0, 5, 0,
};

const signed m_star[] =
{
	3,		/* number of polylines */
	2,		/* segments in polyline */
	0, -4, 0, 4,
	2,		/* segments in polyline */
	4, 2, -4, -2,
	2,		/* segments in polyline */
	4, -2, -4, 2,
};


const signed m_square[] =
{
	1,		/* number of polylines */
	5,		/* segments in polyline */
	-5, -4, 5, -4, 5, 4, -5, 4, -5, -4
};


const signed m_cross[] =
{
	2,		/* number of polylines */
	2,		/* segments in polyline */
	-5, -4, 5, 4,
	2,		/* segments in polyline */
	-5, 4, 5, -4,
};


const signed m_dmnd[] =
{
	1,		/* number of polylines */
	5,		/* segments in polyline */
	-5, 0, 0, -4, 5, 0, 0, 4, -5, 0
};


const unsigned SIZ_TAB[12] =
{
	0,	/* min char width */
	0,	/* min char height */
	0,	/* max char width */
	0,	/* max char height */
	1,	/* min line width */
	0,	/* not used */
	40,	/* max line width */
	0,	/* not used */
	15,	/* min marker width */
	11,	/* min marker height */
	120,	/* max marker width */
	88	/* max marker height */
};
