/************************************************************************
 *       Copyright 1999, Caldera Thin Clients, Inc.                     * 
 *       This software is licenced under the GNU Public License.        *
 *       Please see LICENSE.TXT for further information.                * 
 *                                                                      * 
 *                  Historical Copyright                                * 
 *									*
 *									*
 *									*
 *  Copyright (c) 1987, Digital Research, Inc. All Rights Reserved.	*
 *  The Software Code contained in this listing is proprietary to	*
 *  Digital Research, Inc., Monterey, California and is covered by U.S.	*
 *  and other copyright protection.  Unauthorized copying, adaptation,	*
 *  distribution, use or display is prohibited and may be subject to 	*
 *  civil and criminal penalties.  Disclosure to others is prohibited.	*
 *  For the terms and conditions of software code use refer to the 	*
 *  appropriate Digital Research License Agreement.			*
 *									*
 ************************************************************************/

#include "sdsdl_i.h"

static FONT_HEAD *find_font_seg0(DRIVERDATA *self, FONT_HEAD *fnt);
static int find_ade_seg(DRIVERDATA *self, FONT_HEAD **fnt, unsigned ch);
/*

		cseg
;;;		public	set_fnthdr
;;;		public	chk_ade		; jn 10-27-87
		public	chk_fnt
		public	inc_lfu
		public	CLC_DDA
		public	ACT_SIZ
		public	in_rot
		public	in_doub
		public	cpy_head
		public	ftmgradd
		public	txtblt_rrot_table_1
if VESA_MULTISEG
		extrn	VESA_SLICE:word
		extrn	setslice:near
		extrn	incdi1024:near
endif

ega_seq_add	equ	3c4h		;the ega sequencer add reg
ega_seq_data	equ	3c5h		;the ega sequencer data reg
ega_wmapmask_reg equ	2		;the write plane mask reg
ega_graphic_add	equ	3ceh		;the ega graphics add reg
ega_graphic_data equ	3cfh
ega_setres_reg	equ	0		;the ega plane set reset values 
ega_ensetres_reg equ	1		;the ega plane set reset enable bits
ega_datarot_reg	equ	3		;the ega data rotate register
ega_rmapmask_reg equ	4		;the ega plane read mask
ega_mode_reg	equ	5		;the ega data source mode register
ega_bitmask_reg	equ	8		;the ega bit mask register

public	txtblt_rep_rr
public	txtblt_tran_rr
public	txtblt_itran_rr
public	txtblt_rep_rl
public	txtblt_tran_rl
public	txtblt_itran_rl
public	txtblt_xor_rl_s
public	txtblt_xor_rr_s


set_flag	rb	1

;
;these two tables are initialized to rotate and mask the data 
;
txtblt_rrot_table_1 rb	2048
txtblt_rrot_table_2 rb	2048
double_table	    rb	512	
public	double_table
;
		dseg

		extrn	font_inf:word
		extrn	first:dword

		extrn	cur_font:dword
		extrn	act_font:dword
		extrn	cur_head:dword
		extrn	T_SCLSTS:word
		extrn	DDA_INC:word
		extrn	fi_flags:word
		extrn	FOFF:word
		extrn	poff_tbl:word
		extrn	seg_htbl:word
if ( num_planes gt 1 ) and ( not segment_access )
		extrn	plane_port_tbl:byte
		extrn	plane_read_tbl:byte
endif
ftmgradd	rd	0	
ftmgroff	dw	0		;offset of font mgr call
ftmgrseg	dw	0		;segment of font mgr call
		public	ftmgroff
		public	ftmgrseg
		cseg
;*******************************************
;txtblt_rep_rr
;	replace mode rotate right 
;
;	Entry
;		es:di = dest pointer ( screen )
;		ds:si = source pointer ( memory )
;		ah    = rotate count
;		dl    = left mask
;		dh    = right mask
;		ch    = middle byte count
;		cl    = vertical scan count
;		bp    = source form width
;********************************************	
;
;this code draws a character with left fringe only
;
txtblt_rep_rr_noright:
	out	dx, al				;apply the left mask
	xor	ch, ch
txtblt_rep_rr_noright_loop:
	mov	al, es:[di]			;get the dest byte
	mov	bl, [si]			;get the source data
	mov	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	stosb
	add	si, bp				;add the souce width in
	if	VESA_MULTISEG
	 dec	di
	 call	incdi1024
	else
	 add	di, next_line-1			;move to the next screen line
	endif

	loop	txtblt_rep_rr_noright_loop
	ret
;
;this code draws a character with left + right mask only
;
txtblt_rep_rr_nomid:
	mov	ch, al				;save the right mask here
	and	ah, ah
	jz	txtblt_rep_rr_noright
	dec	bp				;make the add -1 for speed
txtblt_rep_rr_nomid_loop:
	mov	al, ch
	out	dx, al				;apply the left mask
	mov	bl, [si]			;get the source data
	mov	al, es:[di]			;read the dest data
	mov	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	stosb					;apply the byte
	mov	al, ah
	out	dx, al				;apply the right mask
 	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	stosb
	add	si, bp				;add the souce width in
	add	di, next_line-2			;move to the next screen line
	if	VESA_MULTISEG
	 jnc	G0002
	 inc	cs:VESA_SLICE
	 call	setslice
G0002:
	endif
	dec	cl
	jnz	txtblt_rep_rr_nomid_loop
	ret
;
;this code is for middle + left + right
;
txtblt_rep_rr:
	mov	bx, ax
	mov	ax, dx				;save the masks
	not	ax				;invert the masks
	mov	dx, ega_graphic_data 		;get the port address
	and	ch, ch				;is this a no middle one
	jz	txtblt_rep_rr_nomid
txtblt_rep_rr_wide:
	push	si
	push	di
	push	ax				;save the masks
	out	dx, al				;set the left mask value
	mov	bl, [si]			;get the source data
	mov	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	mov	ah, es:[di]			;get the dest byte
	stosb					;apply the byte
	mov	al, 0ffh			;allow all bits to be set
	out	dx, al				;set the middle mask
	mov	ah, ch				;ah will be the middle count
txtblt_rep_rr_wide_bloop:
	mov	al, cs:txtblt_rrot_table_2[bx]	;fetch the second byte from src
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;fetch the first byte from nxt src
	stosb	
	dec	ah
	jnz	txtblt_rep_rr_wide_bloop
	pop	ax
	push	ax
	mov	al, ah
	out	dx, al				;apply the right mask
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	mov	ah, es:[di]			;get the dest byte
	stosb					;apply the byte
	pop	ax				;restore the masks
	pop	di
	pop	si
	add	si, bp				;add the souce width in
	if	VESA_MULTISEG
	 call	incdi1024
	else
	 add	di, next_line			;move to the next screen line
	endif
txtblt_rep_rr_wide_end:
	dec	cl
	jnz	txtblt_rep_rr_wide
	ret
;*******************************************
;txtblt_rep_rl
;	replace mode rotate left 
;
;	Entry
;		es:di = dest pointer ( screen )
;		ds:si = source pointer ( memory )
;		ah    = rotate count
;		dl    = left mask
;		dh    = right mask
;		ch    = middle byte count
;		cl    = vertical scan count
;		bp    = source form width
;********************************************	
;this code is for left only
txtblt_rep_rl_noright:
	out	dx, al				;apply the left mask
	xor	ch, ch
txtblt_rep_rl_noright_loop:
	mov	bl, [si]			;get the source data
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]
	mov	ah, es:[di]			;get the dest byte
	stosb					;apply the byte
	add	si, bp				;add the souce width in
	if	VESA_MULTISEG
	 dec	di	
	 call	incdi1024
	else
	 add	di, next_line-1			;move to the next screen line
	endif
	loop	txtblt_rep_rl_noright_loop
	ret
;this code is for left + right
txtblt_rep_rl_nomid:
	dec	bp
	mov	ch, al
	and	ah, ah
	jz	txtblt_rep_rl_noright
	dec	bp				;set up the next line counter
txtblt_rep_rl_nomid_loop:
	mov	al, ch
	out	dx, al				;apply the left mask
	mov	al, es:[di]			;get the dest data
	mov	bl, [si]			;get the source data
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]
	stosb					;apply the byte
	mov	al, ah
	out	dx, al				;apply the right mask
	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	mov	es:[di], al			;apply the byte
	add	si, bp				;add the source width in
	if	VESA_MULTISEG
	 dec	di	
	 call	incdi1024
	else
	 add	di, next_line-1			;move to the next screen line
	endif
	dec	cl
	jnz	txtblt_rep_rl_nomid_loop
	ret
;this code is for left + middle + right
txtblt_rep_rl:
	mov	bx, ax
	mov	ax, dx
	not	ax				;invert the masks
	mov	dx, ega_graphic_data 		;get the port
	and	ch, ch
	jz	txtblt_rep_rl_nomid
txtblt_rep_rl_wide:
	push	si
	push	di
	push	ax
	out	dx, al				;apply the left mask
	mov	al, es:[di]			;get the dest byte
	mov	bl, [si]			;get the source data
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]
	stosb					;apply the byte
	mov	ah, ch				;ah will be the middle count
	mov	al, 0ffh			;don't mask the middle
	out	dx, al
txtblt_rep_rl_wide_bloop:
	mov	al, cs:txtblt_rrot_table_2[bx]	;fetch the second byte from src
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;fetch the first byte from nxt src
	stosb	
	dec	ah
	jnz	txtblt_rep_rl_wide_bloop
txtblt_rep_rl_wide_right:
	pop	ax				;get the masks back
	push	ax
	mov	al, ah
	out	dx, al				;apply the right mask
	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	stosb					;apply the byte
	pop	ax				;restore the masks
	pop	di
	pop	si
	add	si, bp				;add the souce width in
	if	VESA_MULTISEG
	 call	incdi1024
	else
	 add	di, next_line			;move to the next screen line
	endif
	dec	cl
	jnz	txtblt_rep_rl_wide
	ret
;
;*******************************************
;txtblt_tran_rr
;	transparent mode rotate right 
;
;	Entry
;		es:di = dest pointer ( screen )
;		ds:si = source pointer ( memory )
;		ah    = rotate count
;		dl    = left mask
;		dh    = right mask
;		ch    = middle byte count
;		cl    = vertical scan count
;		bp    = source form width
;********************************************	
txtblt_tran_rr:
	mov	bx, ax
	mov	ax, dx
	not	ax
	mov	dx, ega_graphic_data 		;get the port
	and	ch, ch
	jnz	txtblt_tran_rr_wide
	jmp	txtblt_rep_rr_nomid
;
;this code is for middle + left + right
;
txtblt_tran_rr_wide:
	push	si
	push	di
	push	ax
	out	dx, al				;apply the left mask
	mov	bl, [si]			;get the source data
	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	stosb					;apply the dest
	mov	ah, ch				;ah will be the middle count
	mov	al, 0ffh			;don't mask the middle
	out	dx, al
txtblt_tran_rr_wide_bloop:
	mov	al, es:[di]			;fetch the dest
	mov	al, cs:txtblt_rrot_table_2[bx]	;fetch the second byte from src
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;fetch the first byte from nxt src
	stosb
	dec	ah
	jnz	txtblt_tran_rr_wide_bloop
txtblt_tran_rr_wide_right:
	pop	ax
	push	ax
	mov	al, ah				;apply the right mask
	out	dx, al
	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	mov	es:[di], al
	pop	ax
	pop	di
	pop	si
	add	si, bp				;add the souce width in
	if	VESA_MULTISEG
	 call	incdi1024
	else
	 add	di, next_line			;move to the next screen line
	endif
	dec	cl
	jnz	txtblt_tran_rr_wide
	ret
;*******************************************
;txtblt_tran_rl
;	transparent mode rotate left 
;
;	Entry
;		es:di = dest pointer ( screen )
;		ds:si = source pointer ( memory )
;		ah    = rotate count
;		dl    = left mask
;		dh    = right mask
;		ch    = middle byte count
;		cl    = vertical scan count
;		bp    = source form width
;********************************************	
;
;this code is for middle + left + right
;
txtblt_tran_rl:
	mov	bx, ax
	mov	ax, dx
	not	ax
	mov	dx, ega_graphic_data 		;get the port
	and	ch, ch
	jnz	txtblt_tran_rl_wide
	jmp	txtblt_rep_rl_nomid
txtblt_tran_rl_wide:
	push	si
	push	di
	push	ax
	out	dx, al				;apply the left mask
	mov	bl, [si]			;get the source data
	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]
	stosb					;apply the byte
	mov	ah, ch				;ah will be the middle count
	mov	al, 0ffh			;no mask in the middle
	out	dx, al
txtblt_tran_rl_wide_bloop:
	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_2[bx]	;fetch the second byte from src
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;fetch the first byte from nxt src
	stosb
	dec	ah
	jnz	txtblt_tran_rl_wide_bloop
txtblt_tran_rl_wide_right:
	pop	ax
	push	ax
	mov	al, ah
	out	dx, al				;apply the right mask
	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	mov	es:[di], al
	pop	ax
	pop	di
	pop	si
	add	si, bp				;add the souce width in
	if	VESA_MULTISEG
	 call	incdi1024
	else
	 add	di, next_line			;move to the next screen line
	endif
	dec	cl
	jnz	txtblt_tran_rl_wide
	ret
;
;*******************************************
;txtblt_itran_rr
;	inverse transparent mode rotate right 
;
;	Entry
;		es:di = dest pointer ( screen )
;		ds:si = source pointer ( memory )
;		ah    = rotate count
;		dl    = left mask
;		dh    = right mask
;		ch    = middle byte count
;		cl    = vertical scan count
;		bp    = source form width
;********************************************	
;
;
;this code draws a character with left fringe only
;
txtblt_itran_rr_noright:
	out	dx, al				;apply the left mask
	xor	ch, ch
txtblt_itran_rr_noright_loop:
	mov	al, es:[di]			;get the dest byte
	mov	bl, [si]			;get the source data
	mov	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	not	al				;invert the source
	stosb
	add	si, bp				;add the souce width in
	if	VESA_MULTISEG
	 dec	di
	 call	incdi1024
	else
	 add	di, next_line-1			;move to the next screen line
	endif
	loop	txtblt_itran_rr_noright_loop
	ret
;
;this code draws a character with left + right mask only
;
txtblt_itran_rr_nomid:
	mov	ch, al				;save the right mask here
	and	ah, ah
	jz	txtblt_itran_rr_noright
	dec	bp				;make the add -1 for speed
txtblt_itran_rr_nomid_loop:
	mov	al, ch
	out	dx, al				;apply the left mask
	mov	bl, [si]			;get the source data
	mov	al, es:[di]			;read the dest data
	mov	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	not	al				;invert the source
	stosb					;apply the byte
	mov	al, ah
	out	dx, al				;apply the right mask
 	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	not	al				;invert the source
	stosb
	add	si, bp				;add the souce width in
	add	di, next_line-2			;move to the next screen line
	if	VESA_MULTISEG
	 jnc	G0009
	 inc	cs:VESA_SLICE
	 call	setslice
G0009:
	endif
	dec	cl
	jnz	txtblt_itran_rr_nomid_loop
	ret
;
txtblt_itran_rr:
	mov	bx, ax
	mov	ax, dx
	not	ax
	mov	dx, ega_graphic_data 		;get the port
	and	ch, ch
	jnz	txtblt_itran_rr_wide
	jmp	txtblt_itran_rr_nomid
;
;this code is for middle + left + right
;
txtblt_itran_rr_wide:
	push	si
	push	di
	push	ax
	out	dx, al				;apply the left mask
	mov	bl, [si]			;get the source data
	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	not	al				;invert the data
	stosb					;apply the dest
	mov	ah, ch				;ah will be the middle count
	mov	al, 0ffh			;don't mask the middle
	out	dx, al
txtblt_itran_rr_wide_bloop:
	mov	al, es:[di]			;fetch the dest
	mov	al, cs:txtblt_rrot_table_2[bx]	;fetch the second byte from src
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;fetch the first byte from nxt src
	not	al				;invert the data
	stosb
	dec	ah
	jnz	txtblt_itran_rr_wide_bloop
txtblt_itran_rr_wide_right:
	pop	ax
	push	ax
	mov	al, ah				;apply the right mask
	out	dx, al
	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	not	al				;invert the data
	mov	es:[di], al
	pop	ax
	pop	di
	pop	si
	add	si, bp				;add the souce width in
	if	VESA_MULTISEG
	 call	incdi1024
	else
	 add	di, next_line			;move to the next screen line
	endif
	dec	cl
	jnz	txtblt_itran_rr_wide
	ret
;*******************************************
;txtblt_itran_rl
;	transparent mode rotate left color ix = 1
;
;	Entry
;		es:di = dest pointer ( screen )
;		ds:si = source pointer ( memory )
;		ah    = rotate count
;		dl    = left mask
;		dh    = right mask
;		ch    = middle byte count
;		cl    = vertical scan count
;		bp    = source form width
;********************************************	
;
;this code is for left only
txtblt_itran_rl_noright:
	out	dx, al				;apply the left mask
	xor	ch, ch
txtblt_itran_rl_noright_loop:
	mov	bl, [si]			;get the source data
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]
	mov	ah, es:[di]			;get the dest byte
	not	al				;invert the source
	stosb					;apply the byte
	add	si, bp				;add the souce width in
	if	VESA_MULTISEG
	 dec	di
	 call	incdi1024
	else
	 add	di, next_line-1			;move to the next screen line
	endif
	loop	txtblt_itran_rl_noright_loop
	ret
;this code is for left + right
txtblt_itran_rl_nomid:
	dec	bp
	mov	ch, al
	and	ah, ah
	jz	txtblt_itran_rl_noright
	dec	bp				;set up the next line counter
txtblt_itran_rl_nomid_loop:
	mov	al, ch
	out	dx, al				;apply the left mask
	mov	al, es:[di]			;get the dest data
	mov	bl, [si]			;get the source data
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]
	not	al				;invert the source
	stosb					;apply the byte
	mov	al, ah
	out	dx, al				;apply the right mask
	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	not	al				;invert the source
	mov	es:[di], al			;apply the byte
	add	si, bp				;add the source width in
	if	VESA_MULTISEG
	 dec	di
	 call	incdi1024
	else
	 add	di, next_line-1			;move to the next screen line
	endif
	dec	cl
	jnz	txtblt_itran_rl_nomid_loop
	ret
;
txtblt_itran_rl:
	mov	bx, ax
	mov	ax, dx
	not	ax
	mov	dx, ega_graphic_data 		;get the port
	and	ch, ch
	jnz	txtblt_itran_rl_wide
	jmp	txtblt_itran_rl_nomid
;
;this code is for middle + left + right
;
txtblt_itran_rl_wide:
	push	si
	push	di
	push	ax
	out	dx, al				;apply the left mask
	mov	bl, [si]			;get the source data
	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]
	not	al				;invert the data
	stosb					;apply the byte
	mov	ah, ch				;ah will be the middle count
	mov	al, 0ffh			;no mask in the middle
	out	dx, al
txtblt_itran_rl_wide_bloop:
	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_2[bx]	;fetch the second byte from src
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;fetch the first byte from nxt src
	not	al
	stosb
	dec	ah
	jnz	txtblt_itran_rl_wide_bloop
txtblt_itran_rl_wide_right:
	pop	ax
	push	ax
	mov	al, ah
	out	dx, al				;apply the right mask
	mov	al, es:[di]			;get the dest byte
	mov	al, cs:txtblt_rrot_table_2[bx]	;rotate and mask the source 
	inc	si
	mov	bl, [si]
	or	al, cs:txtblt_rrot_table_1[bx]	;rotate and mask the source 
	not	al
	mov	es:[di], al
	pop	ax
	pop	di
	pop	si
	add	si, bp				;add the souce width in
	if	VESA_MULTISEG
	 call	incdi1024
	else
	 add	di, next_line			;move to the next screen line
	endif
	dec	cl
	jnz	txtblt_itran_rl_wide
	ret
;
*/
/*******************************************
*txtblt_xor_rr_s
*txtblt_xor_rr_0
*	xor mode rotate right color ix = 0/1
*
*	Entry
*		es:di = dest pointer ( screen )
*		ds:si = source pointer ( memory )
*		ah    = rotate count
*		dl    = left mask
*		dh    = right mask
*		ch    = middle byte count
*		cl    = vertical scan count
*		bp    = source form width
*********************************************/
void txtblt_xor_rr_i(DRIVERDATA *self,
			Uint8 *dest, Uint8 *src, unsigned rotatecount,
			Uint8 leftmask, Uint8 rightmask, Uint8 midcount) 
{
	Uint8 bl, al;
	Uint16 bh;
	unsigned sx = 0;
	unsigned dx = 0;

	bh = (rotatecount << 8);
	leftmask  = ~leftmask;
	rightmask = ~rightmask;

	bl = src[sx];			/* Get the source data */
					/* Rotate & mask the source */
	al = self->common->txtblt_rrot_table_1[bl | bh];
	al &= leftmask;
	dest[dx++] ^= al;		/* apply the byte */

	while (midcount)
	{
		al = self->common->txtblt_rrot_table_2[bl | bh];
		++sx;
		bl = src[sx];
		al |= self->common->txtblt_rrot_table_1[bl | bh];
		dest[dx++] ^= al;
		--midcount;
	}
	al = self->common->txtblt_rrot_table_2[bl | bh];
	++sx;
	bl = src[sx];
	al |= self->common->txtblt_rrot_table_1[bl | bh];
	al &= rightmask;
	dest[dx] ^= al;
}
	

/*******************************************
*txtblt_xor_rl_s
*txtblt_xor_rl_0
*	xor mode rotate left color ix = 0/1
*
*	Entry
*		es:di = dest pointer ( screen )
*		ds:si = source pointer ( memory )
*		ah    = rotate count
*		dl    = left mask
*		dh    = right mask
*		ch    = middle byte count
*		cl    = vertical scan count
*		bp    = source form width
*********************************************/

void txtblt_xor_rl_i(DRIVERDATA *self,
			Uint8 *dest, Uint8 *src, unsigned rotatecount,
			Uint8 leftmask, Uint8 rightmask, Uint8 midcount) 
{
	Uint8 bl, al;
	Uint16 bh;
	unsigned sx = 0;
	unsigned dx = 0;

	bh = (rotatecount << 8);
	leftmask  = ~leftmask;
	rightmask = ~rightmask;

	bl = src[sx++];			/* Get the source data */
						/* Rotate & mask the source */
	al = self->common->txtblt_rrot_table_2[bl | bh];
	bl = src[sx];
	al |= self->common->txtblt_rrot_table_1[bl | bh];
	al &= leftmask;
	dest[dx++] ^= al;		/* apply the byte */

	while (midcount)
	{
		al = self->common->txtblt_rrot_table_2[bl | bh];
		++sx;
		bl = src[sx];
		al |= self->common->txtblt_rrot_table_1[bl | bh];
		dest[dx++] ^= al;
		--midcount;
	}
	al = self->common->txtblt_rrot_table_2[bl | bh];
	++sx;
	bl = src[sx];
	al |= self->common->txtblt_rrot_table_1[bl | bh];
	al &= rightmask;
	dest[dx] ^= al;
}

	

/*************************
 * in_doub
 *	
 *	initializes the double table
 *************************/

void in_doub(DRIVERDATA *self)
{
	Uint16 *di = self->common->double_table;
	Uint16 ch16;
	Uint16 ch;
	Uint16 mask8, mask16;

	if (self->common->double_inited) return;
	for (ch = 0; ch < 256; ++ch)
	{
		ch16 = 0;
		mask8 = 0x80;
		mask16 = 0xC000;
		while (mask8)
		{
			if (ch & mask8) ch16 |= mask16;	
			mask8 >>= 1;
			mask16 >>= 2;
		}
		*di++ = ch16;
	}
}



/*************************
 * in_rot
 *	initialize the two rotation tables
 *	
 *************************/

void in_rot(DRIVERDATA *self)
{
	/* As you may guess, mechanistic translation of the original 8086 code*/
	Uint8 *di = self->common->txtblt_rrot_table_1;
        Uint8 *si = self->common->txtblt_rrot_table_2;
	Uint8 ah = 0, al = 0;
	Uint8 bl;
	Uint8 ch = 8, cl = 0;
	Uint8 dh = 0, dl = 0xFF;	
	Uint16 bp;

	if (self->common->txtblt_rrot_inited) return;

	for (ch = 8; ch > 0; ch--)
	{
		for (bp = 0; bp < 256; bp++)
		{
			al = (ah >> cl);
			bl = (ah << (8 - cl));
			al &= dl;
			bl &= dh;
			*di++ = al;
			*si++ = bl;
			++ah;
		}	
		ah = 0;
		dl = dl >> 1;
		dh = ~dl;
		++cl;
	}
	self->common->txtblt_rrot_inited = 1;
/*
	{
		int n;
		for (n = 0; n < 2048; n++)
		{
			fprintf(stderr, "%02x %02x -> %02x %02x\n",
				(n >> 8), (n & 0xFF), 
			self->common->txtblt_rrot_table_1[n],
			self->common->txtblt_rrot_table_2[n]);
		}
	}*/
}

/*************************
; CLC_DDA
; entry
;	4[bp] = actual size
;	6[bp] = requested size
;
; exit
;	ax = dda_inc
;**************************/ 
double CLC_DDA(DRIVERDATA *self, double actual, double requested)
{	
	if (requested <= actual)
	{
		self->T_SCLSTS = 0;
		if (!actual) actual = 1;
		return requested / actual;
	}
	self->T_SCLSTS = 1;
	requested -= actual;
	if (requested >= actual) return 1.0;
	
	return requested / actual;
}

/**************************
 ACT_SIZ
 entry
	4[bp] = size to scale
 exit
	ax = actual size
**************************/

unsigned ACT_SIZ(DRIVERDATA *self, unsigned size)
{
	double bx;	
	Uint32 ax;

	if (self->DDA_INC == 1.0)  return 2 * size;
	if (!size) return 0;
	bx = 0.5;
	ax = 0;
	if (self->T_SCLSTS & 1)	/* Getting bigger */
	{
		while (size--)
		{
			bx += self->DDA_INC; 
			if (bx > 1.0) 
			{
				++ax;
				bx -= 1.0;
			}
			++ax;
		}
		return ax;
	}
	while (size--)
	{
		bx += self->DDA_INC;
		if (bx > 1.0) 	// Compare ACT_SIZ_SMALL_LOOP in opttdraw.a86
		{	
			++ax;
			bx -= 1.0;
		}
	}
	if (!ax) ++ax;
	return ax;
}



/**************************
 *CPY_HEAD
 **************************/

void cpy_head(DRIVERDATA *self)
{
	memcpy(self->cur_head, self->cur_font, sizeof(*self->cur_head));
}


/**************************
 *  inc_lfu
 **************************/

void inc_lfu(DRIVERDATA *self)
{
	++self->act_font->lfu;
}

/*************************
 *  chk_fnt
 *************************/

void chk_fnt(DRIVERDATA *self)
{
	if (self->act_font->flags & 0x10) /* Font not present */
	{
		/* XXX Call external font manager, passing address of 
		 * self->act_font */
		self->act_font->flags &= ~0x10;
/*	mov	ax, di
	mov	bx, es
	callf	ftmgradd		;here we go	
	and	fi_flags, 0ffefh	;enable the local font header
	mov	ax, es:word ptr 70[di]
	mov	poff_tbl+2, ax		;fix up the segment
	mov	seg_htbl, ax		;fix up segment of horz off table
	mov	ax, es:word ptr 78[di]
	mov	FOFF+2, ax */
	}
}
/*
;
; Below this point, not present in SDPSC9
;

if 0

;==========
set_fnthdr:	; set font header
;==========
;
;	Set the current font header.
;
;	Entry:	ax = char
;
;	Exit:	act_font = font header for this character
;		cur_font = act_font
;		font_inf = *cur_font

	push ax
	call chk_ade
	; Is the proper header in place?
	cmp ax, 0 ! je sfe
	  ; Nope, 
	  ; Is the char out of range
	  cmp ax, 2 ! jne sf1
	    ; Yes,  force a space
	    pop ax			; clear the incoming char from stack
	    mov ax, 20h			; set a space
	    push ax			
	    call chk_ade
	    cmp ax, 0 ! je sfe
sf1:
	    call chk_fnt
sfe:
	pop ax
	ret

eject

*/
/*
 * jn 10-27-87
 * This is the support for a segmented screen font.
 *
 * This routine must be called for every character.
 *
 * If the ADE value of the character passed in falls within
 * the range of the characters in the currently selected font
 * then we just return.
 *
 * If the ADE value of the character passed in not within the
 * the range of the characters in the currently selected font
 * the following is done:
 *
 *	1) The font chain traversed, starting with first, until
 *	   the first font header segment for the currently selected
 *	   font is found.
 *
 *	2) The font segments for the currently selected font are
 *	   traversed until the font segment containing 
 *	   the required ADE value is found.
 *
 *	3) act_font is set to the new font header.
 *
 *	Entry:	char passed in on stack
 *
 *	Exit:	act_font = the proper font header for the entry character 
 *		cur_font = act_font
 *		the new font header is copied into the current virtual
 *		work station font info structure.
 *		ax = 0 - if no change to the font_inf header
 *		   = 1 - if there was a change.
 *			 or if the font in the font header is not loaded.
 *		   = 2 - if the character was out of range.
 *
 *	Note:	This routine preserves all registers used
 *		except ax.  This is because is was added onto an
 *		existing system.
 *
 *		act_font is relative to the current virtual work 
 *		station
 */

unsigned chk_ade(DRIVERDATA *self, unsigned ch)
{
	FONT_HEAD *fh;

	/* Does the ADE value of the character fall
	 * within the range of the current font header ADE values? */

	ch &= 0xFF;	// XXX Restrict to ASCII range for now

	if (ch >= self->act_font->first_ade && ch <= self->act_font->last_ade)
	{
	    /* The character falls within
	     * the ADE bounds of the current font header.
	     * Is the font present? */
		if (self->act_font->flags & 0x10)	/* Font not present */
			return 1;
		else	return 0;
	}

	/* the character does not fall within the bounds of the
	 * current font header.  find the correct header. */

	fh = find_font_seg0(self, self->act_font);
	if (find_ade_seg(self, &fh, ch))
	{
		return 2;	/* No such character */
	}
	self->act_font = self->cur_font = fh;
	cpy_head(self);
	return 1;
}


static int find_ade_seg(DRIVERDATA *self, FONT_HEAD **fnt, unsigned ch)
{
/*
 *	Find the font header segment that contains the
 *	ADE segment range
 *
 *	Entry:	ax = char
 *		es:si = first header for this font style and point size
 *
 *	Exit:	es:si = header we want.
 *		ax = 0 - if we found a font segment that contains
 *			 the char we want
 *		   = 1 - if the character is out of bounds
 */
	do
	{
		if (ch >= (*fnt)->first_ade && ch <= (*fnt)->last_ade)
		{
			return 0;
		}
		if (!(*fnt)->next_sect)
		{
			return 1;
		}
		*fnt = (*fnt)->next_sect;
	}
	while (1);
}


static FONT_HEAD *find_font_seg0(DRIVERDATA *self, FONT_HEAD *match)
{
/*
 *	Find the first segment of this font.
 *
 *	Entry:	es:si = act_font
 *
 *	Exit:	es:si = addr of first font header segment of the
 *			desired font face and point size.
 */
	unsigned id = match->font_id;
	signed   pt = match->point;
	FONT_HEAD *head, *last;

	for (head = self->common->font_top; head != NULL; 
		head = head->next_font)
	{
		last = head;
		if (head->font_id == id && head->point == pt)
		{
			return head;
		}
	}
	return last;	/* Font not found. Should not be possible because 
			 * why didn't it find 'match'? */
}
