/*
SDSDL: GEM video driver for SDL
Copyright 2012 John Elliott <jce@seasip.demon.co.uk>
Based on SDPSC9.VGA copyright 1987, 1999 Caldera Thin Clients, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "gempb.h"

typedef SDL_Event *EVPTR;
typedef SDL_Surface *PSURFACE;
typedef SDL_Rect *PRECT;
typedef struct mfdb *PMFDB;
typedef struct font_head *PFONT;
typedef void (*FONTMGRFUNC)(PFONT pf);

/* Handle SDL events. Returns 1 if event processed */
int sd_handle_event(unsigned handle, EVPTR ev);

/* Set reported screen resolution and depth. */
void sd_setwidth(unsigned w);
void sd_setheight(unsigned h);
void sd_setplanes(unsigned np);

/* Make SDSDL render into a rectangle on an existing surface rather than 
 * creating its own */
void sd_setsurface(PSURFACE s, PRECT window);


unsigned sd_dispatch(GSXPB *pb);

unsigned sd_opnwk(unsigned work_in[11], unsigned *handle, 
			unsigned work_out[57]);	/* 1 */
void sd_clswk(unsigned handle);	/* 2 */
void sd_clrwk(unsigned handle);	/* 3 */
void sd_updwk(unsigned handle);	/* 4 */
void sd_escape(GSXPB *pb);	/* 5 */

/* Escapes: */
void sd_qchcells(unsigned handle, signed *rows, signed *cols);	/* 5:1 */
void sd_exit_cur(unsigned handle);				/* 5:2 */
void sd_enter_cur(unsigned handle);				/* 5:3 */
void sd_curup(unsigned handle);					/* 5:4 */
void sd_curdown(unsigned handle);				/* 5:5 */
void sd_curleft(unsigned handle);				/* 5:6 */
void sd_curright(unsigned handle);				/* 5:7 */
void sd_curhome(unsigned handle);				/* 5:8 */
void sd_eeos(unsigned handle);					/* 5:9 */
void sd_eeol(unsigned handle);					/* 5:10 */
void sd_scuraddress(unsigned handle, unsigned row, unsigned col);/* 5:11 */
void sd_curtext(unsigned handle, unsigned count, unsigned *str);/* 5:12 */
void sd_rvon(unsigned handle);					/* 5:13 */
void sd_rvoff(unsigned handle);					/* 5:14 */
void sd_qcuraddress(unsigned handle, unsigned *row, unsigned *col); /* 5:15 */
unsigned sd_qtabstatus(unsigned handle);			/* 5:16 */
void sd_hardcopy(unsigned handle);				/* 5:17 */
void sd_dspcur(unsigned handle, signed x, signed y);		/* 5:18 */
void sd_rmcur(unsigned handle);					/* 5:19 */
void sd_form_adv(unsigned handle);				/* 5:20 */
void sd_output_window(unsigned handle, signed xy[]);		/* 5:21 */
void sd_clear_disp_list(unsigned handle);			/* 5:22 */
void sd_bit_image(unsigned handle, unsigned len_filename,
	unsigned *filename, 
	unsigned aspect, unsigned xscale, unsigned yscale,
	unsigned h_align, unsigned v_align, signed xy[]);	/* 5:23 */

unsigned sd_spalette(unsigned handle, unsigned palette);	/* 5:60 */
void sd_sound(unsigned handle, unsigned frequency, unsigned duration);
unsigned sd_mute(unsigned handle, signed action);		/* 5:62 */


void sd_pline(unsigned handle, unsigned count, signed xy[]);	/* 6 */
void sd_pmarker(unsigned handle, unsigned count, signed xy[]);	/* 7 */
void sd_gtext(unsigned handle, signed x, signed y, unsigned count, 
		unsigned *text, int fxn);			/* 8 */
void sd_fillarea(unsigned handle, unsigned count, signed xy[]);	/* 9 */
void sd_cellarray(unsigned handle, signed *xy, unsigned row_len,
		unsigned el_used, unsigned num_rows, unsigned wr_mode,
		unsigned *colours);
void sd_gdp(GSXPB *pb);	/* 11 */

/* GDPs: */
void sd_bar    (unsigned handle, signed *xy);	/* 11.1 */
void sd_arc    (unsigned handle, signed xc, signed yc, signed xrad, 
		unsigned sang, unsigned eang);	/* 11.2 */
void sd_pieslice(unsigned handle, signed xc, signed yc, signed xrad,
		unsigned sang, unsigned eang);	/* 11.3 */
void sd_circle  (unsigned handle, signed xc, signed yc, signed xrad); /* 11.4 */
void sd_ellipse (unsigned handle, signed xc, signed yc, signed xrad,
		 signed yrad); /* 11.5 */
void sd_ellarc(unsigned handle, signed xc, signed yc, signed xrad, 
		signed yrad, unsigned sang, unsigned eang);	/* 11.6 */
void sd_ellpie(unsigned handle, signed xc, signed yc, signed xrad,
		signed yrad, unsigned sang, unsigned eang);	/* 11.7 */
void sd_rbox     (unsigned handle, signed xy[]);		/* 11.8 */
void sd_rfbox    (unsigned handle, signed xy[]);		/* 11.9 */
void sd_justified(unsigned handle, signed x, signed y, unsigned count, /*11.10*/
		  unsigned *text,  signed width, unsigned wordspace, 
		  unsigned charspace, unsigned *sizecount, unsigned *sizes,
		  unsigned fx);

unsigned sd_stheight  (unsigned handle, unsigned ptsize, 
			signed *char_width, signed *char_height, 
			signed *cell_width, signed *cell_height); /* 12 */
signed sd_strotation    (unsigned handle, signed angle);  /* 13 */
void sd_setcolor(unsigned handle, unsigned colour, const unsigned *rgb); /* 14 */
unsigned sd_sltype    (unsigned handle, unsigned style);  /* 15 */
unsigned sd_slwidth   (unsigned handle, unsigned width);  /* 16 */
unsigned sd_slcolor   (unsigned handle, unsigned colour); /* 17 */
unsigned sd_smtype    (unsigned handle, unsigned type);   /* 18 */
unsigned sd_smheight  (unsigned handle, unsigned height); /* 19 */
unsigned sd_smcolor   (unsigned handle, unsigned colour); /* 20 */
unsigned sd_stfont    (unsigned handle, unsigned font);	  /* 21 */
unsigned sd_stcolor   (unsigned handle, unsigned colour); /* 22 */ 
unsigned sd_sfinterior(unsigned handle, unsigned fill);	  /* 23 */
unsigned sd_sfstyle   (unsigned handle, unsigned fill);	  /* 24 */
unsigned sd_sfcolor   (unsigned handle, unsigned colour); /* 25 */
unsigned sd_qcolor    (unsigned handle, unsigned index, unsigned flag, 
			unsigned rgb[3]);		/* 26 */
unsigned sd_qcellarray(unsigned handle, signed *xy, unsigned row_len,
		unsigned num_rows, unsigned *el_used, unsigned *rows_used,
		unsigned *status, unsigned *colours);	/* 27 */
unsigned sdrq_locator(unsigned handle, unsigned loc_number, 
				signed initx, signed inity,
				signed *xres, signed *yres,
				unsigned *term, unsigned *status); /* 28 */
unsigned sdrq_valuator(unsigned handle, unsigned val_number, unsigned value,
				unsigned *val_out, unsigned *term,
				unsigned *status); /* 29 */
unsigned sdrq_choice  (unsigned handle, unsigned chc_number, unsigned value,
				unsigned *val_out, unsigned *status); /* 30 */
unsigned sd_string (unsigned handle, signed maxlen, /* 31 */
			unsigned echo, signed echo_xy[2], unsigned *result);
unsigned sd_swrmode(unsigned handle, unsigned mode);	/* 32 */
unsigned sd_sinmode(unsigned handle, unsigned type, unsigned mode); /* 33 */

void	 sd_qlattributes(unsigned handle, unsigned attributes[], 
			 signed *lwidth); /* 35 */
void	 sd_qmattributes(unsigned handle, unsigned attributes[], 
			 signed *size); /* 36 */
void     sd_qfattributes(unsigned handle, unsigned attributes[]); /* 37 */
void     sd_qtattributes(unsigned handle, unsigned attributes[]); /* 38 */
void	 sd_stalignment (unsigned handle, unsigned horiz, unsigned vert,
				unsigned *h_out, unsigned *v_out); /* 39 */

unsigned sd_opnvwk(unsigned work_in[11], unsigned *handle, 
			unsigned work_out[57]);	/* 100 */
void sd_clsvwk(unsigned handle);	/* 101 */
void sd_qextnd(unsigned handle, unsigned owflag, unsigned result[57]); /* 102 */
void sd_contourfill(unsigned handle, signed x, signed y, signed pen); /* 103 */
unsigned sd_sfperimeter  (unsigned handle, unsigned perimeter); /* 104 */
void sd_get_pixel(unsigned handle, signed x, signed y, 
			unsigned *pel, unsigned *colour); /* 105 */
unsigned sd_steffects(unsigned handle, unsigned effect); /* 106 */
unsigned sd_stpoint  (unsigned handle, unsigned ptsize, 
			signed *char_width, signed *char_height, 
			signed *cell_width, signed *cell_height); /* 107 */
void sd_slends(unsigned handle, unsigned requested[2], 
			unsigned actual[2]);			  /* 108 */
void sd_rocpyfm(unsigned handle, unsigned mode, signed xy[], 	  /* 109 */
			PMFDB mfdb1, PMFDB mfdb2);
void sd_trnfm(unsigned handle, PMFDB mfdb1, PMFDB mfdb2); 	  /* 110 */
void sd_scform(unsigned handle, unsigned *data);		  /* 111 */
int  sd_udpat (unsigned handle, unsigned *data, unsigned planes); /* 112 */
void sd_udstyle(unsigned handle, unsigned pattern); /* 113 */
void sd_recfl (unsigned handle, signed xy[4]);	/* 114 */ 
unsigned sd_qinmode(unsigned handle, unsigned dev_type); /* 115 */
void sd_qtextent(unsigned handle, unsigned count, unsigned *string, 
			signed *dimensions);	/* 116 */
signed sd_qtwidth(unsigned handle, unsigned ch, signed *cell_width,
			signed *left_delta, signed *right_delta);
unsigned sd_extimv(unsigned handle, TIMVEC vec, TIMVEC *old);	/* 118 */
unsigned sd_load_fonts(unsigned handle, PFONT font, unsigned char *textbuf, 
				unsigned len, FONTMGRFUNC pfunc); /* 119 */
void	 sd_unload_fonts(unsigned handle, PFONT font);		/* 120 */
void sd_rtcpyfm(unsigned handle, unsigned mode, signed xy[], 	  /* 121 */
			PMFDB mfdb1, PMFDB mfdb2, unsigned fg, unsigned bg);
void sd_show_c(unsigned handle, unsigned reset);	/* 122 */
void sd_hide_c(unsigned handle);			/* 123 */
void sd_qmouse(unsigned handle, unsigned *buttons, signed *x, signed *y);
void sd_exbutv(unsigned handle, BUTVEC vec, BUTVEC *old);	/* 125 */
void sd_exmotv(unsigned handle, MOTVEC vec, MOTVEC *old);	/* 126 */
void sd_excurv(unsigned handle, CURVEC vec, CURVEC *old);	/* 127 */
unsigned sd_qkeys (unsigned handle);	/* 128 */
void sd_sclip (unsigned handle, unsigned enable, signed xy[4]); /* 129 */
unsigned sd_qtname(unsigned handle, unsigned font, unsigned *result); /* 130 */
void sd_qtfontinfo(unsigned handle, unsigned *minADE, unsigned *maxADE,
			signed *distances, signed *maxwidth, signed *effects);
void sd_qtjustified(unsigned handle, signed x, signed y, signed req_width,
		unsigned count, unsigned *str, unsigned word_space, 
		unsigned char_space, signed *offsets);	/* 132 */
void sd_delay(unsigned handle, unsigned usec);	/* 1000 */

/* For checking buffer overflows and the like: Assert that internal 
 * data structures are undamaged. */
void sd_assertvalid(unsigned handle);


#ifdef __cplusplus
}
#endif

