/*
SDSDL: GEM video driver for SDL
Copyright 2012 John Elliott <jce@seasip.demon.co.uk>
Based on SDPSC9.VGA copyright 1987, 1999 Caldera Thin Clients, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

typedef struct mfdb
{
	void *mp;
	unsigned fwp;
	unsigned fh;
	unsigned fww;
	unsigned ff;
	unsigned np;
	unsigned r1;
	unsigned r2;
	unsigned r3;
} MFDB;

typedef struct gsxctrl
{
	unsigned function;
	unsigned ptsin_count;
	unsigned ptsout_count;
	unsigned intin_count;
	unsigned intout_count;
	unsigned subfunction;
	unsigned handle;
	void *ptr1;
	void *ptr2;
	void *ptr3;
	unsigned extra[5];	/* For cell array functions */
} GSXCTRL;


typedef struct gsxpb
{
	GSXCTRL *contrl;
	unsigned *intin;
	signed *ptsin;
	unsigned *intout;
	signed *ptsout;
} GSXPB;


typedef void (*TIMVEC)(void);
typedef void (*BUTVEC)(unsigned buttons);
typedef void (*MOTVEC)(signed x, signed y);
typedef void (*CURVEC)(signed x, signed y);
