/*
SDSDL: GEM video driver for SDL
Copyright 2012 John Elliott <jce@seasip.demon.co.uk>
Based on SDPSC9.VGA copyright 1987, 1999 Caldera Thin Clients, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/* fh_flags   */
#define	DEFAULT   1	/* this is the default font (face and size) */
#define	HORZ_OFF  2	/* there are left and right offset tables */
#define	STDFORM   4	/* is the font in standard format */
#define MONOSPACE 8     /* mono-spaced font */

/* style bits */
#define	THICKEN	0x001
#define	LIGHT	0x002
#define	SKEW	0x004
#define	UNDER	0x008
#define	OUTLINE 0x010
#define	SHADOW	0x020
#define ROTODD  0x040
#define ROTHIGH 0x080
#define	ROTATE	0x0c0
#define	SCALE	0x100

typedef struct font_head {		/* descibes a font */
    unsigned font_id;
    signed point;
    char name[32];
    unsigned first_ade;
    unsigned last_ade;
    unsigned top;
    unsigned ascent;
    unsigned half;
    unsigned descent;		
    unsigned bottom;
    unsigned max_char_width;
    unsigned max_cell_width;
    unsigned left_offset;		/* amount character slants left when skewed */
    unsigned right_offset;		/* amount character slants right */
    unsigned thicken;		/* number of pixels to smear */
    unsigned ul_size;		/* size of the underline */
    unsigned lighten;		/* mask to and with to lighten  */
    unsigned skew;			/* mask for skewing */
    unsigned flags;		    

    unsigned char *hor_table;	  	/* horizontal offsets */
    unsigned *off_table;		/* character offsets  */
    unsigned char *dat_table;		/* character definitions */
    unsigned form_width;
    unsigned form_height;

    struct font_head *next_font;/* pointer to next font */
    struct font_head *next_sect; /* pointer to next segment of font */	
    signed lfu;			/* least frequently used counter for font */
    signed *file_off;		/* gdos data for offset into font file */
    signed data_siz;		/* gdos data for size of font data */
    signed reserve[8];		/* reserved data area for future use */
} FONT_HEAD;
