/************************************************************************

    MONITOR v1.00 - switch monitors on Compaq laptop

    Copyright (C) 2001  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

#include "ppdgem.h"    
#include <dos.h>
#include <stdio.h>
#include <string.h>

static int cpqcheck(void)
{
	union REGS rg;

	rg.x.ax = 0xBF03;
	rg.x.bx = 0x0000;
	int86(0x10, &rg, &rg);

	if (rg.h.bl == 0) return 0;
	return 1;
}


static int extmon(void)
{
	union REGS rg;

	rg.x.ax = 0xbf00;
	int86(0x10, &rg, &rg);

	rg.x.ax = 0xbf03;
	rg.x.bx = 0x0000;
	int86(0x10, &rg, &rg);

	if (rg.h.bh != 0 && rg.h.bh != 3) return 0;
	return 1;
}


static void intmon(void)
{
	union REGS rg;

	rg.x.ax = 0xbf01;
	int86(0x10, &rg, &rg);
}

/*
static int is_internal(void)
{
	union REGS rg;
	rg.x.ax = 0xBF03;
	rg.x.bx = 0x0000;
	int86(0x10,&rg, &rg);

	if (rg.h.bh == 1 || rg.h.bh == 3) return 1;
	return 0;
}
*/


static char *showmon(unsigned char c, int internal)
{
	static char buf[20];

	sprintf(buf, "0x%02x", c);
	switch(c)
	{
		case  0: return "None";
		case  1: return "Dual-mode monitor";
		case  2: return "5153 RGB monitor";
		case  3: return "Compaq Color monitor";
		case  4: return "640x400 flat panel";
		case  5: return "VGC mono";
		case  6: return "VGC colour";
		case  7: if (internal) return "8-level mono LCD VGA";
				 else return "1024x768 VGA mono";
		case  8: if (internal) return "16-level mono plasma VGA";
				 else return "1024x768 VGA colour";
		case  9: return "4-level mono LCD CGA";
		case 10: return "16-level mono LCD VGA";
		case 11: return "Active-matrix colour VGA";
		case 12: return "Active-matrix mono VGA";
		case 13: return "STN colour VGA";
	}
	return buf;
}

char *mondiag(char *buf)
{
	union REGS rg;
	rg.x.ax = 0xBF03;
	rg.x.bx = 0x0000;
	rg.x.cx = 0x0000;
	rg.x.dx = 0x0000;
	int86(0x10,&rg, &rg);
	
	strcat(buf, "Active monitor:   ");
	switch(rg.h.bh)
	{
		case 0: strcat(buf, "External"); break;
		case 1: strcat(buf, "Internal"); break;
		case 3: strcat(buf, "Both"); break;
		case 4: strcat(buf, "Neither"); break;
		default: sprintf(buf + strlen(buf), "0x%02x", rg.h.bh); break;
	}	
	strcat(buf, "|Master mode:      ");
	switch(rg.h.bl)
	{
		case 0:  strcat(buf, "Not present"); break;
		case 4:  strcat(buf, "CGA"); break;
		case 5:  strcat(buf, "EGA"); break;
		case 7:  strcat(buf, "MDA"); break;
		case 8:  strcat(buf, "LCD"); break;
		case 9:  strcat(buf, "Plasma VGA"); break;
		case 10: strcat(buf, "TFT"); break;
		default: sprintf(buf + strlen(buf), "0x%02x", rg.h.bl); break;
	}
	sprintf(buf + strlen(buf), "|ASIC type:        0x%02x", rg.h.ch);
	/* No room for this in the message box
	printf("Modes supported:  ");
	if (!rg.h.cl)    fputs("None", stdout);
	if (rg.h.cl &    1) fputs("CGA ", stdout);
	if (rg.h.cl &    8) fputs("MDA ", stdout);
	if (rg.h.cl & 0x10) fputs("BitBLT ", stdout);
	if (rg.h.cl & 0x20) fputs("132-column ", stdout);
	if (rg.h.cl & 0x40) fputs("640x480x256 ", stdout);
	if (rg.h.cl & 0x80) fputs("8-bit DAC ", stdout);
	fputc('\n', stdout);
	*/
	strcat(buf, "|Internal monitor: "); strcat(buf, showmon(rg.h.dh, 1));
	strcat(buf, "|External monitor: "); strcat(buf, showmon(rg.h.dl, 0));
	return buf;
}


#define	ARROW		0
#define	HOUR_GLASS	2			

#define	DESK		0

#define END_UPDATE	0
#define	BEG_UPDATE	1




static WORD	gl_wchar;			/* character width		*/
static WORD	gl_hchar;			/* character height		*/
static WORD	gl_wbox;			/* box (cell) width		*/
static WORD	gl_hbox;			/* box (cell) height		*/
static WORD	gem_handle;			/* GEM vdi handle		*/
static WORD	vdi_handle;			/* hello vdi handle		*/
static WORD	gl_apid;			/* application ID		*/
static WORD	gl_rmsg[8];			/* message buffer		*/
static LPBYTE	ad_rmsg;		/* LONG pointer to message bfr	*/
static WORD	gl_item = 0;		/* hello menu item		*/
static WORD	ev_which;			/* event message returned value	*/




static char alert[1024];

void on_ac_open(void)
{
	int choice;
	
	if (!cpqcheck())
	{
		form_alert(1, "[3][No Compaq video adaptor found.][ Cancel ]");
		return;
	}
	do
	{
		strcpy(alert, "[0][");
		mondiag(alert);
		strcat(alert, "][ Internal | External | Cancel ]");

		choice = form_alert(3, alert);
		switch(choice)
		{
			case 1: intmon(); break;
			case 3: return;
		}
		if (choice == 2 && (!extmon()))
		{
			form_alert(1, "[3][No external monitor found.][ Cancel ]");
		}
	}
	while (1);
}



void hndl_mesag()
{
	if ( gl_rmsg[0] == AC_OPEN && gl_rmsg[4] == gl_item) on_ac_open();
} 



static void monitor(void)
{
	do
	{
		ev_which = evnt_mesag(ad_rmsg);
		wind_update(BEG_UPDATE);
		hndl_mesag();
		wind_update(END_UPDATE);
	}
	while (1);
}


/*------------------------------*/
/*	hello_init		*/
/*------------------------------*/
WORD monitor_init(void)
{
	gl_apid = appl_init(NULL);			/* initialize libraries	*/
	wind_update(BEG_UPDATE);
	
	gem_handle = graf_handle(&gl_wchar,&gl_hchar,&gl_wbox,&gl_hbox);
	vdi_handle = gem_handle;

	gl_item = menu_register(gl_apid, ADDR("  Monitor"));
	ad_rmsg = ADDR((BYTE *) &gl_rmsg[0]);

	wind_update(END_UPDATE);
	return(TRUE);
}


WORD GEMAIN(WORD argc, BYTE *ARGV[])
{
	if (monitor_init())			/* initialization	*/
	{
		monitor();
	}
	return 0;
}

