
#include "gemglk.h"

/* Translation tables. 0x07 means nonexistent character. EXP1-EXP6 are
 * expansion tokens */
#undef NONE

#define NONE 0x07
#define EXP1 0x01
#define EXP2 0x02
#define EXP3 0x03
#define EXP4 0x04
#define EXP5 0x05

unsigned char iso_to_gem[256] = 
{
	/* All control characters banned save 0x0A, linefeed */

	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,	// 0x00 - NONE 
	NONE, NONE, 0x0A, NONE, NONE, NONE, NONE, NONE,	// 0x08 - 0x0F 
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,	// 0x10 - 0x17 
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,	// 0x18 - 0x1F 

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, // Printable range
	0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
	0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 
	0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 
	0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 
	0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 
	0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, NONE,

	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,	// 0x80 - 0x87 
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,	// 0x88 - 0x8F 
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,	// 0x90 - 0x97 
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,	// 0x98 - 0x9F 
	
	NONE, 0xAD, 0xB3, 0x9C, 0x9E, 0xB2, 0x7C, 0xB9,	// 0xa0
	NONE, 0xBD, 0xA6, 0xAE, NONE, 0xC4, 0xBE, NONE,
	0xC6, 0xF1, 0xFD, 0x33, 0x27, 0xE6, 0xBC, 0xC3,	// 0xb0
	NONE, 0x31, 0xA7, 0xAF, EXP1, EXP2, EXP3, 0xA8,
	0xB6, 0xC7, 0xC8, 0xB7, 0x8E, 0x8F, 0x92, 0x80,	// 0xc0
	0xC9, 0x90, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,	
	0x44, 0xA5, 0xD0, 0xD1, 0xD2, 0xD8, 0x99, 0x78,	// 0xd0
	0x9D, 0xD5, 0xD6, 0xD7, 0x9A, 0x59, EXP4, 0xD9,
	0x85, 0xA0, 0x83, 0xB0, 0x84, 0x86, 0x91, 0x87,
	0x8A, 0x82, 0x88, 0x89, 0x8D, 0xA1, 0x8C, 0x8B,
	0x64, 0xA4, 0x95, 0xA2, 0x93, 0xB1, 0x94, 0xF6,
	0x9B, 0x97, 0xA3, 0x96, 0x81, 0x79, EXP5, 0x98
};


unsigned char gem_to_iso[256] = 
{
// Banned ctrl chars are:
//
// ^@ and ^[ to ^_ are assumed untypeable
// ^I we will want to move between GLK windows
// ^J and ^M are return
// ^C is SIGINT
// ^Q is Quit

	NONE, 0x01, 0x02, NONE, 0x04, 0x05, 0x06, 0x07, 
	0x08, NONE, NONE, 0x0B, 0x0C, NONE, 0x0E, 0x0F,
	0x10, NONE, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 
	0x18, 0x19, 0x1A, NONE, NONE, NONE, NONE, NONE,

	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, // Printable range
	0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
	0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 
	0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 
	0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 
	0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 
	0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, NONE,

	0xC7, 0xFC, 0xE9, 0xE2, 0xE4, 0xE0, 0xE5, 0xE7,	// 0x80 - 0x87 
	0xEA, 0xEB, 0xE8, 0xEF, 0xEE, 0xEC, 0xC4, 0xC5,	// 0x88 - 0x8F 
	0xC9, 0xE6, 0xC6, 0xF4, 0xF6, 0xF2, 0xFB, 0xF9,	// 0x90 - 0x97 
	0xFF, 0xD6, 0xDC, 0xF8, 0xA3, 0xD8, 0xA4, 0x66,	// 0x98 - 0x9F 
	
	0xE1, 0xED, 0xF3, 0xFA, 0xF1, 0xD1, 0xAA, 0xBA,
	0xBF, 0x22, 0x22, 0x3C, 0x3E, 0xA1, 0xAB, 0xBB,
	0xE3, 0xF5, 0xA5, 0xA2, NONE, NONE, 0xC0, 0xC3,
	0xD5, 0xA7, NONE, NONE, 0xB6, 0xA9, 0xAE, NONE,
	NONE, NONE, NONE, 0xB7, 0xB0, 0xAD, 0xAD, 0xC1,
	0xC2, 0xC8, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,	
	0xD2, 0xD3, 0xD4, 0x53, 0x73, 0xD9, 0xDA, 0xDB,
	0x59, 0xDF, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, 0xB5, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, 0xB1, NONE, NONE, NONE, NONE, 0xF7, NONE,
	NONE, NONE, NONE, NONE, NONE, 0xB2, NONE, 0xD8,
};


glui32 gem_to_glk(WORD code)
{
	switch(code)
	{
		/* Wordstar keys too? */
		case 0x4800: return keycode_Up;
		case 0x5000: return keycode_Down;
		case 0x4B00: return keycode_Left;
		case 0x4D00: return keycode_Right;
		case 0x0D:
		case 0x0A:
		case 0x1C00: return keycode_Return;
		case 0x5300:
		case 0x0E08:
		case 0x08:   return keycode_Delete;
		case 0x1B:
		case 0x011B: return keycode_Escape;
		case 0x4900: return keycode_PageUp;
		case 0x5100: return keycode_PageDown;
		case 0x4700: return keycode_Home;
		case 0x4F00: return keycode_End;
		case 0x3B00: return keycode_Func1;
		case 0x3C00: return keycode_Func2;
		case 0x3D00: return keycode_Func3;
		case 0x3E00: return keycode_Func4;
		case 0x3F00: return keycode_Func5;
		case 0x4000: return keycode_Func6;
		case 0x4100: return keycode_Func7;
		case 0x4200: return keycode_Func8;
		case 0x4300: return keycode_Func9;
		case 0x4400: return keycode_Func10;
	}
	if ((code & 0xFF) == 0) return keycode_Unknown;
	return gem_to_iso[code & 0xFF];

}
