
/* GLK textbuffer window (and stub for graphics window) */

#include "gemglk.h"

#define LINEBUF_FACTOR 10	/* Scroll back 10 screens */

glk_text_window::glk_text_window(glk_pair_window *parent, glui32 method, glui32 size)
	: glk_window_class(parent, method, size)
{
	gw_type = wintype_TextBuffer;	
	cur_page = 0;
	cur_para = 0;
	max_para = 8;
	prev_last_para = last_para = 0;
	parabuf = new paraptr[8];
	for (int n = 0; n < 8; n++) parabuf[n] = new glk_text_para;
}


glk_text_window::~glk_text_window()
{
	for (int n = 0; n < max_para; n++) delete parabuf[n];
	delete parabuf;
}

void glk_text_window::clear(void)
{
	for (int n = 0; n < max_para; n++) delete parabuf[n];
	delete parabuf;
	cur_page = 0;
	prev_last_para = last_para = 0;
	cur_para = 0;
	max_para = 8;
	parabuf = new paraptr[8];
	for (int n = 0; n < 8; n++) parabuf[n] = new glk_text_para;

	redraw_window();
}


void glk_text_window::put_char(unsigned char c)
{
	int n = 0;
	glui32 style;

	if (reqd_event & REQ_LINE) return; 
	/* Can't output while input is pending */

	/* Convert ISO-8859-1 to GEM characters */
	c = iso_to_gem[c];
	switch(c)
	{
		case 1:	put_char('1'); put_char('/'); c = '2'; break;
		case 2:	put_char('1'); put_char('/'); c = '4'; break;
		case 3:	put_char('3'); put_char('/'); c = '4'; break;
		case 4:	put_char('T');                c = 'h'; break;
		case 5:	put_char('t');                c = 'h'; break;
	}
	set_dirty();
	if (c != '\n')
	{
		parabuf[cur_para]->put_char(c);
		return;
	}		
	style = parabuf[cur_para]->get_style();

	// When all letters have been added, lay out the paragraph.
	parabuf[cur_para]->arrange(&winrect);

	++cur_para;

	if (cur_para == max_para)
	{
		glk_text_para **p = new paraptr[2*max_para];
		for (n = 0; n < max_para; n++) 
		{
			p[n] = parabuf[n];
		}
		for (n = 0; n < max_para; n++) 
		{
			p[n + max_para] = new glk_text_para;
		}
		delete parabuf;
		parabuf = p;
		max_para *= 2;
	}
	parabuf[cur_para]->set_style(style);
}

void glk_text_window::set_style(glui32 style)
{
	parabuf[cur_para]->set_style(style);
}


glui32 glk_text_window::get_style()
{
	return parabuf[cur_para]->get_style();
}

void glk_text_window::set_size()
{
	gw_size = sizeof(*this);
}



WORD glk_text_window::on_paint(PARMBLK *pb)
{
	int n;
	WORD y, h, tlh;
	GRECT rcClip, rcWin, rcClip2;

	/* Make sure we don't paint outside our window */
	memcpy(&rcClip,  &pb->pb_xc, sizeof(GRECT));
	memcpy(&rcWin,   &pb->pb_x,  sizeof(GRECT));
	memcpy(&rcClip2, &pb->pb_xc, sizeof(GRECT));

	rc_intersect(&rcWin, &rcClip);
	/* Set the correct clip rectangle in the parameter block */
	memcpy(&pb->pb_xc, &rcClip, sizeof(GRECT));

	set_clip(TRUE, (GRECT *)&rcClip);

	/* Optimisation: Don't lay out paragraphs if we're only
         * redrawing the input rectangle */

	if ( !(reqd_event & REQ_MORE) && (reqd_event & REQ_LINE))
			/* Input is expected */
	{
		if (input_rect.g_x <= pb->pb_xc &&
		    input_rect.g_y <= pb->pb_yc &&
	            input_rect.g_w + input_rect.g_x >= pb->pb_xc + pb->pb_wc &&
		    input_rect.g_h + input_rect.g_y >= pb->pb_yc + pb->pb_hc)
		{
			y = dflt_style[wintype_TextBuffer][style_Normal].background;
			filled_rect((GRECT *)&input_rect, y, y, 1, 1);
			paint_input_rect();
			set_clip(FALSE, (GRECT *)&pb->pb_xc);
			memcpy(&pb->pb_xc, &rcClip2, sizeof(GRECT));
			return 0;
		}
	}
	

	y = dflt_style[wintype_TextBuffer][style_Normal].background;
	filled_rect(&winrect, y, y, 1, 1);
	vswr_mode(vdi_handle, MD_TRANS);

	y = pb->pb_y + pb->pb_h - 1;

	/* Move down "cur_page" pages */
	y += cur_page * (pb->pb_h / 2);

	for (n = cur_para; n >= 0; n--)
	{
/* Y = coordinate of the BASE of the paragraph */
/* H = total height of the paragraph. */

		parabuf[n]->get_height(&h, &tlh);
		y -= h;
		parabuf[n]->on_paint(winrect.g_x, y - 2, pb);

		if (y < pb->pb_y) break;
	}
	if (reqd_event & REQ_MORE)
	{
		paint_more_rect(&winrect);
	}
	else if (reqd_event & REQ_LINE)/* Input is expected */
	{
		paint_input_rect();

	}
	set_clip(FALSE, &rcClip);
/* Restore original clip rectangle in PARMBLK*/
	memcpy(&pb->pb_xc, &rcClip2, sizeof(GRECT));
	return 0;
}


void glk_text_window::paint_input_rect()
{
	WORD pt[8];
	GRECT g;
	char ibuf[81];

	/* VDI buffers only hold 80 characters in the standard binding */

	int elen = ev_inlen; if (elen > 80) elen = 80;

	if (ev_inlen)
	{
		WORD th;

		memcpy(ibuf, ev_inbuf, elen);
		ibuf[elen] = 0;
		th = dflt_style[wintype_TextBuffer][style_Input].vsel(vdi_handle, dflt_style[wintype_TextBuffer]);
		dflt_style[wintype_TextBuffer][style_Input].paint(input_rect.g_x, input_rect.g_y + th - 1, ibuf);
	}
	
	g.g_y = input_rect.g_y;
	g.g_x = input_rect.g_x;
	g.g_w = 3;
	g.g_h = input_rect.g_h - 1;

	elen = ev_inpos; if (elen > 80) elen = 80;

	if (elen)	/* Work out where to put the text cursor */
	{
		memcpy(ibuf, ev_inbuf, elen);
		ibuf[elen] = 0;
		dflt_style[wintype_TextBuffer][style_Input].vsel(vdi_handle, dflt_style[wintype_TextBuffer]);

		vqt_extent(vdi_handle, ibuf, pt);
		g.g_x += pt[4];
	}

	/* If window has the focus, draw text cursor in it */

	if (focus_window != this) return;

	/* Draw the text cursor (in XOR mode) */
	vswr_mode(vdi_handle, MD_XOR);

   	pt[0] = g.g_x;
   	pt[1] = g.g_y;
	pt[2] = g.g_x;
	pt[3] = g.g_y + g.g_h;

   	vswr_mode(vdi_handle, MD_XOR);
	v_pline  (vdi_handle, 2, pt);
	vswr_mode(vdi_handle, MD_REPLACE);
}

void glk_text_window::paint_more_rect(GRECT *area)
{
	WORD pt[10];

	pt[0] = area->g_x;
	pt[1] = area->g_y + area->g_h;
	pt[2] = pt[0];
	pt[3] = pt[1] - input_rect.g_h;
	pt[4] = pt[0] + input_rect.g_h;
	pt[5] = pt[3];
	pt[6] = pt[4];
	pt[7] = pt[1];
	vswr_mode(vdi_handle, MD_XOR);
	vsf_color(vdi_handle, WHITE);
	vsf_interior(vdi_handle, 1);
	v_fillarea(vdi_handle, 4, pt);
	vswr_mode(vdi_handle, MD_REPLACE);
}


WORD glk_text_window::get_cursor(GRECT *r, GRECT *w)
{
	glui32 s = parabuf[cur_para]->get_style();
	
	vst_font(vdi_handle, gl_fontid[dflt_style[wintype_TextBuffer][s].font - 1]);
	vst_point(vdi_handle, dflt_style[wintype_TextBuffer][s].ptsize, &r->g_x, &r->g_y, 
                                                    &r->g_w, &r->g_h);

	parabuf[cur_para]->get_curpos(&r->g_x, &r->g_y);

	r->g_x += w->g_x;
	r->g_y = w->g_y + w->g_h - r->g_h - 2;

	if (reqd_event & REQ_LINE) return 1; 
	return 0;
}

VOID glk_text_window::line_append_key(WORD k)
{
	glui32  n;

	if (k == 0x4B00)	/* <- */
	{
		if (!ev_inpos) return;
		--ev_inpos;
		send_redraw(glk_whndl, &input_rect);	
		return;
	}
	if (k == 0x4D00)	/* -> */
	{
		if (ev_inpos >= ev_inlen) return;
		++ev_inpos;
		send_redraw(glk_whndl, &input_rect);	
		return;
	}
	
	if ((k & 0xFF) == 8 || (k & 0xFF) == 0x7F)
	{
		if (!ev_inlen) return;
		--ev_inlen;
		--ev_inpos;
		send_redraw(glk_whndl, &input_rect);	
		return;
	}
	if (ev_inlen >= ev_inmax) return;

	if (ev_inlen) for (n = ev_inlen; n > ev_inpos; n--)
	{
		ev_inbuf[n] = ev_inbuf[n-1];
	}
	
	ev_inbuf[ev_inpos] = (k & 0xFF);
	++ev_inlen;
	++ev_inpos;

	send_redraw(glk_whndl, &input_rect);	
}

VOID glk_text_window::cancel_line_event(event_t *ev)
{
	glk_window_class::cancel_line_event(ev);

	/* Note that get_stream() is used so the command is echoed to a
	 * transcript file */

	glui32 s = get_style();
	set_style(style_Input);
	for (glui32 n = 0; n < ev_inlen; n++)
	{
		get_stream()->put_char(ev_inbuf[n]);
	}
	get_stream()->put_char('\n');
	set_style(s);
	send_redraw(glk_whndl, &input_rect);	
}


glui32 glk_text_window::preferred_width(glui32 pixels)
{
	WORD x,y;
	glk_style *s = &dflt_style[wintype_TextBuffer][style_Normal];

	s->vsel(vdi_handle, s);
	s->text_size("0", &x, &y);
	
	return x * pixels;	
}



glui32 glk_text_window::preferred_height(glui32 pixels)
{
	WORD x,y;
	glk_style *s = &dflt_style[wintype_TextBuffer][style_Normal];

	s->vsel(vdi_handle, s);
	s->text_size("0", &x, &y);
	
	return y * pixels;	
}


void glk_text_window::get_size(glui32 *x, glui32 *y)
{
	WORD x1,y1;
	glk_style *s = &dflt_style[wintype_TextBuffer][style_Normal];

	s->vsel(vdi_handle, s);
	s->text_size("0", &x1, &y1);

	glk_window_class::get_size(x, y);
	if (x && x1) { *x /= x1;  }
	if (y && y1) { *y /= y1;  }
}

/* Called: 
 * 
 *  - When the font size or window size changes 
 *  - When input is requested. 
 *
 *  It lays out all the text, and works out how many pages the text needs
 * to be displayed in.
 */

void glk_text_window::arrange()
{
	glk_window_class::arrange();
	get_area(&winrect);
	for (int n = 0; n <= cur_para; n++) parabuf[n]->arrange(&winrect);

	if (reqd_event & REQ_LINE)
	{
		get_cursor(&input_rect, &winrect);

		input_rect.g_w = winrect.g_w + winrect.g_x - input_rect.g_x;
	}
//	if (cur_page)	/* Waiting on a [More] */
//	{
//		last_para = prev_last_para;
//		check_page();
//	}

}


int glk_text_window::check_page()
{
	int n, y;
	GRECT area;
	WORD h, tlh;

	get_area(&area);
	/* Return 1 to print a [More] message, 0 not to. */	

	y = 0;
	for (n = cur_para; n > last_para; n--)
	{
		parabuf[n]->get_height(&h, &tlh);		
		y += h;
	}	
	if (y > area.g_h)
	{
		cur_page = 2 * (y / area.g_h);
		return 1;
	}
	cur_page = 0;
	return 0;
}


void glk_text_window::request_line_event(char *buf, glui32 a, glui32 b)
{
	glk_window_class::request_line_event(buf,a,b);	
	arrange();	
	compact();
	prev_last_para = last_para;
	last_para = cur_para;
}


void glk_text_window::request_char_event()
{
	glk_window_class::request_char_event();
	arrange();		
	compact();
	prev_last_para = last_para;
	last_para = cur_para;
}

/* Delete paragraphs which have scrolled off the screen.

  nb: This means if you use a big font and then switch to a little one,
     paragraphs which have scrolled off don't come back.

 */


void glk_text_window::compact()
{
	GRECT area;
	int y, n;
	WORD h,tlh;

	get_area(&area);

	y = area.g_y + area.g_h - 1;

	/* Move down "cur_page" pages */
	y += cur_page * (area.g_h / 2);

	for (n = cur_para; n >= 0; n--)
	{
/* Y = coordinate of the BASE of the paragraph */
/* H = total height of the paragraph. */

		parabuf[n]->get_height(&h, &tlh);
		y -= h;

		if (y >= area.g_y) continue;

/* Delete paragraphs which have gone off the top of the window */

		delete parabuf[n];
		parabuf[n] = NULL;
	}
	for (y = 0; y <= cur_para; y++)
	{
		if (parabuf[y]) break;
	}
/* y is the number of the first existing paragraph. Move all paragraphs
 * down so para y becomes para 0. */

	if (!y) return;

	cur_para       -= y;
	last_para      -= y;
	prev_last_para -= y;
	if (prev_last_para < 0) prev_last_para = 0;

/* Move paragraphs down */

	for (n = 0; n <= cur_para; n++)
	{
		parabuf[n] = parabuf[n+y];
		parabuf[n+y] = NULL;		
	}

/* Fill the space at the end with blank paragraphs */

	for (n = 0; n <= max_para; n++) 
	{
		if (parabuf[n] == NULL) parabuf[n] = new glk_text_para;
	}
}




WORD glk_text_window::on_key(event_t *event, WORD key)
{
	if (reqd_event & REQ_MORE)
	{
		GRECT area;

		get_area(&area);
		--cur_page;

		if (cur_page == 0) reqd_event &= ~REQ_MORE;
		send_redraw(glk_whndl, &area);
		return 0;
	}
	return glk_window_class::on_key(event, key);
}

//////////////////////////////////////////////////////////////////////////////


glk_graphics_window::glk_graphics_window(glk_pair_window *parent, glui32 method, glui32 size)
	: glk_window_class(parent, method, size)
{

}

//////////////////////////////////////////////////////////////////////////////


