
#include "gemglk.h"


glk_pair_window::glk_pair_window(glk_pair_window *parent, glk_window_class *k, WORD obj, glui32 m, glui32 s)
	: glk_window_class(parent, obj, m, s)
{
	/* Make this window a transparent box */
	glk_tree[obj].ob_type = G_IBOX;
	gw_gemspec = 0;
	lost_key = 0;

	UNUSED(k);

	splitdir = m & winmethod_DirMask;
	splitdiv = m & winmethod_DivisionMask;
	size = s;
	arrange();
}


void glk_pair_window::arrange(void)
{
	GRECT wr, kr, or;	/* Rectangles for: this window, key window, other window */
	glk_window_class *key = get_key();

	get_area(&wr);
	memcpy(&or, &wr, sizeof(GRECT));
	memcpy(&kr, &wr, sizeof(GRECT));

	/* Fixed splits */
	if (splitdiv == winmethod_Fixed) switch(splitdir)
	{
		case winmethod_Above:
			if (key) kr.g_h = key->preferred_height(size);	
			else     kr.g_h = 0;
			or.g_y = wr.g_y + kr.g_h;
			or.g_h = wr.g_h - kr.g_h;
			break;	

		case winmethod_Below:
			if (key) kr.g_h = key->preferred_height(size);	
			else     kr.g_h = 0;
			or.g_h = wr.g_h - kr.g_h;
			kr.g_y = wr.g_y + or.g_h;
			break;	

		case winmethod_Left:
			if (key) kr.g_w = key->preferred_width(size);
			else     kr.g_w = 0;
			or.g_x = wr.g_x + kr.g_x;
			or.g_w = wr.g_w - kr.g_w;
			break;

		case winmethod_Right:
			if (key) kr.g_w = key->preferred_width(size);
			else     kr.g_w = 0;
			or.g_w = wr.g_w - kr.g_w;
			kr.g_x = wr.g_x + or.g_w;
			break;
	}
	/* Proportional splits */
	else switch(splitdir)
	{
		case winmethod_Above:
			kr.g_h = wr.g_h * size / 100;
			or.g_y = wr.g_y + kr.g_h;
			or.g_h = wr.g_h - kr.g_h;
			break;	

		case winmethod_Below:
			kr.g_h = wr.g_h * size / 100;
			or.g_h = wr.g_h - kr.g_h;
			kr.g_y = wr.g_y + or.g_h;
			break;	

		case winmethod_Left:
			kr.g_w = wr.g_w * size / 100;
			or.g_x = wr.g_x + kr.g_w;
			or.g_w = wr.g_w - kr.g_w;
			break;

		case winmethod_Right:
			kr.g_w = wr.g_w * size / 100;
			or.g_w = wr.g_w - kr.g_w;
			kr.g_x = wr.g_x + or.g_w;
			break;
	}
	/* We have 2 rectangles. Find out in which child the key is. */

	glk_window_class *c1, *c2, *upward;

	upward = get_key();
	c1 = get_child(0);
	c2 = get_child(1);
	if (c1 == c2) c2 = NULL;

	while (upward)
	{
		if (c1 == upward || lost_key == 1) 
		{
			c1->set_area(&kr);
			if (c2) c2->set_area(&or);
			break;
		}
		if (c2 == upward || lost_key == 2) 
		{
			c2->set_area(&kr);
			if (c1) c1->set_area(&or);
			break;
		}
		upward = upward->get_parent();
	}	

	if (c1) c1->arrange();
	if (c2) c2->arrange();
}



void glk_pair_window::set_arrangement(glui32 m, glui32 s, glk_window_class *keywin)
{
	splitdir = m & winmethod_DirMask;
	splitdiv = m & winmethod_DivisionMask;
	size = s;
	set_key(keywin);
	arrange();
	lost_key = 0;
}


void glk_pair_window::get_arrangement(glui32 *methodptr, glui32 *sizeptr, glk_window_struct **keywinptr)
{
	if (methodptr) *methodptr = (splitdir | splitdiv);
	if (sizeptr)   *sizeptr   = size;
	if (keywinptr) *keywinptr = get_key()->get_winid();
}


void glk_pair_window::close(stream_result_t *result)
{
	/* When closing a pair, close both its children as well 
         * note: Closing the first child closes and deletes "this"
         * automatically */

	glk_window_class *c1, *c2;
	c1 = get_child(0);
	c2 = get_child(1);
	
	if (c1) c1->close(result);
	if (c2) c2->close(result);
}

/* The key window is closing */

void glk_pair_window::goodbye(glk_window_class *old_key)
{
	glk_window_class *c1, *c2;

	dj_form_alert(1,"[1][Goodbye from %x][ OK ]", old_key);

	c1 = get_child(0);
	c2 = get_child(1);
	if (c1 == c2) c2 = NULL;

	while (old_key)
	{
		if (c1 == old_key) 
		{
			lost_key = 1;
			break;
		}
		if (c2 == old_key) 
		{
			lost_key = 2;
			break;
		}
		old_key = old_key->get_parent();
	}	
	dj_form_alert(1,"[1][Goodbye from %x|c1=%x c2=%x lk=%d][ OK ]", 
			old_key, c1, c2, lost_key);

}
