
#include "gemglk.h"

extern GRECT work_area;

glk_window_class::glk_window_class(glk_pair_window *parent, glui32 method, glui32 type)
{
	common_construct(parent, NIL, method, type);
}

glk_window_class::glk_window_class(glk_pair_window *parent, WORD object, glui32 method, glui32 type)
{
	common_construct(parent, object, method, type);
}


void glk_window_class::common_construct(glk_pair_window *parent, WORD obj_id, glui32 method, glui32 type)
{
	OBJECT *gemob;
	int bind_to_existing;	/* bind to a GEM object that's already in the
				 * tree? If so, don't fiddle with the 
                                 * ob_head, ob_tail or ob_next */


	keyholder = key = NULL;
	reqd_event = 0;
	ev_inlen = 0;
	ev_inmax = 0;
	ev_inbuf = NULL;
	dirty = 0;

	if (obj_id == NIL) 
	{
		bind_to_existing = 0;
		obj_id = find_free_gemob();
	}
	else bind_to_existing = 1;

	set_size();

	gemob = &glk_tree[obj_id];
	glk_assert(gemob >= glk_tree);

	UNUSED(method);
	UNUSED(type);

	if (!parent)	/* Opening a window at the root */
	{
		gemob->ob_x = work_area.g_x;
		gemob->ob_y = work_area.g_y;
		gemob->ob_width = work_area.g_w;
		gemob->ob_height = work_area.g_h;
	}
	else	/* Child window. Occupy all the parent window   */ 
	{	/* (this will be dealt with later by the parent */
                /* window's arrange() function).                */
		parent->get_area((GRECT *)&gemob->ob_x);
	}

	if (!bind_to_existing)
	{

		gemob->ob_next  = -1;
		gemob->ob_head  = -1;
		gemob->ob_tail  = -1;	
	}
	gemob->ob_type  = G_USERDEF;

	gemob->ob_spec  = (LONG)get_winid();

	/* USERBLK address must be in segment:offset form, because it will
         * not be automatically transformed by the program when going
         * into 16-bit space. */

	gw_gemspec      = SEGOFF(glk_userblk[obj_id].ub_16bit);
	glk_userblk[obj_id].ub_parm = (LONG)get_winid();

	gemob->ob_flags = INDIRECT;
	gemob->ob_state = 0;

	gw_type = wintype_Blank;
	gw_rock = 0;

	if (!gl_wincount)	/* Creating the first object */
	{
		gemob->ob_flags |= LASTOB;
	}
	else			/* Creating a subsequent object */
	{
		int n;
		/* If the new object makes the tree longer, move the LASTOB 
	         * flag to it */
		for (n = 0; n < MAXWINDOW; n++)
		{
			if (glk_tree[n].ob_flags & LASTOB) break;
		}
		if (obj_id > n)
		{
			glk_tree[n     ].ob_flags &= ~LASTOB;
			glk_tree[obj_id].ob_flags |= LASTOB;
		}
		if (!bind_to_existing)
		{
			if (parent) dj_objc_add(glk_tree, parent->get_object(), obj_id);
			else        dj_objc_add(glk_tree, 0,                    obj_id);
		}
	}
	++gl_wincount;
	
	send_redraw(glk_whndl, &work_area);

	wdw_stream = new glk_window_stream(this);
	echo_stream = NULL;	
	register_window(this);
}


glk_window_class::~glk_window_class()
{
	WORD o = get_object();
	if (o != NIL)
	{
		dj_objc_delete(glk_tree, o);	/* Remove us from the window tree */
		glk_tree[o].ob_type = 0;
		glk_tree[o].ob_flags &= LASTOB; /* Drop all flags except LASTOB */
		glk_tree[o].ob_spec = NULL;
	}

	/* Someone is using us as a key. Warn them that we closed */
	if (keyholder) 
	{ 
		keyholder->set_key(NULL);
	}
	/* We may have a key window. Release it. */
	set_key(NULL);

	--gl_wincount;	
	unregister_window(this);
	delete wdw_stream;
}


void glk_window_class::set_key(glk_window_class *k)
{
	/* Take a window as our key window. Ask to be notified when it
         * closes */

	if (key) key->keyholder = NULL;
	key = k;
	if (k) k->keyholder = this;
}

glk_window_class *glk_window_class::get_key()
{
	return key;
}


void glk_window_class::set_echo(glk_stream_class *s)
{
	echo_stream = s;
}

glk_stream_class *glk_window_class::get_echo()
{
	return echo_stream;
}



glk_stream_class *glk_window_class::get_stream()
{
	return wdw_stream;
}


/* Base class: doesn't do anything */
void glk_window_class::put_char(unsigned char c)
{
	UNUSED(c);
}


void glk_window_class::set_size()
{
	gw_size = sizeof(glk_window_class);
}


glui32 glk_window_class::get_rock()
{
	return gw_rock;
}


void glk_window_class::set_rock(glui32 rock)
{
	gw_rock = rock;
}

glui32 glk_window_class::get_type()
{
	return gw_type;
}

glk_pair_window *glk_window_class::get_parent()
{
	WORD ob = get_object();

	if (ob == NIL) return NULL;

	return (glk_pair_window *)from_object(::get_parent(glk_tree, ob));
}

glk_window_class *glk_window_class::from_object(WORD ob)
{
	if (ob == NIL) return NULL;

	glk_assert(glk_tree[ob].ob_flags & INDIRECT);

	return (glk_window_class *)glk_tree[ob].ob_spec;

}

glk_window_class *glk_window_class::get_sibling()
{
	WORD ob = get_object();
	WORD ob2;

	if (ob == NIL) return NULL;

	ob2 = ::get_parent(glk_tree, ob);

	if (ob2 == NIL) return NULL;

	/* Window is an only child */
	if (glk_tree[ob2].ob_head == glk_tree[ob2].ob_tail) return NULL;
	/* Which one is it? */

	if (glk_tree[ob2].ob_head == ob) ob2 = glk_tree[ob2].ob_tail;
	else                             ob2 = glk_tree[ob2].ob_head;

	return from_object(ob2);
}


/* Walk the object tree, looking for a window that points at us */

WORD glk_window_class::get_object(void)
{
	WORD ob = 0;

	do
	{
		if ((glk_tree[ob].ob_flags & INDIRECT) &&
		    ((winid_t)glk_tree[ob].ob_spec == 
                     (winid_t)this))                      return ob;
		++ob;
	}
	while (!(glk_tree[ob-1].ob_flags & LASTOB));

	return NIL;
}

/* Reassign this window to a new object tree member */
void glk_window_class::set_object(WORD new_obj)
{
	WORD old_obj = get_object();
	WORD type = glk_tree[old_obj].ob_type;

	if (type == G_USERDEF)
	{
		glk_tree[new_obj].ob_spec = (LONG)get_winid();
		glk_tree[new_obj].ob_type = G_USERDEF;
		glk_tree[new_obj].ob_flags = INDIRECT;
		glk_tree[new_obj].ob_state = 0;
		glk_userblk[old_obj].ub_parm = 0L;

		glk_tree[old_obj].ob_flags &= ~INDIRECT;
		glk_tree[old_obj].ob_type  = G_IBOX;
		glk_tree[old_obj].ob_spec  = 0;
		glk_tree[old_obj].ob_state = 0;
		gw_gemspec      = SEGOFF(glk_userblk[new_obj].ub_16bit);
		glk_userblk[new_obj].ub_parm = (LONG)get_winid();
	}
	else
	{
		glk_tree[new_obj].ob_spec = gw_gemspec;
		glk_tree[new_obj].ob_type = type;
		glk_tree[new_obj].ob_flags = glk_tree[old_obj].ob_flags;
		glk_tree[new_obj].ob_state = glk_tree[old_obj].ob_state;
		glk_userblk[new_obj].ub_parm = 0L;

		glk_tree[old_obj].ob_flags &= ~INDIRECT;
		glk_tree[old_obj].ob_type  = G_IBOX;
		glk_tree[old_obj].ob_spec  = 0;
		glk_tree[old_obj].ob_state = 0;
	}
	glk_tree[new_obj].ob_next   = NIL;
	glk_tree[new_obj].ob_head   = NIL;
	glk_tree[new_obj].ob_tail   = NIL;
	glk_tree[new_obj].ob_x      = glk_tree[old_obj].ob_x;
	glk_tree[new_obj].ob_y      = glk_tree[old_obj].ob_y;
	glk_tree[new_obj].ob_width  = glk_tree[old_obj].ob_width;
	glk_tree[new_obj].ob_height = glk_tree[old_obj].ob_height;
}


void glk_window_class::get_area(GRECT *r)
{
	WORD obj = get_object();

	glk_assert(obj != NIL);
	
	dj_objc_offset(glk_tree, obj, &r->g_x, &r->g_y);
	r->g_w = glk_tree[obj].ob_width;
	r->g_h = glk_tree[obj].ob_height;
}


void glk_window_class::set_area(GRECT *r)
{
	WORD obj = get_object();
	WORD ox, oy;

	glk_assert(obj != NIL);

	dj_objc_offset(glk_tree, obj, &ox, &oy);

	glk_tree[obj].ob_x      += r->g_x - ox;
	glk_tree[obj].ob_y      += r->g_y - oy;
	glk_tree[obj].ob_width   = r->g_w;
	glk_tree[obj].ob_height  = r->g_h;
}


WORD glk_window_class::on_paint(PARMBLK *pb)
{
	WORD pxy[10];

	set_clip(TRUE, (GRECT *)&pb->pb_xc);

	vsf_interior(vdi_handle, 2);
	vsf_style(vdi_handle, 4);
	vsf_color(vdi_handle, RED);
	rc_grect_to_array((GRECT *)&pb->pb_x, pxy);
//	graf_mouse(M_OFF, 0x0L);
	vr_recfl(vdi_handle, pxy);	/* clear entire message area	*/
//	graf_mouse(M_ON, 0x0L);
	set_clip(FALSE, (GRECT *)&pb->pb_xc);
	return 0;
}

/* The drawing callback itself */
WORD draw_win(PARMBLK *pb)
{
	glk_window_class *w = (glk_window_class *)pb->pb_parm;

	return w->on_paint(pb);
}


void glk_window_class::set_style(glui32 style)
{
	UNUSED(style);
}


glui32 glk_window_class::get_style()
{
	return style_Normal;
}

int glk_window_class::check_page()
{
	return 0;
}

void glk_window_class::request_char_event(void)
{
	if ((get_type() == wintype_TextBuffer  
        ||   get_type() == wintype_TextGrid)
        && !(reqd_event & REQ_LINE))
	{
		reqd_event |= REQ_CHAR;
		if (check_page()) reqd_event |= REQ_MORE;
	}
}

void glk_window_class::cancel_char_event(void)
{
	reqd_event &= ~REQ_CHAR;
	reqd_event &= ~REQ_MORE;
}

void glk_window_class::request_line_event(char *buf, glui32 maxlen, glui32 initlen)
{
	if ((get_type() == wintype_TextBuffer || get_type() == wintype_TextGrid)
        && !(reqd_event & REQ_CHAR))
	{
		GRECT area;

		reqd_event |= REQ_LINE;
		if (check_page()) reqd_event |= REQ_MORE;
		ev_inlen = initlen;
		ev_inmax = maxlen;
		ev_inbuf = buf;
		ev_inpos = 0;
		set_buf_rock(register_memory(buf, maxlen, "&+#!Cn"));

		get_area(&area);
		get_cursor(&input_rect, &area);

		input_rect.g_w = area.g_w + area.g_x - input_rect.g_x;
		if (check_page()) reqd_event |= REQ_MORE;
		set_dirty();
	}
}


void glk_window_class::cancel_line_event(event_t *ev)
{
	if (ev)
	{
		if (reqd_event & REQ_LINE)
		{
			unregister_memory(ev_inbuf, ev_inmax, "&+#!Cn", get_buf_rock());
			ev->type = evtype_LineInput;
			ev->win  = (winid_t)this;
			ev->val1 = ev_inlen;
			ev->val2 = 0;
		}
		else
		{
			ev->type = evtype_None;
			ev->win  = NULL;
			ev->val1 = 0;
			ev->val2 = 0;
		}
	}	
	reqd_event &= ~REQ_LINE;
	reqd_event &= ~REQ_MORE;
}


void glk_window_class::request_mouse_event(void)
{
	if ((get_type() == wintype_Graphics || get_type() == wintype_TextGrid))
	{
		reqd_event |= REQ_MOUSE;
	}
}

void glk_window_class::cancel_mouse_event(void)
{
	reqd_event &= ~REQ_MOUSE;
}


WORD glk_window_class::get_cursor(GRECT *r, GRECT *w)
{
	UNUSED(r);
	UNUSED(w);
	return 0;
}


WORD glk_window_class::on_key(event_t *ev, WORD key)
{
	if (reqd_event & REQ_CHAR)
	{
		glui32 val1 = gem_to_glk(key);
		if (val1 == 0x07) return 0;

		ev->type = evtype_CharInput;
		ev->win  = (winid_t)this;
		ev->val1 = val1;
		ev->val2 = 0;

		cancel_char_event();
		return 2;
	}
	if (reqd_event & REQ_LINE)
	{
		if ((key & 0xFF) == 0x0D)
		{
			cancel_line_event(ev);
			return 2;
		}
		line_append_key(key);
	}
	return 0;
}


void glk_window_class::line_append_key(WORD key)
{
	UNUSED(key);
}


void glk_window_class::set_disp_rock(gidispatch_rock_t r)
{
	disp_rock = r;
}

gidispatch_rock_t glk_window_class::get_disp_rock()
{
	return disp_rock;
}

void glk_window_class::set_buf_rock(gidispatch_rock_t r)
{
	buf_rock = r;
}

gidispatch_rock_t glk_window_class::get_buf_rock()
{
	return buf_rock;
}



void glk_window_class::set_reg_index(int index)
{
	reg_index = index;
}

int glk_window_class::get_reg_index()
{
	return reg_index;
}


WORD glk_window_class::find_free_gemob()
{
	for (int n = 0; n < MAXWINDOW; n++)
	{
		if (glk_tree[n].ob_type == 0) return n;
	}
	return -1;
}

glk_pair_window *glk_window_class::split_yourself(glui32 method, glui32 amount)
{
	WORD obj = get_object();
	WORD n_child = find_free_gemob();
	glk_pair_window *parent = get_parent();
	int n;

	/* 1. Move this window to the newly-created object, and make it 
         *   a child of what will become the pair window */

	set_object(n_child);

	/* If the new object makes the tree longer, move the LASTOB 
         * flag to it */
	for (n = 0; n < MAXWINDOW; n++)
	{
		if (glk_tree[n].ob_flags & LASTOB) break;
	}
	if (n_child > n)
	{
		glk_tree[n      ].ob_flags &= ~LASTOB;
		glk_tree[n_child].ob_flags |= LASTOB;
	}
	dj_objc_add(glk_tree, obj, n_child);

	/* 2. Create a pair window where this object was */
	glk_pair_window *pair = new glk_pair_window(parent, this, obj, method, amount);

	return pair;
}


/* This window may need to be rearranged. Base class: does nothing */
void glk_window_class::arrange(void)
{
}


glk_window_class *glk_window_class::get_child(int which)
{
	int nobj = get_object();

	if (nobj == NIL) return NULL;

	if (which & 1) nobj = glk_tree[nobj].ob_tail;
	else           nobj = glk_tree[nobj].ob_head;

	if (nobj == NIL) return NULL;
	if (!(glk_tree[nobj].ob_flags & INDIRECT)) return NULL;

	return from_object(nobj);
}

glui32 glk_window_class::preferred_height(glui32 i)
{
	return i;	/* Measure in pixels */
}

glui32 glk_window_class::preferred_width(glui32 i)
{
	return i;	/* Measure in pixels */
}

int glk_window_class::is_input_wanted(void)
{
	if (reqd_event & REQ_KEY) return 1;

	return 0;
}


void glk_window_class::clear()	/* Default behaviour for a clear() is to provoke redraw of
                  this window */
{
	redraw_window();
}


void glk_window_class::move_cursor(glui32 x, glui32 y)
{
	/* No default behaviour */
	UNUSED(x);
	UNUSED(y);
}


void glk_window_class::redraw_window(void)
{
	/* nb: The GEM message queue is extremely short. Normally we have
         * to be careful about sending ourselves messages. However with
         * repaint messages we're lucky; GEM amalgamates multiple repaint
         * messages so they only take one space in the queue. */

	GRECT wRect;

	get_area(&wRect);
	send_redraw(glk_whndl, &wRect);
}


void glk_window_class::get_size(glui32 *x, glui32 *y)
{
	GRECT wRect;

	get_area(&wRect);

	if (x) *x = wRect.g_w;
	if (y) *y = wRect.g_h;	
}

int glk_window_class::is_dirty()
{
	return dirty;
}

void glk_window_class::set_dirty(int d)
{
	dirty = d;
}


void glk_window_class::close(stream_result_t *result)
{
	glk_pair_window *parent;
	glk_window_class *c1, *c2, *up, *upp;
	WORD pobj, uobj;
	GRECT r;

	wdw_stream->close(result);

/* If we are the key for a window, tell it we are closing */

	if (keyholder) keyholder->goodbye(this);


/*     Deal with arrangement matters when closing a window - if we
 *     have a parent, move our sibling up into where the parent was.
 *     If we don't (we are the root) then there are no other windows.
 */
	parent = get_parent();
	if (!parent) 
	{
		delete this;
		return;
	}
	c1 = parent->get_child(0);
	c2 = parent->get_child(1);

	glk_assert(this == c1 || this == c2);

	if (this == c1) up = c2;	/* Window to move up */
	else		up = c1;
	
	pobj = parent->get_object();	/* Object number of parent */
	upp  = parent->get_parent();	/* Parent's parent (if any) */
	if (upp) uobj = upp->get_object();
	else     uobj = NIL;

/* Get rectangle for parent window */
	memcpy(&r, &glk_tree[pobj].ob_x, sizeof(GRECT));

/* Remove this object from the tree */

	WORD o = get_object();
	if (o != NIL)
	{
		dj_objc_delete(glk_tree, o);	/* Remove us from the window tree */
		glk_tree[o].ob_type = 0;
		glk_tree[o].ob_flags &= LASTOB;	/* Drop all flags except LASTOB */
		glk_tree[o].ob_spec = NULL;
	}

/* Remove parent from the tree */

	dj_objc_delete(glk_tree, pobj);

/* Set rectangle for window "up" */
	memcpy(&glk_tree[up->get_object()].ob_x, &r, sizeof(GRECT));

/* Add "up" to the tree where the parent was */
	if (uobj == NIL) /* Window "up" becomes the root */
	{
		up->set_object(0);
	}
	else		/* "up" becomes child of "upp" */
	{
		dj_objc_add(glk_tree, uobj, up->get_object());
	}
	if (upp) upp->arrange();	/* windows resize */
	else	 up->arrange();

	delete this;	/* Remove our window object */
}

/* Base class, & does nothing */
void glk_window_class::set_arrangement(glui32 method, glui32 size, glk_window_class *keywin)
{
	UNUSED(method);
	UNUSED(size);
	UNUSED(keywin);
}

/* Base class, & does nothing */
void glk_window_class::get_arrangement(glui32 *methodptr, glui32 *sizeptr, glk_window_struct **keywinptr)
{
	UNUSED(methodptr);
	UNUSED(sizeptr);
	UNUSED(keywinptr);
}

/* Notification that our key window is closing */
void glk_window_class::goodbye(glk_window_class *c)
{
	UNUSED(c);
}
