
#include "gemglk.h"

WORD glk_style::vsel(WORD vdi_handle, glk_style *def)
{
	WORD a,b,c,d;

	if (font > 0)    vst_font(vdi_handle, gl_fontid[font - 1]);
	else	         vst_font(vdi_handle, gl_fontid[def->font - 1]);
	if (colour >= 0) vst_color(vdi_handle, colour);
	else 		 vst_color(vdi_handle, def->colour);
	if (ptsize >= 0) vst_point(vdi_handle, ptsize, &a, &b, &c, &d);
	else		 vst_point(vdi_handle, def->ptsize, &a, &b, &c, &d);
	vst_effects(vdi_handle, effects);

	/* Return the distance between top of character cell, and 
	  character baseline. */

	return b;
}

WORD glk_style::text_size(char *s, WORD *x, WORD *y)
{
	return general_output(0, x, y, s);
}

void glk_style::paint(WORD x, WORD y, char *s)
{
	general_output(1, &x, &y, s);
}


WORD glk_style::general_output(WORD mode, WORD *x, WORD *y, char *s)
{
	WORD xx, yy;
	WORD dim[8], dif;

	glk_style *def = dflt_style[wintype_TextBuffer];

	if (mode == 1) { xx = *x; yy = *y; }
	else           { xx =  0; yy =  0; }

	dif = vsel(vdi_handle, def);
	vqt_extent(vdi_handle, s, dim);
	if (mode == 0)
	{

/* vqt_extent returns 4 points - the size of the area is given by a 
 * diagonally opposite pair */
		
		*x = dim[4] - dim[0];
		*y = dim[5] - dim[1];	
	}	
	else
	{
		GRECT g;

		g.g_w = dim[4] - dim[0];
		g.g_h = dim[5] - dim[1];
		g.g_x = xx;
		g.g_y = yy - dif;	/* Should not be g.g_h. Should
					 * be baseline height. */

		if (background >= 0 && background != def->background)
		{
			filled_rect(&g, background, background, 1, 1);
		}
		// else filled_rect(&g, def->background, def->background, 1, 1);	
		vswr_mode(vdi_handle, MD_TRANS);
		v_gtext(vdi_handle, xx, yy, s);
	}
	return dif;
}
