
#include "gemglk.h"

glk_window_stream::glk_window_stream(glk_window_class *w) :
	glk_stream_class()
{
	gs_window = w;
	gs_mode   = filemode_Write;
}

extern char s[], t[];

void glk_window_stream::put_char(unsigned char c)
{
	glk_stream_class *echo = gs_window->get_echo();

	++gs_wcount;

	/* Sanity checks */
	if (echo != this && echo != NULL) echo->put_char(c);
	gs_window->put_char(c);
	
	glk_stream_class::put_char(c);
}


void glk_window_stream::set_style(glui32 s)
{
	gs_window->set_style(s);	
}


glui32 glk_window_stream::get_style()
{
	return gs_window->get_style();	
}



glui32 glk_window_stream::open()
{
	return 1;
}


void glk_window_stream::close(stream_result_struct *s)
{
	glk_stream_class::close(s);
}


////////////////////////////////////////////////////////////////////////////

glk_memory_stream::glk_memory_stream(char *buf, glui32 len, glui32 rock, glui32 mode)
				: glk_stream_class()
{
	gs_buf = buf;
	gs_len = len;
	gs_pos = 0;
	gs_mode = mode;	

	if (!gs_buf) gs_len = 0;
	
	set_rock(rock);
	set_buf_rock(register_memory(buf, len, "&+#!Cn"));
}

glk_memory_stream::~glk_memory_stream()
{
	unregister_memory(gs_buf, gs_len, "&+#!Cn", get_buf_rock());

}

void glk_memory_stream::put_char(unsigned char ch)
{
	if (!gs_len || !gs_buf) return;

	if (gs_mode == filemode_Write || gs_mode == filemode_ReadWrite)
	{
		if (gs_pos == gs_len) return;
		gs_buf[gs_pos++] = ch;
		++gs_wcount;
	}
}
	

glsi32 glk_memory_stream::get_char()
{
	if (!gs_len || !gs_buf) return -1;

	if (gs_mode == filemode_Read || gs_mode == filemode_ReadWrite)
	{
		if (gs_pos == gs_len) return -1;
		++gs_rcount;
		return gs_buf[gs_pos++];
	}
	return -1;
}

glui32 glk_memory_stream::tell()
{
	return gs_pos;
}

void glk_memory_stream::seek(glsi32 pos, glui32 whence)
{
	glsi32 old = gs_pos;

	switch(whence)
	{
		case seekmode_Start:   old = pos;  break;
		case seekmode_Current: old += pos; break;
		case seekmode_End:     old = gs_len + pos; break;
	}
	if (old < 0) old = 0;
	if (old > (glsi32)gs_len) old = gs_len;

	gs_pos = old;
}

glui32 glk_memory_stream::open()
{
	return 1;
}


void glk_memory_stream::set_buf_rock(gidispatch_rock_t r)
{
	buf_rock = r;
}

gidispatch_rock_t glk_memory_stream::get_buf_rock()
{
	return buf_rock;
}


////////////////////////////////////////////////////////////////////////////

glk_file_stream::glk_file_stream(glk_fileref_class *name, glui32 mode, glui32 rock)
				: glk_stream_class()
{
	char wmode[4];

	switch(mode)
	{
		case filemode_Write:		strcpy(wmode, "w"); break;
		case filemode_Read:		strcpy(wmode, "r"); break;
		case filemode_ReadWrite:	strcpy(wmode, "r+"); break;
		case filemode_WriteAppend:	strcpy(wmode, "a"); break;
	}
	gs_mode = mode;	
	if (name->is_binary()) strcat(wmode, "b");

	gs_fp = fopen(name->get_path(), wmode);

	set_rock(rock);
}


glk_file_stream::glk_file_stream(char *name, glui32 is_text, glui32 rock)
				: glk_stream_class()
{
	char wmode[4];

	strcpy(wmode, "r");
	gs_mode = filemode_Read;	
	if (!is_text) strcat(wmode, "b");

	gs_fp = fopen(name, wmode);

	set_rock(rock);
}


glk_file_stream::~glk_file_stream()
{
	if (gs_fp) fclose(gs_fp);
}

glui32 glk_file_stream::open()
{
	if (gs_fp) return 1; else return 0;
}

void glk_file_stream::close(stream_result_struct *s)
{
	if (gs_fp) 
	{
		fclose(gs_fp);
		gs_fp = NULL;
	}
	glk_stream_class::close(s);
}



void glk_file_stream::put_char(unsigned char ch)
{
	if (!gs_fp) return;
	if (fputc(ch, gs_fp) != EOF) ++gs_wcount;
}
	

glsi32 glk_file_stream::get_char()
{
	if (!gs_fp) return -1;

	int i = fgetc(gs_fp);
	if (i == EOF) return -1; 

	++gs_rcount;
	return i;
}

glui32 glk_file_stream::tell()
{
	if (!gs_fp) return 0;
	return ftell(gs_fp);
}

void glk_file_stream::seek(glsi32 pos, glui32 whence)
{
	int w = -1;

	switch(whence)
	{
		case seekmode_Start:   w = SEEK_SET; break;
		case seekmode_Current: w = SEEK_CUR; break;
		case seekmode_End:     w = SEEK_END; break;
	}
	if (!gs_fp || w < 0) return;	
	
	fseek(gs_fp, pos, w);
}



glui32 glk_file_stream::get_line(char *s, int l)
{
	if (!gs_fp) return 0;

	char *t = fgets(s, l, gs_fp);

	if (!t) return 0; 

	gs_rcount += strlen(s);
	return strlen(s);
}



glui32 glk_file_stream::get_buffer(char *s, int l)
{
	int ct;
	if (!gs_fp) return 0;

	ct = fread(s, 1, l, gs_fp);
	gs_rcount += ct;
	return ct;
}
