
class glk_window_class;		/* Will be needed */
class glk_fileref_class;		/* Will be needed */

struct glk_stream_struct
{
	glui32	gs_type;	/* GLK type */
	glui32	gs_rock;	/* GLK user-defined parameter */
	glui32	gs_rcount;	/* Count of bytes read */
	glui32	gs_wcount;	/* Count of bytes written */
	glui32  gs_mode;	/* Read/Write mode */
};

class glk_stream_class : protected glk_stream_struct
{
public:
	glk_stream_class();
	virtual ~glk_stream_class();

	static glk_stream_class *get_current();
	static void set_current(glk_stream_class *n);

	__inline__ glk_stream_struct *get_strid() { return (glk_stream_struct *)this; }
	__inline__ operator glk_stream_struct *() { return get_strid(); }

	glui32 get_rock();
	void set_rock(glui32 rock);

	virtual void   put_char(unsigned char ch);
	virtual glsi32 get_char();
	virtual void   set_style(glui32 style);
	virtual glui32 get_style();
	virtual void   put_string(unsigned char *s);
	virtual void   put_buffer(unsigned char *s, int l);
	virtual glui32 get_line(char *buf, int l);
	virtual glui32 get_buffer(char *buf, int l);
	virtual glui32 tell();
	virtual void   seek(glsi32 pos, glui32 whence);
	virtual glui32 open();

	virtual void   close(stream_result_struct *s);

	void set_echofor(glk_window_class *win);
	glk_window_class *get_echofor();

	void set_disp_rock(gidispatch_rock_t r);
	gidispatch_rock_t get_disp_rock(void);
	void set_reg_index(int idx);
	int  get_reg_index(void);

protected:
	int reg_index;
	gidispatch_rock_t disp_rock;
private:
	glk_window_class *gs_echofor;
};

typedef glk_stream_class *strclass_t;


class glk_memory_stream : public glk_stream_class
{
public:
	glk_memory_stream(char *buf, glui32 len, glui32 rock, glui32 mode);
	virtual ~glk_memory_stream();
	virtual void put_char(unsigned char ch);
	virtual glsi32 get_char();
	virtual glui32 tell();
	virtual void seek(glsi32 pos, glui32 whence);
	virtual glui32 open();
	void set_buf_rock(gidispatch_rock_t r);
	gidispatch_rock_t get_buf_rock(void);

private:
	gidispatch_rock_t buf_rock;
	glui32 gs_pos;
	glui32 gs_len;
	char  *gs_buf;
};


class glk_window_stream : public glk_stream_class
{
public:
	glk_window_stream(glk_window_class *w);
	virtual void   put_char(unsigned char ch);
	virtual void   set_style(glui32 style);
	virtual glui32 get_style();
	virtual glui32 open();
	virtual void   close(stream_result_struct *s);

private:
	glk_window_class *gs_window;
};


class glk_file_stream : public glk_stream_class
{
public:
	glk_file_stream(glk_fileref_class *fname, glui32 mode, glui32 rock);
	glk_file_stream(char *path, glui32 is_text, glui32 rock);
	virtual ~glk_file_stream();
	virtual void put_char(unsigned char ch);
	virtual glsi32 get_char();
	virtual glui32 tell();
	virtual void seek(glsi32 pos, glui32 whence);
	virtual glui32 open();
	virtual void close(stream_result_struct *s);
	virtual glui32 get_line(char *buf, int l);
	virtual glui32 get_buffer(char *buf, int l);
private:
	FILE *gs_fp;
};
