
#include "gemglk.h"

glk_stream_class::glk_stream_class()
{
	gs_type = 0;
	gs_rock = 0;
	gs_wcount = 0;
	gs_rcount = 0;
	gs_mode = 0;
	gs_echofor = NULL;
	register_stream(this);
}

glk_stream_class::~glk_stream_class()
{
	unregister_stream(this);
	/* If we are echoing a window, tell the window to stop */
	if (gs_echofor) gs_echofor->set_echo(NULL);
}

glk_stream_class *glk_stream_class::get_current()
{
	return str_current;
}

void glk_stream_class::set_current(glk_stream_class *s)
{
	str_current = s;
}

glui32 glk_stream_class::get_rock()
{
	return gs_rock;
}

void glk_stream_class::set_rock(glui32 rock)
{
	gs_rock = rock;
}

glsi32 glk_stream_class::get_char()
{
	return -1;
}


/* This is the base class and does nothing :-) */
void glk_stream_class::put_char(unsigned char c)
{
	UNUSED(c);
	++gs_wcount;	
}

/* Rather as in Java, there are several write functions which can be
 * overridden independently or routed through one single function.
 * If these two are not overridden, they just go via put_char().
 */

void glk_stream_class::put_buffer(unsigned char *s, int l)
{
	for (int n = 0; n < l; n++) put_char(s[n]);
}


void glk_stream_class::put_string(unsigned char *s)
{
	for (int n = 0; s[n]; n++) put_char(s[n]);
}


glui32 glk_stream_class::get_line(char *s, int l)
{
	int count = 0;

	while (l > 0)
	{
		glsi32 c = get_char();
		if (c == -1) break;
		s[count++] = c;
		if (c == '\n') break;
		--l;
	}
	s[count] = 0;
	return count;
}

glui32 glk_stream_class::get_buffer(char *s, int l)
{
	int count = 0;

	while (l > 0)
	{
		glsi32 c = get_char();
		if (c == -1) break;
		s[count++] = c;
		--l;
	}
	return count;
}




/* Default behaviour is to ignore styles */
void glk_stream_class::set_style(glui32 s)
{
	UNUSED(s);	
}


glui32 glk_stream_class::get_style()
{
	return style_Normal;
}


glui32 glk_stream_class::tell()
{
	return 0;
}

void glk_stream_class::seek(glsi32 offset, glui32 whence)
{
	UNUSED(offset);
	UNUSED(whence);
}


void glk_stream_class::close(stream_result_struct *s)
{
	if (s)
	{
		s->readcount = gs_rcount;
		s->writecount = gs_wcount;
	}
}


glui32 glk_stream_class::open()
{
	return 0;
}


glk_window_class *glk_stream_class::get_echofor()
{
	return gs_echofor;
}


void glk_stream_class::set_echofor(glk_window_class *w)
{
	gs_echofor = w;
}


void glk_stream_class::set_disp_rock(gidispatch_rock_t r)
{
	disp_rock = r;
}

gidispatch_rock_t glk_stream_class::get_disp_rock()
{
	return disp_rock;
}


void glk_stream_class::set_reg_index(int index)
{
	reg_index = index;
}

int glk_stream_class::get_reg_index()
{
	return reg_index;
}

