/* glkstart.h: GEM-specific header file for GEMGLK
        (GEM implementation of the Glk API).
    John Elliott, 21-11-1999

    Based on the Unix version by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html

    Cut down a lot because GEM (being a GUI) only passes filenames to
    a program, not options.
*/

#ifndef GT_START_H
#define GT_START_H

/* We define our own TRUE and FALSE and NULL, because ANSI
    is a strange world. */
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef NULL
#define NULL 0
#endif

typedef struct glkgem_startup_struct {
    int argc;		/* Unix-style argc */
    char **argv;	/* Unix-style argv */
    char **wintitle;	/* Title of GEM window */
    char **rscfile;	/* RSC filename */
} glkgem_startup_t;


extern int glkgem_startup_code(glkgem_startup_t *data);

extern strid_t glkgem_stream_open_pathname(char *pathname, glui32 textmode, 
    glui32 rock);

#endif /* GT_START_H */

