/* Text storage for a text window:
 * 
 * We do text as a list of paragraphs. Paragraphs are terminated with a 
 * "\n".
 *
 * Each paragraph contains, for each character within it:
 *
 * - The character
 * - The GLK style for that character
 * - A GRECT containing the size & position of that character. This 
 *  is calculated when the paragraph's arrange() method is called.
 * - The height of the character above the baseline.
 *
 */

class glk_text_para
{
public:
	glk_text_para();
	~glk_text_para();

	int put_char(char c);
	void get_height(WORD *h, WORD *tlh);
	void on_paint(WORD x, WORD y, PARMBLK *pb);
	void get_curpos(WORD *x, WORD *y);

	glui32 get_style();
	void   set_style(glui32 s);
	void   arrange(GRECT *winrect);

private:
	char   *buf;	/* The text */
	glui32 *baseh;	/* Height above baseline for character */
	glui32 *base2;	/* Height above baseline to use when drawing */
	glui32 *style;	/* Styles for each character */
	GRECT  *rects;	/* A list of rectangles - the dimensions & */
			/* position of each character */
	int    buf_length;
	int    buf_max;
	glui32 cur_style;

	void layout(WORD width);
	void find_range(int *rs, int *re);
	WORD measure_text(int rs, int re, WORD *lw, WORD *lh);
	void set_xy(int rs, int re, WORD x, WORD y);
};

typedef glk_text_para *paraptr;
