
#include "gemglk.h"

WORD get_parent(OBJECT *tree, WORD obj)
{
	WORD		pobj;
	
	if (obj == NIL) return (NIL);
	pobj = tree[obj].ob_next;

	if (pobj != NIL)
	{	
	  while( tree[pobj].ob_tail != obj ) 
	  {
	    obj  = pobj;
	    pobj = tree[obj].ob_next;
	  }
	}
	return(pobj);
}

WORD rsrc_alert(WORD def, WORD nrsrc)
{
	LPBYTE str;

	rsrc_gaddr(5, nrsrc, &str);

	return form_alert(def, str);
}

#ifndef NDEBUG

void	__gem_assert(const char *a,const char *b,int n)
{
	dj_form_alert(1, "[3][Assertion failed!|"
                     "%-40.40s|"
                     "in %-37.37s|"
		     "at line %d][ Abort ]",a,b,n);
	glk_exit();
}

#endif


VOID send_redraw(WORD wh, GRECT *p)
	{
	WORD	msg[8];

	msg[0] = WM_REDRAW;		/* Defined in GEMBIND.H	    */
	msg[1] = gl_apid;		/* As returned by appl_init */
	msg[2] = 0;
	msg[3] = wh;			/* Handle of window to redraw */
	msg[4] = p->g_x;
	msg[5] = p->g_y;
	msg[6] = p->g_w;
	msg[7] = p->g_h;
	appl_write(gl_apid, 16, msg);	
	}


#if 0	/* Diagnostic function only */

VOID dump_tree(char *capt, OBJECT *tr)
{
	int o=0, d=0;
	FILE *fp = fopen("d:/gemapp.log", "a");
	int no = o;

	if (capt) fprintf(fp, "%s\n", capt);
/*
	while (no != l)
	{
		fprintf(fp, "%04d: %*s %c %04x %04x %04x Type %04x Flags %04x State %04x Spec %08x\n",
			no, d, " ",
			((tr[no].ob_flags & LASTOB) ? '*' : ' '), 
			tr[no].ob_next,
			tr[no].ob_head,
			tr[no].ob_tail,
			tr[no].ob_type,
			tr[no].ob_flags,
			tr[no].ob_state,
			tr[no].ob_spec);
		if (tr[no].ob_head != -1)
		{
			dump_tree(NULL, tr, tr[no].ob_head, d + 1, tr[no].ob_tail);
		}
		no = tr[no].ob_next;
	}
*/

	if (capt) 
	{
//		fprintf(fp, " - or - \n");
		no = 0;
		do
		{
			fprintf(fp, "%04d: %*s %c %04x %04x %04x Type %04x Flags %04x State %04x Spec %08x [%d,%d,%d,%d]\n",
			no, d, " ",
			((tr[no].ob_flags & LASTOB) ? '*' : ' '), 
			tr[no].ob_next,
			tr[no].ob_head,
			tr[no].ob_tail,
			tr[no].ob_type,
			tr[no].ob_flags,
			tr[no].ob_state,
			tr[no].ob_spec,
			tr[no].ob_x,
			tr[no].ob_y,
			tr[no].ob_width,
			tr[no].ob_height);
			if (tr[no].ob_type == 31)
			{
				ICONBLK *ib = (ICONBLK *)tr[no].ob_spec;
	
				fprintf(fp, "    ICONBLK: mask=%08x data=%08x ptext=%x\n"
                                            "             h=%d w=%d", ib->ib_pmask, ib->ib_pdata, 
                                            ib->ib_ptext, ib->ib_hicon, ib->ib_wicon);
			}

		}
		while (!(tr[no++].ob_flags & LASTOB));
	}

	fclose(fp);
}
#endif /* 0 */

