
#include "glkstyl.h"	/* Styles */
#include "glkstrm.h"	/* Streams */
#include "glkpara.h"	/* Text storage */
#include "glkwin.h"	/* Windows */
#include "glkfref.h"	/* File refs */
#include "glkreg.h"	/* Object registry */

#define UNUSED(x) ((void)x)	/* for unused parameters */

/******************************* GLOBAL FUNCTIONS ****************************/

WORD get_parent(OBJECT *tree, WORD obj);	/* Get parent of object */
VOID send_redraw(WORD handle, GRECT *rect);	/* Invalidate a window */
VOID set_clip(WORD clip, GRECT *r);		/* Set clipping rectangle */
WORD draw_win(PARMBLK *pb);			/* Window drawing callback */
WORD draw_clr(PARMBLK *pb);			/* Colour drawing callback */
VOID on_about(VOID);				/* About box */
VOID on_prefs(glui32 wintype);			/* Preferences */
/* Draw a filled coloured shaded rectangle */
VOID filled_rect(GRECT *area, WORD fg, WORD bg, WORD style, WORD index);
VOID draw_rect(GRECT *area);			/* Draw a rectangle outline */
WORD contrast(WORD colour);			/* Contrasting colour */
VOID update_windows(VOID);			/* Force an update */
glui32 gem_to_glk(WORD keycode);		/* Convert GEM keycode to 
						 * GLK character */

WORD rsrc_alert(WORD defbutton, WORD string);	/* Alert using resources */

/* Window arrange events */
VOID fire_arrange(VOID);			/* Fire an "arrange" event */

/* Popup menus */
int menu_popup(WORD x, WORD y, OBJECT *tr);
int menu_popup_strings(WORD x, WORD y, int n, ...);

/******************************* GLOBAL VARIABLES ***************************/

extern unsigned char gem_to_iso[256];
extern unsigned char iso_to_gem[256];

#ifdef INSTANTIATE
#define EQ(x) = x
#define EXT 
#else
#define EQ(x) 
#define EXT extern
#endif

/* The window with input focus */
EXT glk_window_class *focus_window EQ(NULL);

/* The GLK window tree */
EXT OBJECT glk_tree [MAXWINDOW];
/* The addresses of the GLK object for each tree object */
EXT USERBLK glk_treecode[MAXWINDOW];
/* Drawing callbacks for each GLK window */
EXT DJUSERBLK glk_userblk[MAXWINDOW];

/* Drawing callbacks for the colour chooser */
#define MAXCOLOUR 16	/* Max no. of colours for text */
EXT DJUSERBLK clr_userblk[MAXCOLOUR];

/* Function to call on interrupt */
EXT void (*int_handler)(void);

/* Timer events? */
EXT glui32 timer_tick EQ(0);

/* Count of open windows */
EXT WORD gl_wincount EQ(0);

/* 16-bit USERDEF block array */
EXT LPWORD glk_userdefs EQ(0);

EXT GRECT work_area;		/* Screen area less the menu */
EXT WORD glk_whndl EQ(0); 	/* Window handle for GLK window */
EXT WORD gl_apid;		/* Application ID */
EXT WORD vdi_handle;		/* Application device context */
EXT WORD gem_handle;		/* System device context */
EXT glk_stream_class *str_current EQ(NULL);	/* Current GLK stream */

/* System font characteristics: */

EXT WORD gl_wchar;			/* character width		*/
EXT WORD gl_hchar;			/* character height		*/
EXT WORD gl_wbox;			/* box (cell) width		*/
EXT WORD gl_hbox;			/* box (cell) height		*/


#define MAXFONTS 4			/* Max number of fonts this program */
					/* can handle */
#define MAXPOINTS 14			/* Max number of point sizes / font */
EXT WORD gl_fontcount EQ(0);		/* No. of fonts in the system */
EXT WORD gl_fontid[MAXFONTS];		/* Fonts' indentity codes */
EXT char gl_fontname[MAXFONTS][38];	/* Fonts' names */
EXT WORD gl_fontpts[MAXFONTS][MAXPOINTS]; /* Usable point sizes */
EXT WORD gl_ptcount[MAXFONTS];		/* Sizes of the fontpts arrays */

/* Menu bar */

EXT OBJECT *gl_menutree;		/* Menu bar */

/* These attributes ought to be customisable. Since they are (or may be) 
  used before glk_main() is called, they can be set in the initialisation
  code.
*/
EXT char *rsc_str EQ("_GLK.RSC");
EXT char *win_title EQ(" GLK application ");

/* Set when initialising */
EXT BOOLEAN inittime EQ(FALSE);

#undef EXT
#undef EQ



