
#include "gemglk.h"

/* All this file does is interface C calls either to GEM subroutines or
 * to C++ object methods */

void glk_exit(void)
{
	gem_final_select();
	glklib_term();
	exit(0);
}


void glk_set_interrupt_handler(void (*func)(void))
{
	int_handler = func;
}

void glk_tick(void)
{
	// I am assuming (maybe wrongly) that GEM has no gnurrs in its
	// voodvork. So this doesn't do anything.
}

glui32 glk_gestalt(glui32 id, glui32 val)
{
	return glk_gestalt_ext(id, val, NULL);
}




unsigned char glk_char_to_upper(unsigned char ch)
{
	if ((ch >= 0x61 && ch <= 0x7A) ||
            (ch >= 0xE0 && ch <= 0xF6) ||
            (ch >= 0xF8 && ch <= 0xFE))      ch -= 0x20;

	return ch;
}

unsigned char glk_char_to_lower(unsigned char ch)
{
	if ((ch >= 0x41 && ch <= 0x5A) ||
            (ch >= 0xC0 && ch <= 0xD6) ||
            (ch >= 0xD8 && ch <= 0xDE))      ch += 0x20;

	return ch;
}



winid_t glk_window_get_root(void)
{
	return (winid_t)(glk_tree[0].ob_spec);
}


winid_t glk_window_open(winid_t split, glui32 method, glui32 size, 
    glui32 wintype, glui32 rock)
{
	winclass_t wc, wn;
	glk_pair_window *pair;

	if (split == NULL) wc = NULL;
	else wc = (winclass_t)split;
	if (wc) pair = wc->split_yourself(method, size);	
	else    pair = NULL;

	switch(wintype)
	{
		default:			   /* Unknown window type */
		case wintype_Pair:       return 0; /* Not created automatically */
		case wintype_Blank:      wn = new glk_window_class   (pair, method, size); break;
		case wintype_TextBuffer: wn = new glk_text_window    (pair, method, size); break;
		case wintype_TextGrid:   wn = new glk_textgrid_window(pair, method, size); break;
		case wintype_Graphics:   wn = new glk_graphics_window(pair, method, size); break;
	}
	if (!wn) return 0;
	wn->set_rock(rock);

	if (pair) 
	{
		glk_pair_window *pparent = pair->get_parent();
		if (!pparent) pparent = pair;

		pair->set_key(wn);
		pparent->arrange();
	}
	return wn->get_winid();
}

void glk_window_close(winid_t win, stream_result_t *result)
{
	((winclass_t)win)->close(result);
}

void glk_window_get_size(winid_t win, glui32 *widthptr, glui32 *heightptr)
{
	((winclass_t)win)->get_size(widthptr, heightptr);
}


void glk_window_set_arrangement(winid_t win, glui32 method,
    glui32 size, winid_t keywin)
{
	((winclass_t)win)->set_arrangement(method, size, (winclass_t)keywin);
}

void glk_window_get_arrangement(winid_t win, glui32 *methodptr,
    glui32 *sizeptr, winid_t *keywinptr)
{
	((winclass_t)win)->get_arrangement(methodptr, sizeptr, keywinptr);
}


winid_t glk_window_iterate(winid_t win, glui32 *rockptr)
{
	winclass_t w = (winclass_t)win;

	w = (winclass_t)window_registry.iterate(w);
	
	if (w) 
	{
		if (rockptr) *rockptr = w->get_rock();
		return w->get_winid();
	}
	return NULL;
}

glui32 glk_window_get_rock(winid_t win)
{
	return ((winclass_t)win)->get_rock();
}

glui32 glk_window_get_type(winid_t win)
{
	return ((winclass_t)win)->get_type();
}

winid_t glk_window_get_parent(winid_t win)
{
	return (winid_t)(((winclass_t)win)->get_parent());
}

winid_t glk_window_get_sibling(winid_t win)
{
	return (winid_t)(((winclass_t)win)->get_sibling());
}

void glk_window_clear(winid_t win)
{
	((winclass_t)win)->clear();
}


void glk_window_move_cursor(winid_t win, glui32 xpos, glui32 ypos)
{
	((winclass_t)win)->move_cursor(xpos, ypos);
}

strid_t glk_window_get_stream(winid_t win)
{
	glk_window_class *w = (glk_window_class *)win;

	return (w->get_stream())->get_strid();
}

void glk_window_set_echo_stream(winid_t win, strid_t str)
{
	glk_window_class *w = (glk_window_class *)win;
	glk_stream_class *s = (glk_stream_class *)str;

	w->set_echo(s);
	s->set_echofor(w);
}

strid_t glk_window_get_echo_stream(winid_t win)
{
	glk_window_class *w = (glk_window_class *)win;

	return w->get_echo()->get_strid();
}

void glk_set_window(winid_t win)
{
	if (!win) return;

	glk_stream_set_current(glk_window_get_stream(win));
}

strid_t glk_stream_open_file(frefid_t fileref, glui32 fmode, glui32 rock)
{
	glk_file_stream *strm = new glk_file_stream((glk_fileref_class *)fileref, fmode, rock);

	if (!strm->open())
	{
		delete strm;
		return NULL;
	}
	return strm->get_strid();
}

strid_t glk_stream_open_memory(char *buf, glui32 buflen, glui32 fmode, glui32 rock)
{
	glk_memory_stream *strm = new glk_memory_stream(buf, buflen, fmode, rock);

	return strm->get_strid();
}

void glk_stream_close(strid_t str, stream_result_t *result)
{
	((glk_stream_class *)str)->close(result);
	delete ((glk_stream_class *)str);
}

strid_t glk_stream_iterate(strid_t str, glui32 *rockptr)
{
	glk_stream_class *s = (glk_stream_class *)str;

	s = (glk_stream_class *)stream_registry.iterate(s);
	
	if (s) 
	{
		if (rockptr) *rockptr = s->get_rock();
		return s->get_strid();
	}
	return NULL;
}


glui32 glk_stream_get_rock(strid_t str)
{
	return ((glk_stream_class *)str)->get_rock();
}

void glk_stream_set_position(strid_t str, glsi32 pos, glui32 seekmode)
{
	((glk_stream_class *)str)->seek(pos, seekmode);
}


glui32 glk_stream_get_position(strid_t str)
{
	return ((glk_stream_class *)str)->tell();
}


void glk_stream_set_current(strid_t str)
{
	glk_stream_class::set_current((glk_stream_class *)str);
}


strid_t glk_stream_get_current(void)
{
	return (glk_stream_class::get_current())->get_strid();
}


void glk_put_char(unsigned char ch)
{
	glk_stream_class::get_current()->put_char(ch);
}


void glk_put_char_stream(strid_t str, unsigned char ch)
{
	((glk_stream_class *)str)->put_char(ch);
}


void glk_put_string(char *s)
{
	glk_stream_class::get_current()->put_string((unsigned char *)s);
}

void glk_put_string_stream(strid_t str, char *s)
{
	((glk_stream_class *)str)->put_string((unsigned char *)s);
}


void glk_put_buffer(char *buf, glui32 len)
{
	glk_stream_class::get_current()->put_buffer((unsigned char *)buf, len);
}


void glk_put_buffer_stream(strid_t str, char *buf, glui32 len)
{
	((glk_stream_class *)str)->put_buffer((unsigned char *)buf, len);
}


void glk_set_style(glui32 styl)
{
	glk_stream_class::get_current()->set_style(styl);
}


void glk_set_style_stream(strid_t str, glui32 styl)
{
	((glk_stream_class *)str)->set_style(styl);
}


glsi32 glk_get_char_stream(strid_t str)
{
	return ((glk_stream_class *)str)->get_char();	
}


glui32 glk_get_line_stream(strid_t str, char *buf, glui32 len)
{
	return ((glk_stream_class *)str)->get_line(buf, len);	
}


glui32 glk_get_buffer_stream(strid_t str, char *buf, glui32 len)
{
	return ((glk_stream_class *)str)->get_buffer(buf, len);	
}

void glk_stylehint_set(glui32 wintype, glui32 styl, glui32 hint, glsi32 val)
{
	/* XXX Not implemented. All styles are set by the library */
	UNUSED(wintype);
	UNUSED(styl);
	UNUSED(hint);
	UNUSED(val);
}

void glk_stylehint_clear(glui32 wintype, glui32 styl, glui32 hint)
{
	/* XXX Not implemented. All styles are set by the library */
	UNUSED(wintype);
	UNUSED(styl);
	UNUSED(hint);
}

glui32 glk_style_distinguish(winid_t win, glui32 styl1, glui32 styl2)
{
	/* XXX Not implemented. We claim all styles look the same */
	UNUSED(win);
	UNUSED(styl1);
	UNUSED(styl2);
	return 0;
}


glui32 glk_style_measure(winid_t win, glui32 styl, glui32 hint, glui32 *result)
{
	/* XXX Not implemented. Always returns 0 */
	UNUSED(win);
	UNUSED(styl);
	UNUSED(hint);
	UNUSED(result);
	return 0;
}


frefid_t glk_fileref_create_temp(glui32 usage, glui32 rock)
{
	glk_fileref_class *c = new glk_fileref_class(usage, rock);

	return c;
}

frefid_t glk_fileref_create_by_name(glui32 usage, char *name, glui32 rock)
{
	glk_fileref_class *c = new glk_fileref_class(usage, name, rock);

	return c;
}

frefid_t glk_fileref_create_by_prompt(glui32 usage, glui32 fmode, glui32 rock)
{
	glk_fileref_class *c = new glk_fileref_class(usage, fmode, rock);

	if (c->gf_path[0] == 0)	/* Cancelled */
	{
		delete c;
		return NULL;
	}

	return c;
}

frefid_t glk_fileref_create_from_fileref(glui32 usage, frefid_t fref, glui32 rock)
{
	glk_fileref_class *c = new glk_fileref_class(usage, (glk_fileref_class *)fref, rock);
	return c;
}

void glk_fileref_destroy(frefid_t fref)
{
	delete (glk_fileref_class *)fref;
}


frefid_t glk_fileref_iterate(frefid_t fref, glui32 *rockptr)
{
	glk_fileref_class *f = (glk_fileref_class *)fref;

	f = (glk_fileref_class *)fileref_registry.iterate(f);
	
	if (f) 
	{
		if (rockptr) *rockptr = f->get_rock();
		return (frefid_t)f;
	}
	return NULL;
}


glui32 glk_fileref_get_rock(frefid_t fref)
{
	return ((glk_fileref_class *)fref)->get_rock();
}


void glk_fileref_delete_file(frefid_t fref)
{
	((glk_fileref_class *)fref)->delete_file();
}


glui32 glk_fileref_does_file_exist(frefid_t fref)
{
	return ((glk_fileref_class *)fref)->exists_file();
}


void glk_select(event_t *event)
{
	update_windows();
	gem_select(event, FALSE);
}

void glk_select_poll(event_t *event)
{
	update_windows();
	gem_select(event, TRUE);
}

void glk_request_timer_events(glui32 millisecs)
{
	timer_tick = millisecs;
}

void glk_request_line_event(winid_t win, char *buf, glui32 maxlen, glui32 initlen)
{
	((winclass_t)win)->request_line_event(buf, maxlen, initlen);
}

void glk_request_char_event(winid_t win)
{
	((winclass_t)win)->request_char_event();
}

void glk_request_mouse_event(winid_t win)
{
	((winclass_t)win)->request_mouse_event();
}


void glk_cancel_line_event(winid_t win, event_t *event)
{
	((winclass_t)win)->cancel_line_event(event);
}


void glk_cancel_char_event(winid_t win)
{
	((winclass_t)win)->cancel_char_event();
}

void glk_cancel_mouse_event(winid_t win)
{
	((winclass_t)win)->cancel_mouse_event();
}

/* Stubs for image (which we might one day support) and sound (which we
 * won't, ever) */

glui32 glk_image_draw(winid_t win, glui32 image, glsi32 val1, glsi32 val2)
{
	UNUSED(win);
	UNUSED(image);
	UNUSED(val1);
	UNUSED(val2);
	return FALSE;
}

glui32 glk_image_draw_scaled(winid_t win, glui32 image, glsi32 val1, 
                             glsi32 val2, glui32 width, glui32 height)
{
	UNUSED(win);
	UNUSED(image);
	UNUSED(val1);
	UNUSED(val2);
	UNUSED(width);
	UNUSED(height);
	return FALSE;
}


glui32 glk_image_get_info(glui32 image, glui32 *width, glui32 *height)
{
	UNUSED(image);
	UNUSED(width);
	UNUSED(height);
	return FALSE;
}

void glk_window_flow_break(winid_t win)
{
	UNUSED(win);
}

void glk_window_erase_rect(winid_t win, 
    glsi32 left, glsi32 top, glui32 width, glui32 height)
{
	UNUSED(win);
	UNUSED(left);
	UNUSED(top);
	UNUSED(width);
	UNUSED(height);
}

void glk_window_fill_rect(winid_t win, glui32 color, 
    glsi32 left, glsi32 top, glui32 width, glui32 height)
{
	UNUSED(win);
	UNUSED(color);
	UNUSED(left);
	UNUSED(top);
	UNUSED(width);
	UNUSED(height);
}


void glk_window_set_background_color(winid_t win, glui32 color)
{
	UNUSED(win);
	UNUSED(color);
}

schanid_t glk_schannel_create (glui32 rock)                     
{
	UNUSED(rock);
	return NULL; 
}

void      glk_schannel_destroy(schanid_t chan)
{
	UNUSED(chan);
}

schanid_t glk_schannel_iterate(schanid_t chan, glui32 *rockptr) 
{ 
	UNUSED(chan);
	UNUSED(rockptr);
	return NULL; 
}

glui32    glk_schannel_get_rock(schanid_t chan)
{
	UNUSED(chan);
	return 0; 
}

glui32 glk_schannel_play(schanid_t chan, glui32 snd)            
{
	UNUSED(chan);
	UNUSED(snd);
	return 0; 
}

glui32 glk_schannel_play_ext(schanid_t chan, glui32 snd, 
        glui32 repeats,	glui32 notify)				
{
	UNUSED(chan);
	UNUSED(snd);
	UNUSED(repeats);
	UNUSED(notify);
	return 0; 
}

void glk_schannel_stop(schanid_t chan)				
{
	UNUSED(chan);
}

void glk_schannel_set_volume(schanid_t chan, glui32 vol)	
{
	UNUSED(chan);
	UNUSED(vol);
}

void glk_sound_load_hint(glui32 snd, glui32 flag)
{
	UNUSED(snd);
	UNUSED(flag);
}

////////////////////////////////////////////////////////////////////////
// GEM-specific startup code

strid_t glkgem_stream_open_pathname(char *pathname, glui32 textmode, 
    glui32 rock)
{
	if (!inittime) return NULL;

	glk_file_stream *strm = new glk_file_stream(pathname, (textmode != 0), rock);

	if (!strm->open())
	{
		delete strm;
		return NULL;
	}
	return strm->get_strid();
}
