
#include "gemglk.h"

extern LPBYTE pGeneral;	/* General GEM buffer */

MLOCAL VOID get_path(BYTE *tmp_path)	/* get directory path name		*/
{
	char *s;

	getcwd(tmp_path, 259);

/* DJGPP returns the path with forward slashes. But GEM only handles 
  * backward ones (bad bad bad) */

	while ((s = strrchr(tmp_path, '/'))) *s = '\\';
	strcat(tmp_path, "\\");
}


glk_fileref_class::glk_fileref_class(glui32 usage, glui32 rock)
{
	static int tctr = 0;

	scrp_read(pGeneral);
	dosmemget(pGeneral, LSTRLEN(pGeneral), gf_path);
	sprintf(gf_path + strlen(gf_path), "GLK%05d.", tctr++);
	tctr %= 100000;
	append_type(usage);	
	gf_rock = rock;	
	gf_usage = usage;

	register_fileref(this);
}


/* Create prompt */
glk_fileref_class::glk_fileref_class(glui32 usage, glui32 fmode, glui32 rock)
{
	WORD	fs_iexbutton;
	BYTE	fs_iinsel[13];

	gf_rock = rock;	
	gf_usage = usage;
	register_fileref(this);
	while (TRUE)
	{
		::get_path(gf_path);
		strcat(gf_path, "*.");
		append_type(usage);		

		fs_iinsel[0] = '\0'; 

		fsel_input(gf_path, fs_iinsel, &fs_iexbutton);
		if (fs_iexbutton)
		{
			char *bs = strrchr(gf_path, '\\');
			if (!bs) bs = strrchr(gf_path, '/');
			if (!bs) bs = strrchr(gf_path, ':');
			if (!bs) bs = gf_path - 1;
			++bs;
			*bs = 0;
			strcat(gf_path, fs_iinsel);

			switch(fmode)
			{
				FILE *fp;

				case filemode_Read:
					fp = fopen(gf_path, "rb");
					if (!fp)
					{	
						rsrc_alert(1, CANTOPEN);
						break;
					}
					fclose(fp);
					return;
				case filemode_Write:
					fp = fopen(gf_path, "rb");
					if (fp) 
					{	
						fclose(fp);
						if (rsrc_alert(1, CONFDEL) != 1) break;

						if (remove(gf_path)) 
						{
							rsrc_alert(1, CANTDEL);
							break;
						}												
					}
					return;
				case filemode_ReadWrite:
				case filemode_WriteAppend:
					fp = fopen(gf_path, "rb");
					if (fp) 
					{	
						fclose(fp);
						if (rsrc_alert(1, CONFMOD) != 1) break;
					}
					return;

			}
		}
		else { gf_path[0] = 0; return; }
	}
	gf_path[0] = 0;
}

/* Create by name */
glk_fileref_class::glk_fileref_class(glui32 usage, char *name, glui32 rock)
{
	::get_path(gf_path);	/* Current dir */

	int m = strlen(gf_path);
	for (int n = 0; n < 8; n++)
	{
		char c = name[n];
		
		if (!c) break;
		if (c < '0' || (c > '9' && c < 'a') || (c > 'Z' && c < 'a') || (c > 'z')) c = '#';

		gf_path[m++] = c;
	}
	gf_path[m++] = '.';
	gf_path[m] = 0;
	append_type(usage);	
	gf_rock = rock;	
	gf_usage = usage;
	register_fileref(this);
}

/* Create by copy */
glk_fileref_class::glk_fileref_class(glui32 usage, glk_fileref_class *src, glui32 rock)
{
	strcpy(gf_path, src->gf_path);
	gf_usage = usage;
	gf_rock = rock;

	char *s = strrchr(gf_path, '.');

	if (s == NULL) return;	
	
	s[1] = 0;
	append_type(usage);
	register_fileref(this);
}

glk_fileref_class::~glk_fileref_class()
{
	unregister_fileref(this);
}


void glk_fileref_class::append_type(glui32 usage)
{
	switch(usage & fileusage_TypeMask)
	{
		case fileusage_Data:        strcat(gf_path, "GLD"); break;
		case fileusage_SavedGame:   strcat(gf_path, "GLS"); break;
		case fileusage_Transcript:  strcat(gf_path, "GLT"); break;
		case fileusage_InputRecord: strcat(gf_path, "GLI"); break;
		default:                    strcat(gf_path, "GLQ"); break;
	}
}

void glk_fileref_class::delete_file()
{
	remove(gf_path);
}


glui32 glk_fileref_class::exists_file()
{
	FILE *fp = fopen(gf_path, "rb");
	if (fp) { fclose(fp); return 1; }
	return 0;
}


glui32 glk_fileref_class::get_rock()
{
	return gf_rock;
}

void glk_fileref_class::set_rock(glui32 r)
{
	gf_rock = r;
}


int glk_fileref_class::is_binary()
{
	if (gf_usage & fileusage_TextMode) return 0;
	return 1;
}

char *glk_fileref_class::get_path()
{
	return gf_path;
}


void glk_fileref_class::set_disp_rock(gidispatch_rock_t r)
{
	disp_rock = r;
}

gidispatch_rock_t glk_fileref_class::get_disp_rock()
{
	return disp_rock;
}


void glk_fileref_class::set_reg_index(int index)
{
	reg_index = index;
}

int glk_fileref_class::get_reg_index()
{
	return reg_index;
}

