
#include "gemglk.h"

static glui32 gcharout(glui32 id, glui32 *rw)
{
	unsigned char och;

	if (id > 255)	/* Unprintable, no placeholder */
	{
		*rw = 0;
		return gestalt_CharOutput_CannotPrint;
	}
	och = iso_to_gem[id];

	if (och == 7) 	/* Unprintable, placeholder */
	{
		*rw = 1;
		return gestalt_CharOutput_ExactPrint;
	}
	if (och < 127) 	/* Printable */
	{
		*rw = 1;
		return gestalt_CharOutput_ExactPrint;
	}
	if (och < 4)	/* Fractions */
	{
		*rw = 3;
		return gestalt_CharOutput_ApproxPrint;
	}
	if (och < 6)	/* Thorns */
	{
		*rw = 2;
		return gestalt_CharOutput_ApproxPrint;
	}
	if (och < 0x7F)	/* Approximations */
	{
		*rw = 1;
		return gestalt_CharOutput_ApproxPrint;
	}
	*rw = 1;
	return gestalt_CharOutput_ExactPrint;
}

static glui32 glinein(glui32 ch)
{
	if (ch > 255) return 0;
	if (ch < 32) return 0;
	if (ch > 126 && ch < 160) return 0;

	if (gem_to_iso[ch] == 7) return 0;

	return 1;
}

static glui32 gcharin(glui32 ch)
{
	switch(ch)
	{
		case keycode_Tab:
			return 0;	/* Never */
		case keycode_Unknown:
			return 1;	/* Always */

		case keycode_Left:
		case keycode_Right:
		case keycode_Up:
		case keycode_Down:
		case keycode_Return:
		case keycode_Delete:
		case keycode_Escape:
		case keycode_PageUp:
		case keycode_PageDown:
		case keycode_Home:
		case keycode_End:
		case keycode_Func1:
		case keycode_Func2:
		case keycode_Func3:
		case keycode_Func4:
		case keycode_Func5:
		case keycode_Func6:
		case keycode_Func7:
		case keycode_Func8:
		case keycode_Func9:
		case keycode_Func10:
			return 1;	// Supported
		case keycode_Func11:
		case keycode_Func12:
			return 0;	// Not supported
	}

	if (ch > 255) return 0;
	if (ch < 32) return 0;
	if (ch > 126 && ch < 160) return 0;

	if (gem_to_iso[ch] == 7) return 0;

	return 1;
}


glui32 glk_gestalt_ext(glui32 id, glui32 val, void *ptr)
{
	glui32 rv, rw;

	switch(id)
	{
		case gestalt_Version:
			return 0x00000502;
		case gestalt_LineInput:
			return glinein(val);
		case gestalt_CharInput:
			return gcharin(val);
		case gestalt_CharOutput:
			rv = gcharout(val, &rw);
			if (ptr) *(glui32 *)ptr = rw;
			return rv;							
		case gestalt_MouseInput:
// not yet		if (val == wintype_Graphics || val == wintype_TextGrid) return 1;
			return 0;
		case gestalt_Timer:
			return 1;
		case gestalt_Graphics:
// not yet		return 1;
			return 0;
		case gestalt_DrawImage:
// not yet		return 1;
			return 0;
		case gestalt_Sound:
		case gestalt_SoundNotify:
		case gestalt_SoundVolume:
			return 0;	// never

	}
	return 0;
}
