
/* Structure of GLK for GEM:
 *
 * External interfaces are "C" in both directions (calls are made to GEM,
 * a C library; and by the GLK client, a C program. Internal implementation
 * is done in C++. 
 *
 * In GEM, a window is a valuable resource (the system allows only 8, 
 * including the desktop window) so all of GLK lives in one window.
 *
 * Each GLK window is represented by an entry in a GEM widget tree
 * (this is also the way GEM windows are represented internally within GEM,
 *  but I digress). 
 *
 * Each widget has the INDIRECT flag set. Its spec then points to the 
 * managing window structure.
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>

/* C-style includes */
extern "C" {

#include <djgppgem.h>	/* GEM bindings */
#include "_glk.h"	/* Resources */
#include "glk.h"	/* GLK prototypes */
#include "gi_dispa.h"	/* Dispatch layer */
#include "gi_blorb.h"	/* Blorb layer */
#include "glkstart.h"	/* Startup functions */
}

/* C++ functions and types */

#include "glkimpl.h"	/* GLK implementation types */
#include "glassert.h"	/* Assertions */

void glklib_term(void);
void gem_select(event_t *event, BOOLEAN poll);
void gem_final_select(void);
