#define INSTANTIATE
#include "gemglk.h"

/* GEM program - based on the Hello World sample */

#define	ARROW		0
#define	HOUR_GLASS	2			

#define	DESK		0

#define END_UPDATE	0
#define	BEG_UPDATE	1

#define WIND_STYLE (CLOSER | NAME)

#define TAB 0x0F09		/* GEM scancode for the tab key */

WORD	work_out[57];			/* open virt workstation values	*/
WORD	gl_rmsg[8];			/* message buffer		*/
WORD	gl_xfull;			/* full window 'x'		*/
WORD	gl_yfull;			/* full window 'y'		*/
WORD	gl_wfull;			/* full window 'w' width	*/
WORD	gl_hfull;			/* full window 'h' height	*/
WORD	ev_which;			/* event message returned value	*/
WORD	type_size;			/* system font cell size	*/
LPBYTE	str_title;

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Local Procedures			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


MLOCAL WORD menu_set = 0;
MLOCAL WORD gl_out = 0;
MLOCAL char glk_cfgname[256];
MLOCAL char cfgname[256];
MLOCAL BOOLEAN arrange_waiting = 0;

VOID fire_arrange(void)
{
	arrange_waiting = 1;
}


/*------------------------------*/
/*	do_open			*/
/*------------------------------*/
WORD do_open(WORD wh, WORD org_x, WORD org_y, WORD x, WORD y, WORD w, WORD h)
	/* grow and open specified wdw	*/
{
	WORD	ret_code;

	graf_mouse(2,0x0L);
	graf_growbox(org_x, org_y, 21, 21, x, y, w, h);
	ret_code = wind_open(wh, x, y, w, h);
	graf_mouse(ARROW,0x0L);
	return(ret_code);
}


/*------------------------------*/
/*	do_close		*/
/*------------------------------*/
VOID do_close(WORD wh, WORD org_x, WORD org_y)	/* close and shrink specified window	*/
{
	WORD	x, y, w, h;

	graf_mouse(2,0x0L);
	wind_get(wh, WF_CXYWH, &x, &y, &w, &h);
	wind_close(wh);
	graf_shrinkbox(org_x, org_y, 21, 21, x, y, w, h);
	graf_mouse(ARROW,0x0L);
}

/*------------------------------*/
/*	set_clip		*/
/*------------------------------*/
VOID set_clip(WORD clip_flag, GRECT *s_area)	/* set clip to specified area		*/
{
	WORD	pxy[4];

	rc_grect_to_array(s_area, pxy);
	vs_clip(vdi_handle, clip_flag, pxy);
}

/*------------------------------*/
/*	align_x			*/
/*------------------------------*/
WORD align_x(WORD x)	
{
	return((x & 0xfff0) + ((x & 0x000c) ? 0x0010 : 0));
}	

/*--------------------------------*/
/*	Size window to work area  */
/*--------------------------------*/
VOID wdw_size(GRECT *box)	/* compute window size for given w * h chars	*/
{
	box->g_x = gl_xfull;
	box->g_y = gl_yfull;
	box->g_w = gl_wfull;
	box->g_h = gl_hfull;
	box->g_x = align_x(box->g_x) ;

/* Don't, because we gl_xfull are already the window's outer dimensions */

/*	wind_calc(WC_BORDER, WIND_STYLE, box->g_x,  box->g_y,  box->g_w,  box->g_h,
                                        &box->g_x, &box->g_y, &box->g_w, &box->g_h);
*/
}


/*------------------------------*/
/*	disp_message		*/
/*------------------------------*/
VOID disp_glktree(GRECT *clip_area)	/* display message applying input clip	*/
{
	WORD	pxy[4];

	if (!gl_wincount)
	{
		set_clip(TRUE, clip_area);
		vsf_interior(vdi_handle, 2);
		vsf_style(vdi_handle, 4);
		vsf_color(vdi_handle, BLACK);
		rc_grect_to_array(&work_area, pxy);
		graf_mouse(M_OFF, 0x0L);
		vr_recfl(vdi_handle, pxy);	/* clear entire message area	*/
		graf_mouse(M_ON, 0x0L);
		set_clip(FALSE, clip_area);
		return;
	}
	dj_objc_draw(glk_tree,  ROOT, MAX_DEPTH, clip_area->g_x, clip_area->g_y,
		                                 clip_area->g_w, clip_area->g_h);
}

WORD contrast(WORD col)
{
	if (col == 0 || col == 3 || col == 5 || col == 6) return BLACK;
	return WHITE;
}


VOID draw_rect(GRECT *area)	/* Draw a rectangle round an area */
{
   	WORD	pxy[10];

   	pxy[0] = area->g_x;
   	pxy[1] = area->g_y;
   	pxy[2] = area->g_x + area->g_w - 1;
   	pxy[3] = area->g_y + area->g_h - 1;
   	pxy[4] = pxy[2];
   	pxy[5] = pxy[3];
   	pxy[3] = pxy[1];
  	pxy[6] = pxy[0];
   	pxy[7] = pxy[5];
   	pxy[8] = pxy[0];
   	pxy[9] = pxy[1];
   	v_pline(vdi_handle, 5, pxy);
}



VOID filled_rect(GRECT *area, WORD fg, WORD bg, WORD style, WORD index)
{
	WORD pxy[8];
	
   	pxy[0] = area->g_x;
   	pxy[1] = area->g_y;
   	pxy[2] = area->g_x + area->g_w - 1;
   	pxy[3] = area->g_y + area->g_h - 1;
   	pxy[4] = pxy[2];
   	pxy[5] = pxy[3];
   	pxy[3] = pxy[1];
   	pxy[6] = pxy[0];
   	pxy[7] = pxy[5];

   	vswr_mode   (vdi_handle, 1);
	vsf_interior(vdi_handle, 1);
	vsf_style(   vdi_handle, 1);
	vsf_color(   vdi_handle, bg);
	v_fillarea(  vdi_handle, 4, pxy);

	vswr_mode   (vdi_handle, 2);
	vsf_interior(vdi_handle, style);
	vsf_style(   vdi_handle, index);
	vsf_color(   vdi_handle, fg);
	v_fillarea(  vdi_handle, 4, pxy);

}



/*------------------------------*/
/*	do_redraw		*/
/*------------------------------*/
VOID do_redraw(WORD wh, GRECT *area)		/* redraw message applying area clip	*/
{
	GRECT	box;

	graf_mouse(M_OFF, 0x0L);

	wind_get(wh, WF_FIRSTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	while ( box.g_w && box.g_h )
	{
		if (rc_intersect(area, &box))
		{
			if (wh == glk_whndl)
			{
				disp_glktree(&box);
			}
		}
		wind_get(wh, WF_NEXTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	}
	graf_mouse(M_ON, 0x0L);
}



/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Message Handling			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/

WORD hndl_menu(WORD title, WORD item)
{
	switch(title)
	{
		case FILEMENU:
			if (item == FILEQUIT) return 1;
			break;

		case PREFMENU:
			switch(item)
			{
				case PREFTEXT: on_prefs(wintype_TextBuffer); break;
				case PREFGRID: on_prefs(wintype_TextGrid); break;
			}
			break;

		case DESKMENU:
			if (item == MENUABOU) on_about();
			break;
		
	}
	return 0;
}



WORD main_open(void)
{
	GRECT box;

	if (!glk_whndl) 
	{
		graf_mouse(HOUR_GLASS, 0x0L);
		glk_whndl = wind_create(WIND_STYLE, align_x(gl_xfull)-1, gl_yfull, gl_wfull, gl_hfull);
		if (glk_whndl == -1)
		{ 
			graf_mouse(ARROW, 0x0L);
			rsrc_alert(1, NOWINDOW);
			glk_whndl = 0;
			return FALSE;
		}

		dj_wind_setl(glk_whndl, WF_NAME, str_title, 0L);
		wdw_size(&box);
		do_open(glk_whndl, gl_wfull/2, gl_hfull/2, box.g_x, box.g_y, box.g_w, box.g_h);
		wind_get(glk_whndl, WF_WXYWH,	&work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
		disp_glktree(&work_area);
		graf_mouse(ARROW,0x0L);
	}
	else   
	{
		graf_mouse(ARROW, 0x0L);
		wind_set(glk_whndl, WF_TOP, 0, 0, 0, 0); 
	}
	return TRUE;
}



/*------------------------------*/
/*	hndl_mesag		*/
/*------------------------------*/
BOOLEAN	hndl_mesag()
{
	BOOLEAN	done; 
	WORD	wdw_hndl;

	done = FALSE;
	wdw_hndl = gl_rmsg[3];			/* wdw handle of mesag	*/
	switch( gl_rmsg[0] )			/* switch on type of msg*/
	{
	case MN_SELECTED:
		done = hndl_menu(gl_rmsg[3], gl_rmsg[4]);
		break;

	case WM_REDRAW:				/* do redraw wdw contnts*/
		do_redraw(wdw_hndl, (GRECT *) &gl_rmsg[4]);
		break;

	case WM_TOPPED:				/* do window topped	*/
		wind_set(wdw_hndl, WF_TOP, 0, 0, 0, 0);
		break;

	case WM_CLOSED:				/* do window closed	*/
		do_close(glk_whndl, gl_wfull/2, gl_hfull/2);
		wind_delete(glk_whndl);
		glk_whndl = 0;
		done = TRUE;
		break;

	case WM_MOVED:				/* do window move	*/
		wind_set(wdw_hndl, WF_CXYWH, align_x(gl_rmsg[4])-1, gl_rmsg[5], gl_rmsg[6], gl_rmsg[7]);
		wind_get(glk_whndl, WF_WXYWH,	&work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
		break;

	default:
		break;
	} /* switch */

	return(done);
} /* hndl_mesag */



WORD hndl_mouse(VOID)		/* change mouse form depending on 	*/
{ 				/* whether it's in or out of window 	*/
	if (gl_out) graf_mouse(ARROW, 0x0L);
	else	    graf_mouse(TEXT_CRSR, 0x0L);

	gl_out = !gl_out; 	/* change MU_M1 entry/exit flag 	*/
	return FALSE;
}

WORD hndl_button(event_t *event)
{

	return FALSE;
}


WORD hndl_keybd(event_t *event, WORD kreturn)
{
	/* Ctrl+Q - shortcut for Quit */
	if ((kreturn & 0xFF) == ('Q' - '@')) return TRUE;

	/* TAB - change focus */
	if (kreturn == TAB)
	{
		/* Find the next window that might like focus */
		winid_t c0, c1, c2;

		c1 = NULL;
		c2 = (winid_t)(-1);
		c0 = glk_window_iterate(NULL, NULL);

		/* c1 is the first window ready for input */
		/* c2 is the first window after the focus window 
                 * that is ready for input */

		while (c0)
		{
			if ((winclass_t)c0 == focus_window) c2 = NULL;
			else if (((winclass_t)c0)->is_input_wanted())
			{
				if (!c1) c1 = c0;
				if (!c2) c2 = c0;
			}
			c0 = glk_window_iterate(c0, NULL);
		}		
		if (focus_window) focus_window->set_dirty();

		if (c2 && c2 != (winid_t)(-1)) focus_window = (winclass_t)c2;
		else if (c1)                   focus_window = (winclass_t)c1;

		/* Show the change of focus */
		if (focus_window) focus_window->set_dirty();
		update_windows();
		return FALSE;
	}

	/* Find a window that wants input */
	if (focus_window != NULL && focus_window->is_input_wanted())
	{
		return ((winclass_t)focus_window)->on_key(event, kreturn);

	}
	winid_t win = glk_window_iterate(NULL, NULL);

	while (win)
	{
		if (((winclass_t)win)->is_input_wanted()) break;
		
		win = glk_window_iterate(win, NULL);
	}
	if (!win) return 0;	/* No window wants input */

	focus_window = (winclass_t)win;
	return ((winclass_t)win)->on_key(event, kreturn);
}





/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Hello Event Handler			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	gem_select		*/
/*------------------------------*/
VOID gem_select(event_t *event, BOOLEAN poll)
{
	BOOLEAN	done;
	WORD mousex, mousey, bstate,kreturn, bclicks, kstate;
	WORD mask, timer_h, timer_l;

	/**/					/* loop handling user	*/
	/**/					/*   input until done	*/
	done = FALSE;				/*   -or- if DESKACC	*/
	while( !done )				/*   then forever	*/
	{
		if (arrange_waiting)
		{
			arrange_waiting = 0;
			((winclass_t)glk_window_get_root())->arrange();
			event->type = evtype_Arrange;
			event->win = NULL;
			event->val1 = 0;
			event->val2 = 0;
			return;
		}

		if (poll) 
		{
			mask = MU_MESAG | MU_TIMER;
			timer_l = 1;
			timer_h = 0;
		}
		else
		{
			mask = MU_BUTTON | MU_MESAG | MU_M1 | MU_KEYBD;
			if (timer_tick)
			{
				mask |= MU_TIMER;
				timer_l = (timer_tick & 0xFFFF);
				timer_h = (timer_tick >> 16);
			}
		}
		ev_which = evnt_multi(mask,
		0x01, 0x01, 0x01, /* 1 click, 1 button, button down */
		gl_out,  /* entry , work_area x,y,w,h */ 
		(UWORD) work_area.g_x, (UWORD) work_area.g_y,
		(UWORD) work_area.g_w, (UWORD) work_area.g_h, 
		/* mouse rect 2 flags , x,y,w,h */
		0, 0, 0, 0, 0, 
		/* Message buffer, timer low count , high count 	*/
		gl_rmsg, timer_l, timer_h,
		/* mouse posit ,  btn state, r & lshift, Ctrl, Alt 	*/
		(UWORD *)&mousex, (UWORD *)&mousey, (UWORD *)&bstate, 
		(UWORD *)&kstate, 
		/* keybd key,# btn clicks */
		(UWORD *)&kreturn, (UWORD *)&bclicks);

		if (ev_which & MU_MESAG)   
		{
			wind_update(BEG_UPDATE);
			done = hndl_mesag();
			wind_update(END_UPDATE);
		}

		if (ev_which & MU_BUTTON) done = hndl_button(event);

		if (ev_which & MU_M1) done = hndl_mouse();

		if (ev_which & MU_KEYBD) done = hndl_keybd(event, kreturn);

		if (ev_which & MU_TIMER)
		{
			if (poll) event->type = evtype_None;
			else      event->type = evtype_Timer;
			event->win = NULL;
			event->val1 = 0;
			event->val2 = 0;
			return;
		}
	}
	if (done == 1)
	{
		if (int_handler) (*int_handler)();
		glklib_term();
		exit(1);
	}
}	


/* Called after a glk_exit() - waits for a keypress & terminates */

VOID gem_final_select(void)
{
	BOOLEAN	done;
	WORD mousex, mousey, bstate,kreturn, bclicks, kstate;
 	LPBYTE str_title;

	update_windows();	/* Make it redraw the "goodbye" message */

	/* Print "press key to finish" */
	rsrc_gaddr(5, FINISH, &str_title);
	dj_wind_setl(glk_whndl, WF_NAME, str_title, 0L);

	/**/					/* loop handling user	*/
	/**/					/*   input until done	*/
	done = FALSE;				/*   -or- if DESKACC	*/
	while( !done )				/*   then forever	*/
	{
		ev_which = evnt_multi(MU_KEYBD | MU_MESAG | MU_M1,
		0x01, 0x01, 0x01, /* 1 click, 1 button, button down */
		gl_out,  /* entry , work_area x,y,w,h */ 
		(UWORD) work_area.g_x, (UWORD) work_area.g_y,
		(UWORD) work_area.g_w, (UWORD) work_area.g_h, 
		/* mouse rect 2 flags , x,y,w,h */
		0, 0, 0, 0, 0, 
		/* Message buffer, timer low count , high count 	*/
		gl_rmsg, 0, 0,
		/* mouse posit ,  btn state, r & lshift, Ctrl, Alt 	*/
		(UWORD *)&mousex, (UWORD *)&mousey, (UWORD *)&bstate, 
		(UWORD *)&kstate, 
		/* keybd key,# btn clicks */
		(UWORD *)&kreturn, (UWORD *)&bclicks);

		if (ev_which & MU_MESAG)   
		{
			wind_update(BEG_UPDATE);
			done = hndl_mesag();
			wind_update(END_UPDATE);
		}

		if (ev_which & MU_M1) done = hndl_mouse();

		if (ev_which & MU_KEYBD) done = TRUE;
	}
	return;
}	



/* Redraw text windows.
 * 
 * Send a load of redraw messages, one for each window. GEM will
 * (or it had better) combine these into a single redraw message.
 */

VOID update_windows(void)
{
	GRECT area;

	winid_t win = glk_window_iterate(NULL, NULL);
	while (win != NULL)
	{
		if (((winclass_t)win)->is_dirty())
		{
			((winclass_t)win)->get_area(&area);
			send_redraw(glk_whndl, &area);
			((winclass_t)win)->set_dirty(0);
		}
		win = glk_window_iterate(win, NULL);
	}
}


/***********************************************************************/
/* Work out what fonts we have, what sizes they are, and what 
 * their names are. Based on the font enumerator in GEM Paint.
 */

void enum_fonts(void)
{
	WORD f3, f5, f7, f9;
	WORD ptmin, ptmax, ptfnd;
	WORD xtrcount, cfont, n, m, nfont;

	xtrcount = -1;

	/* Load additional fonts... */
	while (xtrcount < 0)
	{
		xtrcount = vst_load_fonts(vdi_handle, 0);
	}
	if (xtrcount < 0) xtrcount = 0;	

	gl_fontcount = work_out[10] + xtrcount;
	if (gl_fontcount > MAXFONTS) gl_fontcount = MAXFONTS;

	cfont = 1;

	for (nfont = 0; nfont < gl_fontcount; )
	{
		gl_ptcount[nfont] = 0;
		for (n = 0; n <= 12; n++) 
		{
			gl_fontpts[nfont][n] = 0xFFF;
		}
		gl_fontname[nfont][0] = ' ';
		gl_fontname[nfont][1] = ' ';
		gl_fontid[nfont] = vqt_name(vdi_handle, cfont++, 
                                            &gl_fontname[nfont][2]);		
		if (gl_fontname[nfont][2] == 0)
		{
			strcat(gl_fontname[nfont], "!! System !!");
			gl_fontcount = 1;
		}
		strcat(gl_fontname[nfont], "  ");		

		vst_font(vdi_handle, gl_fontid[nfont]);
		ptmin = 1000;
		ptmax = 1001;
		ptfnd = 0;
		while (ptmin < ptmax)
		{
			ptmax = ptmin - 1;
			ptmin = vst_point(vdi_handle, ptmax, &f3, &f5, &f7, &f9);

			for (n = 0; ptmin > gl_fontpts[nfont][n]; ++n);

			if (ptmin == gl_fontpts[nfont][n]) 
			{
				ptfnd = 1;
				continue;
			}

			if (gl_ptcount[nfont] >= MAXPOINTS) continue;

			/* Throw out the biggest size to make room for a smaller one */

			m = gl_ptcount[nfont];
			++gl_ptcount[nfont];
			while (m > n)
			{
				gl_fontpts[nfont][m] = gl_fontpts[nfont][m - 1];
				--m;
			}
			gl_fontpts[nfont][n] = ptmin;
			ptfnd = 1;
		}
		if (ptfnd) ++nfont;
		else --gl_fontcount;	/* No usable point sizes */
	}
	vst_font(vdi_handle, gl_fontid[0]);
}



/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Termination				     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	glklib_term		*/
/*------------------------------*/  
VOID glklib_term(VOID) 
{
	if (menu_set) 
	{
		dj_menu_bar(NULL, FALSE);
		free(gl_menutree);
		menu_set = 0;
	}
	if (gl_fontcount > 0) vst_unload_fonts(vdi_handle, 0);

	v_clsvwk( vdi_handle );		/* close virtual work station	*/
	appl_exit();			/* application exit		*/ 

/* Write settings */

	if (!cfgname[0]) return;
	FILE *cfgfile = fopen(cfgname, "wb");
	if (!cfgfile) return;
	fwrite(dflt_style, 1, sizeof(dflt_style), cfgfile);	
	fclose(cfgfile);

	return;

}

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Initialization			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/

/*------------------------------*/
/*	glklib_init		*/
/*------------------------------*/
WORD glklib_init(char *progname)
{
	WORD	i;
	WORD	work_in[11];
	WORD	attributes[10];
	int n;

	gl_apid = appl_init(NULL);		/* initialize libraries	*/

	if (!rsrc_load(rsc_str))
	{
		dj_form_alert(1, "[3][Cannot load %s][ Quit ]", rsc_str);
		return FALSE;
	}
	dj_rsrc_treeaddr(MENUTREE, &gl_menutree);
	if (gl_menutree)
	{
		menu_set = 1;
		dj_menu_bar(gl_menutree, TRUE);
	}


/* Move the title into DOS space */

	str_title = dj_string_addr(win_title);

	for (i=0; i<10; i++) work_in[i] = 1;
	work_in[10] = 2;

	gem_handle = graf_handle(&gl_wchar,&gl_hchar,&gl_wbox,&gl_hbox);
	vdi_handle = gem_handle;
	v_opnvwk(work_in,&vdi_handle,work_out);	/* open virtual work stn*/

	if (!vqt_attributes(vdi_handle, attributes))	/* get text attributes	*/
	{
		rsrc_alert(1, NOVQT);
		return FALSE;
	}
	else type_size = attributes[7];

	
	if (vdi_handle == 0)
		return(FALSE);

						/* init. message address*/
	wind_get(DESK, WF_WXYWH, &gl_xfull, &gl_yfull, &gl_wfull, &gl_hfull);

	dj_userdef_prealloc(MAXWINDOW);
	

	/* We now fill out the glk_userblk structures. Create a dummy tree
           in 16-bit space, generate the correct USERDEF blocks for it,
           then dump the tree and keep the blocks. 
         */
	LPTREE tr = dos_alloc((MAXWINDOW+MAXCOLOUR) * sizeof(OBJECT));
	
	for (n = 0; n < MAXWINDOW; n++)
	{
		glk_userblk[n].ub_code = draw_win;
		glk_userblk[n].ub_parm = 0;
		dj_userdef(tr, n, &glk_userblk[n]);
	}

	for (n = 0; n < MAXCOLOUR; n++)
	{
		clr_userblk[n].ub_code = draw_win;
		clr_userblk[n].ub_parm = 0;
		dj_userdef(tr, n + MAXWINDOW, &clr_userblk[n]);
	}

	dos_free(tr);

/* Convert the 2 images in the about box to display format */

	LPTREE tree;
	rsrc_gaddr(R_TREE, ABOUTBOX, &tree);
	trans_gimage(vdi_handle, tree, GLKICONC);
	trans_gimage(vdi_handle, tree, GLKICONM);


	enum_fonts();

	/* Read settings */

	FILE *cfgfile;

	strcpy(cfgname, progname);
	strcpy(glk_cfgname, progname);
	char *s = strrchr(cfgname, '.');
	if (!s) 
	{
		glk_cfgname[0] = 0;
		cfgname[0] = 0; 
		return TRUE; 
	}

	*s = 0;
	strcat(cfgname, ".CFG");
	s         = strrchr(glk_cfgname, '/');
	if (!s) s = strrchr(glk_cfgname, '\\');
	if (!s) glk_cfgname[0] = 0;
	else 
	{
		*s = 0;
		strcat(glk_cfgname, "/GLK.CFG");
	}
	cfgfile = fopen(cfgname, "rb");
	if (!cfgfile && glk_cfgname[0])	/* Try for program.CFG and GLK.CFG */
	{
		cfgfile = fopen(glk_cfgname, "rb");
	}	
	if (!cfgfile) return TRUE;
	fread(dflt_style, 1, sizeof(dflt_style), cfgfile);	
	fclose(cfgfile);

	return(TRUE);
}

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Main Program			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/





/*------------------------------*/
/*	GEMAIN			*/
/*------------------------------*/
extern "C"
WORD GEMAIN(WORD argc, BYTE *argv[])
{
	glkgem_startup_t startdata;

	/* This being a GEM program, we don't parse out options or 
         * anything. All we can expect to be passed is a filename. 
         * Perhaps we should use the shel_*() calls rather than 
         * argv & argc to get the command line. */

	startdata.argc     = argc;
	startdata.argv     = argv;
	startdata.rscfile  = &rsc_str;
	startdata.wintitle = &win_title;

	signal(SIGINT, SIG_IGN);	/* Ignore ctrl-C */
	
	inittime = TRUE;
    	if (!glkgem_startup_code(&startdata)) return 0;
	inittime = FALSE;

	if (glklib_init(argv[0]))	/* initialization	*/
	{
		/* Open a window */
		if (main_open())
		{
			glk_main();	
			gem_final_select();
		}
		glklib_term();			/* termination		*/
	}
	return 0;
}

