	page	,132

;*** TRAP.ASM for Microsoft Windows 3.00  keyboard drivers ******************
;
;	Copyright (C) 1984-1990 Microsoft Corporation.  All Rights Reserved.
;
;	Copyright 1985-1987 by Ing. C. Olivetti & Co, SPA.
;
;	This contains the hardware interrupt handler (keybd_int)
;	for the Windows keyboard driver.
;
;	NOTE: BIGSTK may or may not be defined here; see below.
;
;***********************************************************
;	Conditional-assembly flags:
;
;	Only ONE of the following should be set in the command line!
;
;	ENHANCE	handles 'RT' 101/102-key enhanced keyboard.
;
;	ICO	handles Olivetti M24 keyboard lights and Olivetti M24
;			'ICO' 102-key keyboard features, also 101/102
;			Enhanced keyboard, and AT&T 301 & 302 keyboards.
;
;	ENVOY	Handles Hewlett-Packard keyboards, including Envoy and
;		enhanced.
;
;	NOKIA	NOKIA/Ericsson 1050, 9140, etc., keyboards.
;	
;***********************************************************
; History Windows 3.00
; 
; 16 apr 90	peterbe		4 lines before CheckDel:, changed jump target
;				from kbToBios to kbi1 to REALLY fix HP bug
;				related to CtrlAlt+char.
;
; 13 apr 90	peterbe		In SetShiftState(), unscrambled and fixed
;				code for HP/Nokia in ifdef's, to fix KBDHP
;				driver's handling of Ctrl+Alt+char.
;
; 02 feb 90	davidw		Cleaning up ctrl-brk, and redoing
;				Ctrl-Alt-SysReq
;
; 14 jan 90	davidw		Re-enabling ctrl-brk
;
; 21 nov 89	peterbe		Changed PIN's and POUT's back to in's and out's
;
; 09 nov 89	peterbe		(for HP): call KbdRst just before CheckDel
;
; 03 oct 89	peterbe		Remove INT 3 put in by hp
;
; 31 oct 89	peterbe		(1.48!) only test for control at ccNum1
;				This fixed bug # 5775
;
; 15 oct 89	peterbe		Integrated HP changes.  DosXMacro defined
;				as null in 'ifndef'.
;
; 13 oct 89	peterbe		Change handling of NumLock+SHIFT+numpad
;				cursor key to optimize repeated key, stop
;				wierd beeping.  (second update: fix handling
;				of cursor key release).
;
; 18 sep 89	peterbe		SysReq code now tests fSysReq instead of
;				looking at seg of NMI vector to enable
;				trap to debugger.
;
; 07 sep 89	peterbe		Removed CtlBrkCase(), INT1BHandler().
;				Ctl-break -> VK_CANCEL, ASCII 3 (ctl-C).
;
; 31 aug 89	peterbe		Fixed (type 4) Pause problem: toggled
;				numlock: added pause_proc(), and test
;				for shifts at ccNum1:
;
; 24 aug 89	peterbe		SetShiftState handles WORD at 40:17, so
;				Ctrl & Alt work on some machines.
;
; 23 aug 89	peterbe		Use fExtend (former IcoExtend) to flag
;				VK_NUMLOCK msgs. which actually come from kbd.
;				Then ToAscii() can handle these messages
;				slightly differently (for NCR problem).
;
; 22 aug 89	peterbe		Added NumLockFlag handling: to solve NCR
;				keyboard problem.  See SetShiftState().
;
; 03 aug 89	peterbe		Add STI before IRET.
;
; 16 jul 89	peterbe		In FakeCapsLock(), load CapsLock scan code.
;				(For German, etc. keyboards.)
;				Changed jne kbToBios to jne kbi1 before
;				kbToBios so CTRL-ALT keys will work.
;
; 15 jul 89	peterbe		Ifdef out some function key code no longer
;				needed since Winoldap doesn't have to trans.
;				function keys any more.
;
; 14 jul 89	peterbe		Ignore E1 prefix from Enhanced Pause key.
;				No longer pass control-numlock to BIOS for
;				Pause!!  (will still go to BIOS if fHold is
;				set, so this can be cleared).
;
; 11 may 89	peterbe		'Extended' keys on ICO (2) keyboard pass
;				flag in BH to event_proc now, like type 4.
; 20 apr 89	peterbe		Removed old comments above kbic: about
;				Business Network and W.1.00 keyboard test.
; 07 apr 89	peterbe		No longer check screen mode for graphics.
;				Makes life easier for display driver coders.
; 14 mar 89	peterbe		Revised printscreen code again.  ALT-print is
;				now current window snap.  unshifted-print is
;				full screen snap for Enhanced and ICO kbd's.
;				SHIFT-PRINT is full screen for XT, AT.
; 12 mar 89	peterbe		Rewrote printscreen/snapshot code for detecting
;				key combinations.  ALT-PrintScn is now
;				full-screen snapshot, while shift-PrintScn is
;				current-window snap.  Errors corrected.
;
; 14 dec 88	peterbe		Remove prtsc_event.  Printscreen now sends
;				special VK_SNAPSHOT.
;
; 01 dec 88	davidw		Made it bi-modal.
;
; 29 nov 88	peterbe		Added prtsc_event, and kbCheckCapture code.
;				Printscreen causes prtsc_event() to be called.
;
; 02 nov 88	peterbe		SysReq key ignored if fOS2Box is set, due
;				to conflict in keyboard usage.
;
; 23 sep 88	peterbe		Removed VK_PREFIX stuff, set bit 0 of BH
;				when calling event_proc to indicate extended
;				key on enhanced keyboard.
;				(made sure BH = 0 otherwise!)
;
; 22 sep 88	peterbe		Changed scan code for VK_PREFIX to 60h.
;				Define VK_PREFIX value here until it's
;				finalized.
;
; 21 sep 88	peterbe		Adding VK_PREFIX output when extended key is
;				typed. (if VK_PREFIX is defined).
;
; 08 sep 88	peterbe		Fixing extra WM_KEYUP in VK_ICO_00 code.
;
; 26 aug 88	peterbe		Put in some comments regarding AT keyboard
;				enable.
;
; 23 aug 88	peterbe		Removed an ifdef at notkbi1:
;
; 22 aug 88	peterbe		Fixing NMI trap (SysReq) code. Enable() must
;				now set up nmi_vector, which MUST be in the
;				CODE segment.
;				Moved LightsAddr,enabled,bios1b_proc to Enable.
;				bios_proc MUST be in CODE segment also
;
; 19 aug 88	peterbe		MAJOR CHANGES: Renamed to TRAP.ASM (was datacom)
;				Moved code to CODE segment, radical change
;				in usage of segment registers.
;				ES -> RAMBIOS
;				Moved 'include date.inc' to INIT segment.
;				Removed inquireData.
;
; 18 aug 88	peterbe		Changed some exclusion ifdefs, removed old
;				debug stuff, fixed comments and added some FF's
;				Added alternate jz for ENVOY at notkbi1Env:
;				At kbi12:, set DS to 40H.
;				At sysreqdown:, set DS to 0.
;
; 17 aug 88	peterbe		Checking NOKIA ifdefs.
;
; 16 aug 88	peterbe		Set ENHANCE if ICO is set. Olivetti driver
;				always handles compatible 101-102 keyboard now.
;				Fixed printscreen code accordingly.
;
; 15 aug 88	peterbe		Changed SysReq code to handle ICO keyboard.
;
; 14 aug 88	peterbe		Moved keyTrTab to TABS.ASM file.
;
; 12 aug 88	peterbe		Changing to keep DS=40h, rename RAM BIOS
;				variables, use RAMBIOS def.
;				Moved fCaps etc. defs to keyboard.inc
;
; 11 aug 88	peterbe		Add page directive at beginning.
;				Updated code in ENHANCE ifdefs to check
;				KeyType, where necessary.
;				Code in ICO ifdefs checks whether this is
;				a 102-key ICO keyboard.
;
; 08 aug 88	peterbe		Init. KeyType to 0 now.  PCType, KeyType,
;				etc. moved to TABS.ASM.
;
; 02 aug 88	peterbe		SYSREQ code turns off Control and Alt
;				before doing NMI.
;
; 27 jul 88	peterbe		Renamed keyTranslationTable to keyTrTab
;
; 26 jul 88	peterbe		Moved version string to TABS.ASM.
;
; 15 jul 88	peterbe		Add lots of ifdefs for different keyboard
;				types.  Now 1 driver per keyboard type!
;				keyTrTab moved into this file.
;				All the OEM-specific extensions to this
;				table are here.
;
; ==== Windows 2.10 ====================================
; 27 jun 88	peterbe	Now use fCaps flag in BIOS 40:17h instead of fShiftLock
; 23 jun 88	peterbe	Changed CMP fVectra... to TEST fVectra (after kbi4:)
; 21 jun 88	peterbe	Some ShiftLock code factored out as 'FakeCapsLock'
; 20 jun 88	peterbe	Experimental implementation of ShiftLock.
; 15 jun 88	peterbe	moved includes to before any ifdefs
; 14 jun 88	peterbe	Added hp enhancements -- BIGSTK, ENVOY ifdefs
;
; ========================================================================

; ========================================================================
; Check for mutually incompatible ifdefs

ifdef ENHANCE
    TYPEERRORFLAG equ 1
endif; ENHANCE

ifdef ICO
    TYPEERRORFLAG equ 1
    ; also handle enhanced keyboard
    ENHANCE = 1
endif ; ICO

ifdef NOKIA
    TYPEERRORFLAG equ 2
endif ; NOKIA

ifdef ENVOY
    TYPEERRORFLAG equ 1
    ifdef ICO
	TYPEERRORFLAG equ 3
    endif
    ; also handle enhanced keyboard
    ENHANCE = 1
endif ; ENVOY

; ========================================================================
; display which option(s) we've chosen.

if1

%out
%out	.... TRAP.ASM -- Windows keyboard INT 09H ....
%out	.... Keyboards handled besides XT ....

    ifdef NOKIA
	%out .  NOKIA 1050 and 9140 version
    endif

    ifdef ICO
	%out .  Olivetti M24 83 & 102-key (ICO) version
	%out .  AT&T 301, 302 keyboards on 6300, 6300+.
    endif

    ifdef ENVOY
	%out .  Hewlett-Packard Vectra & Envoy version
    endif

    ifdef ENHANCE
	%out .  Handles Enhanced, XT, AT keyboards
    endif


endif	; if1

; ========================================================================

ifndef DosXMacro
    DosXMacro macro x, y

    endm
endif

; Allocate big stack when calling
; BIGSTK equ 0


SYSREQ	=	054h	; PC-AT SYS REQ key .. not on M24 or ICO keyboard
			; (on Enhanced keyboard, is PrintScn/SysReq)

if1
    ifdef SYSREQ
	%out .. Has SysReq handling
    else
	%out .. Does NOT have SysReq handling
    endif
endif


; scan codes for special keys

cEsc		EQU	 1	;
cReturn		EQU	28

cCtrl		EQU	29
cLShift		EQU	42
cSlash		EQU	53	; 35h
cRShift		EQU	54	; 36h
cPrint		EQU	55	; 37h IBM keyboard printscreen
cAlt		EQU	56	; 38h
cCapsLock	EQU	58	; 3ah
cF1		equ	59	; 3bh F1 key on anything
cF7		equ	65	; 41h F7 key on anything
cNumLock	EQU	69	; 45h
cBreak		EQU	70	; 46h
cUp		equ	72	; 48h up key
cLeft		equ	75	; 4bh left key
cRight		equ	77	; 4dh right key
cDown		equ	80	; 50h down key
cDelete		EQU	83

cExtended	EQU	96	; E0h-80h - for RT extended codes - 13feb87
cExtended1	equ	97	; E1h-80h - prefix for Pause key

ifdef	NOKIA

cCommand	EQU	0FAH	; NOKIA

else	; NOKIA

cCommand	EQU	0F0H	; not NOKIA

endif	; NOKIA

ifdef ICO
				; Olivetti only:
cIcoPrint	equ	85	; 55h ICO keyboard printscreen
cIcoDivide	equ	95	; Ico divide key
				; ICO extended funct.keys F11..F18 are 96..103
endif ; ICO

; **************** data segment begins here ***********************

; ********** System Type information ******************

;;; externB fKeyType		; flags mainly for RT keyboard.

; These things are updated at INIT or ENABLE time from the keyboard
; tables or from WIN.INI.

;;; externB	PCType		; identifies system type
;;; externB	PCTypeHigh
;;; externB	KeyType		; keyboard type (usually == TableType)
;;; externB	IsEri
;;; externB	IsOli
;;; externB	OliType

; Flag for change in BIOS NumLock flag.

;;;    externB	NumLockFlag

; Table for translating scan codes to virtual keycodes.
; (in TABS.ASM)

;;; externW	KeyTransBase	;  dataOffset keyTrTab
;;; externW KeyTransTblSize	;  KeyTransTblEnd - keyTrTab 

; This is the translation for the numeric pad when NUMLOCK is set.
; This is the same for all keyboards, and is fixed in length.


; External from INIT.ASM
; Value of acknowledge byte
;;;	extrn	AckByte:byte

; Kernel routine for extended memory reset
;
;;;EXTRN	KbdRst:FAR

; Kernel routine for ctrl-brk handling
;
;;; EXTRN	DoSignal:FAR

; Kernel routine for CVW handling
;
;;;EXTRN	CVWBreak:FAR

; Flag for enabling SysReq key


; *********************** Local data *********************************
;
;
; Address of keyboard event-proc
;
; the keyboard event_proc is called with the following parameters:
;
;	ah == 80h for uptrans, 00h for downtrans
;	al == virtual key
;	bh == 0 if no prefix byte, 1 if E0 prefix byte preceded this scancode.
;	bl == scan code

public  event_proc

event_proc  DD	0   ; Address of enabled keyboard event procedure

ifdef BIGSTK
    if1
	%out HAS BIG LOCAL STACK
    endif
;
; Private keyboard stack (HP c-ralphp 6/9/88) see comments in keybd_int
;
staticB	, ?, 384
globalW	Stack, ?
staticW	SaveSS,	0
staticW	SaveSP,	0
staticW	NextSS,	0

; end (HP c-ralphp modifications)
else
    if1
	%out .. DOES NOT HAVE BIG LOCAL STACK
    endif
endif ; BIGSTK

; (MS code has ShiftLockException table here)

ifdef	ENVOY

;-------------------------------------------------------------
;
; Envoy data area
;
include	equate.inc	; HP-System equates

; Envoy keyboard equates
;
cCCP_UP	    EQU	60h
cf8	    EQU	77h
cPlus	    EQU	4Eh
cMinus	    EQU	4Ah
cCCPDel	    EQU	69h
cBackSlash  EQU	2Bh

; Flags for Hewlett-Packard
;
staticB	 fModifier,0	; -1 if modifier. Set by SetShiftState
FV_A		= 001b
FV_ENVOY	= 100b
externB	 fVectra, 0	; 1 if Vectra. Set by Enable


; This table is used to translate the function keys and cursor pad
; keys. This is now neccesary because they are now placed in a raw
; mode.
;
HPTransTable	label	byte
	DB	VK_UP			; CCP up arrow
	DB	VK_LEFT			; CCP left arrow
	DB	VK_DOWN			; CCP down arrow
	DB	VK_RIGHT		; CCP right arrow
	DB	VK_HOME			; CCP home
	DB	VK_PRIOR		; CCP PgUp
	DB	VK_END			; CCP end
	DB	VK_NEXT			; CCP PgDn
	DB	VK_INSERT		; CCP Ins
	DB	VK_DELETE		; CCP Del
	DB	VK_CLEAR		; CCP Cntr
	DB	5 dup (-1)
	DB	VK_F1			; f1
	DB	VK_F2			; f2
	DB	VK_F3			; f3
	DB	VK_F4			; f4
	DB	VK_F5			; f5
	DB	VK_F6			; f6
	DB	VK_F7			; f7
	DB	VK_F8			; f8


; Reset Vector used for soft resets
;
ResetVector	dd	0ffff0000h					;9/3/86


;~~ VVR 092789
; debugging information

SOFT	db	"Softkey pressed",0,13,10
Mod1	db	"Modifier is -1",0, 13, 10

Mod0	db	"Modifier is 0", 0, 13, 10
endif	;ENVOY




; Address of routine called to handle a scan code.
; For non-RT keyboards, this never changes -- it's always 'standard_proc'.
; For RT keyboards, this changes when a prefix code is seen


ifdef ICO	; Olivetti M24 102-key keyboard

; Table to translate ICO scan codes in range cIcoPrint..cIcoDivide
; .. so that WINOLDAP will recognize these..

IcoTransT label byte
	db	cPrint			; 55h PrintScreen
	db	56h			; 56h Help
	db	cReturn			; 57h Return
	db	cLeft			; 58h Left cursor
	db	cDown			; 59h Down cursor
	db	cRight			; 5ah Right cursor
	db	cUp			; 5bh Up cursor
	db	5ch			; 5ch Clear
	db	cBreak			; 5dh Break
	db	5eh			; -- nothing --
	db	cSlash			; 5fh Divide key

endif ; ICO


globalD bios_proc, 0
globalD int_1b, 0
globalD nmi_vector, 0

public LightsAddr			; used in ToAscii
LightsAddr	DD	0		; old int16h address

;;; WIN1 enabled a word rather than a byte
public enabled				; public for debug
enabled		dw	0		; enabled flag

fBreak		DB	0
fReEnter	DB	0	; reentrancy flag


;***********************************************************
;
;--- keyboard hardware service -----------------------
;
;	Usage of segment registers:
;
;	Currently:		In 2.10 and earlier drivers:
;
;	CS = CODE		(was DATA)
;	DS = DATA		(was BIOS data area at 40h)
;	ES = RAMBIOS (40h)	(wasn't used)
;
;***********************************************************

public keybd_int
keybd_int   PROC    FAR


    assumes CS, DATA
	push	ax			; save registers we use
	push	ds
	xor	ax, ax
	mov	ds, ax
	
	in	al,kb_data		; get the scan code
;;; WIN1
;;;	mov	ah,es:[kb_flag]		; get current shift state..

	cmp	al,cCommand		; is it a keyboard command?
;;; WIN1
	jnb	kbToBios
;;;	jb	kbiTestCursor		; (note: cCommand is different
;;;					;  for Ericsson!)
;;;	jmp	kbToBios		; if so, let BIOS do it

;;; WIN1
;;; kbiTestCursor:
;;; 	cmp	LastCursor, 0		; is flag (scancode) set for numpad
;;; 	jz	kbiTestUp		; cursor?
;;; 	cmp	al, LastCursor		; yes, is this the same scancode?
;;; 	jne	kbiTestCursorUp
;;; 	jmp	kbi1			; yes, so it's a MAKE of the same one
;;; kbiTestCursorUp:			; no..
;;; 	push	ax			; it might be BREAK for same code
;;; 	and	al,7fh
;;; 	cmp	LastCursor,al
;;; 	pop	ax
;;; 	je	kbiTestUp		; if ==, it is
;;; 	push	ax			; but it's not, so we
;;; 	push	bx
;;; 	mov	ax, VK_SHIFT		; fake SHIFT DOWN
;;; 	mov	bx,54
;;; 	call	ds:[event_proc]
;;; 	pop	bx
;;; 	pop	ax
;;; 	mov	LastCursor, 0		; clear flag

kbiTestUp:

ifdef	NOKIA

	cmp	al,80H			; handle Nokia prefix byte
	jne	NotPrefix
	or	BYTE PTR es:[ProtocolFlag],$PrefixFlag
	jmp	kbToBios		; Let BIOS also get prefix
NotPrefix:
	jb	notkbi1			; was jbe, but never ==
	jmp	kbi1			; it's an UP transition..			
notkbi1:

else	; not NOKIA

	test	al,80h			; is it an up transition?
;;; WIN1
	jnz	kbi1
;;;	jz	notkbi1			; .. if not, continue
;;;	jmp	kbi1			; it's an UP transition, jump..
notkbi1:				; it's a DOWN transition..

endif	; not NOKIA

	; this will make BIOS clear fHold if it's set:
	test	byte ptr ds:[0400h + kb_flag_1],fHold	; in hold state?
	jnz	kbToBios		; if so, jump to ROM
	cmp	byte ptr ds:[0400h + CrtMode], 4	;In text mode?
	jc	kbToBios
	mov	ah, ds:[0400h + kb_flag]
	cmp	al, cNumLock
	jnz	kbib
	test	ah, fCtrl
	jnz	kbToBios

;;; WIN1
;;;	jnz	jkbToBios		; if so, jump to ROM
;;;	cmp     al,cCapsLock            ; is it CapsLock ?
;;;	jnz     kbib                    ; no...
;;;
kbic:					; it's CapsLock --
;;;     test    ah,fCtrl                ; is it Ctrl-NumLock or -CapsLock?
;;;     jnz     jkbToBios               ; yes, jump to ROM
;;;	jmp     kbi1			; no, go check hotkey
;;;jkbToBios:
;;;	jmp	kbToBios


; It's not capslock 
; [AH] = BIOS shift state, [AL] = scan code, 
; If it's Delete or Break, go check for Ctl-Alt


kbib:	cmp	al,cDelete
	je	kbia
	cmp	al,cBreak
	je	kbia


ifdef	ENVOY
; Look for CTRL-Alt + or - which on Vectra A, and A+ is handled in the
; int9 BIOS.
;
	test	ds:fVectra, FV_A ; If Vectra A,A+, Pass thru Cntl-Alt + and -
	jz	kbihp
	cmp	al,cPlus
	je	kbia
	cmp	al,cMinus
	je	kbia

kbihp:
	cmp	al,cBackSlash		; If Carrera, pass thru Cntl-Alt-\
	je	kbia			; for speed change


; The following code was added to test for the possiblity of a CCP CTRL-ALT-DEL
;
	test	ds:[fVectra], FV_ENVOY
	jz	no_reset
	cmp	al, cCCPDel
	je	kbia
no_reset:
endif ; ENVOY

; OLD Screen Print code here deleted 14 dec 88 .. see screen-capture code
; at KBI1:

; (WIN1) restore this
	cmp	al, cPrint
	jnz	kbi1
	test	ah, fShift
	jnz	kbToBios

; kbia: check for Control ALT something here
; Scan code is one of
;
;	cDelete		(Reset)
;	cBreak		(interrupt)
;	cPrint		(Screen Grab)
;	
;	cCCPDel 	- Vectra
;	cBackSlash	- Vectra
;	cMinus		- Vectra
;	cPlus		- Vectra
;
; 
kbia:
	mov	ah,ds:[0400h + kb_flag]		; Get BIOS shift state (again)
	not	ah
	test	ah,fAlt+fCtrl		; test for CTRL-ALT something...
	jnz	kbi1			; nope, go to hotkey check


; Control and Alt are BOTH down now.  We're going to BIOS
; if its cDelete..

;;;	cmp	al,cDelete
;;;	jne	kbi1

; It's control-alt-Delete ..
; Inform the kernel that Ctl+Alt+Del is happening so that he can inform
; any expanded memory card to reset. (Wed 21-Oct-1987 : bobgu)

;;;	call	KbdRst

kbToBios:

	pop	ds
	pop	ax
	jmp	cs:bios_proc

;;;	push	word ptr [bios_proc][2]
;;;	push	word ptr [bios_proc][0]     ; put address of bios proc on stack
;;;	push	bp
;;;	mov	bp, sp
;;;	mov	ds, [bp+6]		    ; restore ds
;;;	assumes	DS,NOTHING
;;;	pop	bp
;;;	retf	2			    ; "return" popping ds

kbi1:

;
; Reset the keyboard controller and acknowledge the interrupt.
;

	assumes	DS,DATA

kbi13:
	push	bx
	push	ax			; this little bit is for XT-like systems
	in	al,kb_ctl		; reset interface chip (8255)
	mov	ah,al
	or	al,80h
	out	kb_ctl,al
	xchg	ah,al
	out	kb_ctl,al
	pop	ax			; just for delay..

	;; ??? ;;			; for ATs and PS2s, may need 
					;  to enable keyboard here!
	mov	ah,80h			; move the high order bit to the high
	and	ah,al			; order byte.
	xor	al,ah			; turn off bit if set


	push	ax			; this is for XT or AT-like systems
	mov	al,20h ;;;ds:AckByte	; acknowledge interrupt
	out	ack_port,al
	pop	ax

	call	SetShiftState

;;;	push	bx			; stack = [AX,DS,ES,BX]

; Check for print-screen.
;
; For 3.0 Windows:
;	ALT-printscreen is grab of current window.
;	unshifted printscreen is grab of whole screen.
;	(shift-printscreen on XT, AT keyboards, however).
;
; If this is detected, event_proc is called with VK = VK_SNAPSHOT
; and BX = 0 for current window, and 1 for full screen grab.
;
; AL contains scan code (hi bit is 0), AH contains up/down flag.
;
;;;	mov	bl,es:[kb_flag]		; get current shift state..
;;;	test	bl,fCtrl		; CTRL down? if so,
;;;	jnz	kbiNotPrint		; This is no printscreen...!

ifdef ICO
	; In the ICO keyboard, there's a special PrintScreen key with a
	; unique scan code.  If this is it, we do our thing on unshifted
	; print screen or ALT print screen, like an enhanced keyboard
	; We ignore the XT/AT '*' key.
	cmp	ds:[KeyType],2		; Olivetti ICO 102-key?
	jne	kbiNotIcoPrint
	cmp	al,cIcoPrint		; yes, test for special ICO Prn Scn
	jne	kbiNotPrint		; no, it's not a printscreen at all
	test	bl,fShift		; shift must NOT be down
	jz	kbiCheckIsAlt
	jmp	ignorekey
    kbiNotIcoPrint:
endif ; ICO

ifdef ENHANCE ; 101/102 enhanced?
	; this little bit is a check for ALT-PRINT (= ALT-SysReq) on
	; enhanced keyboard.  What a pain!  the PRINT key gives unprefixed
	; SYSRQ scancode if ALT is down, and we want ALT-PRINT for current
	; window grab!
;;; WIN1
;;;	cmp	ds:[KeyType],4		; Enhanced?
;;;	jne	kbiNoAltPrint
;;;	cmp	al,SYSREQ		; SYSREQ scan code?
;;;	jne	kbiNoAltPrint		; .. nope.
;;;	test	bl,fAlt			; ALT down? (must be, but be patient)
;;;	jz	kbiNoAltPrint
;;;	mov	al,VK_SNAPSHOT		; this is really a screen grab
;;;	mov	bx,0			;  0: current window
;;;	jmp	short kbiPrintSend	; 
;;;    kbiNoAltPrint:
endif
;;;	cmp	al, cPrint		; PrtScn scancode (multiply key)?
;;;	jne	kbiNotPrint		; (XT, AT, or Enhanced)

ifdef ENHANCE ; 'RT' 101/102 keyboard supported?
;;;	cmp	ds:[KeyType],4		; Enhanced keyboard?
;;;	jne	kbiIsPrintKey		; if not, skip the following;
					; if so, don't need shift..
					; and check/restore kbd_proc..
;;;	cmp	ds:[kbd_proc], codeOFFSET prev_was_ext_proc
;;;	jne	kbiNotPrint		; MUST have E0 prefix for CTRL PRINT
;;;	mov	ds:[kbd_proc], codeOFFSET standard_proc
	
	; it is an enhanced-keyboard printscreen key, so..
;;;	test	bl,fShift		; is SHIFT down?
;;;	jnz	kbiGoIgnore		; if so, don't do it.
;;;	mov	al,VK_SNAPSHOT
;;;	mov	bx,1			; full-screen grab: bx == 1
;;;	jmp	short kbiPrintSend

;;;    kbiIsPrintKey:

endif ; ENHANCE
	; We have Printscreen scancode on non-enhanced keyboard.
	; We look for SHIFT or ALT, and snap all or part of the screen.
	; (unshifted PrintScreen is '*' character in this case)
kbiCheckPrint:
;;;	test	bl,fShift+fAlt		; is SHIFT or ALT down?
;;;	jz	kbiNotPrint
kbiCheckIsAlt:
;;;	mov	al,VK_SNAPSHOT		; send special snapshot VK code.
;;;	test	bl,fAlt			; is ALT down?
;;;	mov	bx,1			; set BX, but don't change Z flag!!
;;;	jz	kbiPrintSend		; ALT-PRINT has SysRq scancode, so skip
;;;	dec	bx			; if ALT, clear BX

kbiPrintSend:
;;;	call	ds:[event_proc]		; send VK_SNAPSHOT !!
kbiGoIgnore:
;;;	jmp	ignorekey		; .. no more processing

kbiNotPrint:

ifdef	SYSREQ
;
;  The (PC-AT) SYS REQ key is used to simulate an NMI.
;
;  This is done by clearing up the stack and doing a far jump to the NMI
;  interrupt vector location.  If the NMI interrupt points into the ROM,
;  we don't jump, since the ROM treats NMIs as parity errors.
;
;  When SymDeb returns from the NMI, it returns to wherever CS:IP was
;  when the keyboard interrupt happened!
;
; Depending on the system and keyboard, SysReq requires that ALT or
; both Control and ALT be down, when the scan code 54h is input.
;
; On the Olivetti M24, this is the scan code for the 00 key.
; 
; On Enhanced (RT) and ICO (102-key Olivetti M24) keyboards, interpret
; Control-Alt-PrintScreen or Control-Alt-00 as Sys Req.
; We do a little arithmetic on the ifdef's here...
;
; Additional test, required if this is an Enhanced or ICO (2) keyboard:
; Must use CTRL ALT SCR-PRT on these keyboards, since Windows uses
; ALT SCR-PRT for screen grab.


	cmp	al,SYSREQ	    	; SYSREQ key?
	jne	notsys

ifdef ENHANCE
ifndef ICO

	; This handles Enhanced but NOT ICO keyboards:
	; For Enhanced keyboards, this is the printscreen key, so
	; we change the scan code if Ctrl is not down.

	cmp	ds:[KeyType], 4		; skip the following test,
	jne	sysNotEnh		;  if it's XT or AT keyboard.
					; it IS an Enhanced keyboard
	test	byte ptr es:[kb_flag], fCtrl	; is Ctrl down?
	mov	al, cPrint		; change scan code
	jz	notsys
sysNotEnh:

endif ; ifndef ICO
endif ;  CtrlAltSysRq -- ENHANCE or ICO

ifdef ICO
	; this handles either Enhanced or ICO keyboards.
	; For Enhanced keyboards, this is the printscreen key, so
	; we change the scan code if Ctrl is not down.

	cmp	ds:[KeyType], 4		; skip the following test,
	jne	IcoNotEnh		;  if it's not 101-102
	test	es:byte ptr [kb_flag], fCtrl	; is Ctrl down?
	mov	al, cPrint		; change scan code
	jz	notsys
IcoNotEnh:
	cmp	ds:[KeyType], 2
	test	es:byte ptr [kb_flag], fCtrl	; is Ctrl down?
	jz	notsys

endif	; ICO


ifdef	NOKIA
	cmp	IsEri,1
	jne	NoEricsson
	cmp	PCType,0FCH		; Ignore if not AT-compatible
	jne	notsys
	cmp	KeyType,6
	je	notsys			; No SYSREQ on 9140 (but SyReq)
NoEricsson:
endif	; NOKIA


sysreqwait:
	or	ah,ah		    	; Only on key-down
	js	sysreqdown		; sign set if key-up
igkey:	
	jmp	ignoreu

sysreqdown:
;;; WIN1
;;;	cmp	fSysReq, 0		; EnableKBSysReq() sets/resets this:
;;;	jz	igkey			; can we break to debugger?

;;	%out uncommented stuff -- fix for ROM!
	mov	ax, ds:[0Ah]		; get seg. of NMI vector
	mov	word ptr cs:nmi_vector[2], ax

	cmp	ax, 0F000H		; does it point to ROM
	je	igkey		    	; BIOS or, possibly ..

;;	cmp	ax,0070H		; does it point to DOS BIOS?
;;	je	igkey			;  if so, ignore this.

	mov	ax, ds:[08h]		; get offset of NMI vector
	mov	word ptr cs:nmi_vector[0], ax

	; we now assume NMI points to SymDeb , so we simulate the NMI.
	; But first, we turn control [and Alt?] off, in both the BIOS
	; and Windows!

;;; WIN1
;;;	and	byte ptr es:[kb_flag], not (fCtrl+fAlt)	; do BIOS

;;;	mov	ax,VK_MENU+8000h	; ALT off in Windows
;;;	mov	bx,38h			; was bl .. make sure bh 0
;;;	call	ds:[event_proc]
;;;	mov	ax,VK_CONTROL+8000h	; CONTROL off in Windows
;;;	mov	bx,1dh
;;;	call	ds:[event_proc]

	pop	bx
	pop	ds
	pop	ax
	jmp	cs:nmi_vector

	; now determine if we are to call off to int 2 or kernel!

;;;	test	fSysReq,02

	; now we simulate the NMI
	; The code pointer nmi_vector must be in the CODE segment, since
	; we want to restore ALL the other registers to what they were
	; when the INT 09 interrupt happened, when we emulate the NMI.
	; The Enable() function sets up nmi_vector.

;;;	pop	bx
;;;	pop	es
;;;	pop	ax
;;;	jnz	fwd3

;;;	push   word ptr nmi_vector[2]
;;;	push   word ptr nmi_vector[0]  ; address of nmi_vector on stack
;;;	push   bp
;;;	mov    ds, [bp+6]	       ; restore ds
;;;	pop    bp
;;;	retf   2		       ; "return" to nmi_vector & pop ds

;;;fwd3:	pop	ds
;;;	jmp	CVWBreak		; go to KERNEL!!
notsys:

ENDIF				    	; End of SYSREQ stuff

; We are about to enable interrupt, before doing that we have to protect
; against another interrupt happening before we are done with this one.

	cmp	cs:[fReEnter],0		; are we alone?
	jz	kbiR
	jmp	ignorekey		; is he typing REALLY fast?

kbiR:	inc	cs:[fReEnter]
    ;
    ;   In order for this to work in various 386 Virtual environments
    ;	just setting this "fReEnter" exclusion flag is not the right thing
    ;	to do. A 386 virtual machine monitor may be Simulating keyboard
    ;	activity to us and just doing this exclude will cause us to miss
    ;	lots of keys that the monitor is trying to send us because it will
    ;	send us keys as soon as we EOI the keyboard and enable interrupts.
    ;
    ;	We fix this problem by masking off the keyboard interrupt at the
    ;	interrupt controller. This prevents the 386 monitor from sending us
    ;	more keys till we're ready to get them. This works fine in the non-386
    ;	environments as well. This method is prefered over disabling the
    ;	keyboard at the Keyboard Controller because it is more portable.
    ;	There seems to be a fair variation amoung clones in the keyboard
    ;	controller used, but the keyboard is always IRQ 1, and the interrupt
    ;	controller is always at the IBM port addresses, and is an 8259.
    ;
    ;
;;; WIN1
;;;	push	ax
;;;	in	al,21h			; Get IRQ mask register
;;;	or	al,02h			; mask off kybd ints (IRQ 1)
;;;	jmp	$+2			; I/O delay for AT type machines
;;;	jmp	$+2
;;;	out	21h,al			; set new mask
;;;	pop	ax

ifdef BIGSTK	; hp addition..

; Modification to allow apps with small stack sizes not to blow up
; (i.e. diskcopy) (HP c-ralphp 6/9/88)
;
;
; Switch to a private stack
;
	mov	ds:SaveSS, ss
	mov	ds:SaveSP, sp
	mov	ds:NextSS, cs
	mov	ss, ds:NextSS
	mov	sp, dataOFFSET Stack

; end (HP c-ralphp modifications)
endif ; BIGSTK

	sti				; interrupts on for others...
;
; Win1 break check
;
	test	byte ptr ds:[0400h + kb_flag], 4	;Ctrl pressed?
	jz	noBreak
	cmp	al, cBreak
	jnz	noBreak
	mov	cs:[fBreak], 0
	mov	bx, ax
	call	CtlBrkCase
	mov	al, 3
	cmp	cs:[fBreak], 0	;Handled?
	jnz	doEvent
	jmp	short ignoreu
;
noBreak:
	xor	bx, bx
	mov	bl, al
	mov	al, 0FFh
	cmp	bl, SYSREQ
	jnc	doEvent
	mov	al, cs:KeyTrTab[bx]
	xor	bh, bh
	cmp	bl, 47h	;Home
	jc	doEvent
	cmp	bl, 53h ;Delete
	ja	doEvent
	test	byte ptr ds:[0400h + kb_flag], 20h	;Num lock on?
	jz	doEvent
	test	byte ptr ds:[0400h + kb_flag], 3	;Shift pressed?	
	jnz	unshift
	mov	al, bh
	or	al, al
	jnz	doEvent
	mov	al, cs:KeyTrTab+13[bx]
	jmp	short doEvent

unshift:
	push	ax
	push	bx
	mov	ax, 8010h
	mov	bl, 36h
	call	cs:[event_proc]
	pop	bx
	pop	ax
	call	cs:[event_proc]
	mov	ax, 10h
	mov	bl, 36h	
doEvent:
;;;	call	ds:[kbd_proc]	; standard_proc or prev_was_ext_proc
	call	cs:[event_proc]

ifdef BIGSTK
; Modification to restore the original stack (HP c-ralphp 6/9/88)
;
; Restore the old stack
;
	cli
	mov	ss, ds:SaveSS
	mov	sp, ds:SaveSP

; end (HP c-ralphp modifications)
endif ; BIGSTK

ignoreu:
	mov	cs:[fReEnter],0		; unlock keyboard
;
; Re-enable keyboard INTs at the interrupt controller
;
;;;	cli				; Ints off again.
;;;	in	al,21h			; get IRQ mask register
;;;	and	al,NOT 02h		; turn on kybd ints again (IRQ 1)
;;;	jmp	$+2			; I/O delay for AT type machines
;;;	jmp	$+2
;;;	out	21h,al			; restore correct mask
;;;	jmp	$+2			; I/O delay for AT type machines

	Public ignorekey
ignorekey:

	pop	bx
	pop	ds
	pop	ax
	iret

keybd_int   ENDP
;


	Public CtlBrkCase

CtlBrkCase PROC	NEAR

; we are now control-breaking

	push	bx			; save registers we use
	push	cx
	push	dx
	push	si
	push	di
	push	es
	push	bp

	INT	 1bh

	pop	bp
	pop	es
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	ret
CtlBrkCase ENDP

	public	INT1BHandler
INT1BHandler PROC FAR
	inc	cs:[fBreak]
	iret
INT1BHandler ENDP

;
;  Keep accurate track of shift state byte at 40:17H
;  For Alt and Control, we set or reset bits in 40:18 also.
;  For Numlock, the state bit is in 40:18, and the toggle bit is
;  in 40:17h.
;
;	AL:	scan code
;	AH:	sign bit indicates up/down
;
;	Uses BL or BX as mask.
;
	Public SetShiftState		; public only for debug

SetShiftState proc near

ifdef	ENVOY
	mov	ds:[fModifier],0
endif

;;;	cmp	al,cNumLock		; check for numlock
;;;	jz	ccNum1

SetShiftStateNoNumlock:
	mov	bl,fLshift		; check shift, ctrl, alt bits
	cmp	al,cLshift
	jz	ccv4
	mov	bl,fRshift
	cmp	al,cRshift
	jz	ccv4
	mov	bl,fCtrl
	cmp	al,cCtrl
	jz	ccv4
	mov	bl,fAlt
	cmp	al,cAlt

;;;;; Changed code below 13 April 1990 to fix KBDHP bug ;;;;;;;;;;;;;;;;

ifdef	ENVOY
if1
%out .. ENVOY code in SetShiftState
endif

	; Envoy version
	jz	ccv4
	mov	ds:[fModifier], -1
	ret

else
ifdef NOKIA
if1
%out .. NOKIA code in SetShiftState
endif

	; Nokia version
	jz	ccv4
	cmp	KeyType, 6		; 9140 is special case
	jne	ccv6			; .. it has special rt. alt. scan code
	cmp	al, 055H		; The right Alt key
	jnz	ccv6

else
if1
%out .. STANDARD code in SetShiftState
endif

	; standard version
	jnz	ccv6

endif
endif

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ccv4:
	DosXMacro	ds, Mod0
	or	ah,ah
	jns	ccv5
;;; WIN1 bx -> bl
	not	bl
	and	word ptr ds:[0400h + kb_flag],bl
	ret
ccv5:	or	word ptr ds:[0400h + kb_flag],bl
ccv6:
	ret

; It's NumLock up/down.  This is similar to above, but keeps state in
; 40:18H, and toggles bit in 40:18H, so it's a little more complex.
; [BL] =  fNum is the appropriate bit in BOTH bytes.
; If CTRL is down, we do nothing.

;;;ccNum1:
;;;	test	byte ptr es:[kb_flag], fCtrl 	; (was fShift+fAlt+fCtrl)
;;;	 jnz	ccv6				; must have Ctrl off!
;;;	mov	bl,fNum				; bit for numlock
;;;	or	ah,ah
;;;	jns	ccNum2
;;;	not	bl				; upstroke, so just 
;;;	and	byte ptr es:[kb_flag_1],bl	; clear state
;;;	ret
;;;ccNum2:						; downstroke: already down?
;;;	test	byte ptr es:[kb_flag_1],bl
;;;	jnz	ccNum3
;;;	xor	byte ptr es:[kb_flag],bl	; no, so toggle the toggle bit,
;;;	inc	ds:[NumLockFlag]		; and set flag for ToAscii()

;;;ccNum3:
;;;	or	byte ptr es:[kb_flag_1],bl	; set state bit.
;;;	ret

SetShiftState endp

	public endTRAP
endTRAP:

;;;CheckShifts:
;;;	mov	bl, fLShift
;;;	cmp	al, cLShift
;;;	jz	isShift
;;;	mov	bl, fRShift
;;;	cmp	al, cRShift
;;;	jz	isShift
;;;	mov	bl, fCtrl
;;;	cmp	al, cCtrl
;;;	jz	isShift
;;;	mov	bl, fAlt
;;;	cmp	al, cAlt
;;;	jnz	isntShift
;;;isShift:
;;;	or	ah, ah
;;;	jns	shiftDown
;;;	not	bl
;;;	and	ds:[0400h + kb_flag],bl
;;;	ret
;;;
;;;shiftDown:
;;;	or	ds:[0400h + kb_flag],bl
;;;isntShift:
;;;	ret
		

;;;	public	KeyNumTrans
;;;	even
;;;
;;;KeyNumTrans	LABEL	BYTE
;;;	DB	VK_NUMPAD7	; numpad-7
;;;	DB	VK_NUMPAD8	; numpad-8
;;;	DB	VK_NUMPAD9	; numpad-9
;;;	DB	VK_SUBTRACT	; numpad-minus
;;;	DB	VK_NUMPAD4	; numpad-4
;;;	DB	VK_NUMPAD5	; numpad-5
;;;	DB	VK_NUMPAD6	; numpad-6
;;;	DB	VK_ADD		; numpad-plus
;;;	DB	VK_NUMPAD1	; numpad-1
;;;	DB	VK_NUMPAD2	; numpad-2
;;;	DB	VK_NUMPAD3	; numpad-3
;;;	DB	VK_NUMPAD0	; numpad-0
;;;	DB	VK_DECIMAL	; numpad-period

;;;fBreak	    DB	0
;;;
;;;fAltGrDn    db	0	; set if AltGr is down -- for preventing repeats.

;;;LastCursor  db  0	; last NUMERIC PAD cursor scancode read with NumLock
			; and SHIFT on.

; flags for running in OS/2 Compatibility box

;;;fIgnoreKey	db	0 ; Set to ignore keys used for screen switch
;;;fIgnoreEsc	db	0 ; Count of up keys to ignore
;;;staticW	kbd_proc,standard_proc
;;;fExtend	db	0		; flag for above keys.

;;;	public fSwitchEnable	; accessed in ENABLE.ASM

;;;fSwitchEnable	db	1 ; Flag to prevent/allow screen switches
if2
%out	.... END TRAP.ASM ....
%out
endif

;;;sEnd CODE

