/************************************************************************

    CPPREP v1.00 - Replacement for MODE CON CP PREPARE supporting various
                  file formats.

    Copyright (C) 2006  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

/* Load a font from a PSF file. We support PSF1 and PSF2. 
 *
 * Note that we _don't_ do anything with Unicode tables. You get the 
 * first 256 characters and that's it.
 */

#include "cpprep.h"

void load_psf1(char *filename, FILE *fp, int page, int *haveFonts)
{
	BYTE header[4];
	BYTE far *bits;
	int chsize, n;

	if (fread(header, 1, sizeof(header), fp) < sizeof(header))
	{
		fprintf(stderr, "%s: Unexpected EOF", filename);
		return;
	}
	chsize = header[3];
	bits = fontbits(page, chsize);
	if (!bits)
	{
		fprintf(stderr, "%s:Character size 8x%d is not supported"
				" on this device.\n", filename, chsize);
		return; 
	}
	if (verbose)
	{
		printf("%s: Loading codepage %d", filename, get_pageno(page));
		printf(" from PSF1, size=8x%d\n", chsize);
	}

	for (n = 0; n < 256*chsize; n++)
	{
		bits[n] = fgetc(fp);
	}
	switch(chsize)
	{
		case  8: *haveFonts |= 1; break;
		case 14: *haveFonts |= 2; break;
		case 16: *haveFonts |= 4; break;
	}
}



void load_psf2(char *filename, FILE *fp, int page, int *haveFonts)
{
	DWORD header[8];
	DWORD n;
	int n1;
	BYTE far *bits;
	BYTE hdrbuf[32];	

	if (fread(hdrbuf, 1, sizeof(hdrbuf), fp) < sizeof(hdrbuf))
	{
		fprintf(stderr, "%s: Unexpected EOF", filename);
		return;
	}
	for (n1 = 0; n1 < 8; n1++) 
	{
		header[n1] = PEEK4(hdrbuf + n1*4);
	}
	/* If char height not identical to length in bytes, abandon */
	if (header[6] != header[5])
	{
		fprintf(stderr, "%s: Unsupported font size %ldx%ld\n",
				filename, (long)header[7],(long)header[6]);
		return;
	}
	/* Skip any extra header */
	if (header[2] > 32)
	{
		fseek(fp, header[2] - 32, SEEK_CUR);
	}
	/* Count of chars */
	if (header[4] > 256) header[4] = 256;
	bits = fontbits(page, (int)header[5]);
	if (!bits)
	{
		fprintf(stderr, "%s:Character size 8x%ld is not supported"
				" on this device.\n", filename, (long)header[5]);
		return; 
	}
	if (verbose)
	{
		printf("%s: Loading codepage %d", filename, get_pageno(page));
		printf(" from PSF2, size=8x%ld\n", (long)header[5]);
	}
	for (n = 0; n < header[4]*header[5]; n++)
	{
		bits[(unsigned)n] = fgetc(fp);
	}
	switch((int)header[5])
	{
		case  8: *haveFonts |= 1; break;
		case 14: *haveFonts |= 2; break;
		case 16: *haveFonts |= 4; break;
	}
}


