/************************************************************************

    CPPREP v1.00 - Replacement for MODE CON CP PREPARE supporting various
                  file formats.

    Copyright (C) 2006  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

/* Compiles either with Turbo C under DOS, or gcc under Linux (with 
 * reduced functionality since Linux doesn't have DISPLAY.SYS) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#ifdef __MSDOS__
/* In MS-DOS: Access to unaligned data done by macros. Memory buffers are
 * far. */
# include <alloc.h>
 typedef unsigned char BYTE;
 typedef unsigned short WORD;
 typedef unsigned long DWORD;

# define PEEK2(a) (*((WORD far *)(a)))
# define PEEK4(a) (*((DWORD far *)(a)))
# define POKE2(a, b) (*((WORD far *)(a))) = (b)
# define POKE4(a, b) (*((DWORD far *)(a))) = (b)
 extern int init_hardware(void);
 extern void install_font(int cpcount);
 extern int cpx2cpi(void far * buffer);
#else
/* In UNIX: Access to unaligned data done by painstakingly reading/writing
 * each byte in turn. No such thing as far pointers. */
# include <stdint.h>
 typedef uint8_t BYTE;
 typedef uint16_t WORD;
 typedef uint32_t DWORD;
# define farfree free
# define farmalloc malloc
# define far
 extern unsigned short PEEK2(BYTE *a);
 extern unsigned short PEEK4(BYTE *a);
 extern void POKE2(BYTE *a, WORD b);
 extern void POKE4(BYTE *a, DWORD b);
 #define init_hardware() 0
 #define cpx2cpi(x) 0
#endif


/* The parsed form of a command line parameter
 * (  nnn=file
 *    nnn=file+file
 *    nnn=file+file+file )
 */
typedef struct request
{
	unsigned page;
	char *file[3];
} REQUEST; 

extern int device, verbose;

void init_cpi(unsigned count);
void set_pageno(int page, WORD no);
WORD get_pageno(int page);
void free_cpi(void);
WORD get_cpi_len(void);
BYTE far *get_cpi_base(void);


void load_font(int page, char *filename, int *haveFonts);
void load_cpi (char *filename, FILE *fp, int page, int *haveFonts, int subtype);
void load_cpx (char *filename, FILE *fp, int page, int *haveFonts);
void load_psf1(char *filename, FILE *fp, int page, int *haveFonts);
void load_psf2(char *filename, FILE *fp, int page, int *haveFonts);
void load_raw(char *filename, FILE *fp, int page, int *haveFonts);

int  extrapolate(int page, int haveFonts);
void dump_cpi(char *filename);
BYTE far *fontbits(int page, int height);

void install_font();
